/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import java.util.Vector;

public abstract class HierarchyLayout
extends Layout {
    Vector fRoots;
    Vector unconnectedNodes;
    Vector connectedNodes;
    int nodeCount;
    Node node;

    public void setAllNodesEdgesAccessed(Node node, boolean bl) {
        Node node2 = node;
        while (node2 != null) {
            node2.isAccessed = bl;
            for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                edge.isAccessed = bl;
            }
            node2 = node2.next;
        }
    }

    public void setAllEdgesAccessed(Node node, boolean bl) {
        Node node2 = node;
        while (node2 != null) {
            for (Edge edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                edge.isAccessed = bl;
            }
            node2 = node2.next;
        }
    }

    public int getNodeCount() {
        int n = 0;
        Node node = this.node;
        while (node != null) {
            ++n;
            node = node.next;
        }
        return n;
    }

    public void setNodeAccessed(Node node, boolean bl) {
        node.isAccessed = bl;
    }

    public void setEdgeAccessed(Edge edge, boolean bl) {
        edge.isAccessed = bl;
    }

    public boolean isNodeAccessed(Node node) {
        return node.isAccessed;
    }

    public boolean isEdgeAccessed(Edge edge) {
        return edge.isAccessed;
    }

    protected Layout.Algorithm createAlgorithm() {
        return new HAlgorithm();
    }

    abstract void drawLayout(Node var1);

    public class HAlgorithm
    extends Layout.Algorithm {
        public HAlgorithm() {
            super(HierarchyLayout.this);
        }

        protected void layout(Node node) {
            HierarchyLayout.this.node = node;
            HierarchyLayout.this.fRoots = new Vector();
            HierarchyLayout.this.unconnectedNodes = new Vector();
            HierarchyLayout.this.connectedNodes = new Vector();
            HierarchyLayout.this.nodeCount = HierarchyLayout.this.getNodeCount();
            HierarchyLayout.this.setAllNodesEdgesAccessed(HierarchyLayout.this.node, true);
            this.disassociateNodes();
            HierarchyLayout.this.setAllNodesEdgesAccessed(HierarchyLayout.this.node, true);
            this.searchRoots();
            HierarchyLayout.this.drawLayout(HierarchyLayout.this.node);
        }

        void searchRoots() {
            Object object;
            Object object2;
            boolean bl = false;
            HierarchyLayout.this.setAllNodesEdgesAccessed(HierarchyLayout.this.node, true);
            Node node = HierarchyLayout.this.node;
            while (node != null) {
                if (node.getFirstEdge() != null) {
                    if (HierarchyLayout.this.isNodeAccessed(node)) {
                        bl = true;
                        for (object2 = node.getFirstEdge(); object2 != null; object2 = ((Edge)object2).getNext(node)) {
                            if (HierarchyLayout.this.isEdgeAccessed((Edge)object2)) continue;
                            bl = false;
                        }
                        if (bl) {
                            // empty if block
                        }
                        HierarchyLayout.this.setNodeAccessed(node, false);
                    }
                    object2 = node;
                    HierarchyLayout.this.setNodeAccessed((Node)((Object)object2), false);
                    for (Edge edge = object = ((Node)((Object)object2)).getFirstEdge(); edge != null; edge = edge.getNext((Node)((Object)object2))) {
                        HierarchyLayout.this.setEdgeAccessed(edge, false);
                        HierarchyLayout.this.setNodeAccessed(edge.source, false);
                        HierarchyLayout.this.setNodeAccessed(edge.target, false);
                    }
                }
                node = node.next;
            }
            HierarchyLayout.this.setAllNodesEdgesAccessed(HierarchyLayout.this.node, true);
            node = HierarchyLayout.this.node;
            while (node != null) {
                for (object2 = node.getFirstEdge(); object2 != null; object2 = ((Edge)object2).getNext(node)) {
                    object = ((Edge)object2).target;
                    ((Node)((Object)object)).isAccessed = false;
                    ((Edge)object2).isAccessed = false;
                }
                node = node.next;
            }
            node = HierarchyLayout.this.node;
            while (node != null) {
                if (node.isAccessed) {
                    HierarchyLayout.this.fRoots.add(node);
                }
                node = node.next;
            }
            HierarchyLayout.this.setAllNodesEdgesAccessed(HierarchyLayout.this.node, false);
        }

        public void disassociateNodes() {
            Node node = HierarchyLayout.this.node;
            while (node != null) {
                if (node.getFirstEdge() != null) {
                    HierarchyLayout.this.connectedNodes.add(node);
                } else {
                    HierarchyLayout.this.unconnectedNodes.add(node);
                }
                node = node.next;
            }
        }
    }
}

