/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.ForceBasedLayout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.Random;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

public class SpringLayout
extends ForceBasedLayout {
    float attraction = 1.0f;
    float repulsion = 1.0f;
    public static final Type $TYPE = new Type(SpringLayout.class);
    public static final SCOType.Field attraction$FIELD = Type._addManagedField($TYPE, "attraction", 0x200000, de.grogra.reflect.Type.FLOAT, null, 7);
    public static final SCOType.Field repulsion$FIELD = Type._addManagedField($TYPE, "repulsion", 0x200000, de.grogra.reflect.Type.FLOAT, null, 8);

    protected void setRandomPosition(Node node, Random random) {
        node.x = random.nextFloat();
        node.y = random.nextFloat();
    }

    protected void computeForce(Edge edge, Vector2f vector2f) {
        vector2f.sub((Tuple2f)edge.target, (Tuple2f)edge.source);
        float f = vector2f.length();
        if (f < this.attraction * 1.0E-6f) {
            vector2f.set(this.attraction, 0.0f);
        } else {
            vector2f.scale((this.attraction / edge.weight - f) / f);
        }
    }

    protected void computeForce(Node node, Node node2, Vector2f vector2f) {
        vector2f.sub((Tuple2f)node2, (Tuple2f)node);
        float f = vector2f.length();
        if (f < this.attraction * 1.0E-6f) {
            vector2f.set(this.attraction, 0.0f);
        } else {
            vector2f.scale(this.repulsion / (f * f * f));
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends ForceBasedLayout.Type {
        private static final int SUPER_FIELD_COUNT = 7;
        protected static final int FIELD_COUNT = 9;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SpringLayout springLayout, SCOType sCOType) {
            super(springLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)ForceBasedLayout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 7: {
                    ((SpringLayout)((Object)object)).attraction = f;
                    return;
                }
                case 8: {
                    ((SpringLayout)((Object)object)).repulsion = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 7: {
                    return ((SpringLayout)((Object)object)).attraction;
                }
                case 8: {
                    return ((SpringLayout)((Object)object)).repulsion;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new SpringLayout();
        }
    }
}

