/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.imp2d.layout.NodeWrapper;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.vecmath.Point2d;

public class SugiyamaLayout
extends Layout {
    private double fGridAreaSize = -2.147483648E9;
    private boolean topDown = false;
    private double minDistanceX = 2.0;
    private double minDistanceY = 1.0;
    private Point2d fSpacing;
    private Hashtable fWrappers = new Hashtable(1500);
    private Vector fLevels = new Vector();
    List fMovements = null;
    int fMovementsCurrentLoop = -1;
    int fMovementsMax = Integer.MIN_VALUE;
    int iteration = 0;
    public static final Type $TYPE = new Type(SugiyamaLayout.class);
    public static final SCOType.Field topDown$FIELD = Type._addManagedField($TYPE, "topDown", 0x200002, de.grogra.reflect.Type.BOOLEAN, null, 2);
    public static final SCOType.Field minDistanceX$FIELD = Type._addManagedField($TYPE, "minDistanceX", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 3);
    public static final SCOType.Field minDistanceY$FIELD = Type._addManagedField($TYPE, "minDistanceY", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 4);

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){

            protected void layout(Node node) {
                int n;
                GraphUtilities graphUtilities = new GraphUtilities();
                graphUtilities.setAllNodesEdgesAccessed(node, true);
                SugiyamaLayout.this.fSpacing = new Point2d(SugiyamaLayout.this.minDistanceX, SugiyamaLayout.this.minDistanceY);
                SugiyamaLayout.this.fGridAreaSize = -2.147483648E9;
                SugiyamaLayout.this.fWrappers = new Hashtable(1500);
                SugiyamaLayout.this.fLevels = new Vector();
                SugiyamaLayout.this.fMovements = null;
                SugiyamaLayout.this.fMovementsCurrentLoop = -1;
                SugiyamaLayout.this.fMovementsMax = Integer.MIN_VALUE;
                SugiyamaLayout.this.iteration = 0;
                SugiyamaLayout.this.fGridAreaSize = Double.MIN_VALUE;
                Point2d point2d = new Point2d(0.0, 0.0);
                Object object = node;
                while (object != null) {
                    point2d.set(Math.max((double)((Node)((Object)object)).height, point2d.x), Math.max((double)((Node)((Object)object)).width, point2d.y));
                    object = ((Node)((Object)object)).next;
                }
                if (((SugiyamaLayout)SugiyamaLayout.this).fSpacing.x == 0.0) {
                    ((SugiyamaLayout)SugiyamaLayout.this).fSpacing.x = 2.0 * point2d.x;
                }
                if (((SugiyamaLayout)SugiyamaLayout.this).fSpacing.y == 0.0) {
                    ((SugiyamaLayout)SugiyamaLayout.this).fSpacing.y = 2.0 * point2d.y;
                }
                object = graphUtilities.getRoots(node);
                graphUtilities.setAllNodesEdgesAccessed(node, true);
                for (n = 0; n < ((LinkedList)object).size(); ++n) {
                    this.fillLevels(SugiyamaLayout.this.fLevels, 0, (Node)((Object)((LinkedList)object).get(n)));
                }
                SugiyamaLayout.this.fMovements = new ArrayList(100);
                SugiyamaLayout.this.fMovementsCurrentLoop = -1;
                SugiyamaLayout.this.fMovementsMax = Integer.MIN_VALUE;
                SugiyamaLayout.this.iteration = 0;
                while (SugiyamaLayout.this.fMovementsCurrentLoop != 0) {
                    SugiyamaLayout.this.fMovementsCurrentLoop = 0;
                    for (n = 0; n < SugiyamaLayout.this.fLevels.size() - 1; ++n) {
                        SugiyamaLayout.this.fMovementsCurrentLoop += this.solveEdgeCrosses(true, SugiyamaLayout.this.fLevels, n);
                    }
                    for (n = SugiyamaLayout.this.fLevels.size() - 1; n >= 1; --n) {
                        SugiyamaLayout.this.fMovementsCurrentLoop += this.solveEdgeCrosses(false, SugiyamaLayout.this.fLevels, n);
                    }
                    SugiyamaLayout.this.fMovements.add(new Integer(SugiyamaLayout.this.fMovementsCurrentLoop));
                    ++SugiyamaLayout.this.iteration;
                    if (SugiyamaLayout.this.fMovementsCurrentLoop <= SugiyamaLayout.this.fMovementsMax) continue;
                    SugiyamaLayout.this.fMovementsMax = SugiyamaLayout.this.fMovementsCurrentLoop;
                }
                this.moveToBarycenter(node, SugiyamaLayout.this.fLevels);
                Point2d point2d2 = new Point2d(10000.0, 10000.0);
                Node node2 = node;
                while (node2 != null) {
                    point2d2.set(Math.min((double)node2.height, point2d2.x), Math.min((double)node2.width, point2d2.y));
                    node2 = node2.next;
                }
                for (int i = 0; i < SugiyamaLayout.this.fLevels.size(); ++i) {
                    ArrayList arrayList = (ArrayList)SugiyamaLayout.this.fLevels.get(i);
                    for (int j = 0; j < arrayList.size(); ++j) {
                        NodeWrapper nodeWrapper = (NodeWrapper)arrayList.get(j);
                        Node node3 = (Node)((Object)nodeWrapper.getNode());
                        if (node3 == null) continue;
                        node3.x = (float)(point2d2.x + ((SugiyamaLayout)SugiyamaLayout.this).fSpacing.x * (double)(SugiyamaLayout.this.topDown ? nodeWrapper.getGridPosition() : i));
                        node3.y = -((float)(point2d2.y + ((SugiyamaLayout)SugiyamaLayout.this).fSpacing.y * (double)(SugiyamaLayout.this.topDown ? i : nodeWrapper.getGridPosition())));
                    }
                }
            }

            protected void updateProgress4Movements() {
                SugiyamaLayout.this.fMovements.add(new Integer(SugiyamaLayout.this.fMovementsCurrentLoop));
                ++SugiyamaLayout.this.iteration;
                if (SugiyamaLayout.this.fMovementsCurrentLoop > SugiyamaLayout.this.fMovementsMax) {
                    SugiyamaLayout.this.fMovementsMax = SugiyamaLayout.this.fMovementsCurrentLoop;
                }
            }

            protected void fillLevels(Vector vector, int n, Node node) {
                if (node == null) {
                    return;
                }
                if (vector.size() == n) {
                    vector.add(n, new ArrayList());
                }
                if (!node.isAccessed) {
                    return;
                }
                node.isAccessed = false;
                ArrayList arrayList = (ArrayList)vector.get(n);
                int n2 = arrayList.size();
                NodeWrapper nodeWrapper = new NodeWrapper(n, n2, (Object)node);
                arrayList.add(nodeWrapper);
                SugiyamaLayout.this.fWrappers.put(node, nodeWrapper);
                if (node.getFirstEdge() != null) {
                    Edge edge;
                    for (Edge edge2 = edge = node.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(node)) {
                        if (!edge2.isAccessed) continue;
                        edge2.isAccessed = false;
                        Node node2 = edge2.target;
                        if (node2 == node) continue;
                        this.fillLevels(vector, n + 1, node2);
                    }
                }
                if ((double)arrayList.size() > SugiyamaLayout.this.fGridAreaSize) {
                    SugiyamaLayout.this.fGridAreaSize = arrayList.size();
                }
            }

            protected int solveEdgeCrosses(boolean bl, Vector vector, int n) {
                int n2;
                ArrayList arrayList = (ArrayList)vector.get(n);
                int n3 = 0;
                Object[] objectArray = arrayList.toArray();
                Collections.sort(arrayList);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (((NodeWrapper)objectArray[n2]).getEdgeCrossesIndicator() == ((NodeWrapper)arrayList.get(n2)).getEdgeCrossesIndicator()) continue;
                    ++n3;
                }
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    NodeWrapper nodeWrapper;
                    Edge edge;
                    NodeWrapper nodeWrapper2 = (NodeWrapper)arrayList.get(n2);
                    Node node = (Node)((Object)nodeWrapper2.getNode());
                    if (node.getFirstEdge() == null) continue;
                    Edge edge2 = node.getFirstEdge();
                    Node node2 = null;
                    if (bl) {
                        for (edge = edge2; edge != null; edge = edge.getNext(node)) {
                            node2 = edge.target;
                            if (node2 == null || (nodeWrapper = (NodeWrapper)SugiyamaLayout.this.fWrappers.get((Object)node2)) == null || nodeWrapper.getLevel() <= n) continue;
                            nodeWrapper.addToEdgeCrossesIndicator(nodeWrapper2.getEdgeCrossesIndicator());
                        }
                    }
                    if (bl) continue;
                    for (edge = edge2; edge != null; edge = edge.getNext(node)) {
                        node2 = edge.source;
                        if (node2 == null || (nodeWrapper = (NodeWrapper)SugiyamaLayout.this.fWrappers.get((Object)node2)) == null || nodeWrapper.getLevel() >= n) continue;
                        nodeWrapper.addToEdgeCrossesIndicator(nodeWrapper2.getEdgeCrossesIndicator());
                    }
                }
                return n3;
            }

            protected void moveToBarycenter(Node node, Vector vector) {
                int n;
                Object object;
                Object object2;
                Node node2 = node;
                while (node2 != null) {
                    object2 = (NodeWrapper)SugiyamaLayout.this.fWrappers.get((Object)node2);
                    if (node2.getFirstEdge() != null) {
                        NodeWrapper nodeWrapper;
                        Edge edge;
                        Edge edge2 = node2.getFirstEdge();
                        object = null;
                        for (edge = edge2; edge != null; edge = edge.getNext(node2)) {
                            object = edge.target;
                            if (object == null) continue;
                            nodeWrapper = (NodeWrapper)SugiyamaLayout.this.fWrappers.get(object);
                            if (object2 == null || nodeWrapper == null || ((NodeWrapper)object2).level == nodeWrapper.level) continue;
                            ++((NodeWrapper)object2).priority;
                        }
                        for (edge = edge2; edge != null; edge = edge.getNext(node2)) {
                            object = edge.source;
                            if (object == null) continue;
                            nodeWrapper = (NodeWrapper)SugiyamaLayout.this.fWrappers.get(object);
                            if (object2 == null || nodeWrapper == null || ((NodeWrapper)object2).level == nodeWrapper.level) continue;
                            ++((NodeWrapper)object2).priority;
                        }
                    }
                    node2 = node2.next;
                }
                for (n = 0; n < vector.size(); ++n) {
                    object2 = (ArrayList)vector.get(n);
                    for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                        object = (NodeWrapper)((ArrayList)object2).get(i);
                        ((NodeWrapper)object).setGridPosition(i);
                    }
                }
                SugiyamaLayout.this.fMovements.clear();
                SugiyamaLayout.this.fMovementsCurrentLoop = -1;
                SugiyamaLayout.this.fMovementsMax = Integer.MIN_VALUE;
                SugiyamaLayout.this.iteration = 0;
                while (SugiyamaLayout.this.fMovementsCurrentLoop != 0) {
                    SugiyamaLayout.this.fMovementsCurrentLoop = 0;
                    for (n = 1; n < vector.size(); ++n) {
                        SugiyamaLayout.this.fMovementsCurrentLoop += this.moveToBarycenter(vector, n);
                    }
                    for (n = vector.size() - 1; n >= 0; --n) {
                        SugiyamaLayout.this.fMovementsCurrentLoop += this.moveToBarycenter(vector, n);
                    }
                    this.updateProgress4Movements();
                }
            }

            protected int moveToBarycenter(List list, int n) {
                int n2 = 0;
                ArrayList arrayList = (ArrayList)list.get(n);
                for (int i = 0; i < arrayList.size(); ++i) {
                    NodeWrapper nodeWrapper;
                    Edge edge;
                    NodeWrapper nodeWrapper2 = (NodeWrapper)arrayList.get(i);
                    float f = 0.0f;
                    float f2 = 0.0f;
                    Node node = (Node)((Object)nodeWrapper2.getNode());
                    if (node.getFirstEdge() == null) continue;
                    Edge edge2 = node.getFirstEdge();
                    Node node2 = null;
                    for (edge = edge2; edge != null; edge = edge.getNext(node)) {
                        node2 = edge.target;
                        if (node2 == null || nodeWrapper2 == (nodeWrapper = (NodeWrapper)SugiyamaLayout.this.fWrappers.get((Object)node2)) || nodeWrapper == null || nodeWrapper.getLevel() == n) continue;
                        f += (float)nodeWrapper.getGridPosition();
                        f2 += 1.0f;
                    }
                    for (edge = edge2; edge != null; edge = edge.getNext(node)) {
                        node2 = edge.source;
                        if (node2 == null || nodeWrapper2 == (nodeWrapper = (NodeWrapper)SugiyamaLayout.this.fWrappers.get((Object)node2)) || nodeWrapper == null || nodeWrapper.getLevel() == n) continue;
                        f += (float)nodeWrapper.getGridPosition();
                        f2 += 1.0f;
                    }
                    if (!(f2 > 0.0f)) continue;
                    float f3 = f / f2;
                    int n3 = Math.round(f3);
                    boolean bl = n3 > nodeWrapper2.getGridPosition();
                    boolean bl2 = true;
                    while (n3 != nodeWrapper2.getGridPosition() && bl2) {
                        bl2 = this.move(bl, arrayList, i, nodeWrapper2.getPriority());
                        if (!bl2) continue;
                        ++n2;
                    }
                }
                return n2;
            }

            protected boolean move(boolean bl, ArrayList arrayList, int n, int n2) {
                NodeWrapper nodeWrapper = (NodeWrapper)arrayList.get(n);
                boolean bl2 = false;
                int n3 = n + (bl ? 1 : -1);
                int n4 = nodeWrapper.getGridPosition() + (bl ? 1 : -1);
                if (0 > n4 || (double)n4 >= SugiyamaLayout.this.fGridAreaSize) {
                    return false;
                }
                if (bl && n == arrayList.size() - 1 || !bl && n == 0) {
                    bl2 = true;
                } else {
                    NodeWrapper nodeWrapper2 = (NodeWrapper)arrayList.get(n3);
                    int n5 = nodeWrapper2.getPriority();
                    if (nodeWrapper2.getGridPosition() == n4) {
                        if (n5 >= n2) {
                            return false;
                        }
                        bl2 = this.move(bl, arrayList, n3, n2);
                    } else {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    nodeWrapper.setGridPosition(n4);
                }
                return bl2;
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 5;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SugiyamaLayout sugiyamaLayout, SCOType sCOType) {
            super(sugiyamaLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 2: {
                    ((SugiyamaLayout)((Object)object)).topDown = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((SugiyamaLayout)((Object)object)).topDown;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 3: {
                    ((SugiyamaLayout)((Object)object)).minDistanceX = d;
                    return;
                }
                case 4: {
                    ((SugiyamaLayout)((Object)object)).minDistanceY = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((SugiyamaLayout)((Object)object)).minDistanceX;
                }
                case 4: {
                    return ((SugiyamaLayout)((Object)object)).minDistanceY;
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new SugiyamaLayout();
        }
    }
}

