/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.objects;

import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public class Rhombus
extends RectangularShape {
    float centerX = 0.0f;
    float centerY = 0.0f;
    float width = 0.5f;
    float height = 0.5f;
    public static final Type $TYPE = new Type(Rhombus.class);
    public static final SCOType.Field width$FIELD = Type._addManagedField($TYPE, "width", 0x200000, de.grogra.reflect.Type.FLOAT, null, 0);
    public static final SCOType.Field height$FIELD = Type._addManagedField($TYPE, "height", 0x200000, de.grogra.reflect.Type.FLOAT, null, 1);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public double getX() {
        return this.centerX - 0.5f * this.width;
    }

    public double getY() {
        return this.centerY - 0.5f * this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.width = (float)d3;
        this.height = (float)d4;
        this.centerX = (float)(d + 0.5 * d3);
        this.centerY = (float)(d2 + 0.5 * d4);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.centerX - 0.5f * this.width, this.centerY - 0.5f * this.height, this.width, this.height);
    }

    public boolean contains(double d, double d2) {
        return Math.abs(d - (double)this.centerX) * (double)this.height + Math.abs(d2 - (double)this.centerY) * (double)this.width <= (double)(0.5f * this.width * this.height);
    }

    public void setDeltaHeight(float f) {
        this.centerY = f;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return false;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new Iterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new Iterator(this, affineTransform);
    }

    static {
        $TYPE.validate();
    }

    private static class Iterator
    implements PathIterator {
        float cx;
        float cy;
        float w2;
        float h2;
        AffineTransform affine;
        int index;

        Iterator(Rhombus rhombus, AffineTransform affineTransform) {
            this.cx = rhombus.centerX;
            this.cy = rhombus.centerY;
            this.w2 = 0.5f * rhombus.width;
            this.h2 = 0.5f * rhombus.height;
            this.affine = affineTransform;
            this.index = rhombus.isEmpty() ? 6 : 0;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.index > 5;
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(float[] fArray) {
            switch (this.index) {
                case 0: {
                    fArray[0] = this.cx + this.w2;
                    fArray[1] = this.cy;
                    if (this.affine != null) {
                        this.affine.transform(fArray, 0, fArray, 0, 1);
                    }
                    return 0;
                }
                case 1: {
                    fArray[0] = this.cx;
                    fArray[1] = this.cy + this.h2;
                    break;
                }
                case 2: {
                    fArray[0] = this.cx - this.w2;
                    fArray[1] = this.cy;
                    break;
                }
                case 3: {
                    fArray[0] = this.cx;
                    fArray[1] = this.cy - this.h2;
                    break;
                }
                case 4: {
                    fArray[0] = this.cx + this.w2;
                    fArray[1] = this.cy;
                    break;
                }
                case 5: {
                    return 4;
                }
                default: {
                    throw new NoSuchElementException("iterator out of bounds");
                }
            }
            if (this.affine != null) {
                this.affine.transform(fArray, 0, fArray, 0, 1);
            }
            return 1;
        }

        public int currentSegment(double[] dArray) {
            switch (this.index) {
                case 0: {
                    dArray[0] = this.cx + this.w2;
                    dArray[1] = this.cy;
                    if (this.affine != null) {
                        this.affine.transform(dArray, 0, dArray, 0, 1);
                    }
                    return 0;
                }
                case 1: {
                    dArray[0] = this.cx;
                    dArray[1] = this.cy + this.h2;
                    break;
                }
                case 2: {
                    dArray[0] = this.cx - this.w2;
                    dArray[1] = this.cy;
                    break;
                }
                case 3: {
                    dArray[0] = this.cx;
                    dArray[1] = this.cy - this.h2;
                    break;
                }
                case 4: {
                    dArray[0] = this.cx + this.w2;
                    dArray[1] = this.cy;
                    break;
                }
                case 5: {
                    return 4;
                }
                default: {
                    throw new NoSuchElementException("iterator out of bounds");
                }
            }
            if (this.affine != null) {
                this.affine.transform(dArray, 0, dArray, 0, 1);
            }
            return 1;
        }
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 2;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(Rhombus rhombus, SCOType sCOType) {
            super((Object)rhombus, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 0: {
                    ((Rhombus)object).width = f;
                    return;
                }
                case 1: {
                    ((Rhombus)object).height = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((Rhombus)object).width;
                }
                case 1: {
                    return ((Rhombus)object).height;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new Rhombus();
        }
    }
}

