/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.objects;

import de.grogra.imp2d.IMP2D;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.util.EnumerationType;
import de.grogra.util.I18NBundle;
import java.awt.BasicStroke;
import java.awt.Stroke;

public final class StrokeAdapter
extends ShareableBase {
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DASHED_DOTTED = 3;
    public static final int DASHED_DOUBLE_DOTTED = 4;
    public static final int DASHED_TRIPLE_DOTTED = 5;
    private static final float[][] DASHES = new float[][]{null, {0.5f, 0.5f}, {0.1f, 0.9f}, {0.5f, 0.2f, 0.1f, 0.2f}, {0.4f, 0.15f, 0.075f, 0.15f, 0.075f, 0.15f}, {0.31f, 0.12f, 0.07f, 0.12f, 0.07f, 0.12f, 0.07f, 0.12f}};
    private static final I18NBundle I18N = IMP2D.I18N;
    private static final EnumerationType LINE_STYLE_TYPE = new EnumerationType("lineStyle", I18N, DASHES.length);
    private static final EnumerationType LINE_JOIN_TYPE = new EnumerationType("lineJoin", I18N, 3);
    private static final EnumerationType CAP_STYLE_TYPE = new EnumerationType("capStyle", I18N, 3);
    float lineWidth = 0.01f;
    int lineStyle;
    float dashLength = 0.2f;
    int lineJoin;
    float miterLimit = 1.0f;
    int capStyle;
    public static final Type $TYPE = new Type(StrokeAdapter.class);
    public static final SCOType.Field lineWidth$FIELD = Type._addManagedField($TYPE, "lineWidth", 0x200000, de.grogra.reflect.Type.FLOAT, null, 0);
    public static final SCOType.Field lineStyle$FIELD = Type._addManagedField($TYPE, "lineStyle", 0x200000, (de.grogra.reflect.Type)LINE_STYLE_TYPE, null, 1);
    public static final SCOType.Field dashLength$FIELD = Type._addManagedField($TYPE, "dashLength", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field lineJoin$FIELD = Type._addManagedField($TYPE, "lineJoin", 0x200000, (de.grogra.reflect.Type)LINE_JOIN_TYPE, null, 3);
    public static final SCOType.Field miterLimit$FIELD = Type._addManagedField($TYPE, "miterLimit", 0x200000, de.grogra.reflect.Type.FLOAT, null, 4);
    public static final SCOType.Field capStyle$FIELD = Type._addManagedField($TYPE, "capStyle", 0x200000, (de.grogra.reflect.Type)CAP_STYLE_TYPE, null, 5);
    private transient Stroke stroke;

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public int getCapStyle() {
        return this.capStyle;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public float getDashLength() {
        return this.dashLength;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
        this.stroke = null;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
        this.stroke = null;
    }

    public void setDashLength(float f) {
        this.dashLength = f;
        this.stroke = null;
    }

    public void setLineJoin(int n) {
        this.lineJoin = n;
        this.stroke = null;
    }

    public void setMiterLimit(float f) {
        this.miterLimit = f;
        this.stroke = null;
    }

    public void setCapStyle(int n) {
        this.capStyle = n;
        this.stroke = null;
    }

    public Stroke getStroke() {
        Stroke stroke = this.stroke;
        if (stroke == null) {
            float[] fArray = DASHES[this.lineStyle];
            if (fArray != null) {
                fArray = (float[])fArray.clone();
                int n = 0;
                while (n < fArray.length) {
                    int n2 = n++;
                    fArray[n2] = fArray[n2] * this.dashLength;
                }
            }
            this.stroke = stroke = new BasicStroke(this.lineWidth, this.capStyle, this.lineJoin, this.miterLimit, fArray, 0.0f);
        }
        return stroke;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 6;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(StrokeAdapter strokeAdapter, SCOType sCOType) {
            super((Object)strokeAdapter, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((StrokeAdapter)((Object)object)).setLineStyle(n2);
                    return;
                }
                case 3: {
                    ((StrokeAdapter)((Object)object)).setLineJoin(n2);
                    return;
                }
                case 5: {
                    ((StrokeAdapter)((Object)object)).setCapStyle(n2);
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((StrokeAdapter)((Object)object)).getLineStyle();
                }
                case 3: {
                    return ((StrokeAdapter)((Object)object)).getLineJoin();
                }
                case 5: {
                    return ((StrokeAdapter)((Object)object)).getCapStyle();
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 0: {
                    ((StrokeAdapter)((Object)object)).setLineWidth(f);
                    return;
                }
                case 2: {
                    ((StrokeAdapter)((Object)object)).setDashLength(f);
                    return;
                }
                case 4: {
                    ((StrokeAdapter)((Object)object)).setMiterLimit(f);
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((StrokeAdapter)((Object)object)).getLineWidth();
                }
                case 2: {
                    return ((StrokeAdapter)((Object)object)).getDashLength();
                }
                case 4: {
                    return ((StrokeAdapter)((Object)object)).getMiterLimit();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new StrokeAdapter();
        }
    }
}

