/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

public class QuantizedBvhNodes {
    private static final int STRIDE = 4;
    private int[] buf;
    private int size = 0;

    public QuantizedBvhNodes() {
        this.resize(16);
    }

    public int add() {
        while (this.size + 1 >= this.capacity()) {
            this.resize(this.capacity() * 2);
        }
        return this.size++;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.buf.length / 4;
    }

    public void clear() {
        this.size = 0;
    }

    public void resize(int num) {
        int[] oldBuf = this.buf;
        this.buf = new int[num * 4];
        if (oldBuf != null) {
            System.arraycopy(oldBuf, 0, this.buf, 0, Math.min(oldBuf.length, this.buf.length));
        }
    }

    public static int getNodeSize() {
        return 16;
    }

    public void set(int destId, QuantizedBvhNodes srcNodes, int srcId) {
        int[] buf = this.buf;
        int[] srcBuf = srcNodes.buf;
        buf[destId * 4 + 0] = srcBuf[srcId * 4 + 0];
        buf[destId * 4 + 1] = srcBuf[srcId * 4 + 1];
        buf[destId * 4 + 2] = srcBuf[srcId * 4 + 2];
        buf[destId * 4 + 3] = srcBuf[srcId * 4 + 3];
    }

    public void swap(int id1, int id2) {
        int[] buf = this.buf;
        int temp0 = buf[id1 * 4 + 0];
        int temp1 = buf[id1 * 4 + 1];
        int temp2 = buf[id1 * 4 + 2];
        int temp3 = buf[id1 * 4 + 3];
        buf[id1 * 4 + 0] = buf[id2 * 4 + 0];
        buf[id1 * 4 + 1] = buf[id2 * 4 + 1];
        buf[id1 * 4 + 2] = buf[id2 * 4 + 2];
        buf[id1 * 4 + 3] = buf[id2 * 4 + 3];
        buf[id2 * 4 + 0] = temp0;
        buf[id2 * 4 + 1] = temp1;
        buf[id2 * 4 + 2] = temp2;
        buf[id2 * 4 + 3] = temp3;
    }

    public int getQuantizedAabbMin(int nodeId, int index) {
        switch (index) {
            default: {
                return this.buf[nodeId * 4 + 0] & 0xFFFF;
            }
            case 1: {
                return this.buf[nodeId * 4 + 0] >>> 16 & 0xFFFF;
            }
            case 2: 
        }
        return this.buf[nodeId * 4 + 1] & 0xFFFF;
    }

    public long getQuantizedAabbMin(int nodeId) {
        return (long)this.buf[nodeId * 4 + 0] & 0xFFFFFFFFL | ((long)this.buf[nodeId * 4 + 1] & 0xFFFFL) << 32;
    }

    public void setQuantizedAabbMin(int nodeId, long value) {
        this.buf[nodeId * 4 + 0] = (int)value;
        this.setQuantizedAabbMin(nodeId, 2, (short)((value & 0xFFFF00000000L) >>> 32));
    }

    public void setQuantizedAabbMax(int nodeId, long value) {
        this.setQuantizedAabbMax(nodeId, 0, (short)value);
        this.buf[nodeId * 4 + 2] = (int)(value >>> 16);
    }

    public void setQuantizedAabbMin(int nodeId, int index, int value) {
        switch (index) {
            case 0: {
                this.buf[nodeId * 4 + 0] = this.buf[nodeId * 4 + 0] & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 1: {
                this.buf[nodeId * 4 + 0] = this.buf[nodeId * 4 + 0] & 0xFFFF | (value & 0xFFFF) << 16;
                break;
            }
            case 2: {
                this.buf[nodeId * 4 + 1] = this.buf[nodeId * 4 + 1] & 0xFFFF0000 | value & 0xFFFF;
            }
        }
    }

    public int getQuantizedAabbMax(int nodeId, int index) {
        switch (index) {
            default: {
                return this.buf[nodeId * 4 + 1] >>> 16 & 0xFFFF;
            }
            case 1: {
                return this.buf[nodeId * 4 + 2] & 0xFFFF;
            }
            case 2: 
        }
        return this.buf[nodeId * 4 + 2] >>> 16 & 0xFFFF;
    }

    public long getQuantizedAabbMax(int nodeId) {
        return ((long)this.buf[nodeId * 4 + 1] & 0xFFFF0000L) >>> 16 | ((long)this.buf[nodeId * 4 + 2] & 0xFFFFFFFFL) << 16;
    }

    public void setQuantizedAabbMax(int nodeId, int index, int value) {
        switch (index) {
            case 0: {
                this.buf[nodeId * 4 + 1] = this.buf[nodeId * 4 + 1] & 0xFFFF | (value & 0xFFFF) << 16;
                break;
            }
            case 1: {
                this.buf[nodeId * 4 + 2] = this.buf[nodeId * 4 + 2] & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 2: {
                this.buf[nodeId * 4 + 2] = this.buf[nodeId * 4 + 2] & 0xFFFF | (value & 0xFFFF) << 16;
            }
        }
    }

    public int getEscapeIndexOrTriangleIndex(int nodeId) {
        return this.buf[nodeId * 4 + 3];
    }

    public void setEscapeIndexOrTriangleIndex(int nodeId, int value) {
        this.buf[nodeId * 4 + 3] = value;
    }

    public boolean isLeafNode(int nodeId) {
        return this.getEscapeIndexOrTriangleIndex(nodeId) >= 0;
    }

    public int getEscapeIndex(int nodeId) {
        assert (!this.isLeafNode(nodeId));
        return -this.getEscapeIndexOrTriangleIndex(nodeId);
    }

    public int getTriangleIndex(int nodeId) {
        assert (this.isLeafNode(nodeId));
        return this.getEscapeIndexOrTriangleIndex(nodeId) & 0x1FFFFF;
    }

    public int getPartId(int nodeId) {
        assert (this.isLeafNode(nodeId));
        return this.getEscapeIndexOrTriangleIndex(nodeId) >>> 21;
    }

    public static int getCoord(long vec, int index) {
        switch (index) {
            default: {
                return (int)(vec & 0xFFFFL) & 0xFFFF;
            }
            case 1: {
                return (int)((vec & 0xFFFF0000L) >>> 16) & 0xFFFF;
            }
            case 2: 
        }
        return (int)((vec & 0xFFFF00000000L) >>> 32) & 0xFFFF;
    }
}

