/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import java.awt.Frame;
import raskob.geometry.MassCenter;
import raskob.geometry.MathP;

public abstract class AbstractDensityFunc {
    protected final int MCX = 0;
    protected final int MCY = 1;
    protected final int AREA = 2;
    protected final int ENERGY = 3;
    private double xsteps = 200.0;
    private double ysteps = 50.0;
    private double steps = 1000.0;
    protected final boolean FAST_ENERGY = true;

    protected void setXYSteps(double xsteps, double ysteps, double steps) {
        this.xsteps = xsteps;
        this.ysteps = ysteps;
        this.steps = steps;
    }

    protected double numIntegrate2D(double x1, double x2, double m1, double t1, double m2, double t2, int type) {
        return this.numIntegrate2D(0.0, 0.0, x1, x2, m1, t1, m2, t2, type);
    }

    protected double numIntegrate2D(double zx, double zy, double x1, double x2, double m1, double t1, double m2, double t2, int type) {
        double res = 0.0;
        double xstep = (x2 - x1) / this.xsteps;
        double xcounter = x1 + 0.5 * xstep;
        while (xcounter < x2) {
            double ymax;
            double ycounter;
            if (m1 * xcounter + t1 > m2 * xcounter + t2) {
                ycounter = m2 * xcounter + t2;
                ymax = m1 * xcounter + t1;
            } else {
                ycounter = m1 * xcounter + t1;
                ymax = m2 * xcounter + t2;
            }
            double ystep = (x2 - x1) / this.ysteps;
            ycounter += 0.5 * ystep;
            while (ycounter < ymax) {
                double fac = 1.0;
                if (type == 0) {
                    fac = xcounter;
                } else if (type == 1) {
                    fac = ycounter;
                } else if (type == 3) {
                    fac = (xcounter - zx) * (xcounter - zx) + (ycounter - zy) * (ycounter - zy);
                }
                res += fac * this.calculate(xcounter, ycounter) * xstep * ystep;
                ycounter += ystep;
            }
            xcounter += xstep;
        }
        return res;
    }

    protected double calculateMCX(double x, double m, double t) {
        return new Double(Double.NaN);
    }

    protected double calculateMCY(double x, double m, double t) {
        return new Double(Double.NaN);
    }

    protected double calculateAREA(double x, double m, double t) {
        return new Double(Double.NaN);
    }

    protected double calculateENERGY(double zx, double zy, double x, double m, double t) {
        return new Double(Double.NaN);
    }

    protected double numIntegrate1D(double x1, double x2, double m, double t, int type) {
        return this.numIntegrate1D(0.0, 0.0, x1, x2, m, t, type);
    }

    protected double numIntegrate1D(double zx, double zy, double x1, double x2, double m, double t, int type) {
        double res = 0.0;
        double xstep = (x2 - x1) / this.steps;
        double xcounter = x1 + 0.5 * xstep;
        while (xcounter < x2) {
            double calc = 1.0;
            calc = type == 0 ? this.calculateMCX(xcounter, m, t) : (type == 1 ? this.calculateMCY(xcounter, m, t) : (type == 3 ? this.calculateENERGY(zx, zy, xcounter, m, t) : this.calculateAREA(xcounter, m, t)));
            res += xstep * calc;
            xcounter += xstep;
        }
        return res;
    }

    public abstract String name();

    public abstract MassCenter getMassCenter(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract double getArea(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract double getEnergy(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public double getSlowEnergy(double zx, double zy, double x1, double x2, double m1, double t1, double m2, double t2) {
        double energy = this.getEnergy(zx, zy, x1, x2, m1, t1, m2, t2);
        if (!MathP.equals(energy, 0.0)) {
            return energy;
        }
        return this.numIntegrate2D(zx, zy, x1, x2, m1, t1, m2, t2, 3);
    }

    public abstract double calculate(double var1, double var3);

    public abstract double max();

    public abstract boolean setParameters(Frame var1);
}

