/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import raskob.geometry.InsecPoint;
import raskob.geometry.InsecSweepInsec;
import raskob.geometry.InsecSweepInsecComparator;
import raskob.geometry.InsecSweepPoint;
import raskob.geometry.LineSegment;
import raskob.geometry.MathP;
import raskob.geometry.Point;
import raskob.geometry.Polygon;

public final class InsecSweepLine {
    private final LinkedList sweepLine = new LinkedList();
    private final TreeSet events = new TreeSet(new InsecSweepInsecComparator());
    private final LinkedList vertexList = new LinkedList();
    private final Polygon[] pol = new Polygon[2];
    private double sweepX;

    public InsecSweepLine(Polygon pol0, Polygon pol1) {
        this.pol[0] = pol0;
        this.pol[1] = pol1;
        this.sweepX = MathP.less(pol0.getMinX(), pol1.getMinX()) ? pol0.getMinX() : pol1.getMinX();
    }

    private int findPos(int edge0, int polN0, ListIterator iter) {
        Polygon pol0 = this.pol[polN0];
        while (iter.hasNext()) {
            boolean vl1;
            InsecSweepPoint isp = (InsecSweepPoint)iter.next();
            int edge1 = isp.getEdge();
            int polN1 = isp.getPolN();
            Polygon pol1 = this.pol[polN1];
            int compare = Polygon.compareEdgesAt(pol0, edge0, true, pol1, edge1, vl1 = isp.isVerticalLower(), this.sweepX);
            if (compare < 0) {
                iter.previous();
                return -1;
            }
            if (compare != 0) continue;
            iter.previous();
            return 0;
        }
        return 1;
    }

    private ListIterator findEdge(int vertex, int polN) {
        ListIterator iter = this.sweepLine.listIterator();
        while (iter.hasNext()) {
            InsecSweepPoint isp = (InsecSweepPoint)iter.next();
            if (isp.getEdge() != vertex || isp.getPolN() != polN) continue;
            iter.previous();
            return iter;
        }
        return null;
    }

    public final void removeEdges(int vertex, int polN) {
        Polygon pol = this.pol[polN];
        this.sweepX = pol.get(vertex).getX();
        int otherVertex = pol.getPred(vertex);
        ListIterator iter = this.findEdge(vertex, polN);
        InsecSweepPoint isp = (InsecSweepPoint)iter.next();
        iter.previous();
        iter.remove();
        if (isp.getInOrOut() == 3) {
            this.addFinalVertex(pol.get(vertex), vertex, polN, otherVertex, polN);
        }
        iter = this.findEdge(otherVertex, polN);
        isp = (InsecSweepPoint)iter.next();
        iter.previous();
        iter.remove();
        if (isp.getInOrOut() == 3) {
            this.addFinalVertex(pol.get(vertex), otherVertex, polN, vertex, polN);
        }
    }

    public final ListIterator addEdge(Point p, int vertex, int other, int polN, ListIterator iter) {
        InsecSweepPoint isp;
        boolean first;
        int inOrOut = 0;
        boolean bl = first = iter == null;
        if (iter == null) {
            iter = this.sweepLine.listIterator();
        }
        int compare = this.findPos(vertex, polN, iter);
        if (first && compare == 0) {
            iter.next();
        }
        if (iter.hasNext()) {
            isp = (InsecSweepPoint)iter.next();
            inOrOut = isp.getInOrOut();
            iter.previous();
        }
        isp = new InsecSweepPoint(vertex, polN, inOrOut);
        iter.add(isp);
        iter.previous();
        if (first) {
            this.updateEvents(iter, true, true);
        } else {
            isp.invertInOrOut(polN);
            this.updateEvents(iter, true, true);
        }
        if (isp.getInOrOut() == 3) {
            this.addNewVertex(p, vertex, polN, other, polN);
        }
        return iter;
    }

    public final void addEdges(int vertex, int polN) {
        Polygon pol = this.pol[polN];
        Point p = pol.get(vertex);
        this.sweepX = p.getX();
        int first = pol.getFirstEdge(vertex);
        int second = pol.getSecondEdge(vertex);
        ListIterator iter = this.addEdge(p, first, second, polN, null);
        InsecSweepPoint isp = (InsecSweepPoint)(iter = this.addEdge(p, second, first, polN, iter)).previous();
        if (isp.getEdge() != first || isp.getPolN() != polN) {
            isp.invertInOrOut(polN);
            this.addNewVertex(p, first, polN, isp.getEdge(), isp.getPolN());
            this.addNewVertex(p, second, polN, isp.getEdge(), isp.getPolN());
        }
    }

    public final void continueEdge(int vertex, int polN) {
        Polygon pol = this.pol[polN];
        this.sweepX = pol.get(vertex).getX();
        ListIterator iter = this.findEdge(vertex, polN);
        int otherVertex = pol.getPred(vertex);
        int thisVertex = vertex;
        if (iter == null) {
            iter = this.findEdge(otherVertex, polN);
            thisVertex = otherVertex;
            otherVertex = vertex;
        }
        InsecSweepPoint isp = (InsecSweepPoint)iter.next();
        int inOrOut = isp.getInOrOut();
        isp = new InsecSweepPoint(otherVertex, polN, inOrOut);
        iter.set(isp);
        iter.previous();
        this.updateEvents(iter, true, true);
        if (isp.getInOrOut() == 3) {
            this.addVertex(pol.get(vertex), thisVertex, polN, otherVertex, polN);
        }
        iter.next();
        if (iter.hasNext() && (isp = (InsecSweepPoint)iter.next()).getInOrOut() == 3) {
            this.addVertex(pol.get(vertex), thisVertex, polN, otherVertex, polN);
        }
    }

    private void updateEvents(ListIterator inIter, boolean testPrev, boolean testNext) {
        InsecSweepInsec iss;
        Point insec;
        ListIterator iter = this.sweepLine.listIterator(inIter.nextIndex());
        InsecSweepPoint prev = null;
        InsecSweepPoint next = null;
        LineSegment prevEdge = null;
        LineSegment nextEdge = null;
        if (iter.hasPrevious()) {
            prev = (InsecSweepPoint)iter.previous();
            iter.next();
            prevEdge = this.pol[prev.getPolN()].getEdge(prev.getEdge());
        }
        InsecSweepPoint act = (InsecSweepPoint)iter.next();
        LineSegment actEdge = this.pol[act.getPolN()].getEdge(act.getEdge());
        if (iter.hasNext()) {
            next = (InsecSweepPoint)iter.next();
            iter.previous();
            nextEdge = this.pol[next.getPolN()].getEdge(next.getEdge());
        }
        iter.previous();
        if (prev != null && testPrev && (insec = prevEdge.getIntersection(actEdge)) != null && MathP.greaterEqual(insec.getX(), this.sweepX) && prev.getPolN() != act.getPolN()) {
            iss = new InsecSweepInsec(prev.getEdge(), prev.getPolN(), act.getEdge(), act.getPolN(), insec, prev, act);
            this.events.add(iss);
        }
        if (next != null && testNext && (insec = nextEdge.getIntersection(actEdge)) != null && MathP.greaterEqual(insec.getX(), this.sweepX) && next.getPolN() != act.getPolN()) {
            iss = new InsecSweepInsec(next.getEdge(), next.getPolN(), act.getEdge(), act.getPolN(), insec, act, next);
            this.events.add(iss);
        }
    }

    public final boolean hasEvents() {
        return this.events.size() != 0;
    }

    public final Point getNextEvent() {
        if (this.events.size() == 0) {
            return null;
        }
        InsecSweepInsec iss = (InsecSweepInsec)this.events.first();
        return iss.getIntersection();
    }

    public final void handleEvent() {
        InsecSweepInsec iss = (InsecSweepInsec)this.events.first();
        this.events.remove(this.events.first());
        Point insec = iss.getIntersection();
        this.sweepX = insec.getX();
        InsecSweepPoint isp0 = iss.getIsp0();
        InsecSweepPoint isp1 = iss.getIsp1();
        int edge0 = isp0.getEdge();
        int edge1 = isp1.getEdge();
        int polN0 = isp0.getPolN();
        int polN1 = isp1.getPolN();
        Polygon pol0 = this.pol[polN0];
        Polygon pol1 = this.pol[polN1];
        int ioo0Old = isp0.getInOrOut();
        int ioo1Old = isp1.getInOrOut();
        isp0.clearVerticalLower();
        isp1.clearVerticalLower();
        boolean vl0 = isp0.isVerticalLower();
        boolean vl1 = isp1.isVerticalLower();
        int compare = Polygon.compareEdgesAt(pol0, edge0, vl0, pol1, edge1, vl1, this.sweepX);
        if (compare > 0) {
            ListIterator iter = this.findEdge(edge1, polN1);
            if (iter == null) {
                return;
            }
            iter.set(isp0);
            this.updateEvents(iter, false, true);
            iter = this.findEdge(edge0, polN0);
            if (iter == null) {
                return;
            }
            iter.set(isp1);
            this.updateEvents(iter, true, false);
            isp0.invertInOrOut(1 - polN0);
            isp1.invertInOrOut(1 - polN1);
            int ioo0 = isp0.getInOrOut();
            if (ioo0Old == 3) {
                this.addVertex(iss.getIntersection(), edge0, polN0, edge1, polN1);
            } else if (ioo1Old == 3) {
                this.addFinalVertex(iss.getIntersection(), edge1, polN1, edge0, polN0);
            } else if (ioo0 == 3) {
                this.addNewVertex(iss.getIntersection(), edge1, polN1, edge0, polN0);
            } else {
                this.addVertex(iss.getIntersection(), edge1, polN1, edge0, polN0);
            }
        }
    }

    private void addVertex(Point vertex, int fromEdge, int fromPolN, int toEdge, int toPolN) {
        InsecPoint ip = new InsecPoint(vertex, toEdge, toPolN);
        InsecPoint lastHit = null;
        LinkedList lastLl = null;
        boolean first = false;
        Iterator iter = this.vertexList.iterator();
        while (iter.hasNext()) {
            LinkedList ll = (LinkedList)iter.next();
            if (ll == null || ll.size() == 0) continue;
            InsecPoint testIp = (InsecPoint)ll.getLast();
            if (testIp.getEdge() == fromEdge && testIp.getPolN() == fromPolN && (lastHit == null || MathP.greater(Point.distance(lastHit.getVertex(), vertex), Point.distance(testIp.getVertex(), vertex)))) {
                first = false;
                lastLl = ll;
                lastHit = testIp;
                continue;
            }
            testIp = (InsecPoint)ll.getFirst();
            if (testIp.getEdge() != fromEdge || testIp.getPolN() != fromPolN || lastHit != null && !MathP.greater(Point.distance(lastHit.getVertex(), vertex), Point.distance(testIp.getVertex(), vertex))) continue;
            first = true;
            lastLl = ll;
            lastHit = testIp;
        }
        if (lastHit != null) {
            if (first) {
                lastLl.addFirst(ip);
                return;
            }
            lastLl.addLast(ip);
            return;
        }
        LinkedList<InsecPoint> ll = new LinkedList<InsecPoint>();
        ll.add(ip);
        this.vertexList.add(ll);
    }

    /*
     * Unable to fully structure code
     */
    private void addFinalVertex(Point vertex, int edge0, int polN0, int edge1, int polN1) {
        iter = this.vertexList.iterator();
        ip = null;
        lastHit = null;
        lastLl = null;
        first0 = false;
        first1 = false;
        while (iter.hasNext()) {
            ll0 = (LinkedList)iter.next();
            if (ll0 == null || ll0.size() == 0) continue;
            ip = new InsecPoint(vertex, edge0, polN0);
            testIp = (InsecPoint)ll0.getLast();
            if (testIp.getEdge() == edge0 && testIp.getPolN() == polN0 && (lastHit == null || MathP.greater(Point.distance(lastHit.getVertex(), vertex), Point.distance(testIp.getVertex(), vertex)))) {
                first0 = false;
                lastLl = ll0;
                lastHit = testIp;
                continue;
            }
            testIp = (InsecPoint)ll0.getFirst();
            if (testIp.getEdge() != edge0 || testIp.getPolN() != polN0 || lastHit != null && !MathP.greater(Point.distance(lastHit.getVertex(), vertex), Point.distance(testIp.getVertex(), vertex))) continue;
            first0 = true;
            lastLl = ll0;
            lastHit = testIp;
        }
        ll0 = lastLl;
        if (lastHit != null) {
            if (first0) {
                ll0.addFirst(ip);
            } else {
                ll0.addLast(ip);
            }
        }
        lastHit = null;
        lastLl = null;
        iter = this.vertexList.iterator();
        while (iter.hasNext()) {
            ll1 = (LinkedList)iter.next();
            if (ll1 == null || ll1.size() == 0) continue;
            ip = new InsecPoint(vertex, edge1, polN1);
            testIp = (InsecPoint)ll1.getLast();
            if (testIp.getEdge() == edge1 && testIp.getPolN() == polN1 && (lastHit == null || MathP.greater(Point.distance(lastHit.getVertex(), vertex), Point.distance(testIp.getVertex(), vertex)))) {
                first1 = false;
                lastLl = ll1;
                lastHit = testIp;
                continue;
            }
            testIp = (InsecPoint)ll1.getFirst();
            if (testIp.getEdge() != edge1 || testIp.getPolN() != polN1 || lastHit != null && !MathP.greater(Point.distance(lastHit.getVertex(), vertex), Point.distance(testIp.getVertex(), vertex))) continue;
            first1 = true;
            lastLl = ll1;
            lastHit = testIp;
        }
        ll1 = lastLl;
        if (ll0 == null || ll1 == null) {
            return;
        }
        if (ll0 != ll1) ** GOTO lbl65
        return;
lbl-1000:
        // 1 sources

        {
            if (first1) {
                ip = (InsecPoint)ll1.getFirst();
                ll1.removeFirst();
            } else {
                ip = (InsecPoint)ll1.getLast();
                ll1.removeLast();
            }
            if (first0) {
                ll0.addFirst(ip);
                continue;
            }
            ll0.addLast(ip);
lbl65:
            // 3 sources

            ** while (ll1.size() > 0)
        }
lbl66:
        // 1 sources

    }

    private void addNewVertex(Point vertex, int edge0, int polN0, int edge1, int polN1) {
        LinkedList<InsecPoint> ll = new LinkedList<InsecPoint>();
        InsecPoint ip = new InsecPoint(vertex, edge0, polN0);
        ll.add(ip);
        ip = new InsecPoint(vertex, edge1, polN1);
        ll.add(ip);
        this.vertexList.add(ll);
    }

    public final Polygon toPolygon() {
        Polygon pol = new Polygon(null);
        Iterator iter = this.vertexList.iterator();
        while (iter.hasNext()) {
            LinkedList ll = (LinkedList)iter.next();
            Iterator iter2 = ll.iterator();
            Point oldP = null;
            if (ll.size() > 0) {
                oldP = ((InsecPoint)ll.getLast()).getVertex();
                oldP.round();
            }
            Polygon inner = new Polygon(null);
            while (iter2.hasNext()) {
                InsecPoint ip = (InsecPoint)iter2.next();
                Point p = ip.getVertex();
                p.round();
                if (!oldP.equals(p)) {
                    inner.add(p);
                }
                oldP = p;
            }
            if (inner.size() <= 0) continue;
            pol.addHolePolygon(inner);
        }
        return pol;
    }
}

