/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import raskob.geometry.Line;
import raskob.geometry.MathP;
import raskob.geometry.Point;

public final class LineSegment
extends Line {
    private Point q1;
    private Point q2;

    public LineSegment(Point p1, Point p2) {
        this(p1, p2, p1, p2);
    }

    public LineSegment(Point p1, Point p2, Point q1, Point q2) {
        this(new Line(p1, p2), q1, q2);
    }

    public LineSegment(Line l, Point q1, Point q2) {
        super(l.getP1(), l.getP2());
        if (q1.equals(q2)) {
            throw new RuntimeException("Bounds identical in LineSegment()");
        }
        if (l.contains(q1)) {
            l.contains(q2);
        }
        this.q1 = Point.first(q1, q2);
        this.q2 = Point.second(q1, q2);
    }

    public final Point getQ1() {
        return this.q1;
    }

    public final Point getQ2() {
        return this.q2;
    }

    public final Point getIntersection(LineSegment ls) {
        Point intersect;
        if (super.intersects(ls) && this.contains(intersect = super.getIntersection(ls)) && ls.contains(intersect)) {
            return intersect;
        }
        if (super.equals(ls) && (this.q1.equals(ls.getP2()) || this.q2.equals(ls.getP1()))) {
            return this.q1;
        }
        return null;
    }

    public final boolean intersects(Line l) {
        Point intersect;
        return super.intersects(l) && this.contains(intersect = super.getIntersection(l));
    }

    public final boolean contains(Point p) {
        return this.checkXBounds(p.getX()) && this.checkYBounds(p.getY()) && super.contains(p);
    }

    public final double getY(double x) {
        if (this.checkXBounds(x)) {
            return super.getY(x);
        }
        throw new RuntimeException("Out of Bounds in LineSegment.getY()");
    }

    public static int compareAt(LineSegment ls0, boolean vl0, LineSegment ls1, boolean vl1, double x) {
        if (!ls0.checkXBounds(x) || !ls1.checkXBounds(x)) {
            throw new RuntimeException("Not in line segment in LineSegment.compareAt()");
        }
        double y0 = vl0 ? ls0.getQ1().getY() : ls0.getQ2().getY();
        double y1 = vl1 ? ls1.getQ1().getY() : ls1.getQ2().getY();
        if (ls0.isVertical() && ls1.isVertical()) {
            if (MathP.less(y0, y1)) {
                return -1;
            }
            return !MathP.less(y1, y0) ? 0 : 1;
        }
        if (ls0.isVertical() && MathP.equals(y0, y1 = ls1.getY(x))) {
            return 1;
        }
        if (ls1.isVertical() && MathP.equals(y0 = ls0.getY(x), y1)) {
            return -1;
        }
        if (ls0.isVertical() || ls1.isVertical()) {
            if (MathP.less(y0, y1)) {
                return -1;
            }
            if (MathP.less(y1, y0)) {
                return 1;
            }
        }
        y0 = ls0.getY(x);
        y1 = ls1.getY(x);
        double grad0 = ls0.getGradient();
        double grad1 = ls1.getGradient();
        if (MathP.less(y0, y1)) {
            return -1;
        }
        if (MathP.less(y1, y0)) {
            return 1;
        }
        if (MathP.less(grad0, grad1)) {
            return -1;
        }
        return !MathP.less(grad1, grad0) ? 0 : 1;
    }

    public final String toString() {
        String str = new String();
        str = new StringBuilder(String.valueOf(str)).append(str).append(this.getQ1().getX()).append("x").append(this.getQ1().getY()).append("/").append(this.getQ2().getX()).append("x").append(this.getQ2().getY()).toString();
        return str;
    }

    private boolean checkXBounds(double x) {
        return MathP.lessEqual(this.getQ1().getX(), x) && MathP.lessEqual(x, this.getQ2().getX());
    }

    private boolean checkYBounds(double y) {
        double y1 = MathP.min(this.getQ1().getY(), this.getQ2().getY());
        double y2 = MathP.max(this.getQ1().getY(), this.getQ2().getY());
        return MathP.lessEqual(y1, y) && MathP.lessEqual(y, y2);
    }
}

