/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import raskob.geometry.Line;
import raskob.geometry.MathP;
import raskob.geometry.Point;

public final class Matrix2x2 {
    private double x11;
    private double x12;
    private double y1;
    private double x21;
    private double x22;
    private double y2;
    private boolean solvable;
    private boolean uniValid;
    private Point solution;

    public Matrix2x2(Line l1, Line l2) {
        double x11 = l1.getP1().getX();
        double x12 = l1.getP2().getX();
        double x21 = l2.getP1().getX();
        double x22 = l2.getP2().getX();
        if (MathP.equals(x11, x12)) {
            this.x11 = 1.0;
            this.x12 = 0.0;
            this.y1 = x11;
        } else {
            double m1 = l1.getGradient();
            double t1 = l1.getOrdinate();
            this.x11 = -m1;
            this.x12 = 1.0;
            this.y1 = t1;
        }
        if (MathP.equals(x21, x22)) {
            this.x21 = 1.0;
            this.x22 = 0.0;
            this.y2 = x21;
        } else {
            double m2 = l2.getGradient();
            double t2 = l2.getOrdinate();
            this.x21 = -m2;
            this.x22 = 1.0;
            this.y2 = t2;
        }
        this.solve();
    }

    public final boolean isSolvable() {
        return this.solvable;
    }

    public final boolean isUniValid() {
        return this.uniValid;
    }

    public final Point getSolution() {
        return this.solution;
    }

    private void swapLines() {
        double dummy = this.x11;
        this.x11 = this.x21;
        this.x21 = dummy;
        dummy = this.x12;
        this.x12 = this.x22;
        this.x22 = dummy;
        dummy = this.y1;
        this.y1 = this.y2;
        this.y2 = dummy;
    }

    private boolean solve() {
        this.solvable = false;
        this.uniValid = false;
        if (this.x11 == 0.0) {
            this.swapLines();
        }
        if (this.x21 != 0.0) {
            double dummy = this.x11 / this.x21;
            this.x21 *= dummy;
            this.x22 *= dummy;
            this.y2 *= dummy;
            this.x21 -= this.x11;
            this.x22 -= this.x12;
            this.y2 -= this.y1;
        }
        if (this.x22 != 0.0) {
            this.y2 /= this.x22;
            this.x22 = 1.0;
        }
        if (this.x12 != 0.0) {
            this.y1 -= this.x12 * this.y2;
            this.x12 = 0.0;
        }
        if (this.x11 != 0.0) {
            this.y1 /= this.x11;
            this.x11 = 1.0;
        }
        if (MathP.equals(this.x22, 1.0) && MathP.equals(this.x11, 1.0)) {
            this.solution = new Point(this.y1, this.y2);
            this.solvable = true;
            return true;
        }
        if (MathP.equals(this.x22, 0.0) && MathP.equals(this.y2, 0.0) && (!MathP.equals(this.x11, 0.0) || !MathP.equals(this.x12, 0.0) || MathP.equals(this.y1, 0.0))) {
            this.uniValid = true;
            this.solvable = true;
            return true;
        }
        if (MathP.equals(this.x11, 0.0) && MathP.equals(this.x12, 0.0) && MathP.equals(this.y1, 0.0) && (!MathP.equals(this.x22, 0.0) || MathP.equals(this.y1, 0.0))) {
            this.uniValid = true;
            this.solvable = true;
            return true;
        }
        return false;
    }
}

