/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.TargetError;
import bsh.UtilEvalError;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class BeanShell {
    private static final String REQUIRED_VERSION = "2.0b1.1-jedit-1";
    private static final Object[] NO_ARGS = new Object[0];
    private static CustomClassManager classManager;
    private static Interpreter interpForMethods;
    private static NameSpace global;
    private static boolean running;

    public static void evalSelection(View view, JEditTextArea jEditTextArea) {
        String string = jEditTextArea.getSelectedText();
        if (string == null) {
            view.getToolkit().beep();
            return;
        }
        Object object = BeanShell.eval(view, global, string);
        if (object != null) {
            jEditTextArea.setSelectedText(object.toString());
        }
    }

    public static void showEvaluateDialog(View view) {
        String string = GUIUtilities.input((Component)((Object)view), "beanshell-eval-input", null);
        if (string != null) {
            if (!string.endsWith(";")) {
                string = string + ";";
            }
            int n = view.getInputHandler().getRepeatCount();
            if (view.getMacroRecorder() != null) {
                view.getMacroRecorder().record(n, string);
            }
            Object object = null;
            try {
                for (int i = 0; i < n; ++i) {
                    object = BeanShell._eval(view, global, string);
                }
            }
            catch (Throwable throwable) {
                Log.log(9, BeanShell.class, throwable);
                BeanShell.handleException(view, null, throwable);
            }
            if (object != null) {
                Object[] objectArray = new String[]{object.toString()};
                GUIUtilities.message((Component)((Object)view), "beanshell-eval", objectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showEvaluateLinesDialog(View view) {
        String string = GUIUtilities.input((Component)((Object)view), "beanshell-eval-line", null);
        JEditTextArea jEditTextArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        if (string == null || string.length() == 0) {
            return;
        }
        Selection[] selectionArray = jEditTextArea.getSelection();
        if (selectionArray.length == 0) {
            view.getToolkit().beep();
            return;
        }
        if (!string.endsWith(";")) {
            string = string + ";";
        }
        String string2 = "int[] lines = textArea.getSelectedLines();\nfor(int i = 0; i < lines.length; i++)\n{\nline = lines[i];\nindex = line - lines[0];\nstart = buffer.getLineStartOffset(line);\nend = buffer.getLineEndOffset(line);\ntext = buffer.getText(start,end - start - 1);\nnewText = " + string + "\n" + "if(newText != null)\n" + "{\n" + "buffer.remove(start,end - start - 1);\n" + "buffer.insert(start,String.valueOf(newText));\n" + "}\n" + "}\n";
        if (view.getMacroRecorder() != null) {
            view.getMacroRecorder().record(1, string2);
        }
        try {
            buffer.beginCompoundEdit();
            BeanShell.eval(view, global, string2);
        }
        finally {
            buffer.endCompoundEdit();
        }
        jEditTextArea.selectNone();
    }

    public static void runScript(View view, String string, Reader reader, boolean bl) {
        try {
            BeanShell._runScript(view, string, reader, bl);
        }
        catch (Throwable throwable) {
            Log.log(9, BeanShell.class, throwable);
            BeanShell.handleException(view, string, throwable);
        }
    }

    public static void runScript(View view, String string, Reader reader, NameSpace nameSpace) {
        try {
            BeanShell._runScript(view, string, reader, nameSpace);
        }
        catch (Throwable throwable) {
            Log.log(9, BeanShell.class, throwable);
            BeanShell.handleException(view, string, throwable);
        }
    }

    public static void _runScript(View view, String string, Reader reader, boolean bl) throws Exception {
        BeanShell._runScript(view, string, reader, bl ? new NameSpace(global, "script namespace") : global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void _runScript(View var0, String var1_1, Reader var2_2, NameSpace var3_3) throws Exception {
        block32: {
            block31: {
                block29: {
                    block30: {
                        Log.log(3, BeanShell.class, "Running script " + var1_1);
                        var4_4 = BeanShell.createInterpreter(var3_3);
                        var5_5 = null;
                        var6_6 = null;
                        if (var2_2 != null) ** GOTO lbl36
                        var7_7 = jEdit.getBuffer(var1_1);
                        var5_5 = VFSManager.getVFSForPath(var1_1);
                        var6_6 = var5_5.createVFSSession(var1_1, (Component)var0);
                        if (var6_6 != null) break block29;
                        BeanShell.running = false;
                        if (var6_6 == null) break block30;
                        try {
                            var5_5._endVFSSession(var6_6, (Component)var0);
                        }
                        catch (IOException var8_13) {
                            Log.log(9, BeanShell.class, var8_13);
                            GUIUtilities.error((Component)var0, "read-error", new String[]{var1_1, var8_13.toString()});
                        }
                    }
                    try {
                        if (var3_3 == BeanShell.global) {
                            BeanShell.resetDefaultVariables(var3_3);
                            var4_4.unset("scriptPath");
                        }
                    }
                    catch (EvalError var8_14) {
                        // empty catch block
                    }
                    return;
                }
                if (var7_7 != null) {
                    if (!var7_7.isLoaded()) {
                        VFSManager.waitForRequests();
                    }
                    var2_2 = new StringReader(var7_7.getText(0, var7_7.getLength()));
                } else {
                    var2_2 = new BufferedReader(new InputStreamReader(var5_5._createInputStream(var6_6, var1_1, false, (Component)var0)));
                }
lbl36:
                // 3 sources

                BeanShell.setupDefaultVariables(var3_3, var0);
                var4_4.set("scriptPath", var1_1);
                BeanShell.running = true;
                var4_4.eval(var2_2, var3_3, var1_1);
                BeanShell.running = false;
                if (var6_6 == null) break block31;
                try {
                    var5_5._endVFSSession(var6_6, (Component)var0);
                }
                catch (IOException var7_8) {
                    Log.log(9, BeanShell.class, var7_8);
                    GUIUtilities.error((Component)var0, "read-error", new String[]{var1_1, var7_8.toString()});
                }
            }
            try {
                if (var3_3 == BeanShell.global) {
                    BeanShell.resetDefaultVariables(var3_3);
                    var4_4.unset("scriptPath");
                }
                break block32;
            }
            catch (EvalError var7_9) {}
            break block32;
            catch (Exception var7_10) {
                block33: {
                    try {
                        BeanShell.unwrapException(var7_10);
                        BeanShell.running = false;
                        if (var6_6 == null) break block33;
                    }
                    catch (Throwable var9_15) {
                        BeanShell.running = false;
                        if (var6_6 != null) {
                            try {
                                var5_5._endVFSSession(var6_6, (Component)var0);
                            }
                            catch (IOException var10_16) {
                                Log.log(9, BeanShell.class, var10_16);
                                GUIUtilities.error((Component)var0, "read-error", new String[]{var1_1, var10_16.toString()});
                            }
                        }
                        try {
                            if (var3_3 == BeanShell.global) {
                                BeanShell.resetDefaultVariables(var3_3);
                                var4_4.unset("scriptPath");
                            }
                        }
                        catch (EvalError var10_17) {
                            // empty catch block
                        }
                        throw var9_15;
                    }
                    try {
                        var5_5._endVFSSession(var6_6, (Component)var0);
                    }
                    catch (IOException var7_11) {
                        Log.log(9, BeanShell.class, var7_11);
                        GUIUtilities.error((Component)var0, "read-error", new String[]{var1_1, var7_11.toString()});
                    }
                }
                try {
                    if (var3_3 == BeanShell.global) {
                        BeanShell.resetDefaultVariables(var3_3);
                        var4_4.unset("scriptPath");
                    }
                }
                catch (EvalError var7_12) {}
            }
        }
    }

    public static Object eval(View view, NameSpace nameSpace, String string) {
        try {
            return BeanShell._eval(view, nameSpace, string);
        }
        catch (Throwable throwable) {
            Log.log(9, BeanShell.class, throwable);
            BeanShell.handleException(view, null, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object _eval(View view, NameSpace nameSpace, String string) throws Exception {
        Interpreter interpreter = BeanShell.createInterpreter(nameSpace);
        try {
            BeanShell.setupDefaultVariables(nameSpace, view);
            if (Debug.BEANSHELL_DEBUG) {
                Log.log(1, BeanShell.class, string);
            }
            Object object = interpreter.eval(string);
            return object;
        }
        catch (Exception exception) {
            BeanShell.unwrapException(exception);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            try {
                BeanShell.resetDefaultVariables(nameSpace);
            }
            catch (UtilEvalError utilEvalError) {}
        }
    }

    public static BshMethod cacheBlock(String string, String string2, boolean bl) throws Exception {
        String string3 = "__internal_" + string;
        if (bl) {
            BeanShell._eval(null, global, string3 + "(ns) {\nthis.callstack.set(0,ns);\n" + string2 + "\n}");
            return global.getMethod(string3, new Class[]{NameSpace.class});
        }
        BeanShell._eval(null, global, string3 + "() {\n" + string2 + "\n}");
        return global.getMethod(string3, new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runCachedBlock(BshMethod bshMethod, View view, NameSpace nameSpace) throws Exception {
        boolean bl;
        if (nameSpace == null) {
            bl = false;
            nameSpace = global;
        } else {
            bl = true;
        }
        try {
            Object[] objectArray;
            BeanShell.setupDefaultVariables(nameSpace, view);
            if (bl) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = nameSpace;
            } else {
                objectArray = NO_ARGS;
            }
            Object object = bshMethod.invoke(objectArray, interpForMethods, new CallStack());
            if (object instanceof Primitive) {
                if (object == Primitive.VOID) {
                    Object var5_6 = null;
                    return var5_6;
                }
                Object object2 = ((Primitive)object).getValue();
                return object2;
            }
            Object object3 = object;
            return object3;
        }
        catch (Exception exception) {
            BeanShell.unwrapException(exception);
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            BeanShell.resetDefaultVariables(nameSpace);
        }
    }

    public static boolean isScriptRunning() {
        return running;
    }

    public static NameSpace getNameSpace() {
        return global;
    }

    public static void runScript(View view, String string, boolean bl, boolean bl2) {
        BeanShell.runScript(view, string, null, bl);
    }

    public static void runScript(View view, String string, Reader reader, boolean bl, boolean bl2) {
        BeanShell.runScript(view, string, reader, bl);
    }

    public static Object eval(View view, String string, boolean bl) {
        return BeanShell.eval(view, global, string);
    }

    public static Object eval(View view, NameSpace nameSpace, String string, boolean bl) {
        return BeanShell.eval(view, nameSpace, string);
    }

    static void init() {
        try {
            NameSpace.class.getMethod("addCommandPath", String.class, Class.class);
        }
        catch (Exception exception) {
            Log.log(9, BeanShell.class, "You have BeanShell version 2.0b1.1-jedit-1 in your CLASSPATH.");
            Log.log(9, BeanShell.class, "Please remove it from the CLASSPATH since jEdit can only run with the bundled BeanShell version 2.0b1.1-jedit-1");
            System.exit(1);
        }
        classManager = new CustomClassManager();
        classManager.setClassLoader(new JARClassLoader());
        global = new NameSpace(classManager, "jEdit embedded BeanShell interpreter");
        global.importPackage("org.gjt.sp.jedit");
        global.importPackage("org.gjt.sp.jedit.browser");
        global.importPackage("org.gjt.sp.jedit.buffer");
        global.importPackage("org.gjt.sp.jedit.gui");
        global.importPackage("org.gjt.sp.jedit.help");
        global.importPackage("org.gjt.sp.jedit.io");
        global.importPackage("org.gjt.sp.jedit.menu");
        global.importPackage("org.gjt.sp.jedit.msg");
        global.importPackage("org.gjt.sp.jedit.options");
        global.importPackage("org.gjt.sp.jedit.pluginmgr");
        global.importPackage("org.gjt.sp.jedit.print");
        global.importPackage("org.gjt.sp.jedit.search");
        global.importPackage("org.gjt.sp.jedit.syntax");
        global.importPackage("org.gjt.sp.jedit.textarea");
        global.importPackage("org.gjt.sp.util");
        interpForMethods = BeanShell.createInterpreter(global);
    }

    static void resetClassManager() {
        classManager.reset();
    }

    private static void setupDefaultVariables(NameSpace nameSpace, View view) throws UtilEvalError {
        if (view != null) {
            EditPane editPane = view.getEditPane();
            nameSpace.setVariable("view", view);
            nameSpace.setVariable("editPane", editPane);
            nameSpace.setVariable("buffer", editPane.getBuffer());
            nameSpace.setVariable("textArea", editPane.getTextArea());
            nameSpace.setVariable("wm", view.getDockableWindowManager());
        }
    }

    private static void resetDefaultVariables(NameSpace nameSpace) throws UtilEvalError {
        nameSpace.setVariable("view", null);
        nameSpace.setVariable("editPane", null);
        nameSpace.setVariable("buffer", null);
        nameSpace.setVariable("textArea", null);
        nameSpace.setVariable("wm", null);
    }

    private static void unwrapException(Exception exception) throws Exception {
        Throwable throwable;
        if (exception instanceof TargetError) {
            throwable = ((TargetError)exception).getTarget();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
        if (exception instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)exception).getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
        throw exception;
    }

    private static void handleException(View view, String string, Throwable throwable) {
        if (throwable instanceof IOException) {
            VFSManager.error((Component)((Object)view), string, "ioerror.read-error", new String[]{throwable.toString()});
        } else {
            new BeanShellErrorDialog(view, throwable);
        }
    }

    private static Interpreter createInterpreter(NameSpace nameSpace) {
        return new Interpreter(null, System.out, System.err, false, nameSpace);
    }

    static class CustomClassManager
    extends BshClassManager {
        private LinkedList listeners = new LinkedList();
        private ReferenceQueue refQueue = new ReferenceQueue();

        CustomClassManager() {
        }

        public synchronized void addListener(BshClassManager.Listener listener) {
            Reference reference;
            this.listeners.add(new WeakReference<BshClassManager.Listener>(listener, this.refQueue));
            while ((reference = this.refQueue.poll()) != null) {
                boolean bl = this.listeners.remove(reference);
                if (bl || !Interpreter.DEBUG) continue;
                Interpreter.debug("tried to remove non-existent weak ref: " + reference);
            }
        }

        public void removeListener(BshClassManager.Listener listener) {
            throw new Error("unimplemented");
        }

        public void reset() {
            this.classLoaderChanged();
        }

        protected synchronized void classLoaderChanged() {
            this.clearCaches();
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                BshClassManager.Listener listener = (BshClassManager.Listener)weakReference.get();
                if (listener == null) {
                    iterator.remove();
                    continue;
                }
                listener.classLoaderChanged();
            }
        }
    }
}

