/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import bsh.BshMethod;
import bsh.NameSpace;
import bsh.UtilEvalError;
import java.awt.Component;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class BeanShellAction
extends EditAction {
    private boolean noRepeat;
    private boolean noRecord;
    private boolean noRememberLast;
    private String code;
    private String isSelected;
    private BshMethod cachedCode;
    private BshMethod cachedIsSelected;
    private String sanitizedName;

    public BeanShellAction(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        super(string);
        this.code = string2;
        this.isSelected = string3;
        this.noRepeat = bl;
        this.noRecord = bl2;
        this.noRememberLast = bl3;
        this.sanitizedName = string.replace('.', '_').replace('-', '_');
        jEdit.setTemporaryProperty(string + ".toggle", string3 != null ? "true" : "false");
    }

    public void invoke(View view) {
        try {
            if (this.cachedCode == null) {
                String string = "action_" + this.sanitizedName;
                this.cachedCode = BeanShell.cacheBlock(string, this.code, true);
            }
            BeanShell.runCachedBlock(this.cachedCode, view, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.invoke()"));
        }
        catch (Throwable throwable) {
            Log.log(9, this, throwable);
            new BeanShellErrorDialog(view, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(Component component) {
        if (this.isSelected == null) {
            return false;
        }
        NameSpace nameSpace = BeanShell.getNameSpace();
        try {
            Object object;
            if (this.cachedIsSelected == null) {
                object = "selected_" + this.sanitizedName;
                this.cachedIsSelected = BeanShell.cacheBlock((String)object, this.isSelected, true);
            }
            object = GUIUtilities.getView(component);
            nameSpace.setVariable("_comp", component);
            boolean bl = Boolean.TRUE.equals(BeanShell.runCachedBlock(this.cachedIsSelected, (View)object, new NameSpace(BeanShell.getNameSpace(), "BeanShellAction.isSelected()")));
            return bl;
        }
        catch (Throwable throwable) {
            Log.log(9, this, throwable);
            this.isSelected = null;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                nameSpace.setVariable("_comp", null);
            }
            catch (UtilEvalError utilEvalError) {
                Log.log(9, this, utilEvalError);
            }
        }
    }

    public boolean noRepeat() {
        return this.noRepeat;
    }

    public boolean noRecord() {
        return this.noRecord;
    }

    public boolean noRememberLast() {
        return this.noRememberLast;
    }

    public String getCode() {
        return this.code.trim();
    }
}

