/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.RESyntax;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeListener;
import org.gjt.sp.jedit.buffer.BufferIORequest;
import org.gjt.sp.jedit.buffer.ContentManager;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.LineElement;
import org.gjt.sp.jedit.buffer.LineManager;
import org.gjt.sp.jedit.buffer.PositionManager;
import org.gjt.sp.jedit.buffer.RootElement;
import org.gjt.sp.jedit.buffer.UndoManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.RESearchMatcher;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.DummyTokenHandler;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ReadWriteLock;

public class Buffer {
    public static final String LINESEP = "lineSeparator";
    public static final String BACKED_UP = "Buffer__backedUp";
    public static final String CARET = "Buffer__caret";
    public static final String SELECTION = "Buffer__selection";
    public static final String SCROLL_VERT = "Buffer__scrollVert";
    public static final String SCROLL_HORIZ = "Buffer__scrollHoriz";
    public static final String ENCODING = "encoding";
    public static final String ENCODING_AUTODETECT = "encodingAutodetect";
    public static final String TRAILING_EOL = "trailingEOL";
    public static final String GZIPPED = "gzipped";
    public static final int FILE_NOT_CHANGED = 0;
    public static final int FILE_CHANGED = 1;
    public static final int FILE_DELETED = 2;
    public static final int NORMAL_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    Buffer prev;
    Buffer next;
    private static final int CLOSED = 0;
    private static final int LOADING = 1;
    private static final int IO = 2;
    private static final int NEW_FILE = 3;
    private static final int UNTITLED = 4;
    private static final int AUTOSAVE_DIRTY = 5;
    private static final int DIRTY = 6;
    private static final int READ_ONLY = 7;
    private static final int READ_ONLY_OVERRIDE = 8;
    private static final int UNDO_IN_PROGRESS = 9;
    private static final int TEMPORARY = 10;
    private static final int TRANSACTION = 11;
    private int flags;
    private String path;
    private String symlinkPath;
    private String name;
    private String directory;
    private File file;
    private File autosaveFile;
    private long modTime;
    private Mode mode;
    private HashMap properties;
    private ReadWriteLock lock = new ReadWriteLock();
    private Object propertyLock = new Object();
    private ContentManager contentMgr = new ContentManager();
    private LineManager lineMgr = new LineManager();
    private PositionManager positionMgr = new PositionManager();
    private IntegerArray integerArray = new IntegerArray();
    private UndoManager undoMgr = new UndoManager(this);
    private Vector bufferListeners = new Vector();
    private Vector markers;
    private boolean textMode;
    private TokenMarker tokenMarker;
    private Segment seg = new Segment();
    private FoldHandler foldHandler;
    private Socket waitSocket;

    public void reload(View view) {
        Object[] objectArray;
        int n;
        if (this.getFlag(6) && (n = GUIUtilities.confirm((Component)((Object)view), "changedreload", objectArray = new String[]{this.path}, 0, 2)) != 0) {
            return;
        }
        view.getEditPane().saveCaretInfo();
        this.load(view, true);
    }

    public boolean load(final View view, final boolean bl) {
        Object object;
        boolean bl2;
        if (this.isPerformingIO()) {
            GUIUtilities.error((Component)((Object)view), "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        this.setFlag(1, true);
        if (!this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, view, BufferUpdate.LOAD_STARTED));
        }
        if (bl || !this.getFlag(3)) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!bl && this.autosaveFile != null && this.autosaveFile.exists()) {
                bl2 = this.recoverAutosave(view);
            } else {
                if (this.autosaveFile != null) {
                    this.autosaveFile.delete();
                }
                bl2 = false;
            }
            if (!bl2) {
                object = VFSManager.getVFSForPath(this.path);
                if (!this.checkFileForLoad(view, (VFS)object, this.path)) {
                    this.setFlag(1, false);
                    return false;
                }
                if (!(!bl && this.getFlag(3) || ((VFS)object).load(view, this, this.path))) {
                    this.setFlag(1, false);
                    return false;
                }
            }
        } else {
            bl2 = false;
        }
        object = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = Buffer.this.getStringProperty("BufferIORequest__newPath");
                Segment segment = (Segment)Buffer.this.getProperty("BufferIORequest__loadData");
                IntegerArray integerArray = (IntegerArray)Buffer.this.getProperty("BufferIORequest__endOffsets");
                if (segment == null) {
                    segment = new Segment(new char[1024], 0, 0);
                }
                if (integerArray == null) {
                    integerArray = new IntegerArray();
                    integerArray.add(1);
                }
                try {
                    Buffer.this.writeLock();
                    Buffer.this.firePreContentRemoved(0, 0, Buffer.this.getLineCount() - 1, Buffer.this.getLength());
                    Buffer.this.contentMgr.remove(0, Buffer.this.getLength());
                    Buffer.this.lineMgr.contentRemoved(0, 0, Buffer.this.getLineCount() - 1, Buffer.this.getLength());
                    Buffer.this.positionMgr.contentRemoved(0, Buffer.this.getLength());
                    Buffer.this.fireContentRemoved(0, 0, Buffer.this.getLineCount() - 1, Buffer.this.getLength());
                    Buffer.this.contentMgr._setContent(segment.array, segment.count);
                    Buffer.this.lineMgr._contentInserted(integerArray);
                    Buffer.this.positionMgr.contentInserted(0, segment.count);
                    Buffer.this.fireContentInserted(0, 0, integerArray.getSize() - 1, segment.count - 1);
                }
                finally {
                    Buffer.this.writeUnlock();
                }
                Buffer.this.unsetProperty("BufferIORequest__loadData");
                Buffer.this.unsetProperty("BufferIORequest__endOffsets");
                Buffer.this.unsetProperty("BufferIORequest__newPath");
                Buffer.this.undoMgr.clear();
                Buffer.this.undoMgr.setLimit(jEdit.getIntegerProperty("buffer.undoCount", 100));
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.finishLoading();
                }
                Buffer.this.setFlag(1, false);
                if (bl) {
                    Buffer.this.setDirty(false);
                }
                if (!bl2 && string != null) {
                    Buffer.this.setPath(string);
                }
                if (bl2) {
                    Buffer.this.setFlag(6, true);
                }
                if (!Buffer.this.getFlag(10)) {
                    EditBus.send(new BufferUpdate(Buffer.this, view, BufferUpdate.LOADED));
                }
            }
        };
        if (this.getFlag(10)) {
            object.run();
        } else {
            VFSManager.runInAWTThread((Runnable)object);
        }
        return true;
    }

    public boolean insertFile(View view, String string) {
        if (this.isPerformingIO()) {
            GUIUtilities.error((Component)((Object)view), "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        string = MiscUtilities.constructPath(this.path, string);
        Buffer buffer = jEdit.getBuffer(string);
        if (buffer != null) {
            view.getTextArea().setSelectedText(buffer.getText(0, buffer.getLength()));
            return true;
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        return vFS.insert(view, this, string);
    }

    public void autosave() {
        if (this.autosaveFile == null || !this.getFlag(5) || !this.getFlag(6) || this.getFlag(1) || this.getFlag(2)) {
            return;
        }
        this.setFlag(5, false);
        VFSManager.runInWorkThread(new BufferIORequest(2, null, this, null, VFSManager.getFileVFS(), this.autosaveFile.getPath()));
    }

    public boolean saveAs(View view, boolean bl) {
        String[] stringArray = GUIUtilities.showVFSFileDialog(view, this.path, 1, false);
        if (stringArray == null) {
            return false;
        }
        return this.save(view, stringArray[0], bl);
    }

    public boolean save(View view, String string) {
        return this.save(view, string, true);
    }

    public boolean save(final View view, String objectArray, boolean bl) {
        Object[] objectArray2;
        int n;
        long l;
        if (this.isPerformingIO()) {
            GUIUtilities.error((Component)((Object)view), "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        if (objectArray == null && this.getFlag(3)) {
            return this.saveAs(view, bl);
        }
        if (objectArray == null && this.file != null && (l = this.file.lastModified()) != this.modTime && jEdit.getBooleanProperty("view.checkModStatus") && (n = GUIUtilities.confirm((Component)((Object)view), "filechanged-save", objectArray2 = new Object[]{this.path}, 0, 2)) != 0) {
            return false;
        }
        EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVING));
        this.setFlag(2, true);
        final String string = this.path;
        final String string2 = this.symlinkPath;
        objectArray2 = objectArray == null ? this.path : objectArray;
        VFS vFS = VFSManager.getVFSForPath((String)objectArray2);
        if (!this.checkFileForSave(view, vFS, (String)objectArray2)) {
            this.setFlag(2, false);
            return false;
        }
        if (!vFS.save(view, this, (String)objectArray2)) {
            this.setFlag(2, false);
            return false;
        }
        VFSManager.runInAWTThread(new Runnable((String)objectArray2, bl){
            final /* synthetic */ String val$newPath;
            final /* synthetic */ boolean val$rename;
            {
                this.val$newPath = string3;
                this.val$rename = bl;
            }

            public void run() {
                Buffer.this.setFlag(2, false);
                Buffer.this.finishSaving(view, string, string2, this.val$newPath, this.val$rename, Buffer.this.getBooleanProperty("BufferIORequest__error"));
            }
        });
        return true;
    }

    public int checkFileStatus(View view) {
        if (!(this.getFlag(2) || this.getFlag(1) || this.file == null || this.getFlag(3))) {
            boolean bl;
            boolean bl2 = bl = this.file.exists() && !this.file.canWrite();
            if (bl != this.getFlag(7)) {
                this.setFlag(7, bl);
                EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
            }
            long l = this.modTime;
            long l2 = this.file.lastModified();
            if (l2 != l) {
                this.modTime = l2;
                if (!this.file.exists()) {
                    this.setFlag(3, true);
                    this.setDirty(true);
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    public long getLastModified() {
        return this.modTime;
    }

    public void setLastModified(long l) {
        this.modTime = l;
    }

    public VFS getVFS() {
        return VFSManager.getVFSForPath(this.path);
    }

    public File getAutosaveFile() {
        return this.autosaveFile;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getSymlinkPath() {
        return this.symlinkPath;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isClosed() {
        return this.getFlag(0);
    }

    public boolean isLoaded() {
        return !this.getFlag(1);
    }

    public boolean isPerformingIO() {
        return this.getFlag(1) || this.getFlag(2);
    }

    public boolean isNewFile() {
        return this.getFlag(3);
    }

    public void setNewFile(boolean bl) {
        this.setFlag(3, bl);
        if (!bl) {
            this.setFlag(4, false);
        }
    }

    public boolean isUntitled() {
        return this.getFlag(4);
    }

    public boolean isDirty() {
        return this.getFlag(6);
    }

    public boolean isReadOnly() {
        return this.getFlag(7) || this.getFlag(8);
    }

    public boolean isEditable() {
        return !this.getFlag(7) && !this.getFlag(8) && !this.getFlag(2) && !this.getFlag(1);
    }

    public void setReadOnly(boolean bl) {
        this.setFlag(8, bl);
    }

    public void setDirty(boolean bl) {
        boolean bl2 = this.getFlag(6);
        boolean bl3 = this.isEditable();
        if (bl) {
            if (bl3) {
                this.setFlag(6, true);
                this.setFlag(5, true);
            }
        } else {
            this.setFlag(6, false);
            this.setFlag(5, false);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
            if (!this.getFlag(9)) {
                this.undoMgr.bufferSaved();
            }
        }
        if (bl != bl2 && bl3) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
        }
    }

    public boolean isTemporary() {
        return this.getFlag(10);
    }

    public Icon getIcon() {
        if (this.getFlag(6)) {
            return GUIUtilities.loadIcon("dirty.gif");
        }
        if (this.getFlag(7) || this.getFlag(8)) {
            return GUIUtilities.loadIcon("readonly.gif");
        }
        if (this.getFlag(3)) {
            return GUIUtilities.loadIcon("new.gif");
        }
        return GUIUtilities.loadIcon("normal.gif");
    }

    public void readLock() {
        this.lock.readLock();
    }

    public void readUnlock() {
        this.lock.readUnlock();
    }

    public void writeLock() {
        this.lock.writeLock();
    }

    public void writeUnlock() {
        this.lock.writeUnlock();
    }

    public int getLength() {
        return this.contentMgr.getLength();
    }

    public int getLineCount() {
        return this.lineMgr.getLineCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineOfOffset(int n) {
        try {
            this.readLock();
            if (n < 0 || n > this.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            int n2 = this.lineMgr.getLineOfOffset(n);
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineStartOffset(int n) {
        try {
            this.readLock();
            if (n < 0 || n >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            if (n == 0) {
                int n2 = 0;
                return n2;
            }
            int n3 = this.lineMgr.getLineEndOffset(n - 1);
            return n3;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineEndOffset(int n) {
        try {
            this.readLock();
            if (n < 0 || n >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            int n2 = this.lineMgr.getLineEndOffset(n);
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineLength(int n) {
        try {
            this.readLock();
            int n2 = this.getLineEndOffset(n) - this.getLineStartOffset(n) - 1;
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    public void invalidateCachedScreenLineCounts() {
        this.lineMgr.invalidateScreenLineCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineText(int n) {
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        try {
            this.readLock();
            int n2 = n == 0 ? 0 : this.lineMgr.getLineEndOffset(n - 1);
            int n3 = this.lineMgr.getLineEndOffset(n);
            String string = this.getText(n2, n3 - n2 - 1);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLineText(int n, Segment segment) {
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        try {
            this.readLock();
            int n2 = n == 0 ? 0 : this.lineMgr.getLineEndOffset(n - 1);
            int n3 = this.lineMgr.getLineEndOffset(n);
            this.getText(n2, n3 - n2 - 1, segment);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int n, int n2) {
        try {
            this.readLock();
            if (n < 0 || n2 < 0 || n + n2 > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n + ":" + n2);
            }
            String string = this.contentMgr.getText(n, n2);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(int n, int n2, Segment segment) {
        try {
            this.readLock();
            if (n < 0 || n2 < 0 || n + n2 > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n + ":" + n2);
            }
            this.contentMgr.getText(n, n2, segment);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int n, String string) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.writeLock();
            if (n < 0 || n > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            this.contentMgr.insert(n, string);
            this.integerArray.clear();
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(i) != '\n') continue;
                this.integerArray.add(i + 1);
            }
            if (!this.getFlag(9)) {
                this.undoMgr.contentInserted(n, n2, string, !this.getFlag(6));
            }
            this.contentInserted(n, n2, this.integerArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int n, Segment segment) {
        if (segment.count == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.writeLock();
            if (n < 0 || n > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            this.contentMgr.insert(n, segment);
            this.integerArray.clear();
            for (int i = 0; i < segment.count; ++i) {
                if (segment.array[segment.offset + i] != '\n') continue;
                this.integerArray.add(i + 1);
            }
            if (!this.getFlag(9)) {
                this.undoMgr.contentInserted(n, segment.count, segment.toString(), !this.getFlag(6));
            }
            this.contentInserted(n, segment.count, this.integerArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.isReadOnly()) {
            throw new RuntimeException("buffer read-only");
        }
        try {
            this.setFlag(11, true);
            this.writeLock();
            if (n < 0 || n2 < 0 || n + n2 > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n + ":" + n2);
            }
            int n3 = this.lineMgr.getLineOfOffset(n);
            int n4 = this.lineMgr.getLineOfOffset(n + n2);
            int n5 = n4 - n3;
            if (!this.getFlag(9) && !this.getFlag(1)) {
                this.undoMgr.contentRemoved(n, n2, this.getText(n, n2), !this.getFlag(6));
            }
            this.firePreContentRemoved(n3, n, n5, n2);
            this.contentMgr.remove(n, n2);
            this.lineMgr.contentRemoved(n3, n, n5, n2);
            this.positionMgr.contentRemoved(n, n2);
            this.fireContentRemoved(n3, n, n5, n2);
            if (!this.getFlag(9) && !this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
            this.setDirty(true);
        }
        finally {
            this.setFlag(11, false);
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo(JEditTextArea jEditTextArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            jEditTextArea.getToolkit().beep();
            return;
        }
        try {
            this.writeLock();
            this.setFlag(9, true);
            int n = this.undoMgr.undo();
            if (n == -1) {
                jEditTextArea.getToolkit().beep();
            } else {
                jEditTextArea.setCaretPosition(n);
            }
            this.fireTransactionComplete();
        }
        finally {
            this.setFlag(9, false);
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo(JEditTextArea jEditTextArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            this.writeLock();
            this.setFlag(9, true);
            int n = this.undoMgr.redo();
            if (n == -1) {
                jEditTextArea.getToolkit().beep();
            } else {
                jEditTextArea.setCaretPosition(n);
            }
            this.fireTransactionComplete();
        }
        finally {
            this.setFlag(9, false);
            this.writeUnlock();
        }
    }

    public boolean isTransactionInProgress() {
        return this.getFlag(11) || this.getFlag(9) || this.insideCompoundEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.beginCompoundEdit();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.endCompoundEdit();
            if (!this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean insideCompoundEdit() {
        return this.undoMgr.insideCompoundEdit();
    }

    public void addBufferChangeListener(BufferChangeListener bufferChangeListener, int n) {
        Listener listener = new Listener(bufferChangeListener, n);
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            Listener listener2 = (Listener)this.bufferListeners.get(i);
            if (listener2.priority >= n) continue;
            this.bufferListeners.insertElementAt(listener, i);
            return;
        }
        this.bufferListeners.addElement(listener);
    }

    public void addBufferChangeListener(BufferChangeListener bufferChangeListener) {
        this.addBufferChangeListener(bufferChangeListener, 0);
    }

    public void removeBufferChangeListener(BufferChangeListener bufferChangeListener) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            if (((Listener)this.bufferListeners.get((int)i)).listener != bufferChangeListener) continue;
            this.bufferListeners.removeElementAt(i);
            return;
        }
    }

    public BufferChangeListener[] getBufferChangeListeners() {
        BufferChangeListener[] bufferChangeListenerArray = new BufferChangeListener[this.bufferListeners.size()];
        for (int i = 0; i < bufferChangeListenerArray.length; ++i) {
            bufferChangeListenerArray[i] = ((Listener)this.bufferListeners.get((int)i)).listener;
        }
        return bufferChangeListenerArray;
    }

    public void propertiesChanged() {
        String string = this.getStringProperty("folding");
        FoldHandler foldHandler = FoldHandler.getFoldHandler(string);
        if (foldHandler != null) {
            this.setFoldHandler(foldHandler);
        } else {
            if (string != null) {
                Log.log(7, this, this.path + ": invalid 'folding' property: " + string);
            }
            this.setFoldHandler(new DummyFoldHandler());
        }
        EditBus.send(new BufferUpdate(this, null, BufferUpdate.PROPERTIES_CHANGED));
    }

    public int getTabSize() {
        int n = this.getIntegerProperty("tabSize", 8);
        if (n <= 0) {
            return 8;
        }
        return n;
    }

    public int getIndentSize() {
        int n = this.getIntegerProperty("indentSize", 8);
        if (n <= 0) {
            return 8;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(Object object) {
        Object object2 = this.propertyLock;
        synchronized (object2) {
            Object object3;
            PropValue propValue = (PropValue)this.properties.get(object);
            if (propValue != null) {
                return propValue.value;
            }
            if (!(object instanceof String)) {
                return null;
            }
            if (this.mode != null) {
                Object object4 = this.mode.getProperty((String)object);
                if (object4 == null) {
                    return null;
                }
                this.properties.put(object, new PropValue(object4, true));
                return object4;
            }
            String string = jEdit.getProperty("buffer." + object);
            if (string == null) {
                return null;
            }
            try {
                object3 = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                object3 = string;
            }
            this.properties.put(object, new PropValue(object3, true));
            return object3;
        }
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            this.properties.remove(string);
        } else {
            PropValue propValue = (PropValue)this.properties.get(string);
            if (propValue == null) {
                this.properties.put(string, new PropValue(object, false));
            } else if (!propValue.value.equals(object)) {
                propValue.value = object;
                propValue.defaultValue = false;
            }
        }
    }

    public void unsetProperty(String string) {
        this.properties.remove(string);
    }

    public String getStringProperty(String string) {
        Object object = this.getProperty(string);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public void setStringProperty(String string, String string2) {
        this.setProperty(string, string2);
    }

    public boolean getBooleanProperty(String string) {
        Object object = this.getProperty(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return "true".equals(object) || "on".equals(object) || "yes".equals(object);
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.setProperty(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getIntegerProperty(String string, int n) {
        boolean bl;
        Object object;
        PropValue propValue = (PropValue)this.properties.get(string);
        if (propValue != null) {
            object = propValue.value;
            bl = propValue.defaultValue;
        } else {
            object = this.getProperty(string);
            bl = true;
        }
        if (object == null) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            int n2 = Integer.parseInt(object.toString().trim());
            this.properties.put(string, new PropValue(new Integer(n2), bl));
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void setIntegerProperty(String string, int n) {
        this.setProperty(string, new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RE getRegexpProperty(String string, int n, RESyntax rESyntax) throws REException {
        Object object = this.propertyLock;
        synchronized (object) {
            boolean bl;
            Object object2;
            PropValue propValue = (PropValue)this.properties.get(string);
            if (propValue != null) {
                object2 = propValue.value;
                bl = propValue.defaultValue;
            } else {
                object2 = this.getProperty(string);
                bl = true;
            }
            if (object2 == null) {
                return null;
            }
            if (object2 instanceof RE) {
                return (RE)object2;
            }
            RE rE = new RE(object2.toString(), n, rESyntax);
            this.properties.put(string, new PropValue(rE, bl));
            return rE;
        }
    }

    public ParserRuleSet getRuleSetAtOffset(int n) {
        int n2;
        if ((n -= this.getLineStartOffset(n2 = this.getLineOfOffset(n))) != 0) {
            --n;
        }
        DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
        this.markTokens(n2, defaultTokenHandler);
        Token token = TextUtilities.getTokenAtOffset(defaultTokenHandler.getTokens(), n);
        return token.rules;
    }

    public KeywordMap getKeywordMapAtOffset(int n) {
        return this.getRuleSetAtOffset(n).getKeywords();
    }

    public String getContextSensitiveProperty(int n, String string) {
        ParserRuleSet parserRuleSet = this.getRuleSetAtOffset(n);
        Object object = null;
        Hashtable hashtable = parserRuleSet.getProperties();
        if (hashtable != null) {
            object = hashtable.get(string);
        }
        if (object == null && (object = jEdit.getMode(parserRuleSet.getModeName()).getProperty(string)) == null) {
            object = this.mode.getProperty(string);
        }
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public void toggleWordWrap(View view) {
        String string = this.getStringProperty("wrap");
        if (string.equals("none")) {
            string = "soft";
        } else if (string.equals("soft")) {
            string = "hard";
        } else if (string.equals("hard")) {
            string = "none";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.wrap-changed", new String[]{string}));
        this.setProperty("wrap", string);
        this.propertiesChanged();
    }

    public void toggleLineSeparator(View view) {
        String string = null;
        String string2 = this.getStringProperty(LINESEP);
        if ("\n".equals(string2)) {
            string = "windows";
            string2 = "\r\n";
        } else if ("\r\n".equals(string2)) {
            string = "mac";
            string2 = "\r";
        } else if ("\r".equals(string2)) {
            string = "unix";
            string2 = "\n";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.linesep-changed", new String[]{jEdit.getProperty("lineSep." + string)}));
        this.setProperty(LINESEP, string2);
        this.setDirty(true);
        this.propertiesChanged();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.setMode(jEdit.getMode(string));
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException("Mode must be non-null");
        }
        this.mode = mode;
        this.textMode = "text".equals(mode.getName());
        this.setTokenMarker(mode.getTokenMarker());
        this.resetCachedProperties();
        this.propertiesChanged();
    }

    public void setMode() {
        Object object;
        String string = this.getStringProperty("mode");
        if (string != null && (object = jEdit.getMode(string)) != null) {
            this.setMode((Mode)object);
            return;
        }
        object = this.name.substring(0, this.name.length() - (this.name.endsWith(".gz") ? 3 : 0));
        Mode[] modeArray = jEdit.getModes();
        String string2 = this.getLineText(0);
        for (int i = modeArray.length - 1; i >= 0; --i) {
            if (!modeArray[i].accept((String)object, string2)) continue;
            this.setMode(modeArray[i]);
            return;
        }
        Mode mode = jEdit.getMode(jEdit.getProperty("buffer.defaultMode"));
        if (mode == null) {
            mode = jEdit.getMode("text");
        }
        this.setMode(mode);
    }

    public void markTokens(int n, TokenHandler tokenHandler) {
        int n2;
        Segment segment = SwingUtilities.isEventDispatchThread() ? this.seg : new Segment();
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = this.lineMgr.getFirstInvalidLineContext();
        int n4 = this.textMode || n3 == -1 ? n : Math.min(n3, n);
        if (Debug.TOKEN_MARKER_DEBUG) {
            Log.log(1, this, "tokenize from " + n4 + " to " + n);
        }
        TokenMarker.LineContext lineContext = null;
        TokenMarker.LineContext lineContext2 = null;
        for (n2 = n4; n2 <= n; ++n2) {
            this.getLineText(n2, segment);
            lineContext = this.lineMgr.getLineContext(n2);
            TokenMarker.LineContext lineContext3 = n2 == 0 || this.textMode ? null : this.lineMgr.getLineContext(n2 - 1);
            lineContext2 = this.tokenMarker.markTokens(lineContext3, n2 == n ? tokenHandler : DummyTokenHandler.INSTANCE, segment);
            this.lineMgr.setLineContext(n2, lineContext2);
        }
        n2 = this.lineMgr.getLineCount();
        if (n2 - 1 == n) {
            this.lineMgr.setFirstInvalidLineContext(-1);
        } else if (lineContext != lineContext2) {
            this.lineMgr.setFirstInvalidLineContext(n + 1);
        } else if (n3 != -1) {
            this.lineMgr.setFirstInvalidLineContext(Math.max(n3, n + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrailingWhiteSpace(int[] nArray) {
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                int n2;
                this.getLineText(nArray[i], this.seg);
                if (this.seg.count == 0) continue;
                int n3 = this.seg.offset;
                for (n2 = n = this.seg.offset + this.seg.count - 1; n2 >= n3 && Character.isWhitespace(this.seg.array[n2]); --n2) {
                }
                int n4 = n - n2;
                if (n4 == 0) continue;
                this.remove(this.getLineEndOffset(nArray[i]) - 1 - n4, n4);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentLeft(int[] nArray) {
        int n = this.getTabSize();
        int n2 = this.getIndentSize();
        boolean bl = this.getBooleanProperty("noTabs");
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = this.getLineStartOffset(nArray[i]);
                String string = this.getLineText(nArray[i]);
                int n4 = MiscUtilities.getLeadingWhiteSpace(string);
                if (n4 == 0) continue;
                int n5 = Math.max(0, MiscUtilities.getLeadingWhiteSpaceWidth(string, n) - n2);
                this.insert(n3 + n4, MiscUtilities.createWhiteSpace(n5, bl ? 0 : n));
                this.remove(n3, n4);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentRight(int[] nArray) {
        try {
            this.beginCompoundEdit();
            int n = this.getTabSize();
            int n2 = this.getIndentSize();
            boolean bl = this.getBooleanProperty("noTabs");
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = this.getLineStartOffset(nArray[i]);
                String string = this.getLineText(nArray[i]);
                int n4 = MiscUtilities.getLeadingWhiteSpace(string);
                int n5 = MiscUtilities.getLeadingWhiteSpaceWidth(string, n) + n2;
                this.insert(n3 + n4, MiscUtilities.createWhiteSpace(n5, bl ? 0 : n));
                this.remove(n3, n4);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int n, int n2) {
        try {
            this.beginCompoundEdit();
            for (int i = n; i <= n2; ++i) {
                this.indentLine(i, true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int[] nArray) {
        try {
            this.beginCompoundEdit();
            for (int i = 0; i < nArray.length; ++i) {
                this.indentLine(nArray[i], true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    public boolean indentLine(int n, boolean bl, boolean bl2) {
        return this.indentLine(n, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indentLine(int n, boolean bl) {
        int[] nArray = new int[1];
        int n2 = this.getCurrentIndentForLine(n, nArray);
        int n3 = this.getIdealIndentForLine(n);
        if (n3 == -1 || n3 == n2 || !bl && n3 < n2) {
            return false;
        }
        try {
            this.beginCompoundEdit();
            int n4 = this.getLineStartOffset(n);
            this.remove(n4, nArray[0]);
            this.insert(n4, MiscUtilities.createWhiteSpace(n3, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize()));
        }
        finally {
            this.endCompoundEdit();
        }
        return true;
    }

    public int getCurrentIndentForLine(int n, int[] nArray) {
        this.getLineText(n, this.seg);
        int n2 = this.getTabSize();
        int n3 = 0;
        block4: for (int i = 0; i < this.seg.count; ++i) {
            char c = this.seg.array[this.seg.offset + i];
            switch (c) {
                case ' ': {
                    ++n3;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
                case '\t': {
                    n3 += n2 - n3 % n2;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIdealIndentForLine(int n) {
        int n2;
        int n3;
        int n4;
        RE rE;
        RE rE2;
        String string;
        if (n == 0) {
            return -1;
        }
        String string2 = this.getStringProperty("indentOpenBrackets");
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.getStringProperty("indentCloseBrackets")) == null) {
            string = "";
        }
        try {
            rE2 = this.getRegexpProperty("indentNextLine", 2, RESearchMatcher.RE_SYNTAX_JEDIT);
        }
        catch (REException rEException) {
            rE2 = null;
            Log.log(9, this, "Invalid indentNextLine regexp");
            Log.log(9, this, rEException);
        }
        try {
            rE = this.getRegexpProperty("indentNextLines", 2, RESearchMatcher.RE_SYNTAX_JEDIT);
        }
        catch (REException rEException) {
            rE = null;
            Log.log(9, this, "Invalid indentNextLines regexp");
            Log.log(9, this, rEException);
        }
        boolean bl = this.getBooleanProperty("doubleBracketIndent");
        boolean bl2 = this.getBooleanProperty("lineUpClosingBracket");
        int n5 = this.getTabSize();
        int n6 = this.getIndentSize();
        int n7 = this.getPriorNonEmptyLine(n);
        if (n7 == -1) {
            return -1;
        }
        String string3 = this.getLineText(n7);
        boolean bl3 = true;
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int n11 = -1;
        int n12 = 0;
        Stack<Integer> stack = new Stack<Integer>();
        block8: for (int i = 0; i < string3.length(); ++i) {
            n4 = string3.charAt(i);
            switch (n4) {
                case 32: {
                    if (!bl3) continue block8;
                    ++n8;
                    continue block8;
                }
                case 9: {
                    if (!bl3) continue block8;
                    n8 += n5 - n8 % n5;
                    continue block8;
                }
                default: {
                    bl3 = false;
                    if (string.indexOf(n4) != -1) {
                        if (string3.regionMatches(false, i, "}}}", 0, 3)) {
                            i += 2;
                            continue block8;
                        }
                        if (--n9 >= 0) continue block8;
                        if (bl2) {
                            n9 = 0;
                        }
                        n10 = i;
                        continue block8;
                    }
                    if (string2.indexOf(n4) != -1) {
                        if (string3.regionMatches(false, i, "{{{", 0, 3)) {
                            i += 2;
                            continue block8;
                        }
                        ++n9;
                        continue block8;
                    }
                    if (n4 == 40) {
                        stack.push(new Integer(i));
                        ++n12;
                        continue block8;
                    }
                    if (n4 != 41) continue block8;
                    if (stack.size() > 0) {
                        stack.pop();
                    }
                    --n12;
                }
            }
        }
        if (stack.size() > 0) {
            n11 = (Integer)stack.pop();
        }
        if (Debug.INDENT_DEBUG) {
            Log.log(1, this, "Determined previous line");
            Log.log(1, this, "indent=" + n8 + ",prevLineBrackets=" + n9 + ",prevLineCloseBracketIndex=" + n10);
        }
        String string4 = this.getLineText(n);
        n4 = 0;
        int n13 = -1;
        for (n3 = 0; n3 < string4.length(); ++n3) {
            n2 = string4.charAt(n3);
            if (string.indexOf(n2) != -1) {
                if (string4.regionMatches(false, n3, "}}}", 0, 3)) {
                    n3 += 2;
                    continue;
                }
                n13 = n3;
                --n4;
                continue;
            }
            if (string2.indexOf(n2) == -1) continue;
            if (string4.regionMatches(false, n3, "{{{", 0, 3)) {
                n3 += 2;
                continue;
            }
            if (n4 < 0) continue;
            ++n4;
        }
        if (Debug.INDENT_DEBUG) {
            Log.log(1, this, "Determined current line");
            Log.log(1, this, "lineBrackets=" + n4 + ",closeBracketIndex=" + n13);
        }
        if (this.getBooleanProperty("deepIndent")) {
            if (n12 > 0) {
                n8 = n11 + 1;
                for (n3 = 0; n3 < string3.length(); ++n3) {
                    if (string3.charAt(n3) != '\t') continue;
                    n8 += n5 - 1;
                }
                return n8;
            }
            if (n12 < 0 && (n3 = TextUtilities.findMatchingBracket(this, n7, string3.lastIndexOf(")"))) >= 0) {
                n2 = this.getLineOfOffset(n3);
                int n14 = this.getLineParenWeight(n2);
                n8 = n14 == 1 ? this.getCurrentIndentForLine(n2, null) : this.getOpenParenIndent(n2, n);
            }
        }
        if (n9 > 0) {
            n8 += n6 * n9;
        }
        if (bl2) {
            if (n4 < 0) {
                n3 = TextUtilities.findMatchingBracket(this, n, n13);
                if (n3 == -1) return -1;
                n2 = this.getLineOfOffset(n3);
                String string5 = this.getLineText(n2);
                Log.log(1, this, "parenWeight of " + string5 + " is " + this.getLineParenWeight(n2));
                if (this.getLineParenWeight(n2) < 0) {
                    n3 = TextUtilities.findMatchingBracket(this, n2, string5.indexOf(")"));
                    Log.log(1, this, "openBracketIndex: " + n3);
                }
                string5 = this.getLineText(this.getLineOfOffset(n3));
                Log.log(1, this, "openLine: " + string5);
                n8 = MiscUtilities.getLeadingWhiteSpaceWidth(string5, n5);
                Log.log(1, this, "indent: " + n8);
            }
        } else if (n9 < 0) {
            n3 = TextUtilities.findMatchingBracket(this, n7, n10);
            if (n3 == -1) return -1;
            String string6 = this.getLineText(this.getLineOfOffset(n3));
            n8 = MiscUtilities.getLeadingWhiteSpaceWidth(string6, n5);
        }
        if (n4 < 0) return n8;
        if ((n4 == 0 || bl) && rE != null && rE.isMatch(string3)) {
            if (Debug.INDENT_DEBUG) {
                Log.log(1, this, "Matches indentNextLines");
            }
            n8 += n6;
            return n8;
        } else {
            if (rE2 == null) return n8;
            if ((n4 == 0 || bl) && rE2.isMatch(string3)) {
                n8 += n6;
                return n8;
            } else {
                if (n9 != 0) return n8;
                n3 = this.getPriorNonEmptyLine(n7);
                while (n3 != -1 && rE2.isMatch(this.getLineText(n3))) {
                    n8 = this.getCurrentIndentForLine(n3, null);
                    if (Debug.INDENT_DEBUG) {
                        Log.log(1, this, n3 + " matches " + "indentNextLine");
                    }
                    n3 = this.getPriorNonEmptyLine(n3);
                }
            }
        }
        return n8;
    }

    private int getLineParenWeight(int n) {
        String string = this.getLineText(n);
        int n2 = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': {
                    ++n2;
                    continue block4;
                }
                case ')': {
                    --n2;
                    continue block4;
                }
            }
        }
        return n2;
    }

    private int getOpenParenIndent(int n, int n2) {
        int n3;
        Stack<Integer> stack = new Stack<Integer>();
        for (n3 = n; n3 < n2; ++n3) {
            String string = this.getLineText(n3);
            block5: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '(': {
                        stack.push(new Integer(i));
                        continue block5;
                    }
                    case ')': {
                        if (stack.size() <= 0) continue block5;
                        stack.pop();
                        continue block5;
                    }
                }
            }
        }
        n3 = this.getCurrentIndentForLine(n, null);
        if (stack.size() > 0) {
            n3 += ((Integer)stack.pop()).intValue();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVirtualWidth(int n, int n2) {
        try {
            this.readLock();
            int n3 = this.getLineStartOffset(n);
            this.getText(n3, n2, this.seg);
            int n4 = MiscUtilities.getVirtualWidth(this.seg, this.getTabSize());
            return n4;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffsetOfVirtualColumn(int n, int n2, int[] nArray) {
        try {
            this.readLock();
            this.getLineText(n, this.seg);
            int n3 = MiscUtilities.getOffsetOfVirtualColumn(this.seg, this.getTabSize(), n2, nArray);
            return n3;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAtColumn(int n, int n2, String string) {
        try {
            this.writeLock();
            int[] nArray = new int[1];
            int n3 = this.getOffsetOfVirtualColumn(n, n2, nArray);
            if (n3 == -1) {
                n3 = this.getLineEndOffset(n) - 1;
                string = MiscUtilities.createWhiteSpace(n2 - nArray[0], 0) + string;
            } else {
                n3 += this.getLineStartOffset(n);
            }
            this.insert(n3, string);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertIndented(int n, String string) {
        try {
            int n2;
            this.beginCompoundEdit();
            int n3 = this.getLineOfOffset(n);
            String string2 = this.getLineText(n3);
            int n4 = MiscUtilities.getLeadingWhiteSpaceWidth(string2, this.getTabSize());
            String string3 = MiscUtilities.createWhiteSpace(n4, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize());
            this.insert(n, string);
            int n5 = this.getLineOfOffset(n + string.length());
            for (n2 = n3 + 1; n2 <= n5; ++n2) {
                this.insert(this.getLineStartOffset(n2), string3);
            }
            n2 = string3.length();
            return n2;
        }
        finally {
            this.endCompoundEdit();
        }
    }

    public void putProperty(Object object, Object object2) {
        if (!(object instanceof String)) {
            return;
        }
        this.setProperty((String)object, object2);
    }

    public void putBooleanProperty(String string, boolean bl) {
        this.setBooleanProperty(string, bl);
    }

    public TokenList markTokens(int n) {
        TokenList tokenList = new TokenList();
        this.markTokens(n, tokenList);
        return tokenList;
    }

    public Element[] getRootElements() {
        return new Element[]{this.getDefaultRootElement()};
    }

    public Element getParagraphElement(int n) {
        return new LineElement(this, this.getLineOfOffset(n));
    }

    public Element getDefaultRootElement() {
        return new RootElement(this);
    }

    public void insertString(int n, String string, AttributeSet attributeSet) {
        this.insert(n, string);
    }

    public File getFile() {
        return this.file;
    }

    public int getCurrentIdentForLine(int n, int[] nArray) {
        return this.getCurrentIndentForLine(n, nArray);
    }

    public boolean isFoldStart(int n) {
        return n != this.getLineCount() - 1 && this.getFoldLevel(n) < this.getFoldLevel(n + 1);
    }

    public boolean isFoldEnd(int n) {
        return n != this.getLineCount() - 1 && this.getFoldLevel(n) > this.getFoldLevel(n + 1);
    }

    public void invalidateCachedFoldLevels() {
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldLevelChanged(0, this.getLineCount());
    }

    public int getFoldLevel(int n) {
        if (n < 0 || n >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.foldHandler instanceof DummyFoldHandler) {
            return 0;
        }
        int n2 = this.lineMgr.getFirstInvalidFoldLevel();
        if (n2 == -1 || n < n2) {
            return this.lineMgr.getFoldLevel(n);
        }
        if (Debug.FOLD_DEBUG) {
            Log.log(1, this, "Invalid fold levels from " + n2 + " to " + n);
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = n2; i <= n; ++i) {
            n3 = this.foldHandler.getFoldLevel(this, i, this.seg);
            if (n3 != this.lineMgr.getFoldLevel(i)) {
                if (Debug.FOLD_DEBUG) {
                    Log.log(1, this, i + " fold level changed");
                }
                bl = true;
            }
            this.lineMgr.setFoldLevel(i, n3);
        }
        if (n == this.lineMgr.getLineCount() - 1) {
            this.lineMgr.setFirstInvalidFoldLevel(-1);
        } else {
            this.lineMgr.setFirstInvalidFoldLevel(n + 1);
        }
        if (bl) {
            if (Debug.FOLD_DEBUG) {
                Log.log(1, this, "fold level changed: " + n2 + "," + n);
            }
            this.fireFoldLevelChanged(n2, n);
        }
        return n3;
    }

    public int[] getFoldAtLine(int n) {
        int n2;
        int n3;
        int n4;
        if (this.isFoldStart(n)) {
            n4 = n;
            n3 = this.getFoldLevel(n);
            ++n;
            while (this.getFoldLevel(n) > n3 && ++n != this.getLineCount()) {
            }
            n2 = n - 1;
        } else {
            n3 = this.getFoldLevel(n);
            for (n4 = n; this.getFoldLevel(n4) >= n3 && n4 != 0; --n4) {
            }
            n2 = n;
            while (this.getFoldLevel(n2) >= n3 && ++n2 != this.getLineCount()) {
            }
            --n2;
        }
        while (this.getLineLength(n2) == 0 && n2 > n4) {
            --n2;
        }
        return new int[]{n4, n2};
    }

    public FoldHandler getFoldHandler() {
        return this.foldHandler;
    }

    public void setFoldHandler(FoldHandler foldHandler) {
        FoldHandler foldHandler2 = this.foldHandler;
        if (foldHandler.equals(foldHandler2)) {
            return;
        }
        this.foldHandler = foldHandler;
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldHandlerChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position createPosition(int n) {
        try {
            this.readLock();
            if (n < 0 || n > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            Position position = this.positionMgr.createPosition(n);
            return position;
        }
        finally {
            this.readUnlock();
        }
    }

    public Vector getMarkers() {
        return this.markers;
    }

    public String getMarkerStatusPrompt(String string) {
        return jEdit.getProperty("view.status." + string, new String[]{this.getMarkerNameString()});
    }

    public String getMarkerNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            if (marker.getShortcut() == '\u0000') continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(marker.getShortcut());
        }
        if (stringBuffer.length() == 0) {
            return jEdit.getProperty("view.status.no-markers");
        }
        return stringBuffer.toString();
    }

    public void addOrRemoveMarker(char c, int n) {
        int n2 = this.getLineOfOffset(n);
        if (this.getMarkerAtLine(n2) != null) {
            this.removeMarker(n2);
        } else {
            this.addMarker(c, n);
        }
    }

    public void addMarker(char c, int n) {
        Marker marker = new Marker(this, c, n);
        boolean bl = false;
        if (!this.getFlag(1)) {
            Marker marker2;
            int n2;
            if (jEdit.getBooleanProperty("persistentMarkers")) {
                this.setDirty(true);
            }
            marker.createPosition();
            for (n2 = 0; n2 < this.markers.size(); ++n2) {
                marker2 = (Marker)this.markers.elementAt(n2);
                if (c != '\u0000' && marker2.getShortcut() == c) {
                    marker2.setShortcut('\u0000');
                }
                if (marker2.getPosition() != n) continue;
                this.markers.removeElementAt(n2);
                --n2;
            }
            for (n2 = 0; n2 < this.markers.size(); ++n2) {
                marker2 = (Marker)this.markers.elementAt(n2);
                if (marker2.getPosition() <= n) continue;
                this.markers.insertElementAt(marker, n2);
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.markers.addElement(marker);
        }
        if (!this.getFlag(1) && !this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarkerInRange(int n, int n2) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            int n3 = marker.getPosition();
            if (n3 < n || n3 >= n2) continue;
            return marker;
        }
        return null;
    }

    public Marker getMarkerAtLine(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            if (this.getLineOfOffset(marker.getPosition()) != n) continue;
            return marker;
        }
        return null;
    }

    public void removeMarker(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            if (this.getLineOfOffset(marker.getPosition()) != n) continue;
            if (jEdit.getBooleanProperty("persistentMarkers")) {
                this.setDirty(true);
            }
            marker.removePosition();
            this.markers.removeElementAt(i);
            --i;
        }
        EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
    }

    public void removeAllMarkers() {
        if (jEdit.getBooleanProperty("persistentMarkers")) {
            this.setDirty(true);
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            ((Marker)this.markers.elementAt(i)).removePosition();
        }
        this.markers.removeAllElements();
        if (!this.getFlag(1)) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarker(char c) {
        Enumeration enumeration = this.markers.elements();
        while (enumeration.hasMoreElements()) {
            Marker marker = (Marker)enumeration.nextElement();
            if (marker.getShortcut() != c) continue;
            return marker;
        }
        return null;
    }

    public void setWaitSocket(Socket socket) {
        this.waitSocket = socket;
    }

    public Buffer getNext() {
        return this.next;
    }

    public Buffer getPrev() {
        return this.prev;
    }

    public int getIndex() {
        int n = 0;
        Buffer buffer = this.prev;
        while (buffer != null) {
            ++n;
            buffer = buffer.prev;
        }
        return n;
    }

    public String toString() {
        return this.name + " (" + this.directory + ")";
    }

    public LineManager _getLineManager() {
        return this.lineMgr;
    }

    Buffer(String string, boolean bl, boolean bl2, Hashtable hashtable) {
        Object object;
        this.markers = new Vector();
        this.properties = new HashMap();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Object v = hashtable.get(object);
            this.properties.put(object, new PropValue(v, false));
        }
        if (this.getProperty(ENCODING) == null) {
            object = VFSManager.getVFSForPath(string);
            this.properties.put(ENCODING, new PropValue(((VFS)object).getDefaultEncoding(string), false));
        }
        if (this.getProperty(LINESEP) == null) {
            this.properties.put(LINESEP, new PropValue(System.getProperty("line.separator"), false));
        }
        this.setFlag(10, bl2);
        this.setPath(string);
        this.setFlag(4, bl);
        this.setFlag(3, bl);
    }

    void commitTemporary() {
        this.setFlag(10, false);
        this.finishLoading();
    }

    void resetCachedProperties() {
        Iterator iterator = this.properties.values().iterator();
        while (iterator.hasNext()) {
            PropValue propValue = (PropValue)iterator.next();
            if (!propValue.defaultValue) continue;
            iterator.remove();
        }
    }

    void close() {
        this.setFlag(0, true);
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
        }
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= 1 << n) : (this.flags &= ~(1 << n));
    }

    private boolean getFlag(int n) {
        int n2 = 1 << n;
        return (this.flags & n2) == n2;
    }

    private void setPath(String string) {
        this.path = string;
        VFS vFS = VFSManager.getVFSForPath(string);
        if ((vFS.getCapabilities() & 2) == 0) {
            this.setFlag(7, true);
        }
        this.name = vFS.getFileName(string);
        this.directory = vFS.getParentOfPath(string);
        if (vFS instanceof FileVFS) {
            this.file = new File(string);
            this.symlinkPath = MiscUtilities.resolveSymlinks(string);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
            this.autosaveFile = new File(this.file.getParent(), '#' + this.name + '#');
        } else {
            this.file = null;
            this.autosaveFile = null;
            this.symlinkPath = string;
        }
    }

    private boolean recoverAutosave(final View view) {
        if (!this.autosaveFile.canRead()) {
            return false;
        }
        GUIUtilities.hideSplashScreen();
        final Object[] objectArray = new Object[]{this.autosaveFile.getPath()};
        int n = GUIUtilities.confirm((Component)((Object)view), "autosave-found", objectArray, 0, 2);
        if (n == 0) {
            VFSManager.getFileVFS().load(view, this, this.autosaveFile.getPath());
            VFSManager.runInAWTThread(new Runnable(){

                public void run() {
                    GUIUtilities.message((Component)((Object)view), "autosave-loaded", objectArray);
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkFileForLoad(View view, VFS vFS, String string) {
        if ((vFS.getCapabilities() & 0x40) != 0) {
            Object object;
            block22: {
                VFS.DirectoryEntry directoryEntry;
                block21: {
                    block20: {
                        object = vFS.createVFSSession(string, (Component)((Object)view));
                        if (object == null) {
                            return false;
                        }
                        directoryEntry = vFS._getDirectoryEntry(object, string, (Component)((Object)view));
                        if (directoryEntry != null) break block20;
                        this.setNewFile(true);
                        boolean bl = true;
                        try {
                            vFS._endVFSSession(object, (Component)((Object)view));
                        }
                        catch (IOException iOException) {
                            VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                            return false;
                        }
                        return bl;
                    }
                    if (directoryEntry.canRead) break block21;
                    VFSManager.error((Component)((Object)view), string, "ioerror.no-read", null);
                    this.setNewFile(false);
                    boolean bl = false;
                    try {
                        vFS._endVFSSession(object, (Component)((Object)view));
                    }
                    catch (IOException iOException) {
                        VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                        return false;
                    }
                    return bl;
                }
                this.setFlag(7, !directoryEntry.canWrite);
                if (directoryEntry.type == 0) break block22;
                VFSManager.error((Component)((Object)view), string, "ioerror.open-directory", null);
                this.setNewFile(false);
                boolean bl = false;
                try {
                    vFS._endVFSSession(object, (Component)((Object)view));
                }
                catch (IOException iOException) {
                    VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                    return false;
                }
                return bl;
            }
            try {
                vFS._endVFSSession(object, (Component)((Object)view));
            }
            catch (IOException iOException) {
                VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                return false;
            }
            catch (IOException iOException) {
                boolean bl;
                try {
                    VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        vFS._endVFSSession(object, (Component)((Object)view));
                    }
                    catch (IOException iOException2) {
                        VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException2.toString()});
                        return false;
                    }
                    throw throwable;
                }
                try {
                    vFS._endVFSSession(object, (Component)((Object)view));
                }
                catch (IOException iOException3) {
                    VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException3.toString()});
                    return false;
                }
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkFileForSave(View view, VFS vFS, String string) {
        if ((vFS.getCapabilities() & 0x40) != 0) {
            Object object;
            block18: {
                VFS.DirectoryEntry directoryEntry;
                block17: {
                    object = vFS.createVFSSession(string, (Component)((Object)view));
                    if (object == null) {
                        return false;
                    }
                    directoryEntry = vFS._getDirectoryEntry(object, string, (Component)((Object)view));
                    if (directoryEntry != null) break block17;
                    boolean bl = true;
                    try {
                        vFS._endVFSSession(object, (Component)((Object)view));
                    }
                    catch (IOException iOException) {
                        VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                        return false;
                    }
                    return bl;
                }
                if (directoryEntry.type == 0) break block18;
                VFSManager.error((Component)((Object)view), string, "ioerror.save-directory", null);
                boolean bl = false;
                try {
                    vFS._endVFSSession(object, (Component)((Object)view));
                }
                catch (IOException iOException) {
                    VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                    return false;
                }
                return bl;
            }
            try {
                vFS._endVFSSession(object, (Component)((Object)view));
            }
            catch (IOException iOException) {
                VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                return false;
            }
            catch (IOException iOException) {
                boolean bl;
                try {
                    VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException.toString()});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        vFS._endVFSSession(object, (Component)((Object)view));
                    }
                    catch (IOException iOException2) {
                        VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException2.toString()});
                        return false;
                    }
                    throw throwable;
                }
                try {
                    vFS._endVFSSession(object, (Component)((Object)view));
                }
                catch (IOException iOException3) {
                    VFSManager.error((Component)((Object)view), string, "ioerror", new String[]{iOException3.toString()});
                    return false;
                }
                return bl;
            }
        }
        return true;
    }

    private void finishLoading() {
        this.parseBufferLocalProperties();
        FoldHandler foldHandler = this.foldHandler;
        this.setMode();
        if (this.foldHandler == foldHandler) {
            this.lineMgr.setFirstInvalidFoldLevel(0);
            this.fireFoldHandlerChanged();
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = (Marker)this.markers.elementAt(i);
            marker.removePosition();
            int n = marker.getPosition();
            if (n > this.getLength()) {
                marker.setPosition(this.getLength());
            } else if (n < 0) {
                marker.setPosition(0);
            }
            marker.createPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSaving(View view, String string, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        if (!bl2 && !string3.equals(string)) {
            object = jEdit.getBuffer(string3);
            if (bl) {
                if (object != null && !((Buffer)object).getPath().equals(string)) {
                    ((Buffer)object).setDirty(false);
                    jEdit.closeBuffer(view, (Buffer)object);
                }
                this.setPath(string3);
            } else if (object != null && !((Buffer)object).getPath().equals(string)) {
                ((Buffer)object).load(view, true);
            }
        }
        if (bl) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!bl2) {
                try {
                    this.writeLock();
                    if (this.autosaveFile != null) {
                        this.autosaveFile.delete();
                    }
                    this.setFlag(5, false);
                    this.setFlag(7, false);
                    this.setFlag(3, false);
                    this.setFlag(4, false);
                    this.setFlag(6, false);
                    this.undoMgr.bufferSaved();
                }
                finally {
                    this.writeUnlock();
                }
                this.parseBufferLocalProperties();
                if (!this.getPath().equals(string)) {
                    jEdit.updatePosition(string2, this);
                    this.setMode();
                } else {
                    object = this.getStringProperty("mode");
                    if (object != null && !((String)object).equals(this.getMode().getName())) {
                        this.setMode();
                    } else {
                        this.propertiesChanged();
                    }
                }
                EditBus.send(new BufferUpdate(this, view, BufferUpdate.DIRTY_CHANGED));
                EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVED));
            }
        }
    }

    private void parseBufferLocalProperties() {
        int n = Math.min(9, this.getLineCount() - 1);
        this.parseBufferLocalProperties(this.getText(0, this.getLineEndOffset(n) - 1));
        int n2 = Math.max(n + 1, this.getLineCount() - 10);
        if (n2 < this.getLineCount()) {
            int n3 = this.getLineEndOffset(this.getLineCount() - 1) - (this.getLineStartOffset(n2) + 1);
            this.parseBufferLocalProperties(this.getText(this.getLineStartOffset(n2), n3));
        }
    }

    private void parseBufferLocalProperties(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        boolean bl = false;
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ':': {
                    if (bl) {
                        bl = false;
                        stringBuffer.append(':');
                        continue block8;
                    }
                    if (string2 != null) {
                        this.properties.put(string2, new PropValue(stringBuffer.toString(), false));
                        string2 = null;
                    }
                    stringBuffer.setLength(0);
                    continue block8;
                }
                case '=': {
                    if (bl) {
                        bl = false;
                        stringBuffer.append('=');
                        continue block8;
                    }
                    string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    continue block8;
                }
                case '\\': {
                    if (bl) {
                        stringBuffer.append('\\');
                    }
                    bl = !bl;
                    continue block8;
                }
                case 'n': {
                    if (bl) {
                        stringBuffer.append('\n');
                        bl = false;
                        continue block8;
                    }
                }
                case 'r': {
                    if (bl) {
                        stringBuffer.append('\r');
                        bl = false;
                        continue block8;
                    }
                }
                case 't': {
                    if (bl) {
                        stringBuffer.append('\t');
                        bl = false;
                        continue block8;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
    }

    private void setTokenMarker(TokenMarker tokenMarker) {
        TokenMarker tokenMarker2 = this.tokenMarker;
        this.tokenMarker = tokenMarker;
        if (tokenMarker2 != null && tokenMarker != tokenMarker2) {
            this.lineMgr.setFirstInvalidLineContext(0);
        }
    }

    private int getPriorNonEmptyLine(int n) {
        int n2 = -1;
        for (int i = n - 1; i >= 0; --i) {
            this.getLineText(i, this.seg);
            if (this.seg.count != 0) {
                n2 = i;
            }
            for (int j = 0; j < this.seg.count; ++j) {
                char c = this.seg.array[this.seg.offset + j];
                if (Character.isWhitespace(c)) continue;
                return i;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contentInserted(int n, int n2, IntegerArray integerArray) {
        try {
            this.setFlag(11, true);
            int n3 = this.lineMgr.getLineOfOffset(n);
            int n4 = integerArray.getSize();
            this.lineMgr.contentInserted(n3, n, n4, n2, integerArray);
            this.positionMgr.contentInserted(n, n2);
            this.setDirty(true);
            if (!this.getFlag(1)) {
                this.fireContentInserted(n3, n, n4, n2);
                if (!this.getFlag(9) && !this.insideCompoundEdit()) {
                    this.fireTransactionComplete();
                }
            }
        }
        finally {
            this.setFlag(11, false);
        }
    }

    private BufferChangeListener getListener(int n) {
        return ((Listener)this.bufferListeners.elementAt((int)n)).listener;
    }

    private void fireFoldLevelChanged(int n, int n2) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).foldLevelChanged(this, n, n2);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireContentInserted(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).contentInserted(this, n, n2, n3, n4);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireContentRemoved(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).contentRemoved(this, n, n2, n3, n4);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    private void firePreContentRemoved(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).preContentRemoved(this, n, n2, n3, n4);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireTransactionComplete() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).transactionComplete(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireFoldHandlerChanged() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            try {
                this.getListener(i).foldHandlerChanged(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer event to " + this.getListener(i) + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    public static class TokenList
    extends DefaultTokenHandler {
        public Token getFirstToken() {
            return this.getTokens();
        }
    }

    static class PropValue {
        Object value;
        boolean defaultValue;

        PropValue(Object object, boolean bl) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.value = object;
            this.defaultValue = bl;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static class Listener {
        BufferChangeListener listener;
        int priority;

        Listener(BufferChangeListener bufferChangeListener, int n) {
            this.listener = bufferChangeListener;
            this.priority = n;
        }
    }
}

