/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class BufferHistory {
    private static LinkedList history = new LinkedList();
    private static boolean pathsCaseInsensitive = OperatingSystem.isDOSDerived() || OperatingSystem.isMacOS();
    private static long recentModTime;

    public static Entry getEntry(String string) {
        for (Entry entry : history) {
            if (!(pathsCaseInsensitive ? entry.path.equalsIgnoreCase(string) : entry.path.equals(string))) continue;
            return entry;
        }
        return null;
    }

    public static void setEntry(String string, int n, Selection[] selectionArray, String string2) {
        BufferHistory.removeEntry(string);
        BufferHistory.addEntry(new Entry(string, n, BufferHistory.selectionToString(selectionArray), string2));
        EditBus.send(new DynamicMenuChanged("recent-files"));
    }

    public static List getHistory() {
        return history;
    }

    public static Vector getBufferHistory() {
        Vector vector = new Vector(history.size());
        Iterator iterator = history.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        File file = new File(MiscUtilities.constructPath(string, "recent.xml"));
        if (!file.exists()) {
            return;
        }
        recentModTime = file.lastModified();
        Log.log(3, BufferHistory.class, "Loading recent.xml");
        RecentHandler recentHandler = new RecentHandler();
        XmlParser xmlParser = new XmlParser();
        Reader reader = null;
        xmlParser.setHandler(recentHandler);
        try {
            reader = new BufferedReader(new FileReader(file));
            xmlParser.parse(null, null, reader);
        }
        catch (XmlException xmlException) {
            int n = xmlException.getLine();
            String string2 = xmlException.getMessage();
            Log.log(9, BufferHistory.class, file + ":" + n + ": " + string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            Log.log(9, BufferHistory.class, exception);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                Log.log(9, BufferHistory.class, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        File file = new File(MiscUtilities.constructPath(string, "#recent.xml#save#"));
        File file2 = new File(MiscUtilities.constructPath(string, "recent.xml"));
        if (file2.exists() && file2.lastModified() != recentModTime) {
            Log.log(7, BufferHistory.class, file2 + " changed on disk; will not save recent" + " files");
            return;
        }
        jEdit.backupSettingsFile(file2);
        Log.log(3, BufferHistory.class, "Saving " + file);
        String string2 = System.getProperty("line.separator");
        boolean bl = false;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.write(string2);
            bufferedWriter.write("<!DOCTYPE RECENT SYSTEM \"recent.dtd\">");
            bufferedWriter.write(string2);
            bufferedWriter.write("<RECENT>");
            bufferedWriter.write(string2);
            Iterator iterator = history.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write("<ENTRY>");
                bufferedWriter.write(string2);
                Entry entry = (Entry)iterator.next();
                bufferedWriter.write("<PATH>");
                bufferedWriter.write(MiscUtilities.charsToEntities(entry.path));
                bufferedWriter.write("</PATH>");
                bufferedWriter.write(string2);
                bufferedWriter.write("<CARET>");
                bufferedWriter.write(String.valueOf(entry.caret));
                bufferedWriter.write("</CARET>");
                bufferedWriter.write(string2);
                if (entry.selection != null && entry.selection.length() > 0) {
                    bufferedWriter.write("<SELECTION>");
                    bufferedWriter.write(entry.selection);
                    bufferedWriter.write("</SELECTION>");
                    bufferedWriter.write(string2);
                }
                if (entry.encoding != null) {
                    bufferedWriter.write("<ENCODING>");
                    bufferedWriter.write(entry.encoding);
                    bufferedWriter.write("</ENCODING>");
                    bufferedWriter.write(string2);
                }
                bufferedWriter.write("</ENTRY>");
                bufferedWriter.write(string2);
            }
            bufferedWriter.write("</RECENT>");
            bufferedWriter.write(string2);
            bufferedWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Log.log(9, BufferHistory.class, exception);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bl) {
            file2.delete();
            file.renameTo(file2);
        }
        recentModTime = file2.lastModified();
    }

    static void addEntry(Entry entry) {
        history.addFirst(entry);
        int n = jEdit.getIntegerProperty("recentFiles", 50);
        while (history.size() > n) {
            history.removeLast();
        }
    }

    static void removeEntry(String string) {
        Iterator iterator = history.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (pathsCaseInsensitive) {
                if (!entry.path.equalsIgnoreCase(string)) continue;
                iterator.remove();
                return;
            }
            if (!entry.path.equals(string)) continue;
            iterator.remove();
            return;
        }
    }

    private static String selectionToString(Selection[] selectionArray) {
        if (selectionArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < selectionArray.length; ++i) {
            Selection selection;
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if ((selection = selectionArray[i]) instanceof Selection.Range) {
                stringBuffer.append("range ");
            } else {
                stringBuffer.append("rect ");
            }
            stringBuffer.append(selection.getStart());
            stringBuffer.append(' ');
            stringBuffer.append(selection.getEnd());
        }
        return stringBuffer.toString();
    }

    private static Selection[] stringToSelection(String string) {
        Object[] objectArray;
        if (string == null) {
            return null;
        }
        Vector<Selection.Range> vector = new Vector<Selection.Range>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 < n) continue;
            Selection selection = objectArray.equals("range") ? new Selection.Range(n, n2) : new Selection.Rect(n, n2);
            vector.addElement((Selection.Range)selection);
        }
        objectArray = new Selection[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static class RecentHandler
    extends HandlerBase {
        private String path;
        private int caret;
        private String selection;
        private String encoding;
        private String charData;

        RecentHandler() {
        }

        public void endDocument() throws Exception {
            int n = jEdit.getIntegerProperty("recentFiles", 50);
            while (history.size() > n) {
                history.removeLast();
            }
        }

        public Object resolveEntity(String string, String string2) {
            if ("recent.dtd".equals(string2)) {
                return new StringReader("<!-- -->");
            }
            return null;
        }

        public void doctypeDecl(String string, String string2, String string3) throws Exception {
            if ("RECENT".equals(string)) {
                return;
            }
            Log.log(9, this, "recent.xml: DOCTYPE must be RECENT");
        }

        public void endElement(String string) {
            if (string.equals("ENTRY")) {
                history.addLast(new Entry(this.path, this.caret, this.selection, this.encoding));
                this.path = null;
                this.caret = 0;
                this.selection = null;
                this.encoding = null;
            } else if (string.equals("PATH")) {
                this.path = this.charData;
            } else if (string.equals("CARET")) {
                this.caret = Integer.parseInt(this.charData);
            } else if (string.equals("SELECTION")) {
                this.selection = this.charData;
            } else if (string.equals("ENCODING")) {
                this.encoding = this.charData;
            }
        }

        public void charData(char[] cArray, int n, int n2) {
            this.charData = new String(cArray, n, n2);
        }
    }

    public static class Entry {
        public String path;
        public int caret;
        public String selection;
        public String encoding;

        public Selection[] getSelection() {
            return BufferHistory.stringToSelection(this.selection);
        }

        public Entry(String string, int n, String string2, String string3) {
            this.path = string;
            this.caret = n;
            this.selection = string2;
            this.encoding = string3;
        }

        public String toString() {
            return this.path + ": " + this.caret;
        }
    }
}

