/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSFileChooserDialog;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.SplashScreen;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedCheckBoxMenuItem;
import org.gjt.sp.jedit.menu.EnhancedMenu;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.Log;

public class GUIUtilities {
    public static Icon NEW_BUFFER_ICON;
    public static Icon DIRTY_BUFFER_ICON;
    public static Icon READ_ONLY_BUFFER_ICON;
    public static Icon NORMAL_BUFFER_ICON;
    public static Icon WINDOW_ICON;
    private static SplashScreen splash;
    private static Hashtable icons;
    private static String iconPath;
    private static String defaultIconPath;

    public static void setIconPath(String string) {
        iconPath = string;
        if (icons != null) {
            icons.clear();
        }
    }

    public static Icon loadIcon(String string) {
        Icon icon;
        if (icons == null) {
            icons = new Hashtable();
        }
        if ((icon = (Icon)icons.get(string)) != null) {
            return icon;
        }
        icon = View.loadPlatformIcon(string);
        if (icon == null) {
            if (MiscUtilities.isURL(string)) {
                icon = new ImageIcon(string.substring(5));
            } else {
                try {
                    URL uRL = new URL(iconPath + string);
                    icon = new ImageIcon(uRL);
                }
                catch (Exception exception) {
                    try {
                        URL uRL = new URL(defaultIconPath + string);
                        icon = new ImageIcon(uRL);
                    }
                    catch (Exception exception2) {
                        Log.log(9, GUIUtilities.class, "Icon not found: " + string);
                        Log.log(9, GUIUtilities.class, exception2);
                        return null;
                    }
                }
            }
        }
        icons.put(string, icon);
        return icon;
    }

    public static Image getEditorIcon() {
        return ((ImageIcon)GUIUtilities.loadIcon("jedit-icon.gif")).getImage();
    }

    public static Image getPluginIcon() {
        return GUIUtilities.getEditorIcon();
    }

    public static JMenuBar loadMenuBar(String string) {
        return GUIUtilities.loadMenuBar(jEdit.getActionContext(), string);
    }

    public static JMenuBar loadMenuBar(ActionContext actionContext, String string) {
        String string2 = jEdit.getProperty(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        JMenuBar jMenuBar = new JMenuBar();
        while (stringTokenizer.hasMoreTokens()) {
            jMenuBar.add(GUIUtilities.loadMenu(actionContext, stringTokenizer.nextToken()));
        }
        return jMenuBar;
    }

    public static JMenu loadMenu(String string) {
        return GUIUtilities.loadMenu(jEdit.getActionContext(), string);
    }

    public static JMenu loadMenu(ActionContext actionContext, String string) {
        return new EnhancedMenu(string, jEdit.getProperty(string.concat(".label")), actionContext);
    }

    public static JPopupMenu loadPopupMenu(String string) {
        return GUIUtilities.loadPopupMenu(jEdit.getActionContext(), string);
    }

    public static JPopupMenu loadPopupMenu(ActionContext actionContext, String string) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string2 = jEdit.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("-")) {
                    jPopupMenu.addSeparator();
                    continue;
                }
                jPopupMenu.add(GUIUtilities.loadMenuItem(actionContext, string3, false));
            }
        }
        return jPopupMenu;
    }

    public static JMenuItem loadMenuItem(String string) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), string, true);
    }

    public static JMenuItem loadMenuItem(String string, boolean bl) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), string, bl);
    }

    public static JMenuItem loadMenuItem(ActionContext actionContext, String string, boolean bl) {
        char c;
        int n;
        if (string.startsWith("%")) {
            return GUIUtilities.loadMenu(actionContext, string.substring(1));
        }
        String string2 = jEdit.getProperty(string + ".label");
        if (string2 == null) {
            string2 = string;
        }
        if ((n = string2.indexOf(36)) != -1 && string2.length() - n > 1) {
            c = Character.toLowerCase(string2.charAt(n + 1));
            string2 = string2.substring(0, n).concat(string2.substring(++n));
        } else {
            c = '\u0000';
        }
        JMenuItem jMenuItem = jEdit.getBooleanProperty(string + ".toggle") ? new EnhancedCheckBoxMenuItem(string2, string, actionContext) : new EnhancedMenuItem(string2, string, actionContext);
        if (!OperatingSystem.isMacOS() && bl && c != '\u0000') {
            jMenuItem.setMnemonic(c);
        }
        return jMenuItem;
    }

    public static Box loadToolBar(String string) {
        return GUIUtilities.loadToolBar(jEdit.getActionContext(), string);
    }

    public static Box loadToolBar(ActionContext actionContext, String string) {
        Box box = new Box(0);
        String string2 = jEdit.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("-")) {
                    box.add(Box.createHorizontalStrut(12));
                    continue;
                }
                EnhancedButton enhancedButton = GUIUtilities.loadToolButton(actionContext, string3);
                if (enhancedButton == null) continue;
                box.add(enhancedButton);
            }
        }
        box.add(Box.createGlue());
        return box;
    }

    public static EnhancedButton loadToolButton(String string) {
        return GUIUtilities.loadToolButton(jEdit.getActionContext(), string);
    }

    public static EnhancedButton loadToolButton(ActionContext actionContext, String string) {
        Icon icon;
        String string2;
        String string3 = jEdit.getProperty(string + ".label");
        if (string3 == null) {
            string3 = string;
        }
        if ((string2 = jEdit.getProperty(string + ".icon")) == null) {
            icon = GUIUtilities.loadIcon("BrokenImage.png");
        } else {
            icon = GUIUtilities.loadIcon(string2);
            if (icon == null) {
                icon = GUIUtilities.loadIcon("BrokenImage.png");
            }
        }
        String string4 = GUIUtilities.prettifyMenuLabel(string3);
        String string5 = jEdit.getProperty(string + ".shortcut");
        String string6 = jEdit.getProperty(string + ".shortcut2");
        if (string5 != null || string6 != null) {
            string4 = string4 + " (" + (string5 != null ? string5 : "") + (string5 != null && string6 != null ? " or " : "") + (string6 != null ? string6 : "") + ")";
        }
        return new EnhancedButton(icon, string4, string, actionContext);
    }

    public static String prettifyMenuLabel(String string) {
        int n = string.indexOf(36);
        if (n != -1) {
            string = string.substring(0, n).concat(string.substring(n + 1));
        }
        return string;
    }

    public static void message(Component component, String string, Object[] objectArray) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title"), objectArray), 1);
    }

    public static void error(Component component, String string, Object[] objectArray) {
        GUIUtilities.hideSplashScreen();
        JOptionPane.showMessageDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title"), objectArray), 0);
    }

    public static String input(Component component, String string, Object object) {
        return GUIUtilities.input(component, string, null, object);
    }

    public static String inputProperty(Component component, String string, String string2) {
        return GUIUtilities.inputProperty(component, string, null, string2);
    }

    public static String input(Component component, String string, Object[] objectArray, Object object) {
        GUIUtilities.hideSplashScreen();
        String string2 = (String)JOptionPane.showInputDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title")), 3, null, null, object);
        return string2;
    }

    public static String inputProperty(Component component, String string, Object[] objectArray, String string2) {
        GUIUtilities.hideSplashScreen();
        String string3 = (String)JOptionPane.showInputDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title")), 3, null, null, jEdit.getProperty(string2));
        if (string3 != null) {
            jEdit.setProperty(string2, string3);
        }
        return string3;
    }

    public static int confirm(Component component, String string, Object[] objectArray, int n, int n2) {
        GUIUtilities.hideSplashScreen();
        return JOptionPane.showConfirmDialog(component, jEdit.getProperty(string + ".message", objectArray), jEdit.getProperty(string + ".title"), n, n2);
    }

    public static String[] showVFSFileDialog(View view, String string, int n, boolean bl) {
        if (view == null) {
            Log.log(7, GUIUtilities.class, "showVFSFileDialog(): given null view, assuming jEdit.getActiveView()");
            view = jEdit.getActiveView();
        }
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog vFSFileChooserDialog = new VFSFileChooserDialog(view, string, n, bl);
        String[] stringArray = vFSFileChooserDialog.getSelectedFiles();
        if (stringArray == null) {
            return null;
        }
        return stringArray;
    }

    public static Color parseColor(String string) {
        return GUIUtilities.parseColor(string, Color.black);
    }

    public static Color parseColor(String string, Color color) {
        if (string == null) {
            return color;
        }
        if (string.startsWith("#")) {
            try {
                return Color.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                return color;
            }
        }
        if ("red".equals(string)) {
            return Color.red;
        }
        if ("green".equals(string)) {
            return Color.green;
        }
        if ("blue".equals(string)) {
            return Color.blue;
        }
        if ("yellow".equals(string)) {
            return Color.yellow;
        }
        if ("orange".equals(string)) {
            return Color.orange;
        }
        if ("white".equals(string)) {
            return Color.white;
        }
        if ("lightGray".equals(string)) {
            return Color.lightGray;
        }
        if ("gray".equals(string)) {
            return Color.gray;
        }
        if ("darkGray".equals(string)) {
            return Color.darkGray;
        }
        if ("black".equals(string)) {
            return Color.black;
        }
        if ("cyan".equals(string)) {
            return Color.cyan;
        }
        if ("magenta".equals(string)) {
            return Color.magenta;
        }
        if ("pink".equals(string)) {
            return Color.pink;
        }
        return color;
    }

    public static String getColorHexString(Color color) {
        String string = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - string.length()).concat(string);
    }

    public static SyntaxStyle parseStyle(String string, String string2, int n) throws IllegalArgumentException {
        return GUIUtilities.parseStyle(string, string2, n, true);
    }

    public static SyntaxStyle parseStyle(String string, String string2, int n, boolean bl) throws IllegalArgumentException {
        Color color = Color.black;
        Color color2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("color:")) {
                if (!bl) continue;
                color = GUIUtilities.parseColor(string3.substring(6), Color.black);
                continue;
            }
            if (string3.startsWith("bgColor:")) {
                if (!bl) continue;
                color2 = GUIUtilities.parseColor(string3.substring(8), null);
                continue;
            }
            if (string3.startsWith("style:")) {
                for (int i = 6; i < string3.length(); ++i) {
                    if (string3.charAt(i) == 'i') {
                        bl2 = true;
                        continue;
                    }
                    if (string3.charAt(i) == 'b') {
                        bl3 = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid style: " + string3);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + string3);
        }
        return new SyntaxStyle(color, color2, new Font(string2, (bl2 ? 2 : 0) | (bl3 ? 1 : 0), n));
    }

    public static String getStyleString(SyntaxStyle syntaxStyle) {
        StringBuffer stringBuffer = new StringBuffer();
        if (syntaxStyle.getForegroundColor() != null) {
            stringBuffer.append("color:" + GUIUtilities.getColorHexString(syntaxStyle.getForegroundColor()));
        }
        if (syntaxStyle.getBackgroundColor() != null) {
            stringBuffer.append(" bgColor:" + GUIUtilities.getColorHexString(syntaxStyle.getBackgroundColor()));
        }
        if (!syntaxStyle.getFont().isPlain()) {
            stringBuffer.append(" style:" + (syntaxStyle.getFont().isItalic() ? "i" : "") + (syntaxStyle.getFont().isBold() ? "b" : ""));
        }
        return stringBuffer.toString();
    }

    public static SyntaxStyle[] loadStyles(String string, int n) {
        return GUIUtilities.loadStyles(string, n, true);
    }

    public static SyntaxStyle[] loadStyles(String string, int n, boolean bl) {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[19];
        for (int i = 1; i < syntaxStyleArray.length; ++i) {
            try {
                String string2 = "view.style." + Token.tokenToString((byte)i).toLowerCase();
                syntaxStyleArray[i] = GUIUtilities.parseStyle(jEdit.getProperty(string2), string, n, bl);
                continue;
            }
            catch (Exception exception) {
                Log.log(9, GUIUtilities.class, exception);
            }
        }
        return syntaxStyleArray;
    }

    public static void loadGeometry(Window window, String string) {
        Dimension dimension = window.getSize();
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = jEdit.getIntegerProperty(string + ".width", dimension.width);
        int n4 = jEdit.getIntegerProperty(string + ".height", dimension.height);
        Container container = window.getParent();
        if (container == null) {
            n += (rectangle.width - n3) / 2;
            n2 += (rectangle.height - n4) / 2;
        } else {
            Rectangle rectangle2 = container.getBounds();
            n += rectangle2.x + (rectangle2.width - n3) / 2;
            n2 += rectangle2.y + (rectangle2.height - n4) / 2;
        }
        n = jEdit.getIntegerProperty(string + ".x", n);
        n2 = jEdit.getIntegerProperty(string + ".y", n2);
        int n5 = jEdit.getIntegerProperty(string + ".extendedState", 0);
        Rectangle rectangle3 = new Rectangle(n, n2, n3, n4);
        GUIUtilities.adjustForScreenBounds(rectangle3);
        if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
            new UnixWorkaround(window, string, rectangle3, n5);
        } else {
            window.setBounds(rectangle3);
            if (window instanceof Frame) {
                GUIUtilities.setExtendedState((Frame)window, n5);
            }
        }
    }

    public static void adjustForScreenBounds(Rectangle rectangle) {
        Rectangle rectangle2 = OperatingSystem.getScreenBounds(rectangle);
        if (rectangle.x < rectangle2.x || rectangle.x + rectangle.width > rectangle.x + rectangle2.width) {
            if (rectangle.width > rectangle2.width) {
                rectangle.width = rectangle2.width;
            }
            rectangle.x = (rectangle2.width - rectangle.width) / 2;
        }
        if (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            if (rectangle.height >= rectangle2.height) {
                rectangle.height = rectangle2.height;
            }
            rectangle.y = (rectangle2.height - rectangle.height) / 2;
        }
    }

    public static void saveGeometry(Window window, String string) {
        if (window instanceof Frame) {
            jEdit.setIntegerProperty(string + ".extendedState", GUIUtilities.getExtendedState((Frame)window));
        }
        Rectangle rectangle = window.getBounds();
        jEdit.setIntegerProperty(string + ".x", rectangle.x);
        jEdit.setIntegerProperty(string + ".y", rectangle.y);
        jEdit.setIntegerProperty(string + ".width", rectangle.width);
        jEdit.setIntegerProperty(string + ".height", rectangle.height);
    }

    public static int getExtendedState(Frame frame) {
        if (OperatingSystem.hasJava14()) {
            try {
                Method method = Frame.class.getMethod("getExtendedState", new Class[0]);
                Integer n = (Integer)method.invoke((Object)frame, new Object[0]);
                return n;
            }
            catch (Exception exception) {
                Log.log(9, GUIUtilities.class, exception);
            }
        }
        return 0;
    }

    public static void setExtendedState(Frame frame, int n) {
        if (OperatingSystem.hasJava14()) {
            try {
                Method method = Frame.class.getMethod("setExtendedState", Integer.TYPE);
                method.invoke((Object)frame, new Integer(n));
            }
            catch (Exception exception) {
                Log.log(9, GUIUtilities.class, exception);
            }
        }
    }

    public static void centerOnScreen(Window window) {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        int n = rectangle.x + (rectangle.width - window.getWidth()) / 2;
        int n2 = rectangle.y + (rectangle.height - window.getHeight()) / 2;
        window.setLocation(n, n2);
    }

    public static void hideSplashScreen() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    public static JComponent createMultilineLabel(String string) {
        int n;
        JPanel jPanel = new JPanel(new VariableGridLayout(2, 1, 1, 1));
        int n2 = 0;
        while ((n = string.indexOf(10, n2)) != -1) {
            jPanel.add(new JLabel(string.substring(n2, n)));
            n2 = n + 1;
        }
        if (n2 != string.length()) {
            jPanel.add(new JLabel(string.substring(n2)));
        }
        return jPanel;
    }

    public static void requestFocus(final Window window, final Component component) {
        window.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        component.requestFocus();
                    }
                });
                window.removeWindowListener(this);
            }
        });
    }

    public static boolean isPopupTrigger(MouseEvent mouseEvent) {
        return GUIUtilities.isRightButton(mouseEvent.getModifiers());
    }

    public static boolean isMiddleButton(int n) {
        if (OperatingSystem.isMacOS()) {
            if ((n & 0x10) != 0) {
                return (n & 8) != 0;
            }
            if (!OperatingSystem.hasJava14()) {
                return (n & 4) != 0;
            }
            return (n & 8) != 0;
        }
        return (n & 8) != 0;
    }

    public static boolean isRightButton(int n) {
        if (OperatingSystem.isMacOS()) {
            if ((n & 0x10) != 0) {
                return (n & 2) != 0;
            }
            if (!OperatingSystem.hasJava14()) {
                return (n & 8) != 0;
            }
            return (n & 4) != 0;
        }
        return (n & 4) != 0;
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        GUIUtilities.showPopupMenu(jPopupMenu, component, n, n2, true);
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2, boolean bl) {
        Component component2;
        int n3 = 0;
        int n4 = 0;
        int n5 = bl ? 1 : 0;
        for (component2 = component; !(component2 instanceof Window) && component2 != null; component2 = component2.getParent()) {
            n3 += component2.getX();
            n4 += component2.getY();
        }
        if (component2 != null) {
            Dimension dimension = jPopupMenu.getPreferredSize();
            Rectangle rectangle = component2.getGraphicsConfiguration().getBounds();
            n = n + n3 + dimension.width + component2.getX() > rectangle.width && n + n3 + component2.getX() >= dimension.width ? (bl ? (n -= dimension.width + n5) : component2.getWidth() - dimension.width - n3 + n5) : (n += n5);
            n2 = n2 + n4 + dimension.height + component2.getY() > rectangle.height && n2 + n4 + component2.getY() >= dimension.height ? (bl ? component2.getHeight() - dimension.height - n4 + n5 : -dimension.height - 1) : (n2 += n5);
            jPopupMenu.show(component, n, n2);
        } else {
            jPopupMenu.show(component, n + n5, n2 + n5);
        }
    }

    public static boolean isAncestorOf(Component component, Component component2) {
        while (component2 != null) {
            if (component == component2) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    public static JDialog getParentDialog(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof JDialog); container = container.getParent()) {
        }
        return container instanceof JDialog ? (JDialog)container : null;
    }

    public static Component getComponentParent(Component component, Class clazz) {
        while (component != null) {
            Component component2;
            if (component instanceof JComponent && (component2 = (Component)((JComponent)component).getClientProperty("KORTE_REAL_FRAME")) != null) {
                component = component2;
            }
            if (component.getClass().equals(clazz)) {
                return component;
            }
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            if (component instanceof FloatingWindowContainer) {
                component = ((FloatingWindowContainer)component).getDockableWindowManager();
                continue;
            }
            component = component.getParent();
        }
        return null;
    }

    public static View getView(Component component) {
        return (View)((Object)GUIUtilities.getComponentParent(component, View.class));
    }

    static void init() {
        NEW_BUFFER_ICON = GUIUtilities.loadIcon("new.gif");
        DIRTY_BUFFER_ICON = GUIUtilities.loadIcon("dirty.gif");
        READ_ONLY_BUFFER_ICON = GUIUtilities.loadIcon("readonly.gif");
        NORMAL_BUFFER_ICON = GUIUtilities.loadIcon("normal.gif");
        WINDOW_ICON = GUIUtilities.loadIcon("jedit-icon.gif");
    }

    static void showSplashScreen() {
        splash = new SplashScreen();
    }

    static void advanceSplashProgress() {
        if (splash != null) {
            splash.advance();
        }
    }

    private GUIUtilities() {
    }

    static {
        iconPath = "jeditresource:/org/gjt/sp/jedit/icons/";
        defaultIconPath = "jeditresource:/org/gjt/sp/jedit/icons/";
    }

    static class UnixWorkaround {
        Window win;
        String name;
        Rectangle desired;
        Rectangle required;
        long start;
        boolean windowOpened;

        UnixWorkaround(Window window, String string, Rectangle rectangle, int n) {
            this.win = window;
            this.name = string;
            this.desired = rectangle;
            int n2 = jEdit.getIntegerProperty(string + ".dx", 0);
            int n3 = jEdit.getIntegerProperty(string + ".dy", 0);
            int n4 = jEdit.getIntegerProperty(string + ".d-width", 0);
            int n5 = jEdit.getIntegerProperty(string + ".d-height", 0);
            this.required = new Rectangle(rectangle.x - n2, rectangle.y - n3, rectangle.width - n4, rectangle.height - n5);
            Log.log(1, GUIUtilities.class, "Window " + string + ": desired geometry is " + rectangle);
            Log.log(1, GUIUtilities.class, "Window " + string + ": setting geometry to " + this.required);
            this.start = System.currentTimeMillis();
            window.setBounds(this.required);
            if (window instanceof Frame) {
                GUIUtilities.setExtendedState((Frame)window, n);
            }
            window.addComponentListener(new ComponentHandler());
            window.addWindowListener(new WindowHandler());
        }

        class WindowHandler
        extends WindowAdapter {
            WindowHandler() {
            }

            public void windowOpened(WindowEvent windowEvent) {
                UnixWorkaround.this.windowOpened = true;
                Rectangle rectangle = UnixWorkaround.this.win.getBounds();
                Log.log(1, GUIUtilities.class, "Window " + UnixWorkaround.this.name + ": bounds after opening: " + rectangle);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dx", rectangle.x - UnixWorkaround.this.required.x);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dy", rectangle.y - UnixWorkaround.this.required.y);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-width", rectangle.width - UnixWorkaround.this.required.width);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-height", rectangle.height - UnixWorkaround.this.required.height);
                UnixWorkaround.this.win.removeWindowListener(this);
            }
        }

        class ComponentHandler
        extends ComponentAdapter {
            ComponentHandler() {
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle rectangle = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && rectangle.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!rectangle.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, GUIUtilities.class, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle rectangle = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && rectangle.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!rectangle.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, GUIUtilities.class, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }
        }
    }
}

