/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.util.Log;

public class JARClassLoader
extends ClassLoader {
    private static final Object NO_CLASS = new Object();
    private static int INDEX;
    private static int live;
    private static Hashtable classHash;
    private int id = INDEX++;
    private PluginJAR jar;

    public JARClassLoader() {
        ++live;
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object v = classHash.get(string);
        if (v == NO_CLASS) {
            throw new ClassNotFoundException(string);
        }
        if (v instanceof JARClassLoader) {
            JARClassLoader jARClassLoader = (JARClassLoader)v;
            return jARClassLoader._loadClass(string, bl);
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : this.findSystemClass(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classHash.put(string, NO_CLASS);
            throw classNotFoundException;
        }
    }

    public InputStream getResourceAsStream(String string) {
        if (this.jar == null) {
            return null;
        }
        try {
            ZipFile zipFile = this.jar.getZipFile();
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                return JARClassLoader.getSystemResourceAsStream(string);
            }
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            return null;
        }
    }

    public URL getResource(String string) {
        if (this.jar == null) {
            return null;
        }
        try {
            ZipFile zipFile = this.jar.getZipFile();
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                return JARClassLoader.getSystemResource(string);
            }
            return new URL(this.getResourceAsPath(string));
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            return null;
        }
    }

    public String getResourceAsPath(String string) {
        if (this.jar == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return "jeditresource:/" + MiscUtilities.getFileName(this.jar.getPath()) + "!" + string;
    }

    public ZipFile getZipFile() {
        try {
            return this.jar.getZipFile();
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump() {
        Log.log(1, JARClassLoader.class, "Total instances created: " + INDEX);
        Log.log(1, JARClassLoader.class, "Live instances: " + live);
        Hashtable hashtable = classHash;
        synchronized (hashtable) {
            for (Map.Entry entry : classHash.entrySet()) {
                if (entry.getValue() == NO_CLASS) continue;
                Log.log(1, JARClassLoader.class, entry.getKey() + " ==> " + entry.getValue());
            }
        }
    }

    public String toString() {
        if (this.jar == null) {
            return "<anonymous>(" + this.id + ")";
        }
        return this.jar.getPath() + " (" + this.id + ")";
    }

    protected void finalize() {
        --live;
    }

    JARClassLoader(PluginJAR pluginJAR) {
        this();
        this.jar = pluginJAR;
    }

    void activate() {
        String[] stringArray = this.jar.getClasses();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                classHash.put(stringArray[i], this);
            }
        }
    }

    void deactivate() {
        String[] stringArray = this.jar.getClasses();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = classHash.get(stringArray[i]);
            if (v != this) continue;
            classHash.remove(stringArray[i]);
        }
    }

    private synchronized Class _loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.jar.activatePlugin();
        JARClassLoader jARClassLoader = this;
        synchronized (jARClassLoader) {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            String string2 = MiscUtilities.classToFile(string);
            try {
                ZipFile zipFile = this.jar.getZipFile();
                ZipEntry zipEntry = zipFile.getEntry(string2);
                if (zipEntry == null) {
                    throw new ClassNotFoundException(string);
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                int n = (int)zipEntry.getSize();
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    if ((n2 = inputStream.read(byArray, n3 += n2, n -= n2)) != -1) continue;
                    Log.log(9, this, "Failed to load class " + string + " from " + zipFile.getName());
                    throw new ClassNotFoundException(string);
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                throw new ClassNotFoundException(string);
            }
        }
    }

    static {
        classHash = new Hashtable();
    }
}

