/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceListHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class ServiceManager {
    private static Map serviceMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadServices(PluginJAR pluginJAR, URL uRL, PluginJAR.PluginCacheEntry pluginCacheEntry) {
        Reader reader = null;
        try {
            Log.log(1, jEdit.class, "Loading services from " + uRL);
            ServiceListHandler serviceListHandler = new ServiceListHandler(pluginJAR, uRL);
            XmlParser xmlParser = new XmlParser();
            xmlParser.setHandler(serviceListHandler);
            reader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            xmlParser.parse(null, null, reader);
            if (pluginCacheEntry != null) {
                pluginCacheEntry.cachedServices = serviceListHandler.getCachedServices();
            }
        }
        catch (XmlException xmlException) {
            int n = xmlException.getLine();
            String string = xmlException.getMessage();
            Log.log(9, ServiceManager.class, uRL + ":" + n + ": " + string);
        }
        catch (Exception exception) {
            Log.log(9, ServiceManager.class, exception);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                Log.log(9, ServiceManager.class, iOException);
            }
        }
    }

    public static void unloadServices(PluginJAR pluginJAR) {
        Iterator iterator = serviceMap.keySet().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (descriptor.plugin != pluginJAR) continue;
            iterator.remove();
        }
    }

    public static void registerService(String string, String string2, String string3, PluginJAR pluginJAR) {
        Descriptor descriptor = new Descriptor(string, string2, string3, pluginJAR);
        serviceMap.put(descriptor, descriptor);
    }

    public static void unregisterService(String string, String string2) {
        Descriptor descriptor = new Descriptor(string, string2);
        serviceMap.remove(descriptor);
    }

    public static String[] getServiceTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Descriptor descriptor : serviceMap.keySet()) {
            hashSet.add(descriptor.clazz);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String[] getServiceNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Descriptor descriptor : serviceMap.keySet()) {
            if (!descriptor.clazz.equals(string)) continue;
            arrayList.add(descriptor.name);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Object getService(String string, String string2) {
        Descriptor descriptor = new Descriptor(string, string2);
        Descriptor descriptor2 = (Descriptor)serviceMap.get(descriptor);
        if (descriptor2 == null) {
            return null;
        }
        if (descriptor2.code == null) {
            ServiceManager.loadServices(descriptor2.plugin, descriptor2.plugin.getServicesURI(), null);
            descriptor2 = (Descriptor)serviceMap.get(descriptor);
        }
        return descriptor2.getInstance();
    }

    static void registerService(Descriptor descriptor) {
        serviceMap.put(descriptor, descriptor);
    }

    static class Descriptor {
        String clazz;
        String name;
        String code;
        PluginJAR plugin;
        Object instance;
        boolean instanceIsNull;

        Descriptor(String string, String string2) {
            this.clazz = string;
            this.name = string2;
        }

        Descriptor(String string, String string2, String string3, PluginJAR pluginJAR) {
            this.clazz = string;
            this.name = string2;
            this.code = string3;
            this.plugin = pluginJAR;
        }

        Object getInstance() {
            if (this.instanceIsNull) {
                return null;
            }
            if (this.instance == null) {
                this.instance = BeanShell.eval(null, BeanShell.getNameSpace(), this.code);
                if (this.instance == null) {
                    this.instanceIsNull = true;
                }
            }
            return this.instance;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)object;
                return descriptor.clazz.equals(this.clazz) && descriptor.name.equals(this.name);
            }
            return false;
        }
    }
}

