/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.io.IOException;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

class BrowserIORequest
extends WorkRequest {
    public static final int LIST_DIRECTORY = 0;
    public static final int DELETE = 1;
    public static final int RENAME = 2;
    public static final int MKDIR = 3;
    private int type;
    private VFSBrowser browser;
    private Object session;
    private VFS vfs;
    private String path1;
    private String path2;
    private Object[] loadInfo;

    BrowserIORequest(int n, VFSBrowser vFSBrowser, Object object, VFS vFS, String string, String string2, Object[] objectArray) {
        this.type = n;
        this.browser = vFSBrowser;
        this.session = object;
        this.vfs = vFS;
        this.path1 = string;
        this.path2 = string2;
        this.loadInfo = objectArray;
    }

    public void run() {
        switch (this.type) {
            case 0: {
                this.listDirectory();
                break;
            }
            case 1: {
                this.delete();
                break;
            }
            case 2: {
                this.rename();
                break;
            }
            case 3: {
                this.mkdir();
            }
        }
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "LIST_DIRECTORY";
                break;
            }
            case 1: {
                string = "DELETE";
                break;
            }
            case 2: {
                string = "RENAME";
                break;
            }
            case 3: {
                string = "MKDIR";
                break;
            }
            default: {
                string = "UNKNOWN!!!";
            }
        }
        return this.getClass().getName() + "[type=" + string + ",vfs=" + this.vfs + ",path1=" + this.path1 + ",path2=" + this.path2 + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listDirectory() {
        String string;
        VFS.DirectoryEntry[] directoryEntryArray;
        block14: {
            directoryEntryArray = null;
            Object[] objectArray = new String[]{this.path1};
            this.setStatus(jEdit.getProperty("vfs.status.listing-directory", objectArray));
            string = this.path1;
            this.setAbortable(true);
            string = this.vfs._canonPath(this.session, this.path1, this.browser);
            directoryEntryArray = this.vfs._listDirectory(this.session, string, this.browser);
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException iOException) {
                this.setAbortable(false);
                Log.log(9, this, iOException);
                Object[] objectArray2 = new String[]{iOException.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray2);
            }
            break block14;
            catch (IOException iOException) {
                this.setAbortable(false);
                Log.log(9, this, iOException);
                Object[] objectArray3 = new String[]{iOException.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray3);
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException iOException2) {
                    this.setAbortable(false);
                    Log.log(9, this, iOException2);
                    objectArray3 = new String[]{iOException2.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray3);
                }
            }
            catch (WorkThread.Abort abort) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException iOException3) {
                    this.setAbortable(false);
                    Log.log(9, this, iOException3);
                    Object[] objectArray4 = new String[]{iOException3.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray4);
                }
                {
                    catch (Throwable throwable) {
                        try {
                            this.vfs._endVFSSession(this.session, this.browser);
                        }
                        catch (IOException iOException2) {
                            this.setAbortable(false);
                            Log.log(9, this, iOException2);
                            Object[] objectArray5 = new String[]{iOException2.toString()};
                            VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray5);
                        }
                        throw throwable;
                    }
                }
            }
        }
        this.setAbortable(false);
        this.loadInfo[0] = string;
        this.loadInfo[1] = directoryEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void delete() {
        block13: {
            this.setAbortable(true);
            Object[] objectArray = new String[]{this.path1};
            this.setStatus(jEdit.getProperty("vfs.status.deleting", objectArray));
            try {
                this.path1 = this.vfs._canonPath(this.session, this.path1, this.browser);
                if (!this.vfs._delete(this.session, this.path1, this.browser)) {
                    VFSManager.error(this.browser, this.path1, "ioerror.delete-error", null);
                }
            }
            catch (IOException iOException) {
                this.setAbortable(false);
                Log.log(9, this, iOException);
                Object[] objectArray2 = new String[]{iOException.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray2);
            }
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException iOException) {
                this.setAbortable(false);
                Log.log(9, this, iOException);
                Object[] objectArray3 = new String[]{iOException.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray3);
            }
            break block13;
            catch (WorkThread.Abort abort) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException iOException) {
                    this.setAbortable(false);
                    Log.log(9, this, iOException);
                    Object[] objectArray4 = new String[]{iOException.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray4);
                }
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, this.browser);
                    }
                    catch (IOException iOException) {
                        this.setAbortable(false);
                        Log.log(9, this, iOException);
                        Object[] objectArray5 = new String[]{iOException.toString()};
                        VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray5);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void rename() {
        block18: {
            Object[] objectArray;
            block17: {
                this.setAbortable(true);
                Object[] objectArray2 = new String[]{this.path1, this.path2};
                this.setStatus(jEdit.getProperty("vfs.status.renaming", objectArray2));
                this.path1 = this.vfs._canonPath(this.session, this.path1, this.browser);
                this.path2 = this.vfs._canonPath(this.session, this.path2, this.browser);
                objectArray = this.vfs._getDirectoryEntry(this.session, this.path2, this.browser);
                if (objectArray == null || (OperatingSystem.isDOSDerived() || OperatingSystem.isMacOS()) && this.path1.equalsIgnoreCase(this.path2)) break block17;
                VFSManager.error(this.browser, this.path1, "ioerror.rename-exists", new String[]{this.path2});
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException iOException) {
                    this.setAbortable(false);
                    Log.log(9, this, iOException);
                    Object[] objectArray3 = new String[]{iOException.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray3);
                }
                return;
            }
            if (!this.vfs._rename(this.session, this.path1, this.path2, this.browser)) {
                VFSManager.error(this.browser, this.path1, "ioerror.rename-error", new String[]{this.path2});
            }
            {
                catch (IOException iOException) {
                    this.setAbortable(false);
                    Log.log(9, this, iOException);
                    Object[] objectArray4 = new String[]{iOException.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray4);
                }
            }
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException iOException) {
                this.setAbortable(false);
                Log.log(9, this, iOException);
                objectArray = new String[]{iOException.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray);
            }
            break block18;
            catch (WorkThread.Abort abort) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException iOException) {
                    this.setAbortable(false);
                    Log.log(9, this, iOException);
                    objectArray = new String[]{iOException.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray);
                }
                break block18;
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, this.browser);
                    }
                    catch (IOException iOException) {
                        this.setAbortable(false);
                        Log.log(9, this, iOException);
                        Object[] objectArray5 = new String[]{iOException.toString()};
                        VFSManager.error(this.browser, this.path1, "ioerror.directory-error", objectArray5);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mkdir() {
        block13: {
            this.setAbortable(true);
            Object[] objectArray = new String[]{this.path1};
            this.setStatus(jEdit.getProperty("vfs.status.mkdir", objectArray));
            try {
                this.path1 = this.vfs._canonPath(this.session, this.path1, this.browser);
                if (!this.vfs._mkdir(this.session, this.path1, this.browser)) {
                    VFSManager.error(this.browser, this.path1, "ioerror.mkdir-error", null);
                }
            }
            catch (IOException iOException) {
                this.setAbortable(false);
                Log.log(9, this, iOException);
                objectArray[0] = iOException.toString();
                VFSManager.error(this.browser, this.path1, "ioerror", objectArray);
            }
            try {
                this.vfs._endVFSSession(this.session, this.browser);
            }
            catch (IOException iOException) {
                this.setAbortable(false);
                Log.log(9, this, iOException);
                Object[] objectArray2 = new String[]{iOException.toString()};
                VFSManager.error(this.browser, this.path1, "ioerror", objectArray2);
            }
            break block13;
            catch (WorkThread.Abort abort) {
                try {
                    this.vfs._endVFSSession(this.session, this.browser);
                }
                catch (IOException iOException) {
                    this.setAbortable(false);
                    Log.log(9, this, iOException);
                    Object[] objectArray3 = new String[]{iOException.toString()};
                    VFSManager.error(this.browser, this.path1, "ioerror", objectArray3);
                }
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, this.browser);
                    }
                    catch (IOException iOException) {
                        this.setAbortable(false);
                        Log.log(9, this, iOException);
                        Object[] objectArray4 = new String[]{iOException.toString()};
                        VFSManager.error(this.browser, this.path1, "ioerror", objectArray4);
                    }
                    throw throwable;
                }
            }
        }
    }
}

