/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.BrowserIORequest;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTable;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;

class BrowserView
extends JPanel {
    private VFSBrowser browser;
    private JSplitPane splitPane;
    private JList parentDirectories;
    private VFSDirectoryEntryTable table;
    private Set tmpExpanded;
    private BrowserCommandsMenu popup;
    private boolean showIcons;

    public BrowserView(final VFSBrowser vFSBrowser) {
        this.browser = vFSBrowser;
        this.tmpExpanded = new HashSet();
        this.parentDirectories = new JList();
        this.parentDirectories.getSelectionModel().setSelectionMode(0);
        this.parentDirectories.setCellRenderer(new ParentDirectoryRenderer());
        this.parentDirectories.setVisibleRowCount(5);
        this.parentDirectories.addMouseListener(new ParentMouseHandler());
        final JScrollPane jScrollPane = new JScrollPane(this.parentDirectories);
        jScrollPane.setMinimumSize(new Dimension(0, 0));
        this.table = new VFSDirectoryEntryTable(this);
        this.table.addMouseListener(new TableMouseHandler());
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jScrollPane2.setMinimumSize(new Dimension(0, 0));
        jScrollPane2.getViewport().setBackground(this.table.getBackground());
        jScrollPane2.getViewport().addMouseListener(new TableMouseHandler());
        this.splitPane = new JSplitPane(vFSBrowser.isHorizontalLayout() ? 1 : 0, jScrollPane, jScrollPane2);
        this.splitPane.setOneTouchExpandable(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = vFSBrowser.isHorizontalLayout() ? "vfs.browser.horizontalSplitter" : "vfs.browser.splitter";
                int n = jEdit.getIntegerProperty(string, -1);
                if (n == -1) {
                    n = jScrollPane.getPreferredSize().height;
                }
                BrowserView.this.splitPane.setDividerLocation(n);
                BrowserView.this.parentDirectories.ensureIndexIsVisible(BrowserView.this.parentDirectories.getModel().getSize());
            }
        });
        if (vFSBrowser.isMultipleSelectionEnabled()) {
            this.table.getSelectionModel().setSelectionMode(2);
        } else {
            this.table.getSelectionModel().setSelectionMode(0);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", this.splitPane);
        this.propertiesChanged();
    }

    public void focusOnFileView() {
        this.table.requestFocus();
    }

    public void removeNotify() {
        String string = this.browser.isHorizontalLayout() ? "vfs.browser.horizontalSplitter" : "vfs.browser.splitter";
        jEdit.setIntegerProperty(string, this.splitPane.getDividerLocation());
        super.removeNotify();
    }

    public VFS.DirectoryEntry[] getSelectedFiles() {
        return this.table.getSelectedFiles();
    }

    public void selectNone() {
        this.table.clearSelection();
    }

    public void saveExpansionState() {
        this.tmpExpanded.clear();
        this.table.getExpandedDirectories(this.tmpExpanded);
    }

    public void clearExpansionState() {
        this.tmpExpanded.clear();
    }

    public void loadDirectory(Object object, String string) {
        string = MiscUtilities.constructPath(this.browser.getDirectory(), string);
        VFS vFS = VFSManager.getVFSForPath(string);
        Object object2 = vFS.createVFSSession(string, this);
        if (object2 == null) {
            return;
        }
        if (object == null) {
            this.parentDirectories.setListData(new Object[]{new LoadingPlaceholder()});
        }
        Object[] objectArray = new Object[2];
        VFSManager.runInWorkThread(new BrowserIORequest(0, this.browser, object2, vFS, string, null, objectArray));
        this.browser.directoryLoaded(object, objectArray);
    }

    public void directoryLoaded(Object object, String string, ArrayList arrayList) {
        if (object == null) {
            DefaultListModel<VFS.DirectoryEntry> defaultListModel = new DefaultListModel<VFS.DirectoryEntry>();
            String string2 = string;
            while (true) {
                VFS vFS = VFSManager.getVFSForPath(string2);
                defaultListModel.insertElementAt(new VFS.DirectoryEntry(vFS.getFileName(string2), string2, string2, 1, 0L, false), 0);
                String string3 = vFS.getParentOfPath(string2);
                if (string3 == null || VFSBrowser.pathsEqual(string2, string3)) break;
                string2 = string3;
            }
            this.parentDirectories.setModel(defaultListModel);
            int n = defaultListModel.getSize() - 1;
            this.parentDirectories.setSelectedIndex(n);
            this.parentDirectories.ensureIndexIsVisible(n);
        }
        this.table.setDirectory(VFSManager.getVFSForPath(string), object, arrayList, this.tmpExpanded);
    }

    public void updateFileView() {
        this.table.repaint();
    }

    public void maybeReloadDirectory(String string) {
        String string2 = this.browser.getDirectory();
        String string3 = MiscUtilities.isURL(string2) ? string2 : MiscUtilities.resolveSymlinks(string2);
        if (VFSBrowser.pathsEqual(string, string3)) {
            this.saveExpansionState();
            this.loadDirectory(null, string2);
        }
        if (!(string2.startsWith("favorites") || string2.startsWith("roots") || string.startsWith(string3))) {
            return;
        }
        if (string2.startsWith("roots") && MiscUtilities.isURL(string) && !MiscUtilities.getProtocolOfURL(string).equals("file")) {
            return;
        }
        this.table.maybeReloadDirectory(string);
    }

    public void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
        this.table.propertiesChanged();
        this.splitPane.setBorder(null);
    }

    public VFSBrowser getBrowser() {
        return this.browser;
    }

    public VFSDirectoryEntryTable getTable() {
        return this.table;
    }

    public JList getParentDirectoryList() {
        return this.parentDirectories;
    }

    private void showFilePopup(VFS.DirectoryEntry[] directoryEntryArray, Component component, Point point) {
        this.popup = new BrowserCommandsMenu(this.browser, directoryEntryArray);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n = BrowserView.this.parentDirectories.getModel().getSize() - 1;
                        BrowserView.this.parentDirectories.setSelectedIndex(n);
                    }
                });
            }
        });
        GUIUtilities.showPopupMenu(this.popup, component, point.x, point.y);
    }

    static class LoadingPlaceholder {
        LoadingPlaceholder() {
        }
    }

    class TableMouseHandler
    extends MouseAdapter {
        TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = BrowserView.this.table.rowAtPoint(point);
            int n2 = BrowserView.this.table.columnAtPoint(point);
            if (n == -1) {
                return;
            }
            if (n2 == 0) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(n, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, point.x)) {
                    return;
                }
            }
            if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() % 2 == 0) {
                BrowserView.this.browser.filesActivated(mouseEvent.isShiftDown() ? 1 : 0, true);
            } else if (GUIUtilities.isMiddleButton(mouseEvent.getModifiers())) {
                if (mouseEvent.isShiftDown()) {
                    BrowserView.this.table.getSelectionModel().addSelectionInterval(n, n);
                } else {
                    BrowserView.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
                BrowserView.this.browser.filesActivated(mouseEvent.isShiftDown() ? 1 : 0, true);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getSource() != BrowserView.this.table) {
                point.x -= BrowserView.this.table.getX();
                point.y -= BrowserView.this.table.getY();
            }
            int n = BrowserView.this.table.rowAtPoint(point);
            int n2 = BrowserView.this.table.columnAtPoint(point);
            if (n2 == 0 && n != -1) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(n, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, point.x)) {
                    BrowserView.this.table.toggleExpanded(n);
                    return;
                }
            }
            if (GUIUtilities.isMiddleButton(mouseEvent.getModifiers())) {
                if (n != -1) {
                    if (mouseEvent.isShiftDown()) {
                        BrowserView.this.table.getSelectionModel().addSelectionInterval(n, n);
                    } else {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            } else if (GUIUtilities.isPopupTrigger(mouseEvent)) {
                if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                    BrowserView.this.popup.setVisible(false);
                    BrowserView.this.popup = null;
                    return;
                }
                if (n == -1) {
                    BrowserView.this.showFilePopup(null, BrowserView.this.table, mouseEvent.getPoint());
                } else {
                    if (!BrowserView.this.table.getSelectionModel().isSelectedIndex(n)) {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                    BrowserView.this.showFilePopup(BrowserView.this.getSelectedFiles(), BrowserView.this.table, mouseEvent.getPoint());
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!GUIUtilities.isPopupTrigger(mouseEvent) && BrowserView.this.table.getSelectedRow() != -1) {
                BrowserView.this.browser.filesSelected();
            }
        }
    }

    class ParentMouseHandler
    extends MouseAdapter {
        ParentMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object e;
            int n = BrowserView.this.parentDirectories.locationToIndex(mouseEvent.getPoint());
            if (n != -1 && (e = BrowserView.this.parentDirectories.getModel().getElementAt(n)) instanceof VFS.DirectoryEntry) {
                VFS.DirectoryEntry directoryEntry = (VFS.DirectoryEntry)e;
                if (GUIUtilities.isPopupTrigger(mouseEvent)) {
                    if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                        BrowserView.this.popup.setVisible(false);
                        BrowserView.this.popup = null;
                    } else {
                        BrowserView.this.parentDirectories.setSelectedIndex(n);
                        BrowserView.this.showFilePopup(new VFS.DirectoryEntry[]{directoryEntry}, BrowserView.this.parentDirectories, mouseEvent.getPoint());
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object e;
            if (mouseEvent.getClickCount() % 2 != 0 && !GUIUtilities.isMiddleButton(mouseEvent.getModifiers())) {
                return;
            }
            int n = BrowserView.this.parentDirectories.locationToIndex(mouseEvent.getPoint());
            if (n != -1 && (e = BrowserView.this.parentDirectories.getModel().getElementAt(n)) instanceof VFS.DirectoryEntry) {
                VFS.DirectoryEntry directoryEntry = (VFS.DirectoryEntry)e;
                if (!GUIUtilities.isPopupTrigger(mouseEvent)) {
                    BrowserView.this.browser.setDirectory(directoryEntry.path);
                    if (BrowserView.this.browser.getMode() == 2) {
                        BrowserView.this.focusOnFileView();
                    }
                }
            }
        }
    }

    class ParentDirectoryRenderer
    extends DefaultListCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont;

        ParentDirectoryRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setBorder(new EmptyBorder(1, n * 5 + 1, 1, 1));
            if (object instanceof LoadingPlaceholder) {
                this.setFont(this.plainFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.loadingIcon : null);
                this.setText(jEdit.getProperty("vfs.browser.tree.loading"));
            } else if (object instanceof VFS.DirectoryEntry) {
                VFS.DirectoryEntry directoryEntry = (VFS.DirectoryEntry)object;
                this.setFont(this.boldFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.getIconForFile(directoryEntry, true) : null);
                this.setText(directoryEntry.name);
            } else if (object == null) {
                this.setText("VFS does not follow VFS API");
            }
            return this;
        }
    }
}

