/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import javax.swing.text.Segment;

public class ContentManager {
    private char[] text;
    private int gapStart;
    private int gapEnd;
    private int length;

    public final int getLength() {
        return this.length;
    }

    public String getText(int n, int n2) {
        if (n >= this.gapStart) {
            return new String(this.text, n + this.gapEnd - this.gapStart, n2);
        }
        if (n + n2 <= this.gapStart) {
            return new String(this.text, n, n2);
        }
        return new String(this.text, n, this.gapStart - n).concat(new String(this.text, this.gapEnd, n + n2 - this.gapStart));
    }

    public void getText(int n, int n2, Segment segment) {
        if (n >= this.gapStart) {
            segment.array = this.text;
            segment.offset = n + this.gapEnd - this.gapStart;
            segment.count = n2;
        } else if (n + n2 <= this.gapStart) {
            segment.array = this.text;
            segment.offset = n;
            segment.count = n2;
        } else {
            segment.array = new char[n2];
            System.arraycopy(this.text, n, segment.array, 0, this.gapStart - n);
            System.arraycopy(this.text, this.gapEnd, segment.array, this.gapStart - n, n2 + n - this.gapStart);
            segment.offset = 0;
            segment.count = n2;
        }
    }

    public void insert(int n, String string) {
        int n2 = string.length();
        this.moveGapStart(n);
        if (this.gapEnd - this.gapStart < n2) {
            this.ensureCapacity(this.length + n2 + 1024);
            this.moveGapEnd(n + n2 + 1024);
        }
        string.getChars(0, n2, this.text, n);
        this.gapStart += n2;
        this.length += n2;
    }

    public void insert(int n, Segment segment) {
        this.moveGapStart(n);
        if (this.gapEnd - this.gapStart < segment.count) {
            this.ensureCapacity(this.length + segment.count + 1024);
            this.moveGapEnd(n + segment.count + 1024);
        }
        System.arraycopy(segment.array, segment.offset, this.text, n, segment.count);
        this.gapStart += segment.count;
        this.length += segment.count;
    }

    public void _setContent(char[] cArray, int n) {
        this.text = cArray;
        this.gapEnd = 0;
        this.gapStart = 0;
        this.length = n;
    }

    public void remove(int n, int n2) {
        this.moveGapStart(n);
        this.gapEnd += n2;
        this.length -= n2;
    }

    private void moveGapStart(int n) {
        int n2 = this.gapEnd + (n - this.gapStart);
        if (n != this.gapStart) {
            if (n > this.gapStart) {
                System.arraycopy(this.text, this.gapEnd, this.text, this.gapStart, n - this.gapStart);
            } else if (n < this.gapStart) {
                System.arraycopy(this.text, n, this.text, n2, this.gapStart - n);
            }
        }
        this.gapStart = n;
        this.gapEnd = n2;
    }

    private void moveGapEnd(int n) {
        System.arraycopy(this.text, this.gapEnd, this.text, n, this.length - this.gapStart);
        this.gapEnd = n;
    }

    private void ensureCapacity(int n) {
        if (n >= this.text.length) {
            char[] cArray = new char[n * 2];
            System.arraycopy(this.text, 0, cArray, 0, this.length + (this.gapEnd - this.gapStart));
            this.text = cArray;
        }
    }
}

