/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class BufferOptions
extends EnhancedDialog {
    private View view;
    private Buffer buffer;
    private Mode[] modes;
    private JComboBox mode;
    private JComboBox lineSeparator;
    private JComboBox encoding;
    private JCheckBox gzipped;
    private JComboBox folding;
    private JComboBox wrap;
    private JComboBox maxLineLen;
    private JComboBox tabSize;
    private JComboBox indentSize;
    private JCheckBox noTabs;
    private JButton ok;
    private JButton cancel;

    public BufferOptions(View view, Buffer buffer) {
        super(view, jEdit.getProperty("buffer-options.title"), true);
        this.view = view;
        this.buffer = buffer;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        ActionHandler actionHandler = new ActionHandler();
        AbstractOptionPane abstractOptionPane = new AbstractOptionPane(null);
        abstractOptionPane.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("buffer-options.caption")));
        abstractOptionPane.addSeparator("buffer-options.loading-saving");
        String[] stringArray = new String[]{jEdit.getProperty("lineSep.unix"), jEdit.getProperty("lineSep.windows"), jEdit.getProperty("lineSep.mac")};
        this.lineSeparator = new JComboBox<String>(stringArray);
        String string = buffer.getStringProperty("lineSeparator");
        if (string == null) {
            string = System.getProperty("line.separator");
        }
        if ("\n".equals(string)) {
            this.lineSeparator.setSelectedIndex(0);
        } else if ("\r\n".equals(string)) {
            this.lineSeparator.setSelectedIndex(1);
        } else if ("\r".equals(string)) {
            this.lineSeparator.setSelectedIndex(2);
        }
        abstractOptionPane.addComponent(jEdit.getProperty("buffer-options.lineSeparator"), (Component)this.lineSeparator);
        String[] stringArray2 = MiscUtilities.getEncodings();
        Arrays.sort(stringArray2, new MiscUtilities.StringICaseCompare());
        this.encoding = new JComboBox<String>(stringArray2);
        this.encoding.setEditable(true);
        this.encoding.setSelectedItem(buffer.getStringProperty("encoding"));
        abstractOptionPane.addComponent(jEdit.getProperty("buffer-options.encoding"), (Component)this.encoding);
        this.gzipped = new JCheckBox(jEdit.getProperty("buffer-options.gzipped"));
        this.gzipped.setSelected(buffer.getBooleanProperty("gzipped"));
        abstractOptionPane.addComponent(this.gzipped);
        abstractOptionPane.addSeparator("buffer-options.editing");
        this.modes = jEdit.getModes();
        MiscUtilities.quicksort((Object[])this.modes, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        this.mode = new JComboBox<Mode>(this.modes);
        this.mode.setSelectedItem(buffer.getMode());
        this.mode.addActionListener(actionHandler);
        abstractOptionPane.addComponent(jEdit.getProperty("buffer-options.mode"), (Component)this.mode);
        String[] stringArray3 = FoldHandler.getFoldModes();
        this.folding = new JComboBox<String>(stringArray3);
        this.folding.setSelectedItem(buffer.getStringProperty("folding"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.folding"), (Component)this.folding);
        String[] stringArray4 = new String[]{"none", "soft", "hard"};
        this.wrap = new JComboBox<String>(stringArray4);
        this.wrap.setSelectedItem(buffer.getStringProperty("wrap"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.wrap"), (Component)this.wrap);
        this.wrap.addActionListener(new ActionHandler());
        String[] stringArray5 = new String[]{"0", "72", "76", "80"};
        this.maxLineLen = new JComboBox<String>(stringArray5);
        this.maxLineLen.setEditable(true);
        this.maxLineLen.setSelectedItem(buffer.getStringProperty("maxLineLen"));
        this.maxLineLen.addActionListener(new ActionHandler());
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.maxLineLen"), (Component)this.maxLineLen);
        String[] stringArray6 = new String[]{"2", "4", "8"};
        this.tabSize = new JComboBox<String>(stringArray6);
        this.tabSize.setEditable(true);
        this.tabSize.setSelectedItem(buffer.getStringProperty("tabSize"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.tabSize"), (Component)this.tabSize);
        this.indentSize = new JComboBox<String>(stringArray6);
        this.indentSize.setEditable(true);
        this.indentSize.setSelectedItem(buffer.getStringProperty("indentSize"));
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.indentSize"), (Component)this.indentSize);
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editing.noTabs"));
        this.noTabs.setSelected(buffer.getBooleanProperty("noTabs"));
        abstractOptionPane.addComponent(this.noTabs);
        jPanel.add("North", abstractOptionPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel2.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        jPanel2.add(this.ok);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionHandler);
        jPanel2.add(this.cancel);
        jPanel2.add(Box.createGlue());
        jPanel.add("South", jPanel2);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)view));
        this.setVisible(true);
    }

    public void ok() {
        boolean bl;
        boolean bl2;
        String string;
        int n = this.lineSeparator.getSelectedIndex();
        if (n == 0) {
            string = "\n";
        } else if (n == 1) {
            string = "\r\n";
        } else if (n == 2) {
            string = "\r";
        } else {
            throw new InternalError();
        }
        String string2 = this.buffer.getStringProperty("lineSeparator");
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        if (!string2.equals(string)) {
            this.buffer.setStringProperty("lineSeparator", string);
            this.buffer.setDirty(true);
        }
        String string3 = (String)this.encoding.getSelectedItem();
        String string4 = this.buffer.getStringProperty("encoding");
        if (!string4.equals(string3)) {
            this.buffer.setStringProperty("encoding", string3);
            this.buffer.setDirty(true);
        }
        if ((bl2 = this.gzipped.isSelected()) != (bl = this.buffer.getBooleanProperty("gzipped"))) {
            this.buffer.setBooleanProperty("gzipped", bl2);
            this.buffer.setDirty(true);
        }
        this.buffer.setStringProperty("folding", (String)this.folding.getSelectedItem());
        this.buffer.setStringProperty("wrap", (String)this.wrap.getSelectedItem());
        try {
            this.buffer.setProperty("maxLineLen", new Integer(this.maxLineLen.getSelectedItem().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.buffer.setProperty("tabSize", new Integer(this.tabSize.getSelectedItem().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.buffer.setProperty("indentSize", new Integer(this.indentSize.getSelectedItem().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.buffer.setBooleanProperty("noTabs", this.noTabs.isSelected());
        n = this.mode.getSelectedIndex();
        this.buffer.setMode(this.modes[n]);
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BufferOptions.this.ok) {
                BufferOptions.this.ok();
            } else if (object == BufferOptions.this.cancel) {
                BufferOptions.this.cancel();
            } else if (object == BufferOptions.this.mode) {
                Mode mode = (Mode)BufferOptions.this.mode.getSelectedItem();
                BufferOptions.this.folding.setSelectedItem(mode.getProperty("folding"));
                BufferOptions.this.wrap.setSelectedItem(mode.getProperty("wrap"));
                BufferOptions.this.maxLineLen.setSelectedItem(mode.getProperty("maxLineLen"));
                BufferOptions.this.tabSize.setSelectedItem(mode.getProperty("tabSize"));
                BufferOptions.this.indentSize.setSelectedItem(mode.getProperty("indentSize"));
                BufferOptions.this.noTabs.setSelected(mode.getBooleanProperty("noTabs"));
            } else if (object == BufferOptions.this.wrap) {
                if (!BufferOptions.this.wrap.getSelectedItem().equals("none") && BufferOptions.this.maxLineLen.getSelectedItem().equals("0")) {
                    BufferOptions.this.maxLineLen.setSelectedItem("80");
                }
            } else if (object == BufferOptions.this.maxLineLen && !BufferOptions.this.wrap.getSelectedItem().equals("none") && BufferOptions.this.maxLineLen.getSelectedItem().equals("0")) {
                BufferOptions.this.wrap.setSelectedItem("none");
            }
        }
    }
}

