/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.FontSelectorDialog;
import org.gjt.sp.jedit.jEdit;

public class FontSelector
extends JButton {
    private boolean antiAlias;

    public FontSelector(Font font) {
        this(font, false);
    }

    public FontSelector(Font font, boolean bl) {
        this.setFont(font);
        this.antiAlias = bl;
        this.updateText();
        this.setRequestFocusEnabled(false);
        this.addActionListener(new ActionHandler());
    }

    public void paintComponent(Graphics graphics) {
        this.setAntiAliasEnabled(graphics);
        super.paintComponent(graphics);
    }

    public boolean isAntiAliasEnabled() {
        return this.antiAlias;
    }

    public void setAntiAliasEnabled(boolean bl) {
        this.antiAlias = bl;
    }

    private void updateText() {
        String string;
        Font font = this.getFont();
        switch (font.getStyle()) {
            case 0: {
                string = jEdit.getProperty("font-selector.plain");
                break;
            }
            case 1: {
                string = jEdit.getProperty("font-selector.bold");
                break;
            }
            case 2: {
                string = jEdit.getProperty("font-selector.italic");
                break;
            }
            case 3: {
                string = jEdit.getProperty("font-selector.bolditalic");
                break;
            }
            default: {
                string = "UNKNOWN!!!???";
            }
        }
        this.setText(font.getName() + " " + font.getSize() + " " + string);
    }

    void setAntiAliasEnabled(Graphics graphics) {
        if (this.antiAlias) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JDialog jDialog = GUIUtilities.getParentDialog(FontSelector.this);
            Font font = jDialog == null ? new FontSelectorDialog(JOptionPane.getFrameForComponent(FontSelector.this), FontSelector.this.getFont(), FontSelector.this).getSelectedFont() : new FontSelectorDialog((Dialog)jDialog, FontSelector.this.getFont(), FontSelector.this).getSelectedFont();
            if (font != null) {
                FontSelector.this.setFont(font);
                FontSelector.this.updateText();
            }
        }
    }
}

