/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.util.Log;

public class KeyEventTranslator {
    static int c;
    static int a;
    static int m;
    static int s;
    private static Map transMap;

    public static void addTranslation(Key key, Key key2) {
        transMap.put(key, key2);
    }

    public static Key translateKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        Key key = null;
        switch (keyEvent.getID()) {
            case 401: {
                int n2 = keyEvent.getKeyCode();
                if (n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90) {
                    if (Debug.ALTERNATIVE_DISPATCHER) {
                        return null;
                    }
                    key = new Key(KeyEventTranslator.modifiersToString(n), 0, Character.toLowerCase((char)n2));
                    break;
                }
                if (n2 == 9) {
                    keyEvent.consume();
                    key = new Key(KeyEventTranslator.modifiersToString(n), n2, '\u0000');
                    break;
                }
                if (n2 == 32) {
                    if ((n & 0xFFFFFFFE) == 0) {
                        key = null;
                        break;
                    }
                    key = new Key(KeyEventTranslator.modifiersToString(n), 0, ' ');
                    break;
                }
                key = new Key(KeyEventTranslator.modifiersToString(n), n2, '\u0000');
                break;
            }
            case 400: {
                char c = keyEvent.getKeyChar();
                switch (c) {
                    case '\b': 
                    case '\t': 
                    case '\n': {
                        return null;
                    }
                    case ' ': {
                        if ((n & 0xFFFFFFFE) == 0) break;
                        return null;
                    }
                }
                int n3 = Debug.ALT_KEY_PRESSED_DISABLED ? 41 : 33;
                if ((n & 0x20) == 0 && keyEvent.getWhen() - KeyEventWorkaround.lastKeyTime < 750L && (KeyEventWorkaround.modifiers & ~n3) != 0) {
                    if (Debug.ALTERNATIVE_DISPATCHER) {
                        key = new Key(KeyEventTranslator.modifiersToString(n), 0, c);
                        break;
                    }
                    return null;
                }
                if (c == ' ') {
                    key = new Key(KeyEventTranslator.modifiersToString(n), 0, c);
                    break;
                }
                key = new Key(null, 0, c);
                break;
            }
            default: {
                return null;
            }
        }
        Key key2 = (Key)transMap.get(key);
        if (key2 == null) {
            return key;
        }
        return key2;
    }

    public static Key parseKey(String string) {
        int n;
        String string2;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(43);
        int n3 = 0;
        if (n2 != -1) {
            block8: for (int i = 0; i < n2; ++i) {
                switch (Character.toUpperCase(string.charAt(i))) {
                    case 'A': {
                        n3 |= a;
                        continue block8;
                    }
                    case 'C': {
                        n3 |= c;
                        continue block8;
                    }
                    case 'M': {
                        n3 |= m;
                        continue block8;
                    }
                    case 'S': {
                        n3 |= s;
                    }
                }
            }
        }
        if ((string2 = string.substring(n2 + 1)).length() == 1) {
            return new Key(KeyEventTranslator.modifiersToString(n3), 0, string2.charAt(0));
        }
        if (string2.length() == 0) {
            Log.log(9, DefaultInputHandler.class, "Invalid key stroke: " + string);
            return null;
        }
        if (string2.equals("SPACE")) {
            return new Key(KeyEventTranslator.modifiersToString(n3), 0, ' ');
        }
        try {
            n = KeyEvent.class.getField("VK_".concat(string2)).getInt(null);
        }
        catch (Exception exception) {
            Log.log(9, DefaultInputHandler.class, "Invalid key stroke: " + string);
            return null;
        }
        return new Key(KeyEventTranslator.modifiersToString(n3), n, '\u0000');
    }

    public static void setModifierMapping(int n, int n2, int n3, int n4) {
        int n5 = n & n2 | n & n3 | n & n4 | n2 & n3 | n2 & n4 | n3 & n4;
        if ((n5 & 2) != 0) {
            throw new IllegalArgumentException("CTRL is mapped to more than one modifier");
        }
        if ((n5 & 8) != 0) {
            throw new IllegalArgumentException("ALT is mapped to more than one modifier");
        }
        if ((n5 & 4) != 0) {
            throw new IllegalArgumentException("META is mapped to more than one modifier");
        }
        if ((n5 & 1) != 0) {
            throw new IllegalArgumentException("SHIFT is mapped to more than one modifier");
        }
        c = n;
        a = n2;
        m = n3;
        s = n4;
    }

    public static char getSymbolicModifierName(int n) {
        if ((n & c) != 0) {
            return 'C';
        }
        if ((n & a) != 0) {
            return 'A';
        }
        if ((n & m) != 0) {
            return 'M';
        }
        if ((n & s) != 0) {
            return 'S';
        }
        return '\u0000';
    }

    public static String modifiersToString(int n) {
        StringBuffer stringBuffer = null;
        if ((n & 2) != 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if ((n & 8) != 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if ((n & 4) != 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if ((n & 1) != 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String getModifierString(InputEvent inputEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        if (inputEvent.isControlDown()) {
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if (inputEvent.isAltDown()) {
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if (inputEvent.isMetaDown()) {
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if (inputEvent.isShiftDown()) {
            stringBuffer.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    static {
        transMap = new HashMap();
        if (OperatingSystem.isMacOS()) {
            KeyEventTranslator.setModifierMapping(4, 2, 8, 1);
        } else {
            KeyEventTranslator.setModifierMapping(2, 8, 4, 1);
        }
    }

    public static class Key {
        public String modifiers;
        public int key;
        public char input;

        public Key(String string, int n, char c) {
            this.modifiers = string;
            this.key = n;
            this.input = c;
        }

        public int hashCode() {
            return this.key + this.input;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                if (MiscUtilities.objectsEqual(this.modifiers, key.modifiers) && this.key == key.key && this.input == key.input) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return (this.modifiers == null ? "" : this.modifiers) + "<" + Integer.toString(this.key, 16) + "," + Integer.toString(this.input, 16) + ">";
        }
    }
}

