/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.util.Log;

public class RolloverButton
extends JButton {
    private static AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
    private static Method method;
    private boolean revalidateBlocked;

    public RolloverButton() {
        if (OperatingSystem.hasJava15()) {
            this.setContentAreaFilled(false);
        }
        if (method != null) {
            try {
                method.invoke((Object)this, (Object[])new Boolean[]{Boolean.TRUE});
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
            }
        } else {
            this.addMouseListener(new MouseOverHandler());
        }
    }

    public RolloverButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    public void updateUI() {
        if (OperatingSystem.isWindows()) {
            this.setUI(new BasicButtonUI());
        } else {
            super.updateUI();
        }
        this.setBorder(new EtchedBorder());
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setRequestFocusEnabled(false);
    }

    public boolean isOpaque() {
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (method == null) {
            this.setBorderPainted(false);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBorderPainted(boolean bl) {
        try {
            this.revalidateBlocked = true;
            super.setBorderPainted(bl);
        }
        finally {
            this.revalidateBlocked = false;
        }
    }

    public void revalidate() {
        if (!this.revalidateBlocked) {
            super.revalidate();
        }
    }

    public void paint(Graphics graphics) {
        if (method != null || this.isEnabled()) {
            super.paint(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(c);
            super.paint(graphics2D);
        }
    }

    class MouseOverHandler
    extends MouseAdapter {
        MouseOverHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (RolloverButton.this.isEnabled()) {
                RolloverButton.this.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            RolloverButton.this.setBorderPainted(false);
        }
    }
}

