/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.util.LinkedList;
import javax.swing.filechooser.FileSystemView;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.util.Log;

public class FileRootsVFS
extends VFS {
    public static final String PROTOCOL = "roots";
    private static FileSystemView fsView;
    private static Method getSystemDisplayName;
    private static Method getRoots;
    private static Method isFileSystemRoot;
    private static Method isFloppyDrive;
    private static Method isDrive;

    public FileRootsVFS() {
        super(PROTOCOL, 64, new String[]{"type"});
        if (OperatingSystem.hasJava14()) {
            try {
                getSystemDisplayName = FileSystemView.class.getMethod("getSystemDisplayName", File.class);
                getRoots = FileSystemView.class.getMethod("getRoots", new Class[0]);
                isFileSystemRoot = FileSystemView.class.getMethod("isFileSystemRoot", File.class);
                isFloppyDrive = FileSystemView.class.getMethod("isFloppyDrive", File.class);
                isDrive = FileSystemView.class.getMethod("isDrive", File.class);
                fsView = FileSystemView.getFileSystemView();
                Log.log(1, this, "Java 1.4 FileSystemView detected");
            }
            catch (Exception exception) {
                Log.log(1, this, "Java 1.4 FileSystemView not detected");
            }
        }
    }

    public String getParentOfPath(String string) {
        return "roots:";
    }

    public VFS.DirectoryEntry[] _listDirectory(Object object, String string, Component component) {
        File[] fileArray = FileRootsVFS.listRoots();
        if (fileArray == null) {
            return null;
        }
        VFS.DirectoryEntry[] directoryEntryArray = new VFS.DirectoryEntry[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            directoryEntryArray[i] = new RootsEntry(fileArray[i]);
        }
        return directoryEntryArray;
    }

    public VFS.DirectoryEntry _getDirectoryEntry(Object object, String string, Component component) {
        return new RootsEntry(new File(string));
    }

    private static File[] listRoots() {
        if (OperatingSystem.isMacOS()) {
            File[] fileArray = new File("/Volumes").listFiles();
            LinkedList<File> linkedList = new LinkedList<File>();
            linkedList.add(new File("/"));
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                linkedList.add(fileArray[i]);
            }
            return linkedList.toArray(new File[0]);
        }
        File[] fileArray = File.listRoots();
        File[] fileArray2 = null;
        if (getRoots != null) {
            try {
                fileArray2 = (File[])getRoots.invoke((Object)fsView, new Object[0]);
            }
            catch (Exception exception) {
                Log.log(9, FileRootsVFS.class, "Error getting Desktop: " + exception.getMessage());
                fileArray2 = null;
            }
        }
        if (fileArray2 == null) {
            return fileArray;
        }
        File[] fileArray3 = new File[fileArray.length + fileArray2.length];
        System.arraycopy(fileArray2, 0, fileArray3, 0, fileArray2.length);
        System.arraycopy(fileArray, 0, fileArray3, 1, fileArray.length);
        return fileArray3;
    }

    static class RootsEntry
    extends VFS.DirectoryEntry {
        RootsEntry(File file) {
            this.deletePath = this.symlinkPath = file.getPath();
            this.path = this.symlinkPath;
            if (this.isFloppy(file)) {
                this.type = 2;
                this.name = this.path;
            } else if (this.isDrive(file)) {
                this.type = 2;
                if (getSystemDisplayName != null) {
                    try {
                        this.name = this.path + " " + (String)getSystemDisplayName.invoke((Object)fsView, file);
                    }
                    catch (Exception exception) {
                        Log.log(9, this, exception);
                        this.name = this.path;
                    }
                }
            } else if (file.isDirectory()) {
                this.type = 2;
                if (isFileSystemRoot != null) {
                    try {
                        if (Boolean.FALSE.equals(isFileSystemRoot.invoke((Object)fsView, file))) {
                            this.type = 1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.name = OperatingSystem.isMacOS() ? MiscUtilities.getFileName(this.path) : this.path;
            } else {
                this.type = 0;
            }
        }

        public String getExtendedAttribute(String string) {
            if (string.equals("type")) {
                return super.getExtendedAttribute(string);
            }
            return null;
        }

        private boolean isFloppy(File file) {
            if (isFloppyDrive != null) {
                try {
                    return Boolean.TRUE.equals(isFloppyDrive.invoke((Object)fsView, file));
                }
                catch (Exception exception) {
                    Log.log(9, this, exception);
                    return false;
                }
            }
            return this.path.startsWith("A:") || this.path.startsWith("B:");
        }

        private boolean isDrive(File file) {
            if (isDrive != null) {
                try {
                    return Boolean.TRUE.equals(isDrive.invoke((Object)fsView, file));
                }
                catch (Exception exception) {
                    Log.log(9, this, exception);
                    return false;
                }
            }
            return true;
        }
    }
}

