/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ContextAddDialog;

public class ContextOptionPane
extends AbstractOptionPane {
    private DefaultListModel listModel;
    private JList list;
    private JButton add;
    private JButton remove;
    private JButton moveUp;
    private JButton moveDown;

    public ContextOptionPane() {
        super("context");
    }

    protected void _init() {
        Object object;
        Object object2;
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(jEdit.getProperty("options.context.caption"));
        this.add("North", jLabel);
        String string = jEdit.getProperty("view.context");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.listModel = new DefaultListModel();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            object2 = stringTokenizer.nextToken();
            if (((String)object2).equals("-")) {
                this.listModel.addElement(new MenuItem("-", "-"));
                continue;
            }
            object = jEdit.getAction((String)object2);
            if (object == null || (string2 = ((EditAction)object).getLabel()) == null) continue;
            this.listModel.addElement(new MenuItem((String)object2, string2));
        }
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        this.add("Center", new JScrollPane(this.list));
        object2 = new JPanel();
        ((JComponent)object2).setBorder(new EmptyBorder(3, 0, 0, 0));
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        object = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("common.add"));
        this.add.addActionListener((ActionListener)object);
        ((Container)object2).add(this.add);
        ((Container)object2).add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("common.remove"));
        this.remove.addActionListener((ActionListener)object);
        ((Container)object2).add(this.remove);
        ((Container)object2).add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon("ArrowU.png"));
        this.moveUp.setToolTipText(jEdit.getProperty("common.moveUp"));
        this.moveUp.addActionListener((ActionListener)object);
        ((Container)object2).add(this.moveUp);
        ((Container)object2).add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon("ArrowD.png"));
        this.moveDown.setToolTipText(jEdit.getProperty("common.moveDown"));
        this.moveDown.addActionListener((ActionListener)object);
        ((Container)object2).add(this.moveDown);
        ((Container)object2).add(Box.createGlue());
        this.updateButtons();
        this.add("South", (Component)object2);
    }

    protected void _save() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(((MenuItem)this.listModel.elementAt((int)i)).actionName);
        }
        jEdit.setProperty("view.context", stringBuffer.toString());
    }

    private void updateButtons() {
        int n = this.list.getSelectedIndex();
        this.remove.setEnabled(n != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(n > 0);
        this.moveDown.setEnabled(n != -1 && n != this.listModel.getSize() - 1);
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ContextOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ContextOptionPane.this.add) {
                ContextAddDialog contextAddDialog = new ContextAddDialog(ContextOptionPane.this);
                String string = contextAddDialog.getSelection();
                if (string == null) {
                    return;
                }
                int n = ContextOptionPane.this.list.getSelectedIndex();
                n = n == -1 ? ContextOptionPane.this.listModel.getSize() : ++n;
                MenuItem menuItem = string.equals("-") ? new MenuItem("-", "-") : new MenuItem(string, jEdit.getAction(string).getLabel());
                ContextOptionPane.this.listModel.insertElementAt(menuItem, n);
                ContextOptionPane.this.list.setSelectedIndex(n);
                ContextOptionPane.this.list.ensureIndexIsVisible(n);
            } else if (object == ContextOptionPane.this.remove) {
                int n = ContextOptionPane.this.list.getSelectedIndex();
                ContextOptionPane.this.listModel.removeElementAt(n);
                if (ContextOptionPane.this.listModel.getSize() != 0) {
                    ContextOptionPane.this.list.setSelectedIndex(Math.min(ContextOptionPane.this.listModel.getSize() - 1, n));
                }
                ContextOptionPane.this.updateButtons();
            } else if (object == ContextOptionPane.this.moveUp) {
                int n = ContextOptionPane.this.list.getSelectedIndex();
                Object e = ContextOptionPane.this.list.getSelectedValue();
                ContextOptionPane.this.listModel.removeElementAt(n);
                ContextOptionPane.this.listModel.insertElementAt(e, n - 1);
                ContextOptionPane.this.list.setSelectedIndex(n - 1);
                ContextOptionPane.this.list.ensureIndexIsVisible(n - 1);
            } else if (object == ContextOptionPane.this.moveDown) {
                int n = ContextOptionPane.this.list.getSelectedIndex();
                Object e = ContextOptionPane.this.list.getSelectedValue();
                ContextOptionPane.this.listModel.removeElementAt(n);
                ContextOptionPane.this.listModel.insertElementAt(e, n + 1);
                ContextOptionPane.this.list.setSelectedIndex(n + 1);
                ContextOptionPane.this.list.ensureIndexIsVisible(n + 1);
            }
        }
    }

    static class MenuItem {
        String actionName;
        String label;

        MenuItem(String string, String string2) {
            this.actionName = string;
            this.label = GUIUtilities.prettifyMenuLabel(string2);
        }

        public String toString() {
            return this.label;
        }
    }

    static class MenuItemCompare
    implements MiscUtilities.Compare {
        MenuItemCompare() {
        }

        public int compare(Object object, Object object2) {
            return MiscUtilities.compareStrings(((MenuItem)object).label, ((MenuItem)object2).label, true);
        }
    }
}

