/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ToolBarOptionPane;
import org.gjt.sp.util.Log;

class ToolBarEditDialog
extends EnhancedDialog {
    private boolean isOK;
    private JRadioButton separator;
    private JRadioButton action;
    private JComboBox combo;
    private JList list;
    private JRadioButton builtin;
    private JComboBox builtinCombo;
    private JRadioButton file;
    private JButton fileButton;
    private String fileIcon;
    private JButton ok;
    private JButton cancel;

    public ToolBarEditDialog(Component component, DefaultComboBoxModel defaultComboBoxModel, ToolBarOptionPane.Button button) {
        super(GUIUtilities.getParentDialog(component), jEdit.getProperty("options.toolbar.edit.title"), true);
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        ActionHandler actionHandler = new ActionHandler();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 6, 6));
        jPanel2.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add(new JLabel(jEdit.getProperty("options.toolbar.edit.caption")));
        this.separator = new JRadioButton(jEdit.getProperty("options.toolbar.edit.separator"));
        this.separator.addActionListener(actionHandler);
        buttonGroup.add(this.separator);
        jPanel2.add(this.separator);
        this.action = new JRadioButton(jEdit.getProperty("options.toolbar.edit.action"));
        this.action.addActionListener(actionHandler);
        buttonGroup.add(this.action);
        jPanel2.add(this.action);
        jPanel.add("North", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(6, 6));
        ActionSet[] actionSetArray = jEdit.getActionSets();
        Vector<ActionSet> vector = new Vector<ActionSet>(actionSetArray.length);
        for (int i = 0; i < actionSetArray.length; ++i) {
            object = actionSetArray[i];
            if (((ActionSet)object).getActionCount() == 0) continue;
            vector.addElement((ActionSet)object);
        }
        this.combo = new JComboBox(vector);
        this.combo.addActionListener(actionHandler);
        jPanel3.add("North", this.combo);
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        jPanel3.add("Center", new JScrollPane(this.list));
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 3));
        object = new JPanel(new GridLayout(2, 1));
        ((JComponent)object).setBorder(new EmptyBorder(0, 0, 0, 12));
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        buttonGroup = new ButtonGroup();
        this.builtin = new JRadioButton(jEdit.getProperty("options.toolbar.edit.builtin"));
        ((Container)object).add(this.builtin);
        this.builtin.addActionListener(actionHandler);
        buttonGroup.add(this.builtin);
        this.file = new JRadioButton(jEdit.getProperty("options.toolbar.edit.file"));
        ((Container)object).add(this.file);
        buttonGroup.add(this.file);
        this.file.addActionListener(actionHandler);
        jPanel4.add("West", (Component)object);
        this.builtinCombo = new JComboBox(defaultComboBoxModel);
        this.builtinCombo.setRenderer(new ToolBarOptionPane.IconCellRenderer());
        jPanel5.add(this.builtinCombo);
        this.fileButton = new JButton(jEdit.getProperty("options.toolbar.edit.no-icon"));
        this.fileButton.setMargin(new Insets(1, 1, 1, 1));
        this.fileButton.setIcon(GUIUtilities.loadIcon("Blank24.gif"));
        this.fileButton.setHorizontalAlignment(2);
        this.fileButton.addActionListener(actionHandler);
        jPanel5.add(this.fileButton);
        jPanel4.add("Center", jPanel5);
        jPanel3.add("South", jPanel4);
        jPanel.add("Center", jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel6.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        jPanel6.add(this.ok);
        jPanel6.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionHandler);
        jPanel6.add(this.cancel);
        jPanel6.add(Box.createGlue());
        jPanel.add("South", jPanel6);
        if (button == null) {
            this.action.setSelected(true);
            this.builtin.setSelected(true);
            this.updateList();
        } else if (button.actionName.equals("-")) {
            this.separator.setSelected(true);
            this.builtin.setSelected(true);
        } else {
            this.action.setSelected(true);
            ActionSet actionSet = jEdit.getActionSetForAction(button.actionName);
            this.combo.setSelectedItem(actionSet);
            this.updateList();
            this.list.setSelectedValue(button, true);
            if (MiscUtilities.isURL(button.iconName)) {
                this.file.setSelected(true);
                this.fileIcon = button.iconName;
                try {
                    this.fileButton.setIcon(new ImageIcon(new URL(this.fileIcon)));
                }
                catch (MalformedURLException malformedURLException) {
                    Log.log(9, this, malformedURLException);
                }
                this.fileButton.setText(MiscUtilities.getFileName(this.fileIcon));
            } else {
                String string = MiscUtilities.getFileName(button.iconName);
                this.builtin.setSelected(true);
                ComboBoxModel comboBoxModel = this.builtinCombo.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    ToolBarOptionPane.IconListEntry iconListEntry = (ToolBarOptionPane.IconListEntry)comboBoxModel.getElementAt(i);
                    if (!iconListEntry.name.equals(string)) continue;
                    this.builtinCombo.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.updateEnabled();
        this.pack();
        this.setLocationRelativeTo(GUIUtilities.getParentDialog(component));
        this.setVisible(true);
    }

    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public ToolBarOptionPane.Button getSelection() {
        String string;
        Icon icon;
        Object object;
        if (!this.isOK) {
            return null;
        }
        if (this.separator.isSelected()) {
            return new ToolBarOptionPane.Button("-", null, null, "-");
        }
        if (this.builtin.isSelected()) {
            object = (ToolBarOptionPane.IconListEntry)this.builtinCombo.getSelectedItem();
            icon = ((ToolBarOptionPane.IconListEntry)object).icon;
            string = ((ToolBarOptionPane.IconListEntry)object).name;
        } else {
            icon = this.fileButton.getIcon();
            string = this.fileIcon;
            if (string == null) {
                string = "Blank24.gif";
            }
        }
        if (!this.action.isSelected()) {
            throw new InternalError();
        }
        ToolBarOptionPane.Button button = (ToolBarOptionPane.Button)this.list.getSelectedValue();
        object = button.label;
        String string2 = button.actionName;
        return new ToolBarOptionPane.Button(string2, string, icon, (String)object);
    }

    private void updateEnabled() {
        this.combo.setEnabled(this.action.isSelected());
        this.list.setEnabled(this.action.isSelected());
        boolean bl = !this.separator.isSelected();
        this.builtin.setEnabled(bl);
        this.file.setEnabled(bl);
        this.builtinCombo.setEnabled(bl && this.builtin.isSelected());
        this.fileButton.setEnabled(bl && this.file.isSelected());
    }

    private void updateList() {
        ActionSet actionSet = (ActionSet)this.combo.getSelectedItem();
        EditAction[] editActionArray = actionSet.getActions();
        Vector<ToolBarOptionPane.Button> vector = new Vector<ToolBarOptionPane.Button>(editActionArray.length);
        for (int i = 0; i < editActionArray.length; ++i) {
            EditAction editAction = editActionArray[i];
            String string = editAction.getLabel();
            if (string == null) continue;
            vector.addElement(new ToolBarOptionPane.Button(editAction.getName(), null, null, string));
        }
        MiscUtilities.quicksort(vector, (MiscUtilities.Compare)new ToolBarOptionPane.ButtonCompare());
        this.list.setListData(vector);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                ToolBarEditDialog.this.updateEnabled();
            }
            if (object == ToolBarEditDialog.this.ok) {
                ToolBarEditDialog.this.ok();
            } else if (object == ToolBarEditDialog.this.cancel) {
                ToolBarEditDialog.this.cancel();
            } else if (object == ToolBarEditDialog.this.combo) {
                ToolBarEditDialog.this.updateList();
            } else if (object == ToolBarEditDialog.this.fileButton) {
                String string = ToolBarEditDialog.this.fileIcon == null ? null : MiscUtilities.getParentOfPath(ToolBarEditDialog.this.fileIcon);
                String[] stringArray = GUIUtilities.showVFSFileDialog(null, string, 0, false);
                if (stringArray == null) {
                    return;
                }
                ToolBarEditDialog.this.fileIcon = "file:" + stringArray[0];
                try {
                    ToolBarEditDialog.this.fileButton.setIcon(new ImageIcon(new URL(ToolBarEditDialog.this.fileIcon)));
                }
                catch (MalformedURLException malformedURLException) {
                    Log.log(9, this, malformedURLException);
                }
                ToolBarEditDialog.this.fileButton.setText(MiscUtilities.getFileName(ToolBarEditDialog.this.fileIcon));
            }
        }
    }
}

