/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.search.SearchFileSet;

public abstract class BufferListSet
implements SearchFileSet {
    private String[] files;

    public synchronized String getFirstFile(View view) {
        if (this.files == null) {
            this.files = this._getFiles((Component)((Object)view));
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0];
    }

    public synchronized String getNextFile(View view, String string) {
        if (this.files == null) {
            this.files = this._getFiles((Component)((Object)view));
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        if (string == null) {
            string = view.getBuffer().getSymlinkPath();
            VFS vFS = VFSManager.getVFSForPath(string);
            boolean bl = (vFS.getCapabilities() & 0x80) != 0;
            for (int i = 0; i < this.files.length; ++i) {
                if (MiscUtilities.compareStrings(this.files[i], string, bl) != 0) continue;
                return string;
            }
            return this.getFirstFile(view);
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        boolean bl = (vFS.getCapabilities() & 0x80) != 0;
        for (int i = 0; i < this.files.length - 1; ++i) {
            if (MiscUtilities.compareStrings(this.files[i], string, bl) != 0) continue;
            return this.files[i + 1];
        }
        return null;
    }

    public synchronized String[] getFiles(View view) {
        if (this.files == null) {
            this.files = this._getFiles((Component)((Object)view));
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files;
    }

    public synchronized int getFileCount(View view) {
        if (this.files == null) {
            this.files = this._getFiles((Component)((Object)view));
        }
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    public String getCode() {
        return null;
    }

    public synchronized void invalidateCachedList() {
        this.files = null;
    }

    protected abstract String[] _getFiles(Component var1);
}

