/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.graph.GraphState;
import de.grogra.graph.Path;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.Visitor3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.shading.AlgorithmSwitchShader;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.ShaderRef;
import de.grogra.xl.util.ObjectList;
import javax.vecmath.Matrix4d;

public abstract class DisplayVisitor
extends Visitor3D {
    protected Object lastEntered;
    protected boolean lastEnteredIsNode;
    private ObjectList shaderStack = new ObjectList();
    private Shader shader;
    private ViewConfig3D view;
    private boolean checkLayer;

    public void init(GraphState graphState, Matrix4d matrix4d, ViewConfig3D viewConfig3D, boolean bl) {
        this.init(graphState, graphState.getGraph().getTreePattern(), matrix4d);
        this.shaderStack.clear();
        this.shader = RGBAShader.GRAY;
        this.view = viewConfig3D;
        this.checkLayer = bl;
    }

    public Shader getCurrentShader() {
        return this.shader;
    }

    protected Shader resolveShader(Shader shader) {
        return shader instanceof AlgorithmSwitchShader ? ((AlgorithmSwitchShader)shader).getGUIShader() : (shader instanceof ShaderRef ? ((ShaderRef)shader).resolve() : shader);
    }

    protected boolean isInVisibleLayer(Object object, boolean bl) {
        return !this.checkLayer || this.view.isInVisibleLayer(object, bl, this.state);
    }

    protected void visitEnterImpl(Object object, boolean bl, Path path) {
        Shader shader;
        this.lastEntered = object;
        this.lastEnteredIsNode = bl;
        this.shaderStack.push((Object)this.shader);
        Shader shader2 = (Shader)this.state.getObjectDefault(object, bl, Attributes.SHADER, (Object)this.shader);
        while ((shader = this.resolveShader(shader2)) != shader2) {
            shader2 = shader;
        }
        if (shader2 != null) {
            this.shader = shader2;
        } else {
            shader2 = this.shader;
        }
        if (this.isInVisibleLayer(object, bl)) {
            this.visitImpl(object, bl, shader2, path);
        }
    }

    protected abstract void visitImpl(Object var1, boolean var2, Shader var3, Path var4);

    protected void visitLeaveImpl(Object object, boolean bl, Path path) {
        this.shader = (Shader)this.shaderStack.pop();
    }
}

