/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp.View;
import de.grogra.imp3d.View3D;
import de.grogra.math.TMatrix4d;
import de.grogra.math.TVector3d;
import de.grogra.math.Transform3D;
import de.grogra.math.Tuple3dType;
import de.grogra.math.Tuple3fType;
import de.grogra.persistence.SCOType;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Plugin;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.event.DragEvent;
import de.grogra.pf.ui.registry.CommandItem;
import de.grogra.pf.ui.registry.CommandPlugin;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.util.I18NBundle;
import javax.vecmath.Matrix4d;

public final class IMP3D
extends Plugin
implements CommandPlugin {
    public static final I18NBundle I18N = I18NBundle.getInstance(IMP3D.class);
    public static final SCOType SPECTRUM_3F = (SCOType)new SCOType((Object)new Spectrum3f(), (SCOType)Tuple3fType.$TYPE).validate();
    public static final SCOType SPECTRUM_3D = (SCOType)new SCOType((Object)new Spectrum3d(), (SCOType)Tuple3dType.$TYPE).validate();
    private static IMP3D PLUGIN;

    public static IMP3D getInstance() {
        return PLUGIN;
    }

    public IMP3D() {
        assert (PLUGIN == null);
        PLUGIN = this;
    }

    public void run(Object object, Context context, CommandItem commandItem) {
        DragEvent dragEvent;
        String string = commandItem.getName();
        if ("move".equals(string)) {
            DragEvent dragEvent2 = (DragEvent)object;
            if (dragEvent2.draggingContinued()) {
                ((View3D)dragEvent2.getPanel()).move(dragEvent2.getDeltaX(), dragEvent2.getDeltaY());
            }
        } else if ("dolly".equals(string)) {
            DragEvent dragEvent3 = (DragEvent)object;
            if (dragEvent3.draggingContinued()) {
                ((View3D)dragEvent3.getPanel()).dolly(dragEvent3.getDeltaX(), dragEvent3.getDeltaY());
            }
        } else if ("rotate".equals(string)) {
            DragEvent dragEvent4 = (DragEvent)object;
            if (dragEvent4.draggingContinued()) {
                ((View3D)dragEvent4.getPanel()).rotate(dragEvent4.getDeltaX(), dragEvent4.getDeltaY());
            }
        } else if ("zoom".equals(string) && (dragEvent = (DragEvent)object).draggingContinued()) {
            ((View3D)dragEvent.getPanel()).zoom(dragEvent.getDeltaX(), dragEvent.getDeltaY());
        }
    }

    public static Transform3D toTransform(Matrix4d matrix4d) {
        double d;
        double d2 = matrix4d.m00 - 1.0;
        double d3 = d2 * d2;
        d2 = matrix4d.m01;
        double d4 = d3 + d2 * d2;
        d2 = matrix4d.m02;
        double d5 = d4 + d2 * d2;
        d2 = matrix4d.m10;
        double d6 = d5 + d2 * d2;
        d2 = matrix4d.m11 - 1.0;
        double d7 = d6 + d2 * d2;
        d2 = matrix4d.m12;
        double d8 = d7 + d2 * d2;
        d2 = matrix4d.m20;
        double d9 = d8 + d2 * d2;
        d2 = matrix4d.m21;
        return d9 + d2 * d2 + d * (d2 = matrix4d.m22 - 1.0) < 1.0E-8 ? new TVector3d(matrix4d.m03, matrix4d.m13, matrix4d.m23) : new TMatrix4d(matrix4d);
    }

    public static void fitCamera(Item item, Object object, Context context) {
        View view = View.get((Context)context);
        if (!(view instanceof View3D)) {
            return;
        }
        ((View3D)view).fitCamera();
    }
}

