/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.Graph;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp.View;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.objects.Matrix4dAttribute;
import de.grogra.imp3d.LineArray;
import de.grogra.imp3d.LineSegmentizable;
import de.grogra.imp3d.Pickable;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.Visitor3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.vecmath.Math2;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PickRayVisitor
extends Visitor3D {
    protected PickList list;
    protected final Point3d origin = new Point3d();
    protected final Vector3d direction = new Vector3d();
    final Point3d origin0 = new Point3d();
    final Vector3d direction0 = new Vector3d();
    private final LineArray lines = new LineArray();
    private boolean checkLayer;
    private final ArrayPath placeInPath = new ArrayPath((Graph)null);

    public void pick(View3D view3D, int n, int n2, Point3d point3d, Vector3d vector3d, PickList pickList) {
        pickList.reset((View)view3D, n, n2);
        this.origin0.set((Tuple3d)point3d);
        this.direction0.set((Tuple3d)vector3d);
        this.direction0.normalize();
        this.list = pickList;
        this.placeInPath.clear(view3D.getGraph());
        this.init(view3D.getWorkbenchGraphState(), view3D.getGraph().getTreePattern(), Matrix4dAttribute.IDENTITY);
        this.checkLayer = true;
        view3D.getGraph().accept(null, (Visitor)this, this.placeInPath);
        Tool tool = view3D.getActiveTool();
        if (tool != null) {
            pickList.beginNewGroup();
            this.init(GraphManager.STATIC_STATE, (EdgePattern)EdgePatternImpl.TREE, Matrix4dAttribute.IDENTITY);
            this.placeInPath.clear((Graph)GraphManager.STATIC);
            this.checkLayer = false;
            for (int i = 0; i < tool.getToolCount(); ++i) {
                GraphManager.acceptGraph((Node)tool.getRoot(i), (Visitor)this, (ArrayPath)this.placeInPath);
            }
        }
    }

    protected void visitEnterImpl(Object object, boolean bl, Path path) {
        Object object2 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null);
        if (object2 != null) {
            if (this.checkLayer && !this.list.getView().isInVisibleLayer(object, bl, this.state)) {
                return;
            }
            if (object2 instanceof Pickable) {
                this.origin.set((Tuple3d)this.origin0);
                this.direction.set((Tuple3d)this.direction0);
                Math2.invTransformPointAndVector((Matrix4d)this.transformation, (Tuple3d)this.origin, (Tuple3d)this.direction);
                this.list.begin(path, !bl);
                ((Pickable)object2).pick(object, bl, this.origin, this.direction, this.transformation, this.list);
                this.list.end();
            } else if (object2 instanceof LineSegmentizable) {
                this.origin.set((Tuple3d)this.origin0);
                this.direction.set((Tuple3d)this.direction0);
                Math2.invTransformPointAndVector((Matrix4d)this.transformation, (Tuple3d)this.origin, (Tuple3d)this.direction);
                this.list.begin(path, !bl);
                this.state.setObjectContext(object, bl);
                LineSegmentizable lineSegmentizable = (LineSegmentizable)object2;
                lineSegmentizable.segmentize(lineSegmentizable.getSegmentizableSource(this.state), this.state, this.lines, 1.0f);
                PickRayVisitor.pickLines(this.lines, this.origin, this.direction, this.transformation, this.list, 4);
                this.list.end();
            }
        }
    }

    protected void visitLeaveImpl(Object object, boolean bl, Path path) {
    }

    public static void pickLines(LineArray lineArray, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList, int n) {
        int[] nArray = lineArray.lines.elements;
        float[] fArray = lineArray.vertices.elements;
        int n2 = lineArray.dimension;
        int n3 = lineArray.lines.size;
        int n4 = 0;
        boolean bl = false;
        Point3d point3d2 = pickList.p3d0;
        Point3d point3d3 = pickList.p3d1;
        Vector3d vector3d2 = pickList.v3d0;
        while (n4 < n3) {
            int n5;
            if ((n5 = nArray[n4++]) >= 0) {
                point3d3.x = fArray[n5 *= n2];
                point3d3.y = n2 > 1 ? (double)fArray[n5 + 1] : 0.0;
                double d = point3d3.z = n2 > 2 ? (double)fArray[n5 + 2] : 0.0;
                if (bl) {
                    vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d2);
                    PickRayVisitor.pickLine(point3d2, vector3d2, point3d, vector3d, matrix4d, pickList, n);
                }
                Point3d point3d4 = point3d2;
                point3d2 = point3d3;
                point3d3 = point3d4;
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    public static void pickLine(Point3d point3d, Vector3d vector3d, Point3d point3d2, Vector3d vector3d2, Matrix4d matrix4d, PickList pickList, int n) {
        double[] dArray = pickList.getDoubleArray(0, 2);
        Math2.shortestConnection((Tuple3d)point3d, (Vector3d)vector3d, (Tuple3d)point3d2, (Vector3d)vector3d2, (double[])dArray);
        if (dArray[0] >= 0.0 && dArray[0] <= 1.0 && dArray[1] > 0.0) {
            Point3d point3d3 = pickList.q3d0;
            Point2f point2f = pickList.q2f0;
            point3d3.scaleAdd(dArray[0], (Tuple3d)vector3d, (Tuple3d)point3d);
            matrix4d.transform(point3d3);
            if (((View3D)pickList.getView()).getCanvasCamera().projectWorld((Tuple3d)point3d3, (Tuple2f)point2f) > 0 && Math.abs(point2f.x - (float)pickList.getViewX()) < (float)n && Math.abs(point2f.y - (float)pickList.getViewY()) < (float)n) {
                pickList.add(dArray[1]);
            }
        }
    }

    public static void pickPoint(Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList, int n) {
        Point3d point3d2 = pickList.p3d0;
        Point2f point2f = pickList.p2f0;
        point3d2.set(0.0, 0.0, 0.0);
        matrix4d.transform(point3d2);
        if (((View3D)pickList.getView()).getCanvasCamera().projectWorld((Tuple3d)point3d2, (Tuple2f)point2f) > 0 && Math.abs(point2f.x - (float)pickList.getViewX()) < (float)n && Math.abs(point2f.y - (float)pickList.getViewY()) < (float)n) {
            point3d2.set(0.0, 0.0, 0.0);
            pickList.add(Math2.closestConnection((Tuple3d)point3d, (Vector3d)vector3d, (Tuple3d)point3d2));
        }
    }
}

