/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectMap;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.VolumeBuilder;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.shading.Shader;
import de.grogra.vecmath.geom.EmptyVolume;
import de.grogra.vecmath.geom.Volume;
import javax.vecmath.Matrix4d;

public final class VolumeAttribute
extends ObjectAttribute {
    public static final VolumeAttribute ATTRIBUTE = new VolumeAttribute();
    private static final Volume EMPTY = new EmptyVolume();

    private VolumeAttribute() {
        super(Volume.class, false, null);
        this.initializeName("de.grogra.imp3d.volume");
    }

    public boolean isDerived() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getDerived(Object object, boolean bl, Object object2, GraphState graphState) {
        Builder builder;
        VolumeAttribute volumeAttribute = this;
        synchronized (volumeAttribute) {
            builder = (Builder)this.getAttributeState(graphState);
            if (builder == null) {
                builder = new Builder(graphState);
                this.setAttributeState(graphState, builder);
            }
        }
        return builder.getVolume(object, bl, graphState);
    }

    public static Volume getVolume(Object object, boolean bl, GraphState graphState) {
        return (Volume)ATTRIBUTE.getDerived(object, bl, null, graphState);
    }

    private static class Builder
    extends VolumeBuilder {
        ObjectMap<Listener> listeners;
        private Volume addedVolume;
        private GraphState state;
        private Matrix4d currentXform = new Matrix4d();

        Builder(GraphState graphState) {
            super(new PolygonizationCache(graphState, 3, 10.0f, true), 1.0E-5f);
            this.listeners = graphState.getGraph().createObjectMap();
        }

        protected void addVolume(Volume volume, Matrix4d matrix4d, Shader shader) {
            this.addedVolume = volume;
        }

        protected Matrix4d getCurrentTransformation() {
            return this.currentXform;
        }

        public Shader getCurrentShader() {
            return null;
        }

        public GraphState getRenderGraphState() {
            return this.state;
        }

        synchronized Volume getVolume(Object object, boolean bl, GraphState graphState) {
            Listener listener = (Listener)this.listeners.getObject(object, bl);
            if (listener == null) {
                listener = new Listener();
                this.listeners.putObject(object, bl, (Object)listener);
            }
            if (listener.volume == null) {
                this.addedVolume = EMPTY;
                Object object2 = graphState.getObjectDefault(object, bl, Attributes.SHAPE, null);
                if (object2 instanceof Renderable) {
                    this.state = graphState;
                    GlobalTransformation.get(object, bl, graphState, false).get(this.currentXform);
                    ((Renderable)object2).draw(object, bl, this);
                    this.state = null;
                }
                listener.volume = this.addedVolume;
                this.addedVolume = null;
                graphState.getGraph().addAttributeChangeListener(object, bl, (AttributeChangeListener)listener);
            }
            return listener.volume;
        }
    }

    private static class Listener
    implements AttributeChangeListener {
        Volume volume;

        private Listener() {
        }

        public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
            if (this.volume == null) {
                return;
            }
            this.volume = null;
            attributeChangeEvent.getGraphState().getGraph().removeAttributeChangeListener(attributeChangeEvent.getObject(), attributeChangeEvent.isNode(), (AttributeChangeListener)this);
            attributeChangeEvent.getGraphState().fireAttributeChanged(attributeChangeEvent.getObject(), attributeChangeEvent.isNode(), (Attribute)ATTRIBUTE, null, null);
        }
    }
}

