/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.View;
import de.grogra.imp.awt.CanvasAdapter;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp.objects.FontAdapter;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.DisplayVisitor;
import de.grogra.imp3d.LineArray;
import de.grogra.imp3d.LineSegmentizable;
import de.grogra.imp3d.LineSegmentizationCache;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.NURBSSurface;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineSurface;
import de.grogra.math.Pool;
import de.grogra.math.TMatrix4d;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.util.EventListener;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import de.grogra.util.WrapException;
import de.grogra.vecmath.Math2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import javax.swing.Icon;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jibble.epsgraphics.EpsGraphics2D;

public class WireframeCanvas
extends CanvasAdapter
implements RenderState,
Selectable {
    static final boolean DRAW_NURBS_UNIFORMLY = false;
    public static final int OVERLAY = -1;
    protected static final int COLOR = 0;
    protected static final int FONT = 1;
    protected static final int LINE = 2;
    protected static final int STRING = 3;
    protected static final int DRAW_RECT = 4;
    protected static final int FILL_RECT = 5;
    protected static final int DRAW_POLY = 6;
    protected static final int FILL_POLY = 7;
    protected static final int ICON = 8;
    private static final String OPTION_NAME_SHOW_POINTS = "showPoints";
    private boolean optionShowPoints = false;
    private static final String OPTION_NAME_SHOW_GRID = "showGrid";
    private boolean optionShowGrid = false;
    private static final String OPTION_NAME_GRID_DIMENSION = "gridDimension";
    private int optionGridDimension = 1;
    private static final String OPTION_NAME_GRID_SPACING = "gridSpacing";
    private float optionGridSpacing = 1.0f;
    private static final String OPTION_NAME_GRID_COLOR_R = "gridColorR";
    private float optionGridColorR = 1.0f;
    private static final String OPTION_NAME_GRID_COLOR_G = "gridColorG";
    private float optionGridColorG = 1.0f;
    private static final String OPTION_NAME_GRID_COLOR_B = "gridColorB";
    private float optionGridColorB = 1.0f;
    private static final String OPTION_NAME_BACKGROUND_COLOR_R = "backgroundColorR";
    private float optionBackgroundColorR = 1.0f;
    private static final String OPTION_NAME_BACKGROUND_COLOR_G = "backgroundColorG";
    private float optionBackgroundColorG = 1.0f;
    private static final String OPTION_NAME_BACKGROUND_COLOR_B = "backgroundColorB";
    private float optionBackgroundColorB = 1.0f;
    private static final String OPTION_NAME_BACKGROUND_ALPHA = "backgroundAlpha";
    private float optionBackgroundAlpha = 1.0f;
    private static final String OPTION_NAME_SHOW_AXES = "showAxes";
    private boolean optionShowAxes = false;
    private static final String OPTION_NAME_SHOW_AXES_NAMES = "showAxesNames";
    private boolean optionShowAxesNames = false;
    private static final String OPTION_NAME_SHOW_DISPLAY_SIZE = "showDisplaySize";
    private boolean optionShowDisplaySize = false;
    public final Pool pool = new Pool();
    private float[] cx = new float[10];
    private float[] cy = new float[10];
    private float[] cz = new float[10];
    private Layer[] layers;
    private Layer[] layerStack = new Layer[10];
    private Layer currentLayer;
    private int lsSize;
    private Graphics bufferGraphics;
    private WFVisitor visitor = new WFVisitor();
    private PolygonizationCache polyCache;
    private final Point3d q0 = new Point3d();
    private final Point3f q0f = new Point3f();
    private boolean computeMinMax;
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;
    private boolean justFitCamera;
    private int canvasWidth;
    private int canvasHeight;
    private float lineWidth = 1.0f;
    private final Point lineStart = new Point();
    private final Point lineEnd = new Point();
    private final Point2f retPoint = new Point2f();
    private final Matrix4d xform = new TMatrix4d();

    public WireframeCanvas() {
        this(false);
    }

    private WireframeCanvas(boolean bl) {
        this.justFitCamera = bl;
        this.initCanvas((Component)new CanvasAdapter.CanvasComponent((CanvasAdapter)this, 640, 480));
        this.layers = new Layer[3];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new Layer();
        }
    }

    static void fitCamera(View3D view3D) {
        WireframeCanvas wireframeCanvas = new WireframeCanvas(true);
        wireframeCanvas.initFactory(Item.resolveItem((RegistryContext)view3D.getWorkbench(), (String)"/ui/viewcomponent3dselection/wireframe"));
        wireframeCanvas.initView(view3D, (EventListener)new EventListener.Bicast());
        wireframeCanvas.checkBuffers();
    }

    public View3D getView3D() {
        return (View3D)this.getView();
    }

    public void initView(View view, EventListener eventListener) {
        super.initView(view, eventListener);
        this.optionShowPoints = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_POINTS, Boolean.TRUE));
        this.lineWidth = ((Number)this.getOption("lineWidth", new Float(1.0f))).floatValue();
        this.optionShowGrid = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_GRID, Boolean.FALSE));
        this.optionGridDimension = (Integer)this.getOption(OPTION_NAME_GRID_DIMENSION, 5);
        this.optionGridSpacing = ((Float)this.getOption(OPTION_NAME_GRID_SPACING, Float.valueOf(1.0f))).floatValue();
        this.optionGridColorR = ((Float)this.getOption(OPTION_NAME_GRID_COLOR_R, Float.valueOf(1.0f))).floatValue();
        this.optionGridColorG = ((Float)this.getOption(OPTION_NAME_GRID_COLOR_G, Float.valueOf(1.0f))).floatValue();
        this.optionGridColorB = ((Float)this.getOption(OPTION_NAME_GRID_COLOR_B, Float.valueOf(1.0f))).floatValue();
        this.optionBackgroundColorR = ((Float)this.getOption(OPTION_NAME_BACKGROUND_COLOR_R, Float.valueOf(1.0f))).floatValue();
        this.optionBackgroundColorG = ((Float)this.getOption(OPTION_NAME_BACKGROUND_COLOR_G, Float.valueOf(1.0f))).floatValue();
        this.optionBackgroundColorB = ((Float)this.getOption(OPTION_NAME_BACKGROUND_COLOR_B, Float.valueOf(1.0f))).floatValue();
        this.optionBackgroundAlpha = ((Float)this.getOption(OPTION_NAME_BACKGROUND_ALPHA, Float.valueOf(1.0f))).floatValue();
        this.optionShowAxes = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_AXES, Boolean.FALSE));
        this.optionShowAxesNames = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_AXES_NAMES, Boolean.FALSE));
        this.optionShowDisplaySize = Boolean.TRUE.equals(this.getOption(OPTION_NAME_SHOW_DISPLAY_SIZE, Boolean.FALSE));
    }

    protected void initPaint(int n, int n2, int n3) {
        ((View3D)this.getView()).getCanvasCamera().setDimension(n2, n3);
        this.canvasWidth = n2;
        this.canvasHeight = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintScene(int n, Graphics2D graphics2D) throws InterruptedException {
        this.computeMinMax = true;
        this.minZ = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.minX = Float.POSITIVE_INFINITY;
        this.maxZ = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        if (!this.justFitCamera && !(graphics2D instanceof EpsGraphics2D)) {
            graphics2D.setColor(new Color(this.optionBackgroundColorR, this.optionBackgroundColorG, this.optionBackgroundColorB, this.optionBackgroundAlpha));
            graphics2D.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
        this.currentLayer = null;
        this.lsSize = 0;
        Stroke stroke = graphics2D.getStroke();
        try {
            if (this.antialiasing && !this.justFitCamera) {
                graphics2D.setStroke(new BasicStroke(this.lineWidth));
            }
            this.bufferGraphics = graphics2D;
            if (this.optionShowGrid) {
                this.drawGrid();
            }
            this.visitor.init(this.getRenderGraphState(), 0, 0, true);
            try {
                this.getView().getGraph().accept(null, (Visitor)this.visitor, null);
                if (this.polyCache != null) {
                    this.polyCache.clearUnused();
                }
            }
            catch (WrapException wrapException) {
                if (wrapException.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)wrapException.getCause();
                }
                throw wrapException;
            }
            if (this.optionShowAxes) {
                this.drawAxes();
            }
            if (this.optionShowDisplaySize) {
                this.drawDisplaySize();
            }
            if (!this.justFitCamera) {
                for (int i = 0; i < this.layers.length; ++i) {
                    this.currentLayer = this.layers[i];
                    this.currentLayer.draw(graphics2D);
                    this.currentLayer.reset();
                }
            }
            Point3f point3f = new Point3f(this.minX, this.minY, this.minZ);
            final Point3f point3f2 = new Point3f(this.maxX, this.maxY, this.maxZ);
            final float f = 0.5f * point3f2.distance(point3f);
            point3f2.add((Tuple3f)point3f);
            point3f2.scale(0.5f);
            if (this.justFitCamera) {
                this.getView().getWorkbench().getJobManager().runLater((Command)new LockProtectedCommand((Lockable)this.getView().getGraph(), true, 70536){

                    public String getCommandName() {
                        return null;
                    }

                    protected void runImpl(Object object, Context context, Lock lock) {
                        WireframeCanvas.this.getView3D().fitCamera(new Vector3f((Tuple3f)point3f2), f);
                        WireframeCanvas.this.dispose();
                    }
                }, null, (Context)this.getView(), 70536);
            } else {
                this.getView3D().setExtent((Tuple3f)point3f2, f);
            }
        }
        finally {
            graphics2D.setStroke(stroke);
        }
    }

    protected void paintHighlight(int n, Graphics2D graphics2D) {
        if (this.justFitCamera) {
            return;
        }
        this.computeMinMax = false;
        this.currentLayer = null;
        this.lsSize = 0;
        this.bufferGraphics = graphics2D;
        if (ViewSelection.get((Context)this.getView()) == null) {
            System.err.println("NULL");
            return;
        }
        ArrayPath arrayPath = new ArrayPath(this.getView().getGraph());
        ViewSelection.Entry[] entryArray = ViewSelection.get((Context)this.getView()).getAll(-1);
        for (int i = 0; i < entryArray.length; ++i) {
            Path path = entryArray[i].getPath();
            this.visitor.init(this.getRenderGraphState(), entryArray[i].getValue(), path.getNodeAndEdgeCount(), true);
            GraphUtils.acceptPath((Path)path, (Visitor)this.visitor, (ArrayPath)arrayPath);
        }
        Tool tool = this.getView().getActiveTool();
        if (tool != null) {
            this.visitor.init(GraphManager.STATIC_STATE, 0, 0, false);
            arrayPath.clear((Graph)GraphManager.STATIC);
            for (int i = 0; i < tool.getToolCount(); ++i) {
                GraphManager.acceptGraph((Node)tool.getRoot(i), (Visitor)this.visitor, (ArrayPath)arrayPath);
            }
        }
        for (int i = 0; i < this.layers.length; ++i) {
            this.currentLayer = this.layers[i];
            this.currentLayer.draw(graphics2D);
            this.currentLayer.reset();
        }
    }

    protected void finalizePaint() {
    }

    public void setColor(Color color) {
        if (this.currentLayer == null) {
            this.bufferGraphics.setColor(color);
        } else {
            this.currentLayer.setColor(color);
        }
    }

    public final Color getColor() {
        return this.currentLayer == null ? this.bufferGraphics.getColor() : this.currentLayer.color;
    }

    public final void setFont(Font font) {
        if (this.currentLayer == null) {
            this.bufferGraphics.setFont(font);
        } else {
            this.currentLayer.setFont(font);
        }
    }

    public final void drawLine(int n, int n2) {
        this.drawLine(n, n2, false);
    }

    public final void drawLine(int n, int n2, boolean bl) {
        if (this.justFitCamera) {
            return;
        }
        this.checkRepaintWrapException();
        float f = this.cz[n];
        float f2 = this.cz[n2];
        if (f < f2 ? !((View3D)this.getView()).getCanvasCamera().projectLine(this.cx[n2], this.cy[n2], f2, this.cx[n], this.cy[n], f, this.lineStart, this.lineEnd) : !((View3D)this.getView()).getCanvasCamera().projectLine(this.cx[n], this.cy[n], f, this.cx[n2], this.cy[n2], f2, this.lineStart, this.lineEnd)) {
            return;
        }
        Color color = null;
        if (bl) {
            color = this.getColor();
            this.setColor(Color.white);
        }
        int n3 = this.lineStart.x;
        int n4 = this.lineStart.y;
        int n5 = this.lineEnd.x;
        int n6 = this.lineEnd.y;
        this.drawLine(n3, n4, n5, n6);
        if (bl) {
            this.setColor(color);
            int n7 = n5 - n3;
            int n8 = n6 - n4;
            int n9 = n7 * n7 + n8 * n8;
            if (n9 > 2) {
                float f3 = (float)(1.2 / Math.sqrt(n9));
                n7 = Math.round(f3 * (float)n7);
                n8 = Math.round(f3 * (float)n8);
                this.drawLine(n3 + n8, n4 - n7, n5 + n8, n6 - n7);
                this.drawLine(n3 - n8, n4 + n7, n5 - n8, n6 + n7);
            }
        }
    }

    private void drawLine(int n, int n2, int n3, int n4) {
        if (this.currentLayer == null) {
            this.bufferGraphics.drawLine(n, n2, n3, n4);
        } else {
            this.currentLayer.putInt(2, n, n2, n3, n4);
        }
    }

    private boolean getXY(int n) {
        if (n < 0) {
            this.retPoint.x = 0.0f;
            this.retPoint.y = 0.0f;
            return true;
        }
        return ((View3D)this.getView()).getCanvasCamera().projectView(this.cx[n], this.cy[n], this.cz[n], (Tuple2f)this.retPoint, true) == 1;
    }

    public final void drawString(int n, int n2, int n3, String string) {
        this.checkRepaintWrapException();
        if (this.getXY(n)) {
            if (this.currentLayer == null) {
                this.bufferGraphics.drawString(string, (int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3));
            } else {
                this.currentLayer.putInt(3, (int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3));
                this.currentLayer.putObject(string);
            }
        }
    }

    public final void drawRect(int n, int n2, int n3, int n4, int n5) {
        this.checkRepaintWrapException();
        if (this.getXY(n)) {
            if (this.currentLayer == null) {
                this.bufferGraphics.drawRect((int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3), n4, n5);
            } else {
                this.currentLayer.putInt(4, (int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3), n4, n5);
            }
        }
    }

    public final void fillRect(int n, int n2, int n3, int n4, int n5) {
        this.checkRepaintWrapException();
        if (this.getXY(n)) {
            if (this.currentLayer == null) {
                this.bufferGraphics.fillRect((int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3), n4, n5);
            } else {
                this.currentLayer.putInt(5, (int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3), n4, n5);
            }
        }
    }

    public final void drawPolygon(int n, Polygon polygon) {
        this.checkRepaintWrapException();
        if (this.getXY(n)) {
            if (this.currentLayer == null) {
                this.bufferGraphics.translate((int)this.retPoint.x, (int)this.retPoint.y);
                this.bufferGraphics.drawPolygon(polygon);
                this.bufferGraphics.translate(-((int)this.retPoint.x), -((int)this.retPoint.y));
            } else {
                this.currentLayer.putInt(6, (int)this.retPoint.x, (int)this.retPoint.y);
                this.currentLayer.putObject(polygon);
            }
        }
    }

    public final void fillPolygon(int n, Polygon polygon) {
        this.checkRepaintWrapException();
        if (this.getXY(n)) {
            if (this.currentLayer == null) {
                this.bufferGraphics.translate((int)this.retPoint.x, (int)this.retPoint.y);
                this.bufferGraphics.fillPolygon(polygon);
                this.bufferGraphics.translate(-((int)this.retPoint.x), -((int)this.retPoint.y));
            } else {
                this.currentLayer.putInt(7, (int)this.retPoint.x, (int)this.retPoint.y);
                this.currentLayer.putObject(polygon);
            }
        }
    }

    public final void drawIcon(int n, int n2, int n3, Icon icon) {
        this.checkRepaintWrapException();
        if (this.getXY(n)) {
            if (this.currentLayer == null) {
                icon.paintIcon(null, this.bufferGraphics, (int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3));
            } else {
                this.currentLayer.putInt(8, (int)(this.retPoint.x + (float)n2), (int)(this.retPoint.y + (float)n3));
                this.currentLayer.putObject(icon);
            }
        }
    }

    public final void openLayer(int n) {
        if (this.lsSize == this.layerStack.length) {
            this.layerStack = new Layer[this.lsSize + 10];
            System.arraycopy(this.layerStack, 0, this.layerStack, 0, this.lsSize);
        }
        this.layerStack[this.lsSize++] = this.currentLayer;
        if (n == -1) {
            n = this.layers.length;
        } else if (n >= this.layers.length) {
            n = this.layers.length - 1;
        }
        this.currentLayer = n == 0 ? null : this.layers[n - 1];
    }

    public final void closeLayer() {
        this.currentLayer = this.layerStack[--this.lsSize];
    }

    protected void drawOverlay(int n) {
        throw new Error("Unknown overlay code " + n);
    }

    private void ensureVertexSize(int n) {
        int n2 = this.cx.length;
        if (n2 < n) {
            n = n * 3 >> 1;
            this.cx = new float[n];
            System.arraycopy(this.cx, 0, this.cx, 0, n2);
            this.cy = new float[n];
            System.arraycopy(this.cy, 0, this.cy, 0, n2);
            this.cz = new float[n];
            System.arraycopy(this.cz, 0, this.cz, 0, n2);
        }
    }

    public final void setVertex(int n, Tuple3d tuple3d, Matrix4d matrix4d) {
        this.q0.set(tuple3d);
        matrix4d.transform(this.q0);
        this.setVertex(n, (float)this.q0.x, (float)this.q0.y, (float)this.q0.z);
    }

    public final void setVertex(int n, Tuple3f tuple3f, Matrix4d matrix4d) {
        this.q0f.set(tuple3f);
        matrix4d.transform(this.q0f);
        this.setVertex(n, this.q0f.x, this.q0f.y, this.q0f.z);
    }

    public final void setVertex(int n, Tuple3d tuple3d) {
        this.setVertex(n, (float)tuple3d.x, (float)tuple3d.y, (float)tuple3d.z);
    }

    public final void setVertex(int n, Tuple3f tuple3f) {
        this.setVertex(n, tuple3f.x, tuple3f.y, tuple3f.z);
    }

    public final void setVertex(int n, float f, float f2, float f3) {
        this.ensureVertexSize(n + 1);
        this.cx[n] = f;
        this.cy[n] = f2;
        this.cz[n] = f3;
        if (!this.computeMinMax) {
            return;
        }
        if (f < this.minX) {
            this.minX = f;
        } else if (f > this.maxX) {
            this.maxX = f;
        }
        if (f2 < this.minY) {
            this.minY = f2;
        } else if (f2 > this.maxY) {
            this.maxY = f2;
        }
        if (f3 < this.minZ) {
            this.minZ = f3;
        } else if (f3 > this.maxZ) {
            this.maxZ = f3;
        }
    }

    public final void setVertex(int n, double d, double d2, double d3, Matrix4d matrix4d) {
        this.q0.set(d, d2, d3);
        matrix4d.transform(this.q0);
        this.setVertex(n, (float)this.q0.x, (float)this.q0.y, (float)this.q0.z);
    }

    public Pool getPool() {
        return this.pool;
    }

    public Shader getCurrentShader() {
        return this.visitor.getCurrentShader();
    }

    public int getCurrentHighlight() {
        return this.visitor.selectionState;
    }

    public float estimateScaleAt(Tuple3f tuple3f) {
        return this.getView3D().estimateScaleAt(tuple3f, this.visitor.getCurrentTransformation());
    }

    public void drawPoint(Tuple3f tuple3f, int n, Tuple3f tuple3f2, int n2, Matrix4d matrix4d) {
        if (this.optionShowPoints) {
            if (n2 == -1) {
                n2 = this.visitor.selectionState;
            }
            if (matrix4d == null) {
                matrix4d = this.visitor.getCurrentTransformation();
            } else {
                Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
                matrix4d = this.xform;
            }
            if (tuple3f != null) {
                this.setVertex(0, tuple3f, matrix4d);
            } else {
                this.setVertex(0, (float)matrix4d.m03, (float)matrix4d.m13, (float)matrix4d.m23);
            }
            this.openLayer(1);
            this.setColor(tuple3f2, n2, true);
            this.fillRect(0, n / -2, n / -2, n + 1, n + 1);
            this.closeLayer();
        }
    }

    public void drawPointCloud(float[] fArray, float f, Tuple3f tuple3f, int n, Matrix4d matrix4d) {
        int n2 = fArray.length / 3;
        Point3f point3f = new Point3f();
        if (f <= 0.0f) {
            f = 3.0f;
        }
        for (int i = 0; i < n2; ++i) {
            point3f.set(fArray[3 * i + 0], fArray[3 * i + 1], fArray[3 * i + 2]);
            this.drawPoint((Tuple3f)point3f, Math.max((int)f, 1), tuple3f, -1, null);
        }
    }

    public void drawLine(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, int n, Matrix4d matrix4d) {
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        if (tuple3f != null) {
            this.setVertex(0, tuple3f, matrix4d);
            this.setVertex(1, tuple3f2, matrix4d);
        } else {
            this.setVertex(0, (float)matrix4d.m03, (float)matrix4d.m13, (float)matrix4d.m23);
            this.setVertex(1, tuple3f2, matrix4d);
        }
        this.setColor(tuple3f3, n, false);
        this.drawLine(0, 1, (n & 4) != 0);
    }

    public void drawPlane(Shader shader, int n, Matrix4d matrix4d) {
        int n2;
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        boolean bl = (n & 4) != 0;
        this.setColor(shader.getAverageColor(), n, false);
        int n3 = 10 * (this.getGlobalLOD() - View.LOD_MIN) / (View.LOD_MAX - View.LOD_MIN) + 1;
        Point3d point3d = this.pool.q3d0;
        Point3d point3d2 = this.pool.p3d1;
        Vector3d vector3d = this.pool.w3d0;
        Vector3d vector3d2 = this.pool.w3d1;
        float f = 1000.0f / this.getView3D().estimateScaleAt(0.0f, 0.0f, 0.0f, matrix4d);
        vector3d.x = matrix4d.m00 * (double)f;
        vector3d.y = matrix4d.m10 * (double)f;
        vector3d.z = matrix4d.m20 * (double)f;
        vector3d2.x = matrix4d.m01 * (double)f;
        vector3d2.y = matrix4d.m11 * (double)f;
        vector3d2.z = matrix4d.m21 * (double)f;
        point3d.x = matrix4d.m03 - 0.5 * (vector3d.x + vector3d2.x);
        point3d.y = matrix4d.m13 - 0.5 * (vector3d.y + vector3d2.y);
        point3d.z = matrix4d.m23 - 0.5 * (vector3d.z + vector3d2.z);
        int n4 = 0;
        f = 1.0f / (float)n3;
        boolean bl2 = this.computeMinMax;
        this.computeMinMax = false;
        for (n2 = 0; n2 <= n3; ++n2) {
            point3d2.scaleAdd((double)((float)n2 * f), (Tuple3d)vector3d, (Tuple3d)point3d);
            this.setVertex(n4++, (Tuple3d)point3d2);
            point3d2.add((Tuple3d)vector3d2);
            this.setVertex(n4, (Tuple3d)point3d2);
            this.drawLine(n4 - 1, n4++, bl);
        }
        for (n2 = 1; n2 < n3; ++n2) {
            point3d2.scaleAdd((double)((float)n2 * f), (Tuple3d)vector3d2, (Tuple3d)point3d);
            this.setVertex(n4++, (Tuple3d)point3d2);
            point3d2.add((Tuple3d)vector3d);
            this.setVertex(n4, (Tuple3d)point3d2);
            this.drawLine(n4 - 1, n4++, bl);
        }
        this.drawLine(0, 2 * n3, bl);
        this.drawLine(1, 2 * n3 + 1, bl);
        this.computeMinMax = bl2;
    }

    public void drawBox(float f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        boolean bl = (n & 4) != 0;
        this.setColor(shader.getAverageColor(), n, false);
        double d = 0.0;
        for (int i = 0; i <= 4; i += 4) {
            this.setVertex(i, -f, -f2, d, matrix4d);
            this.setVertex(i + 1, f, -f2, d, matrix4d);
            this.setVertex(i + 2, f, f2, d, matrix4d);
            this.setVertex(i + 3, -f, f2, d, matrix4d);
            for (int j = 0; j < 4; ++j) {
                this.drawLine(i + j, i + (j + 1 & 3), bl);
                if (i <= 0) continue;
                this.drawLine(j, i + j, bl);
            }
            d = f3;
        }
    }

    public void drawSphere(float f, Shader shader, int n, Matrix4d matrix4d) {
        int n2;
        int n3;
        int n4;
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        int n5 = this.getGlobalLOD();
        if (n5 <= View.LOD_MIN) {
            this.setColor(shader.getAverageColor());
            this.setVertex(0, 0.0, 0.0, 0.0, matrix4d);
            this.fillRect(0, 0, 0, 2, 2);
            return;
        }
        if (n5 <= View.LOD_MIN + 1) {
            n4 = 4;
        } else {
            n4 = ((int)(this.getView3D().estimateScaleAt(0.0f, 0.0f, 0.0f, matrix4d) * f) / 20 + 2) * 2;
            if (n5 >= View.LOD_MAX) {
                n4 *= 2;
            }
            if (n4 > 32) {
                n4 = 32;
            } else if (n4 < 4) {
                n4 = 4;
            }
        }
        double d = Math.PI * 2 / (double)n4;
        Point3d point3d = this.pool.q3d0;
        Vector3d vector3d = this.pool.w3d0;
        Vector3d vector3d2 = this.pool.w3d1;
        Vector3d vector3d3 = this.pool.w3d2;
        vector3d.set(0.0, 0.0, (double)f);
        Math2.getOrthogonal((Tuple3d)vector3d, (Tuple3d)vector3d2);
        double d2 = vector3d.length();
        vector3d2.scale(d2 / vector3d2.length());
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.scale(1.0 / d2);
        point3d.set(0.0, 0.0, 0.0);
        matrix4d.transform(vector3d);
        matrix4d.transform(vector3d2);
        matrix4d.transform(vector3d3);
        matrix4d.transform(point3d);
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            d2 = Math.cos((double)n3 * d);
            double d3 = Math.sin((double)n3 * d);
            double d4 = d2 * vector3d2.x + d3 * vector3d3.x;
            double d5 = d2 * vector3d2.y + d3 * vector3d3.y;
            double d6 = d2 * vector3d2.z + d3 * vector3d3.z;
            for (n2 = n4 / 2; n2 >= 0; --n2) {
                double d7 = Math.sin((double)n2 * d);
                double d8 = Math.cos((double)n2 * d);
                this.setVertex(n6++, (float)(point3d.x + d7 * d4 + d8 * vector3d.x), (float)(point3d.y + d7 * d5 + d8 * vector3d.y), (float)(point3d.z + d7 * d6 + d8 * vector3d.z));
            }
        }
        boolean bl = (n & 4) != 0;
        this.setColor(shader.getAverageColor(), n, false);
        n6 = 0;
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < n4 / 2; ++n2) {
                this.drawLine(n6, n6 + 1, bl);
                if (n2 > 0) {
                    if (n3 > 0) {
                        this.drawLine(n6, n6 + n4 / 2 + 1, bl);
                    } else {
                        this.drawLine(n6, n2, bl);
                    }
                }
                ++n6;
            }
            ++n6;
        }
    }

    private Vector3f genVertexSupershape(Vector3f vector3f, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float f13 = (float)(Math.pow(Math.abs(Math.cos((double)(f5 * f) / 4.0) / (double)f3), f7) + Math.pow(Math.abs(Math.sin((double)(f5 * f) / 4.0) / (double)f4), f8));
        float f14 = (float)(Math.pow(Math.abs(Math.cos((double)(f9 * f2) / 4.0) / (double)f3), f11) + Math.pow(Math.abs(Math.sin((double)(f9 * f2) / 4.0) / (double)f4), f12));
        float f15 = (float)Math.pow(Math.abs(f13), -1.0f / f6);
        float f16 = (float)Math.pow(Math.abs(f14), -1.0f / f10);
        float f17 = (float)((double)f15 * Math.cos(f) * (double)f16 * Math.cos(f2));
        float f18 = (float)((double)f15 * Math.sin(f) * (double)f16 * Math.cos(f2));
        float f19 = (float)((double)f16 * Math.sin(f2));
        vector3f.set(f17, f18, f19);
        return vector3f;
    }

    public void drawSupershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Shader shader, int n, Matrix4d matrix4d) {
        int n2;
        int n3;
        int n4;
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        int n5 = this.getGlobalLOD();
        float f11 = (f3 + f7) / 2.0f;
        int n6 = (int)(f11 + f11 * 3.0f * (float)n5);
        int n7 = 0;
        Vector3f vector3f = new Vector3f();
        Point3f point3f = new Point3f();
        for (n4 = 0; n4 < n6; ++n4) {
            float f12 = -Math2.M_PI + Math2.M_2PI * (float)n4 / (float)n6;
            for (n3 = 0; n3 <= n6; ++n3) {
                float f13 = -Math2.M_PI_2 + Math2.M_PI * (float)n3 / (float)n6;
                this.genVertexSupershape(vector3f, f12, f13, f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
                point3f.set((Tuple3f)vector3f);
                matrix4d.transform(point3f);
                this.setVertex(n7++, (Tuple3f)point3f);
            }
        }
        n4 = (n & 4) != 0 ? 1 : 0;
        this.setColor(shader.getAverageColor(), n, false);
        n3 = n6 + 1;
        n7 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            this.drawLine(n7++, n7, n4 != 0);
            this.drawLine((n6 - 1) * n3 + n2, n2, n4 != 0);
        }
        ++n7;
        for (n2 = 1; n2 < n6; ++n2) {
            int n8 = (n2 - 1) * (n6 + 1);
            for (int i = 0; i < n6; ++i) {
                this.drawLine(n7++, n7, n4 != 0);
                this.drawLine(n8 + i, n8 + n3 + i, n4 != 0);
            }
            ++n7;
        }
    }

    public void drawFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Shader shader, int n, Matrix4d matrix4d) {
        int n2;
        int n3;
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        int n4 = this.getGlobalLOD();
        if (n4 <= View.LOD_MIN || Math.abs(f2) + Math.abs(f3) < this.getView().getEpsilon()) {
            this.setColor(shader.getAverageColor());
            this.setVertex(0, 0.0, 0.0, 0.0, matrix4d);
            this.setVertex(1, 0.0, 0.0, f, matrix4d);
            this.drawLine(0, 1, false);
            return;
        }
        if (n4 <= View.LOD_MIN + 1) {
            n3 = 4;
        } else {
            n3 = ((int)(this.getView3D().estimateScaleAt(0.0f, 0.0f, 0.0f, matrix4d) * Math.max(Math.max(f2, f3), Math.abs(f))) / 20 + 2) * 2;
            if (n4 >= View.LOD_MAX) {
                n3 *= 2;
            }
            if (n3 > 16) {
                n3 = 16;
            } else if (n3 < 4) {
                n3 = 4;
            }
        }
        double d = Math.PI * 2 / (double)n3;
        Point3d point3d = this.pool.q3d0;
        Vector3d vector3d = this.pool.w3d0;
        Vector3d vector3d2 = this.pool.w3d1;
        Vector3d vector3d3 = this.pool.w3d2;
        point3d.set(0.0, 0.0, 0.0);
        vector3d.set(0.0, 0.0, (double)f);
        Math2.getOrthogonal((Tuple3d)vector3d, (Tuple3d)vector3d2);
        vector3d2.normalize();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        matrix4d.transform(vector3d);
        matrix4d.transform(vector3d2);
        matrix4d.transform(vector3d3);
        matrix4d.transform(point3d);
        vector3d.add((Tuple3d)point3d);
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            double d2 = Math.cos((double)n2 * d);
            double d3 = Math.sin((double)n2 * d);
            double d4 = d2 * vector3d2.x + d3 * vector3d3.x;
            double d5 = d2 * vector3d2.y + d3 * vector3d3.y;
            double d6 = d2 * vector3d2.z + d3 * vector3d3.z;
            this.setVertex(n5++, (float)(point3d.x + (double)f2 * d4), (float)(point3d.y + (double)f2 * d5), (float)(point3d.z + (double)f2 * d6));
            this.setVertex(n5++, (float)(vector3d.x + (double)f3 * d4), (float)(vector3d.y + (double)f3 * d5), (float)(vector3d.z + (double)f3 * d6));
        }
        boolean bl3 = (n & 4) != 0;
        this.setColor(shader.getAverageColor(), n, false);
        if (bl) {
            for (n2 = 0; n2 < n3; n2 += 2) {
                this.drawLine(n2, n2 + n3, bl3);
            }
        }
        if (bl2) {
            for (n2 = 1; n2 < n3; n2 += 2) {
                this.drawLine(n2, n2 + n3, bl3);
            }
        }
        n3 = 2 * n3 - 2;
        for (n2 = 0; n2 < n3; n2 += 2) {
            this.drawLine(n2, n2 + 1, bl3);
            this.drawLine(n2, n2 + 2, bl3);
            this.drawLine(n2 + 1, n2 + 3, bl3);
        }
        this.drawLine(n3, n3 + 1, bl3);
        this.drawLine(n3, 0, bl3);
        this.drawLine(n3 + 1, 1, bl3);
    }

    public void drawParallelogram(float f, Vector3f vector3f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        int n2;
        float f4;
        int n3;
        int n4;
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        boolean bl = (n & 4) != 0;
        this.setColor(shader.getAverageColor(), n, false);
        int n5 = this.getGlobalLOD();
        if (n5 <= View.LOD_MIN + 1) {
            n4 = 1;
            n3 = 1;
        } else {
            f4 = this.getView3D().estimateScaleAt(0.0f, 0.0f, 0.0f, matrix4d);
            n4 = ((int)(f4 * Math.abs(f)) >> 7) + 1;
            n3 = ((int)(f4 * vector3f.length()) >> 7) + 1;
            if (n5 >= View.LOD_MAX) {
                n4 *= 2;
                n3 *= 2;
            }
            if (n4 > 8) {
                n4 = 8;
            }
            if (n3 > 8) {
                n3 = 8;
            }
        }
        Point3d point3d = this.pool.q3d0;
        Point3d point3d2 = this.pool.p3d1;
        Vector3d vector3d = this.pool.w3d0;
        Vector3d vector3d2 = this.pool.w3d1;
        point3d.set(0.0, 0.0, 0.0);
        matrix4d.transform(point3d);
        vector3d.set((Tuple3f)vector3f);
        matrix4d.transform(vector3d);
        vector3d2.set(0.0, 0.0, (double)f);
        matrix4d.transform(vector3d2);
        int n6 = 0;
        f4 = 1.0f / (float)n4;
        for (n2 = -n4; n2 <= n4; ++n2) {
            point3d2.scaleAdd((double)((float)n2 * f4), (Tuple3d)vector3d, (Tuple3d)point3d);
            this.setVertex(n6++, (Tuple3d)point3d2);
            point3d2.add((Tuple3d)vector3d2);
            this.setVertex(n6, (Tuple3d)point3d2);
            this.drawLine(n6 - 1, n6++, bl);
        }
        f4 = 1.0f / (float)(n3 <<= 1);
        for (n2 = 1; n2 < n3; ++n2) {
            point3d2.scaleAdd((double)((float)n2 * f4), (Tuple3d)vector3d2, (Tuple3d)point3d);
            point3d2.sub((Tuple3d)vector3d);
            this.setVertex(n6++, (Tuple3d)point3d2);
            point3d2.scaleAdd(2.0, (Tuple3d)vector3d, (Tuple3d)point3d2);
            this.setVertex(n6, (Tuple3d)point3d2);
            this.drawLine(n6 - 1, n6++, bl);
        }
        this.drawLine(0, 4 * n4, bl);
        this.drawLine(1, 4 * n4 + 1, bl);
    }

    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        int n2;
        if (this.polyCache != null && this.polyCache.getGraphState() != this.getRenderGraphState()) {
            this.polyCache.clear();
            this.polyCache = null;
        }
        if (this.polyCache == null) {
            this.polyCache = new PolygonizationCache(this.getRenderGraphState(), 0, 100.0f, false);
        }
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        PolygonArray polygonArray = this.polyCache.get(object, bl, polygonizable);
        boolean bl2 = (n & 4) != 0;
        this.setColor(shader.getAverageColor(), n, false);
        float[] fArray = polygonArray.vertices.elements;
        int n3 = polygonArray.dimension;
        for (int i = polygonArray.vertices.size / n3 - 1; i >= 0; --i) {
            n2 = i * n3;
            this.setVertex(i, fArray[n2], n3 > 1 ? (double)fArray[n2 + 1] : 0.0, n3 > 2 ? (double)fArray[n2 + 2] : 0.0, matrix4d);
        }
        if (this.justFitCamera) {
            return;
        }
        int[] nArray = polygonArray.polygons.elements;
        n2 = polygonArray.polygons.size;
        int n4 = -1;
        while (++n4 < n2) {
            int n5;
            int n6 = n5 = nArray[n4];
            for (int i = polygonArray.edgeCount; i > 1; --i) {
                int n7 = n6;
                n6 = nArray[++n4];
                this.drawLine(n7, n6, bl2);
            }
            this.drawLine(n6, n5, bl2);
        }
    }

    void drawNURBSUniformly(NURBSSurface nURBSSurface, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        int n2;
        if (shader == null) {
            shader = this.visitor.getCurrentShader();
        }
        if (n == -1) {
            n = this.visitor.selectionState;
        }
        if (matrix4d == null) {
            matrix4d = this.visitor.getCurrentTransformation();
        } else {
            Math2.mulAffine((Matrix4d)this.xform, (Matrix4d)this.visitor.getCurrentTransformation(), (Matrix4d)matrix4d);
            matrix4d = this.xform;
        }
        boolean bl2 = (n & 4) != 0;
        this.setColor(shader.getAverageColor(), n, false);
        int n3 = this.getGlobalLOD();
        n3 = n3 <= View.LOD_MIN ? 4 : (n3 <= View.LOD_MIN + 1 ? 2 : 1);
        Color color = this.bufferGraphics.getColor();
        if ((float)color.getGreen() > 1.2f * (float)Math.max(color.getRed(), color.getBlue())) {
            n2 = 8;
            if (this.antialiasing) {
                ((Graphics2D)this.bufferGraphics).setStroke(new BasicStroke(3.0f * this.lineWidth));
            }
        } else {
            n2 = 3;
        }
        GraphState graphState = this.getRenderGraphState();
        graphState.setObjectContext((Object)nURBSSurface, bl);
        int n4 = Math.max(Math.round(3.0f / ((float)n3 * nURBSSurface.getFlatness())), 2);
        int n5 = Math.max(Math.round((float)n2 / ((float)n3 * nURBSSurface.getFlatness())), 2);
        BSplineSurface bSplineSurface = nURBSSurface.getSurface();
        if (!BSpline.isValid((BSplineSurface)bSplineSurface, (GraphState)graphState)) {
            return;
        }
        float f = bSplineSurface.getKnot(0, bSplineSurface.getUDegree(graphState), graphState);
        float f2 = (bSplineSurface.getKnot(0, bSplineSurface.getUSize(graphState), graphState) - f) / (float)n4;
        float f3 = bSplineSurface.getKnot(1, bSplineSurface.getVDegree(graphState), graphState);
        float f4 = (bSplineSurface.getKnot(1, bSplineSurface.getVSize(graphState), graphState) - f3) / (float)n5;
        int n6 = bSplineSurface.getDimension(graphState);
        float[] fArray = this.pool.getFloatArray(0, n6);
        int n7 = bSplineSurface.isRational(graphState) ? n6 - 1 : -1;
        int n8 = 0;
        for (int i = 0; i <= n4; ++i) {
            int n9;
            int n10 = n8;
            n8 = (i & 1) * (n5 + 1);
            for (n9 = 0; n9 <= n5; ++n9) {
                BSpline.evaluate((float[])fArray, (BSplineSurface)bSplineSurface, (float)(f + (float)i * f2), (float)(f3 + (float)n9 * f4), (GraphState)graphState);
                if (n7 > 0) {
                    float f5 = 1.0f / fArray[n7];
                    fArray[n7] = 0.0f;
                    this.setVertex(n8 + n9, f5 * fArray[0], f5 * fArray[1], f5 * fArray[2], matrix4d);
                    continue;
                }
                this.setVertex(n8 + n9, fArray[0], fArray[1], fArray[2], matrix4d);
            }
            for (n9 = 0; n9 <= n5; ++n9) {
                int n11 = n8 + n9;
                if (i > 0) {
                    this.drawLine(n11, n10 + n9, bl2);
                }
                if (n9 <= 0) continue;
                this.drawLine(n11, n11 - 1, bl2);
            }
        }
        if (this.antialiasing) {
            ((Graphics2D)this.bufferGraphics).setStroke(new BasicStroke(this.lineWidth));
        }
    }

    public boolean getWindowPos(Tuple3f tuple3f, Tuple2f tuple2f) {
        Matrix4d matrix4d = this.visitor.getCurrentTransformation();
        return this.getView3D().getCanvasCamera().projectView((float)((double)tuple3f.x * matrix4d.m00 + (double)tuple3f.y * matrix4d.m01 + (double)tuple3f.z * matrix4d.m02 + matrix4d.m03), (float)((double)tuple3f.x * matrix4d.m10 + (double)tuple3f.y * matrix4d.m11 + (double)tuple3f.z * matrix4d.m12 + matrix4d.m13), (float)((double)tuple3f.x * matrix4d.m20 + (double)tuple3f.y * matrix4d.m21 + (double)tuple3f.z * matrix4d.m22 + matrix4d.m23), tuple2f, true) == 1;
    }

    public void drawRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        this.openLayer(1);
        this.setColor(tuple3f);
        this.drawRect(-1, n, n2, n3, n4);
        this.closeLayer();
    }

    public void fillRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        this.openLayer(1);
        this.setColor(tuple3f);
        this.fillRect(-1, n, n2, n3, n4);
        this.closeLayer();
    }

    public void drawString(int n, int n2, String string, Font font, Tuple3f tuple3f) {
        this.openLayer(1);
        this.setColor(tuple3f);
        this.setFont(font);
        this.drawString(-1, n, n2, string);
        this.closeLayer();
    }

    protected void optionValueChanged(String string, Object object) {
        if (OPTION_NAME_SHOW_POINTS.equals(string)) {
            this.optionShowPoints = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if ("lineWidth".equals(string)) {
            this.lineWidth = ((Number)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_GRID.equals(string)) {
            this.optionShowGrid = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_GRID_DIMENSION.equals(string)) {
            this.optionGridDimension = (Integer)object;
            this.repaint(7);
        } else if (OPTION_NAME_GRID_SPACING.equals(string)) {
            this.optionGridSpacing = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_GRID_COLOR_R.equals(string)) {
            this.optionGridColorR = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_GRID_COLOR_G.equals(string)) {
            this.optionGridColorG = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_GRID_COLOR_B.equals(string)) {
            this.optionGridColorB = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_COLOR_R.equals(string)) {
            this.optionBackgroundColorR = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_COLOR_G.equals(string)) {
            this.optionBackgroundColorG = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_COLOR_B.equals(string)) {
            this.optionBackgroundColorB = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_BACKGROUND_ALPHA.equals(string)) {
            this.optionBackgroundAlpha = ((Float)object).floatValue();
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_AXES.equals(string)) {
            this.optionShowAxes = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_AXES_NAMES.equals(string)) {
            this.optionShowAxesNames = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else if (OPTION_NAME_SHOW_DISPLAY_SIZE.equals(string)) {
            this.optionShowDisplaySize = Boolean.TRUE.equals(object);
            this.repaint(7);
        } else {
            super.optionValueChanged(string, object);
        }
    }

    private void drawGrid() {
        Color3f color3f = new Color3f(this.optionGridColorR, this.optionGridColorG, this.optionGridColorB);
        float f = (float)this.optionGridDimension * this.optionGridSpacing;
        for (float f2 = -f; f2 <= f; f2 += this.optionGridSpacing) {
            for (float f3 = -f; f3 <= f; f3 += this.optionGridSpacing) {
                this.drawLine((Tuple3f)new Point3f(f2, f3, 0.0f), (Tuple3f)new Point3f(-f2, f3, 0.0f), (Tuple3f)color3f, 0, null);
                this.drawLine((Tuple3f)new Point3f(f2, f3, 0.0f), (Tuple3f)new Point3f(f2, -f3, 0.0f), (Tuple3f)color3f, 0, null);
            }
        }
    }

    private void drawAxes() {
        Color3f color3f = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f color3f2 = new Color3f(0.0f, 1.0f, 0.0f);
        Color3f color3f3 = new Color3f(0.0f, 0.0f, 1.0f);
        Matrix4d matrix4d = new Matrix4d();
        Camera camera = ((View3D)this.getView()).getCamera();
        matrix4d = camera.getWorldToViewTransformation();
        AxisAngle4d axisAngle4d = new AxisAngle4d();
        axisAngle4d.set(matrix4d);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        matrix4d2.set(axisAngle4d);
        int n = 50;
        this.setColor((Tuple3f)color3f, 0, false);
        double[] dArray = new double[]{25.0, 0.0, 0.0};
        double[] dArray2 = new double[]{matrix4d2.m00 * dArray[0] + matrix4d2.m01 * dArray[1] + matrix4d2.m02 * dArray[2], matrix4d2.m10 * dArray[0] + matrix4d2.m11 * dArray[1] + matrix4d2.m12 * dArray[2], matrix4d2.m20 * dArray[0] + matrix4d2.m21 * dArray[1] + matrix4d2.m22 * dArray[2]};
        this.drawLine(n, n, n + (int)dArray2[0], n - (int)dArray2[1]);
        this.setColor((Tuple3f)color3f3, 0, false);
        double[] dArray3 = new double[]{0.0, 25.0, 0.0};
        double[] dArray4 = new double[]{matrix4d2.m00 * dArray3[0] + matrix4d2.m01 * dArray3[1] + matrix4d2.m02 * dArray3[2], matrix4d2.m10 * dArray3[0] + matrix4d2.m11 * dArray3[1] + matrix4d2.m12 * dArray3[2], matrix4d2.m20 * dArray3[0] + matrix4d2.m21 * dArray3[1] + matrix4d2.m22 * dArray3[2]};
        this.drawLine(n, n, n + (int)dArray4[0], n - (int)dArray4[1]);
        this.setColor((Tuple3f)color3f2, 0, false);
        double[] dArray5 = new double[]{0.0, 0.0, 25.0};
        double[] dArray6 = new double[]{matrix4d2.m00 * dArray5[0] + matrix4d2.m01 * dArray5[1] + matrix4d2.m02 * dArray5[2], matrix4d2.m10 * dArray5[0] + matrix4d2.m11 * dArray5[1] + matrix4d2.m12 * dArray5[2], matrix4d2.m20 * dArray5[0] + matrix4d2.m21 * dArray5[1] + matrix4d2.m22 * dArray5[2]};
        this.drawLine(n, n, n + (int)dArray6[0], n - (int)dArray6[1]);
        if (this.optionShowAxesNames) {
            double[] dArray7 = new double[]{31.0, 0.0, 0.0};
            double[] dArray8 = new double[]{matrix4d2.m00 * dArray7[0] + matrix4d2.m01 * dArray7[1] + matrix4d2.m02 * dArray7[2], matrix4d2.m10 * dArray7[0] + matrix4d2.m11 * dArray7[1] + matrix4d2.m12 * dArray7[2], matrix4d2.m20 * dArray7[0] + matrix4d2.m21 * dArray7[1] + matrix4d2.m22 * dArray7[2]};
            Font font = FontAdapter.getFont(null);
            this.drawString(n + (int)dArray8[0] - 3, n - (int)dArray8[1] + 4, "x", font, (Tuple3f)color3f);
            double[] dArray9 = new double[]{0.0, 31.0, 0.0};
            double[] dArray10 = new double[]{matrix4d2.m00 * dArray9[0] + matrix4d2.m01 * dArray9[1] + matrix4d2.m02 * dArray9[2], matrix4d2.m10 * dArray9[0] + matrix4d2.m11 * dArray9[1] + matrix4d2.m12 * dArray9[2], matrix4d2.m20 * dArray9[0] + matrix4d2.m21 * dArray9[1] + matrix4d2.m22 * dArray9[2]};
            this.drawString(n + (int)dArray10[0] - 3, n - (int)dArray10[1] + 4, "y", font, (Tuple3f)color3f3);
            double[] dArray11 = new double[]{0.0, 0.0, 31.0};
            double[] dArray12 = new double[]{matrix4d2.m00 * dArray11[0] + matrix4d2.m01 * dArray11[1] + matrix4d2.m02 * dArray11[2], matrix4d2.m10 * dArray11[0] + matrix4d2.m11 * dArray11[1] + matrix4d2.m12 * dArray11[2], matrix4d2.m20 * dArray11[0] + matrix4d2.m21 * dArray11[1] + matrix4d2.m22 * dArray11[2]};
            this.drawString(n + (int)dArray12[0] - 3, n - (int)dArray12[1] + 4, "z", font, (Tuple3f)color3f2);
        }
    }

    private void drawDisplaySize() {
        Component component = (Component)this.getComponent();
        int n = component.getWidth();
        int n2 = component.getHeight();
        Color3f color3f = new Color3f(0.0f, 0.0f, 0.0f);
        Font font = FontAdapter.getFont(null);
        this.drawString(5, 15, n + " x " + n2, font, (Tuple3f)color3f);
    }

    private class Layer {
        private int[] intFifo = new int[100];
        private Object[] objFifo = new Object[20];
        private int intHead;
        private int intTail;
        private int objHead;
        private int objTail;
        Color color;
        private Font font;

        Layer() {
            this.reset();
        }

        void putInt(int n) {
            if (this.intHead == this.intFifo.length) {
                this.intFifo = new int[this.intHead + 50];
                System.arraycopy(this.intFifo, 0, this.intFifo, 0, this.intHead);
            }
            this.intFifo[this.intHead++] = n;
        }

        void putInt(int n, int n2, int n3) {
            if (this.intHead + 3 > this.intFifo.length) {
                this.intFifo = new int[this.intHead + 50];
                System.arraycopy(this.intFifo, 0, this.intFifo, 0, this.intHead);
            }
            this.intFifo[this.intHead++] = n;
            this.intFifo[this.intHead++] = n2;
            this.intFifo[this.intHead++] = n3;
        }

        void putInt(int n, int n2, int n3, int n4, int n5) {
            if (this.intHead + 5 > this.intFifo.length) {
                this.intFifo = new int[this.intHead + 50];
                System.arraycopy(this.intFifo, 0, this.intFifo, 0, this.intHead);
            }
            this.intFifo[this.intHead++] = n;
            this.intFifo[this.intHead++] = n2;
            this.intFifo[this.intHead++] = n3;
            this.intFifo[this.intHead++] = n4;
            this.intFifo[this.intHead++] = n5;
        }

        int getInt() {
            return this.intFifo[this.intTail++];
        }

        void putObject(Object object) {
            if (this.objHead == this.objFifo.length) {
                this.objFifo = new Object[this.objHead + 50];
                System.arraycopy(this.objFifo, 0, this.objFifo, 0, this.objHead);
            }
            this.objFifo[this.objHead++] = object;
        }

        Object getObject() {
            return this.objFifo[this.objTail++];
        }

        void setColor(Color color) {
            if (this.color != color) {
                this.color = color;
                this.putInt(0);
                this.putObject(color);
            }
        }

        void setFont(Font font) {
            if (this.font != font) {
                this.font = font;
                this.putInt(1);
                this.putObject(font);
            }
        }

        void reset() {
            this.intHead = 0;
            this.intTail = 0;
            this.objHead = 0;
            this.objTail = 0;
            this.color = null;
            this.font = null;
            for (int i = 0; i < this.objFifo.length; ++i) {
                this.objFifo[i] = null;
            }
        }

        void draw(Graphics graphics) {
            block11: while (this.intTail < this.intHead) {
                int n = this.getInt();
                switch (n) {
                    case 0: {
                        graphics.setColor((Color)this.getObject());
                        continue block11;
                    }
                    case 1: {
                        graphics.setFont((Font)this.getObject());
                        continue block11;
                    }
                    case 2: {
                        graphics.drawLine(this.getInt(), this.getInt(), this.getInt(), this.getInt());
                        continue block11;
                    }
                    case 3: {
                        graphics.drawString((String)this.getObject(), this.getInt(), this.getInt());
                        continue block11;
                    }
                    case 4: {
                        graphics.drawRect(this.getInt(), this.getInt(), this.getInt(), this.getInt());
                        continue block11;
                    }
                    case 5: {
                        graphics.fillRect(this.getInt(), this.getInt(), this.getInt(), this.getInt());
                        continue block11;
                    }
                    case 6: {
                        int n2 = this.getInt();
                        int n3 = this.getInt();
                        graphics.translate(n2, n3);
                        graphics.drawPolygon((Polygon)this.getObject());
                        graphics.translate(-n2, -n3);
                        continue block11;
                    }
                    case 7: {
                        int n2 = this.getInt();
                        int n3 = this.getInt();
                        graphics.translate(n2, n3);
                        graphics.fillPolygon((Polygon)this.getObject());
                        graphics.translate(-n2, -n3);
                        continue block11;
                    }
                    case 8: {
                        ((Icon)this.getObject()).paintIcon(null, graphics, this.getInt(), this.getInt());
                        continue block11;
                    }
                }
                WireframeCanvas.this.drawOverlay(n);
            }
        }
    }

    private class WFVisitor
    extends DisplayVisitor {
        private int selectionState;
        private int minPathLength;
        private LineSegmentizationCache lineCache;

        private WFVisitor() {
        }

        void init(GraphState graphState, int n, int n2, boolean bl) {
            this.init(graphState, ((View3D)WireframeCanvas.this.getView()).getCanvasCamera().getWorldToViewTransformation(), WireframeCanvas.this.getView3D(), bl);
            this.selectionState = n;
            this.minPathLength = n2;
            if (this.lineCache == null) {
                this.lineCache = new LineSegmentizationCache(graphState, 1.0f);
            }
        }

        private void setColor(Object object, boolean bl, Shader shader, GraphState graphState) {
            if (WireframeCanvas.this.justFitCamera) {
                return;
            }
            Object object2 = graphState.getObjectDefault(object, bl, Attributes.COLOR, (Object)this);
            if (object2 != null && object2 != this) {
                WireframeCanvas.this.setColor((Tuple3f)((Color3f)object2), this.selectionState, false);
            } else {
                WireframeCanvas.this.setColor(shader.getAverageColor(), this.selectionState, false);
            }
        }

        protected void visitImpl(Object object, boolean bl, Shader shader, Path path) {
            Object object2;
            if (path.getNodeAndEdgeCount() - (bl ? 0 : 1) >= this.minPathLength && (object2 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null)) != null) {
                if (object2 instanceof Renderable) {
                    ((Renderable)object2).draw(object, bl, WireframeCanvas.this);
                } else if (object2 instanceof LineSegmentizable) {
                    LineArray lineArray = this.lineCache.get(object, bl, (LineSegmentizable)object2);
                    boolean bl2 = (this.selectionState & 4) != 0;
                    this.setColor(object, bl, shader, this.state);
                    int[] nArray = lineArray.lines.elements;
                    float[] fArray = lineArray.vertices.elements;
                    int n = lineArray.dimension;
                    int n2 = lineArray.lines.size;
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 < n2) {
                        int n5;
                        if ((n5 = nArray[n3++]) >= 0) {
                            WireframeCanvas.this.setVertex(n4 & 1, fArray[n5 *= n], n > 1 ? (double)fArray[n5 + 1] : 0.0, n > 2 ? (double)fArray[n5 + 2] : 0.0, this.transformation);
                            if (++n4 < 2) continue;
                            WireframeCanvas.this.drawLine(0, 1, bl2);
                            continue;
                        }
                        n4 = 0;
                    }
                }
            }
        }
    }
}

