/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.edit;

import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.edit.ToolRoot;
import de.grogra.imp3d.CameraBase;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.objects.Transformation;
import de.grogra.util.EventListener;
import de.grogra.vecmath.Math2;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;

public abstract class ToolRoot3D
extends ToolRoot
implements Transformation,
EventListener {
    private Matrix4d parentTransformation = new Matrix4d();
    private Matrix4d targetTransformation = new Matrix4d();
    private Matrix4d toolTransformation = new Matrix4d();
    private Matrix4d toolAdjust = new Matrix4d();
    private boolean valid = false;
    public static final Node.NType $TYPE = new Node.NType(ToolRoot3D.class);

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.TRANSFORMATION);
    }

    protected boolean initialize(Tool tool) {
        boolean bl = super.initialize(tool);
        if (bl) {
            tool.getView().addEventListener((EventListener)this);
        }
        return bl;
    }

    public void dispose() {
        this.tool.getView().removeEventListener((EventListener)this);
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof PropertyChangeEvent && eventObject.getSource() == this.tool.getView() && "camera".equals(((PropertyChangeEvent)eventObject).getPropertyName())) {
            this.invalidate();
        }
    }

    protected void attributeChanged(Attribute[] attributeArray) {
        if (GlobalTransformation.ATTRIBUTE.isContained(attributeArray)) {
            this.invalidate();
        }
    }

    public void preTransform(Object object, boolean bl, Matrix4d matrix4d, Matrix4d matrix4d2, GraphState graphState) {
        Math2.mulAffine((Matrix4d)matrix4d2, (Matrix4d)matrix4d, (Matrix4d)this.getToolTransformation());
    }

    public void postTransform(Object object, boolean bl, Matrix4d matrix4d, Matrix4d matrix4d2, Matrix4d matrix4d3, GraphState graphState) {
        matrix4d2.set(matrix4d);
    }

    protected final Matrix4d getParentTransformation() {
        this.validate();
        return this.parentTransformation;
    }

    protected final Matrix4d getTargetTransformation() {
        this.validate();
        return this.targetTransformation;
    }

    protected final Matrix4d getToolTransformation() {
        this.validate();
        return this.toolTransformation;
    }

    protected final Matrix4d getAdjustment() {
        this.validate();
        return this.toolAdjust;
    }

    private void invalidate() {
        this.valid = false;
    }

    private void validate() {
        if (this.valid) {
            return;
        }
        GlobalTransformation.get(this.getToolTarget(), this.isTargetNode(), this.tool.getGraphState(), true);
        GlobalTransformation.getParentValue(this.getToolTarget(), this.isTargetNode(), this.tool.getGraphState(), true).get(this.parentTransformation);
        this.computeTargetTransformation(this.targetTransformation, this.parentTransformation);
        this.toolTransformation.set(this.targetTransformation);
        this.adjustToolTransformation(this.toolTransformation, ((View3D)this.tool.getView()).getCanvasCamera());
        Math2.makeAffine((Matrix4d)this.toolAdjust);
        Math2.invertAffine((Matrix4d)this.targetTransformation, (Matrix4d)this.toolAdjust);
        Math2.mulAffine((Matrix4d)this.toolAdjust, (Matrix4d)this.toolAdjust, (Matrix4d)this.toolTransformation);
        this.valid = true;
    }

    protected abstract void computeTargetTransformation(Matrix4d var1, Matrix4d var2);

    protected void adjustToolTransformation(Matrix4d matrix4d, CameraBase cameraBase) {
    }

    protected static final void adjustScale(Matrix4d matrix4d, CameraBase cameraBase, float f) {
        Matrix3d matrix3d = new Matrix3d();
        Matrix3d matrix3d2 = new Matrix3d();
        matrix4d.getRotationScale(matrix3d);
        Math2.decomposeQR((Matrix3d)matrix3d, (Matrix3d)matrix3d2);
        matrix3d.set((double)(f / cameraBase.getScaleAt(matrix4d.m03, matrix4d.m13, matrix4d.m23)));
        matrix3d2.mul(matrix3d);
        matrix4d.setRotationScale(matrix3d2);
    }

    static {
        ToolRoot3D.initType();
        $TYPE.validate();
    }
}

