/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.graph.GraphState;
import de.grogra.graph.Path;
import de.grogra.graph.impl.Node;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp3d.DisplayVisitor;
import de.grogra.imp3d.LineArray;
import de.grogra.imp3d.LineSegmentizable;
import de.grogra.imp3d.LineSegmentizationCache;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.Renderable;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.gl20.GL20Const;
import de.grogra.imp3d.gl20.GL20GfxServer;
import de.grogra.imp3d.gl20.GL20Node;
import de.grogra.imp3d.gl20.GL20Resource;
import de.grogra.imp3d.gl20.GL20ResourceShapeBox;
import de.grogra.imp3d.gl20.GL20ResourceShapeFrustum;
import de.grogra.imp3d.gl20.GL20ResourceShapeLine;
import de.grogra.imp3d.gl20.GL20ResourceShapeLineStrip;
import de.grogra.imp3d.gl20.GL20ResourceShapeParallelogram;
import de.grogra.imp3d.gl20.GL20ResourceShapePlane;
import de.grogra.imp3d.gl20.GL20ResourceShapePolygons;
import de.grogra.imp3d.gl20.GL20ResourceShapeSphere;
import de.grogra.imp3d.gl20.GL20ShaderServer;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.Pool;
import de.grogra.math.TMatrix4d;
import de.grogra.pf.ui.Context;
import de.grogra.vecmath.Math2;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class GL20DisplayVisitor
extends DisplayVisitor
implements RenderState {
    private PolygonizationCache polygonizationCache;
    private LineSegmentizationCache lineSegmentizationCache = null;
    private final Pool pool = new Pool();
    private GL20Node rootNode = null;
    private GL20GfxServer gfxServer = null;
    private ViewSelection viewSelection = null;
    private GL20Node currentNode = null;
    private boolean toolTravel;
    private int lastContextID = -1;

    public void initialize(GraphState graphState, View3D view3D, boolean bl) {
        this.init(graphState, GL20Const.identityMatrix4d, view3D, true);
        this.toolTravel = bl;
        if (this.rootNode == null) {
            this.rootNode = new GL20Node(0L);
        }
        if (!this.toolTravel) {
            GL20Node.startNewVisit(this.rootNode);
            this.viewSelection = ViewSelection.get((Context)view3D);
        }
        this.gfxServer = GL20GfxServer.getInstance();
        if (this.lastContextID != this.gfxServer.getContextID()) {
            if (this.polygonizationCache != null) {
                this.polygonizationCache.clear();
                this.polygonizationCache = null;
            }
            this.lastContextID = this.gfxServer.getContextID();
        }
    }

    protected void visitEnterImpl(Object object, boolean bl, Path path) {
        if (!this.toolTravel && bl) {
            GL20Node.enterNode(((Node)object).getId());
        }
        super.visitEnterImpl(object, bl, path);
    }

    protected void visitLeaveImpl(Object object, boolean bl, Path path) {
        ArrayList<GL20Node> arrayList;
        if (!this.toolTravel && bl && (arrayList = GL20Node.leaveNode()) != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                GL20Node gL20Node = arrayList.get(i);
                GL20Resource gL20Resource = gL20Node.getResource();
                if (gL20Resource == null) continue;
                gL20Resource.destroy();
            }
        }
        super.visitLeaveImpl(object, bl, path);
    }

    protected void visitImpl(Object object, boolean bl, Shader shader, Path path) {
        if (bl) {
            GL20Node gL20Node = this.toolTravel ? null : GL20Node.getCurrentNode();
            Object object2 = this.toolTravel ? null : this.state.getObjectDefault(object, bl, Attributes.LIGHT, null);
            Object object3 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null);
            if (!this.toolTravel && object3 != null || object2 != null) {
                gL20Node.setSelectionState(this.viewSelection.get(object, bl));
            }
            if (this.toolTravel || !gL20Node.isUpToDate(((Node)object).getStamp())) {
                if (!this.toolTravel) {
                    this.setCurrentNode(gL20Node);
                }
                if (object3 != null) {
                    if (object3 instanceof Renderable) {
                        if (this.toolTravel) {
                            gL20Node = new GL20Node(0L);
                            this.setCurrentNode(gL20Node);
                        }
                        ((Renderable)object3).draw(object, bl, this);
                    } else if (object3 instanceof LineSegmentizable) {
                        if (this.toolTravel) {
                            gL20Node = new GL20Node(0L);
                        }
                        GL20ResourceShapeLineStrip gL20ResourceShapeLineStrip = (GL20ResourceShapeLineStrip)gL20Node.createResource(65540);
                        if (this.lineSegmentizationCache != null && this.lineSegmentizationCache.getGraphState() != this.getRenderGraphState()) {
                            this.lineSegmentizationCache.clear();
                            this.lineSegmentizationCache = null;
                        }
                        if (this.lineSegmentizationCache == null) {
                            this.lineSegmentizationCache = new LineSegmentizationCache(this.getRenderGraphState(), 1.0f);
                        }
                        LineArray lineArray = this.lineSegmentizationCache.get(object, bl, (LineSegmentizable)object3);
                        gL20ResourceShapeLineStrip.setLineArray(lineArray);
                        Object object4 = this.state.getObjectDefault(object, bl, Attributes.COLOR, null);
                        if (object4 != null) {
                            gL20ResourceShapeLineStrip.setColor(new Vector4f((Tuple3f)object4));
                        } else {
                            int n = shader.getAverageColor();
                            gL20ResourceShapeLineStrip.setColor(new Vector4f((float)(n & 0xFF) * 0.003921569f, (float)((n & 0xFF00) >> 8) * 0.003921569f, (float)((n & 0xFF0000) >> 16) * 0.003921569f, (float)((n & 0xFF000000) >> 24) * 0.003921569f));
                        }
                        gL20ResourceShapeLineStrip.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(null));
                    }
                    if (this.toolTravel && gL20Node != null) {
                        gL20Node.update(((Node)object).getStamp());
                        this.gfxServer.addNodeToTool(gL20Node);
                    }
                }
                if (!this.toolTravel) {
                    gL20Node.update(((Node)object).getStamp());
                }
            }
            if (!this.toolTravel) {
                this.gfxServer.addNodeToScene(gL20Node);
            }
        }
    }

    private final void setCurrentNode(GL20Node gL20Node) {
        this.currentNode = gL20Node;
    }

    private final GL20Node getCurrentNode() {
        return this.currentNode;
    }

    public void drawBox(float f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        GL20Node gL20Node = this.getCurrentNode();
        GL20ResourceShapeBox gL20ResourceShapeBox = (GL20ResourceShapeBox)gL20Node.createResource(65537);
        gL20ResourceShapeBox.setHalfWidth(f);
        gL20ResourceShapeBox.setHalfLength(f2);
        gL20ResourceShapeBox.setHeight(f3);
        gL20ResourceShapeBox.setShader(GL20ShaderServer.getShader(this.getCurrentShader(shader)));
        gL20ResourceShapeBox.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(matrix4d));
    }

    public void drawFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Shader shader, int n, Matrix4d matrix4d) {
        GL20Node gL20Node = this.getCurrentNode();
        GL20ResourceShapeFrustum gL20ResourceShapeFrustum = (GL20ResourceShapeFrustum)gL20Node.createResource(65538);
        gL20ResourceShapeFrustum.setHeight(f);
        gL20ResourceShapeFrustum.setBaseRadius(f2);
        gL20ResourceShapeFrustum.setTopRadius(f3);
        gL20ResourceShapeFrustum.setBaseClosed(bl);
        gL20ResourceShapeFrustum.setTopClosed(bl2);
        gL20ResourceShapeFrustum.setShader(GL20ShaderServer.getShader(this.getCurrentShader(shader)));
        gL20ResourceShapeFrustum.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(matrix4d));
    }

    public void drawLine(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, int n, Matrix4d matrix4d) {
        GL20Node gL20Node = this.getCurrentNode();
        GL20ResourceShapeLine gL20ResourceShapeLine = (GL20ResourceShapeLine)gL20Node.createResource(65539);
        gL20ResourceShapeLine.setColor(new Vector4f(tuple3f3));
        gL20ResourceShapeLine.setLineCoordinates(new Vector3f(tuple3f), new Vector3f(tuple3f2));
        gL20ResourceShapeLine.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(matrix4d));
    }

    public void drawParallelogram(float f, Vector3f vector3f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        GL20Node gL20Node = this.getCurrentNode();
        GL20ResourceShapeParallelogram gL20ResourceShapeParallelogram = (GL20ResourceShapeParallelogram)gL20Node.createResource(65541);
        gL20ResourceShapeParallelogram.setAxis(f);
        gL20ResourceShapeParallelogram.setSecondAxis(vector3f);
        gL20ResourceShapeParallelogram.setScaleU(f2);
        gL20ResourceShapeParallelogram.setScaleV(f3);
        gL20ResourceShapeParallelogram.setShader(GL20ShaderServer.getShader(this.getCurrentShader(shader)));
        gL20ResourceShapeParallelogram.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(matrix4d));
    }

    public void drawPlane(Shader shader, int n, Matrix4d matrix4d) {
        GL20Node gL20Node = this.getCurrentNode();
        GL20ResourceShapePlane gL20ResourceShapePlane = (GL20ResourceShapePlane)gL20Node.createResource(65542);
        gL20ResourceShapePlane.setShader(GL20ShaderServer.getShader(this.getCurrentShader(shader)));
        gL20ResourceShapePlane.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(matrix4d));
    }

    public void drawPoint(Tuple3f tuple3f, int n, Tuple3f tuple3f2, int n2, Matrix4d matrix4d) {
    }

    public void drawPointCloud(float[] fArray, float f, Tuple3f tuple3f, int n, Matrix4d matrix4d) {
        int n2 = fArray.length / 3;
        Point3f point3f = new Point3f();
        if (f <= 0.0f) {
            f = 3.0f;
        }
        for (int i = 0; i < n2; ++i) {
            point3f.set(fArray[3 * i + 0], fArray[3 * i + 1], fArray[3 * i + 2]);
            this.drawPoint((Tuple3f)point3f, Math.max((int)f, 1), tuple3f, -1, null);
        }
    }

    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        GL20Node gL20Node = this.getCurrentNode();
        GL20ResourceShapePolygons gL20ResourceShapePolygons = (GL20ResourceShapePolygons)gL20Node.createResource(65543);
        if (this.polygonizationCache != null && this.polygonizationCache.getGraphState() != this.getRenderGraphState()) {
            this.polygonizationCache.clear();
            this.polygonizationCache = null;
        }
        if (this.polygonizationCache == null) {
            this.polygonizationCache = new PolygonizationCache(this.getRenderGraphState(), 3, 10.0f, true);
        }
        PolygonArray polygonArray = this.polygonizationCache.get(object, bl, polygonizable);
        gL20ResourceShapePolygons.setPolygonArray(polygonArray);
        gL20ResourceShapePolygons.setShader(GL20ShaderServer.getShader(this.getCurrentShader(shader)));
        gL20ResourceShapePolygons.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(matrix4d));
    }

    public void drawRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
    }

    public void drawSphere(float f, Shader shader, int n, Matrix4d matrix4d) {
        GL20Node gL20Node = this.getCurrentNode();
        GL20ResourceShapeSphere gL20ResourceShapeSphere = (GL20ResourceShapeSphere)gL20Node.createResource(65544);
        gL20ResourceShapeSphere.setRadius(f);
        gL20ResourceShapeSphere.setShader(GL20ShaderServer.getShader(this.getCurrentShader(shader)));
        gL20ResourceShapeSphere.setWorldTransformationMatrix(this.getCurrentTransformationMatrix(matrix4d));
    }

    public void drawSupershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Shader shader, int n, Matrix4d matrix4d) {
    }

    public void drawString(int n, int n2, String string, Font font, Tuple3f tuple3f) {
    }

    public float estimateScaleAt(Tuple3f tuple3f) {
        return 0.0f;
    }

    public void fillRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
    }

    public int getCurrentHighlight() {
        return 0;
    }

    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public Pool getPool() {
        return this.pool;
    }

    public GraphState getRenderGraphState() {
        return this.state;
    }

    public boolean getWindowPos(Tuple3f tuple3f, Tuple2f tuple2f) {
        return false;
    }

    private Matrix4d getCurrentTransformationMatrix(Matrix4d matrix4d) {
        if (matrix4d == null) {
            return this.getCurrentTransformation();
        }
        TMatrix4d tMatrix4d = new TMatrix4d();
        Math2.mulAffine((Matrix4d)tMatrix4d, (Matrix4d)this.getCurrentTransformation(), (Matrix4d)matrix4d);
        return tMatrix4d;
    }

    private Shader getCurrentShader(Shader shader) {
        if (shader == null) {
            return this.getCurrentShader();
        }
        return shader;
    }
}

