/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import java.util.ArrayList;
import java.util.Stack;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

class GL20GLSLCode {
    public static final int CONST_BIT = 32768;
    public static final String NORMAL_VARIABLE_NAME = new String("normal3_1");
    public static final String POSITION_WORLD_NAME = new String("vertexPosition3_World");
    public static final String POSITION_EYE_NAME = new String("vertexPosition3_Eye");
    public static final String WORLD_TO_VIEW_MATRIX_NAME = new String("worldToViewMatrix4");
    public static final int NORMAL_BIT = 1;
    public static final int POSITION_WORLD_BIT = 2;
    public static final int POSITION_EYE_BIT = 4;
    private Stack<Float> constScalarStack = new Stack();
    private Stack<Vector3f> constVector3Stack = new Stack();
    private Stack<Vector4f> constVector4Stack = new Stack();
    private ArrayList<Boolean> tempScalars = new ArrayList();
    private ArrayList<Boolean> tempVector3 = new ArrayList();
    private ArrayList<Boolean> tempVector4 = new ArrayList();
    private int dependencies = 0;
    private String sourceCode = new String();

    public final boolean isConstant(int n) {
        return (n & 0x8000) != 0;
    }

    public static final String getDependencyName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = NORMAL_VARIABLE_NAME;
                break;
            }
            case 2: {
                string = POSITION_WORLD_NAME;
                break;
            }
            case 4: {
                string = POSITION_EYE_NAME;
            }
        }
        return string;
    }

    public final void setDependency(int n) {
        this.dependencies |= n;
    }

    public final int getDependency() {
        return this.dependencies;
    }

    public final String getConstScalarName(int n) {
        String string = null;
        if (n < this.constScalarStack.size()) {
            string = new String("constScalar_");
            string = string + Integer.valueOf(n).toString();
        }
        return string;
    }

    public final int createConstScalar(float f) {
        int n;
        int n2 = this.constScalarStack.size();
        for (n = 0; n < n2 && ((Float)this.constScalarStack.get(n)).floatValue() != f; ++n) {
        }
        if (n >= n2) {
            this.constScalarStack.add(new Float(f));
        }
        return n;
    }

    public final String getConstVector3Name(int n) {
        String string = null;
        if (n < this.constVector3Stack.size()) {
            string = new String("constVec3_");
            string = string + Integer.valueOf(n).toString();
        }
        return string;
    }

    public final int createConstVector3(Vector3f vector3f) {
        int n;
        int n2 = this.constVector3Stack.size();
        for (n = 0; n < n2 && !((Vector3f)this.constVector3Stack.get(n)).equals((Tuple3f)vector3f); ++n) {
        }
        if (n >= n2) {
            this.constVector3Stack.add(new Vector3f(vector3f));
        }
        return n;
    }

    public final String getConstVector4Name(int n) {
        String string = null;
        if (n < this.constVector4Stack.size()) {
            string = new String("constVec4_");
            string = string + Integer.valueOf(n).toString();
        }
        return string;
    }

    public final int createConstVector4(Vector4f vector4f) {
        int n;
        int n2 = this.constVector4Stack.size();
        for (n = 0; n < n2 && !((Vector4f)this.constVector4Stack.get(n)).equals((Tuple4f)vector4f); ++n) {
        }
        if (n >= n2) {
            this.constVector4Stack.add(new Vector4f(vector4f));
        }
        return n;
    }

    public final String getTemporaryScalarName(int n) {
        String string = null;
        if (n < this.tempScalars.size()) {
            string = new String("tempScalar_");
            string = string + Integer.valueOf(n).toString();
        }
        return string;
    }

    public final int allocateTemporaryScalar() {
        int n;
        int n2 = this.tempScalars.size();
        for (n = 0; n < n2 && !this.tempScalars.get(n).equals(Boolean.FALSE); ++n) {
        }
        if (n >= n2) {
            this.tempScalars.add(new Boolean(Boolean.TRUE));
        } else {
            Boolean bl = this.tempScalars.get(n);
            bl = Boolean.TRUE;
        }
        return n;
    }

    public final void freeTemporaryScalar(int n) {
        if (n < this.tempScalars.size() && this.tempScalars.get(n).equals(Boolean.TRUE)) {
            Boolean bl = this.tempScalars.get(n);
            bl = Boolean.FALSE;
        }
    }

    public final String getTemporaryVector3Name(int n) {
        String string = null;
        if (n < this.tempVector3.size()) {
            string = new String("tempVector3_");
            string = string + Integer.valueOf(n).toString();
        }
        return string;
    }

    public final int allocateTemporaryVector3() {
        int n;
        int n2 = this.tempVector3.size();
        for (n = 0; n < n2 && !this.tempVector3.get(n).equals(Boolean.FALSE); ++n) {
        }
        if (n >= n2) {
            this.tempVector3.add(new Boolean(Boolean.TRUE));
        } else {
            Boolean bl = this.tempVector3.get(n);
            bl = Boolean.TRUE;
        }
        return n;
    }

    public final void freeTemporaryVector3(int n) {
        if (n < this.tempVector3.size() && this.tempVector3.get(n).equals(Boolean.TRUE)) {
            Boolean bl = this.tempVector3.get(n);
            bl = Boolean.FALSE;
        }
    }

    public final String getTemporaryVector4Name(int n) {
        String string = null;
        if (n < this.tempVector4.size()) {
            string = new String("tempVector4_");
            string = string + Integer.valueOf(n).toString();
        }
        return string;
    }

    public final int allocateTemporaryVector4() {
        int n;
        int n2 = this.tempVector4.size();
        for (n = 0; n < n2 && !this.tempVector4.get(n).equals(Boolean.FALSE); ++n) {
        }
        if (n >= n2) {
            this.tempVector4.add(new Boolean(Boolean.TRUE));
        } else {
            Boolean bl = this.tempVector4.get(n);
            bl = Boolean.TRUE;
        }
        return n;
    }

    public final void freeTemporaryVector4(int n) {
        if (n < this.tempVector4.size() && this.tempVector4.get(n).equals(Boolean.TRUE)) {
            Boolean bl = this.tempVector4.get(n);
            bl = Boolean.FALSE;
        }
    }

    public final String getShaderCodeVertex(boolean bl) {
        String string = new String();
        if ((this.dependencies & 1) != 0) {
            string = string + "varying vec3 normal;\n";
        }
        if ((this.dependencies & 2) != 0) {
            string = string + "varying vec3 " + POSITION_WORLD_NAME + ";\n";
        }
        if ((this.dependencies & 4) != 0) {
            string = string + "varying vec3 " + POSITION_EYE_NAME + ";\n";
            string = string + "uniform mat4 " + WORLD_TO_VIEW_MATRIX_NAME + ";\n";
        }
        string = string + "void main(void) {\n";
        if ((this.dependencies & 1) != 0) {
            string = string + "normal = -vec3(gl_NormalMatrix * gl_Normal);\n";
        }
        if ((this.dependencies & 2) != 0) {
            string = string + POSITION_WORLD_NAME + " = vec3(gl_ModelViewMatrix * gl_Vertex);\n";
        }
        if ((this.dependencies & 4) != 0) {
            string = string + POSITION_EYE_NAME + " = -vec3(" + WORLD_TO_VIEW_MATRIX_NAME + " * (gl_ModelViewMatrix * gl_Vertex));\n";
        }
        string = string + "gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n}\n";
        return string;
    }

    public final String getShaderCodeFragment() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string = new String();
        if ((this.dependencies & 1) != 0) {
            string = string + "varying vec3 normal;\n";
        }
        if ((this.dependencies & 2) != 0) {
            string = string + "varying vec3 " + GL20GLSLCode.getDependencyName(2) + ";\n";
        }
        if ((this.dependencies & 4) != 0) {
            string = string + "varying vec3 " + GL20GLSLCode.getDependencyName(4) + ";\n";
        }
        string = string + "void main(void) {\n";
        int n6 = this.constScalarStack.size();
        for (n5 = 0; n5 < n6; ++n5) {
            string = string + "const float " + this.getConstScalarName(n5) + " = " + ((Float)this.constScalarStack.get(n5)).toString() + ";\n";
        }
        n5 = this.constVector3Stack.size();
        for (n4 = 0; n4 < n5; ++n4) {
            Vector3f vector3f = (Vector3f)this.constVector3Stack.get(n4);
            string = string + "const vec3 " + this.getConstVector3Name(n4) + " = vec3(" + Float.valueOf(vector3f.x).toString() + "," + Float.valueOf(vector3f.y).toString() + "," + Float.valueOf(vector3f.z).toString() + ");\n";
        }
        n4 = this.constVector4Stack.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Vector4f vector4f = (Vector4f)this.constVector4Stack.get(n3);
            string = string + "const vec4 " + this.getConstVector4Name(n3) + " = vec4(" + Float.valueOf(vector4f.x).toString() + "," + Float.valueOf(vector4f.y).toString() + "," + Float.valueOf(vector4f.z).toString() + "," + Float.valueOf(vector4f.w).toString() + ");\n";
        }
        n3 = this.tempScalars.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = string + "float " + this.getTemporaryScalarName(n2) + ";\n";
        }
        n2 = this.tempVector3.size();
        for (n = 0; n < n2; ++n) {
            string = string + "vec3 " + this.getTemporaryVector3Name(n) + ";\n";
        }
        n = this.tempVector4.size();
        for (int i = 0; i < n; ++i) {
            string = string + "vec4 " + this.getTemporaryVector4Name(i) + ";\n";
        }
        if ((this.dependencies & 1) != 0) {
            string = string + "const vec3 " + GL20GLSLCode.getDependencyName(1) + " = normalize(normal);\n";
        }
        string = string + this.sourceCode;
        string = string + "}";
        return string;
    }

    public final void appendCode(String string) {
        if (string != null) {
            this.sourceCode = this.sourceCode + string;
        }
    }

    public final String getScalarName(int n) {
        if ((n & 0x8000) != 0) {
            return this.getConstScalarName(n & 0xFFFF7FFF);
        }
        return this.getTemporaryScalarName(n);
    }

    public final String getVector3Name(int n) {
        if ((n & 0x8000) != 0) {
            return this.getConstVector3Name(n & 0xFFFF7FFF);
        }
        return this.getTemporaryVector3Name(n);
    }

    public final String getVector4Name(int n) {
        if ((n & 0x8000) != 0) {
            return this.getConstVector4Name(n & 0xFFFF7FFF);
        }
        return this.getTemporaryVector4Name(n);
    }

    public final void freeScalar(int n) {
        if ((n & 0x8000) == 0) {
            this.freeTemporaryScalar(n);
        }
    }

    public final void freeVector3(int n) {
        if ((n & 0x8000) == 0) {
            this.freeTemporaryVector3(n);
        }
    }

    public final void freeVector4(int n) {
        if ((n & 0x8000) == 0) {
            this.freeTemporaryVector4(n);
        }
    }
}

