/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp3d.gl20.GL20Const;
import de.grogra.imp3d.gl20.GL20GLSLCode;
import de.grogra.imp3d.gl20.GL20MeshServer;
import de.grogra.imp3d.gl20.GL20Node;
import de.grogra.imp3d.gl20.GL20Resource;
import de.grogra.imp3d.gl20.GL20ResourceLight;
import de.grogra.imp3d.gl20.GL20ResourceShader;
import de.grogra.imp3d.gl20.GL20ResourceShape;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;

public class GL20GfxServer {
    private static final int MAX_TEXTURE_STAGES = 16;
    public static final int PRIMITIVE_MASK = 15;
    public static final int TRIANGLES = 1;
    public static final int QUADS = 2;
    public static final int LINES = 3;
    public static final int NORMAL_MASK = 240;
    public static final int HAS_NO_NORMALS = 0;
    public static final int HAS_NORMALS_BYTE = 16;
    public static final int HAS_NORMALS_FLOAT = 32;
    public static final int TEXTURE_MASK = 3840;
    public static final int HAS_NO_TEXTURE_UV = 0;
    public static final int HAS_TEXTURE_UV_SHORT = 256;
    public static final int HAS_TEXTURE_UV_FLOAT = 512;
    public static final int VERTEX_MASK = 61440;
    public static final int HAS_VERTEX_3_SHORT = 4096;
    public static final int HAS_VERTEX_3_FLOAT = 8192;
    public static final int HAS_VERTEX_4_SHORT = 12288;
    public static final int HAS_VERTEX_4_FLOAT = 16384;
    public static final int ORDER_MASK = 983040;
    public static final int ORDER_V_N_UV = 65536;
    public static final int ORDER_V_UV_N = 131072;
    public static final int ORDER_N_V_UV = 196608;
    public static final int ORDER_N_UV_V = 262144;
    public static final int ORDER_UV_V_N = 327680;
    public static final int ORDER_UV_N_V = 393216;
    public static final int ELEMENTS_MASK = 0xF00000;
    public static final int ELEMENTS_BYTE = 0x100000;
    public static final int ELEMENTS_SHORT = 0x200000;
    public static final int ELEMENTS_INT = 0x300000;
    private static GL20GfxServer singleton = new GL20GfxServer();
    private static int currentFrameID;
    private static int currentContextID;
    private int openedArrayBufferIndex;
    private int openedElementArrayBufferIndex;
    private int boundArrayBufferIndex;
    private int boundElementArrayBufferIndex;
    private ByteBuffer arrayBuffer;
    private ByteBuffer elementArrayBuffer;
    private int freeArrayBufferCapacityRestBytes;
    private int freeElementArrayBufferCapacityRestBytes;
    private Matrix4d viewToClipMatrix = new Matrix4d(GL20Const.identityMatrix4d);
    private Matrix4d worldToViewMatrix = new Matrix4d(GL20Const.identityMatrix4d);
    private Matrix4d worldToClipMatrix = new Matrix4d(GL20Const.identityMatrix4d);
    private boolean inScene = false;
    private boolean inRendering = false;
    private Vector4f currentColor = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private int[] boundTextureIndex = new int[16];
    private int[] boundTextureDimension = new int[16];
    private int textureStagesAvailable = 0;
    private boolean calculateNormalMatrix;
    private ArrayList<GL20Node> selectedNodes = new ArrayList();
    private ArrayList<GL20Node> opaqueShaderNodes = new ArrayList();
    private ArrayList<GL20Node> lineStripNodes = new ArrayList();
    private ArrayList<GL20Node> toolNodes = new ArrayList();
    private GL currentGL;
    private int programHandle = 0;
    private double[] openGLMatrix = new double[16];

    private GL20GfxServer() {
        currentFrameID = 0;
        currentContextID = 0;
    }

    public static final GL20GfxServer getInstance() {
        return singleton;
    }

    public final int getFrameID() {
        return currentFrameID;
    }

    public final int getContextID() {
        return currentContextID;
    }

    public final boolean setViewToClipMatrix(Matrix4d matrix4d) {
        boolean bl = false;
        if (!this.inScene && !this.inRendering) {
            this.viewToClipMatrix.set(matrix4d);
            bl = true;
        }
        return bl;
    }

    public final Matrix4d getViewToClipMatrix() {
        return this.viewToClipMatrix;
    }

    public final boolean setWorldToViewMatrix(Matrix4d matrix4d) {
        boolean bl = false;
        if (!this.inScene && !this.inRendering) {
            this.worldToViewMatrix.set(matrix4d);
            bl = true;
        }
        return bl;
    }

    public final Matrix4d getWorldToViewMatrix() {
        return this.worldToViewMatrix;
    }

    public final Matrix4d getWorldToClipMatrix() {
        if (this.inScene || this.inRendering) {
            return this.worldToClipMatrix;
        }
        return null;
    }

    public final void setCurrentColor(Vector4f vector4f) {
        this.currentColor.set((Tuple4f)vector4f);
        if (this.inRendering) {
            this.currentGL.glColor4f(vector4f.x, vector4f.y, vector4f.z, vector4f.w);
        }
    }

    public final Vector4f getCurrentColor() {
        return this.currentColor;
    }

    public final void checkExtensions() {
        if (this.currentGL != null) {
            int[] nArray = new int[1];
            this.currentGL.glGetIntegerv(34018, nArray, 0);
            this.textureStagesAvailable = nArray[0] < 16 ? nArray[0] : 16;
        }
    }

    public final boolean beginScene(GL gL) {
        boolean bl = false;
        if (!this.inScene) {
            int n;
            int n2;
            if (this.currentGL != gL) {
                ++currentContextID;
                this.currentGL = gL;
                this.checkExtensions();
                this.programHandle = gL.glCreateProgram();
                n2 = gL.glCreateShader(35633);
                n = gL.glCreateShader(35632);
                String[] stringArray = new String[]{"varying vec3 normal, lightV, vertexPosEye;varying vec4 diffuse, ambientGlobal, ambient;varying float vertexLightDist;void main(void){vec3 vertexLightV;normal = -normalize(gl_NormalMatrix * gl_Normal);vertexPosEye = vec3(gl_ModelViewMatrix * gl_Vertex);vertexLightV = vec3(vertexPosEye - vec3(gl_LightSource[0].position));lightV = -normalize(vertexLightV);vertexLightDist = length(vertexLightV);diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;ambientGlobal = gl_FrontMaterial.ambient * gl_LightModel.ambient;gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;}"};
                IntBuffer intBuffer = IntBuffer.allocate(1);
                intBuffer.put(0, stringArray[0].length());
                gL.glShaderSource(n2, 1, stringArray, intBuffer);
                String[] stringArray2 = new String[]{"varying vec3 normal, lightV, vertexPosEye;varying vec4 diffuse, ambientGlobal, ambient;varying float vertexLightDist;void main(void){\tvec3 normalN, halfVN;\tfloat NdotL, NdotHV;\tvec4 color = ambientGlobal;\tfloat att;\t\tnormalN = normalize(normal);\t\tNdotL = max(dot(normalN,normalize(vec3(gl_LightSource[0].position) - vertexPosEye)),0.0);\t\tif (NdotL > 0.0) {\t\tatt = 1.0 / (gl_LightSource[0].constantAttenuation + \t\t\t\t\t gl_LightSource[0].linearAttenuation * vertexLightDist + \t\t\t\t\t gl_LightSource[0].quadraticAttenuation * vertexLightDist * vertexLightDist);\t\tcolor += att * (diffuse * NdotL + ambient);\t\t\t\thalfVN = normalize(vec3(gl_LightSource[0].position) - (2.0 * vertexPosEye).xyz);\t\tNdotHV = max(dot(normalN,halfVN),0.0);\t\tcolor += att * gl_FrontMaterial.specular * gl_LightSource[0].specular *\t\t\t\t pow(NdotHV,gl_FrontMaterial.shininess);\t}\t\tgl_FragColor = color;}"};
                intBuffer.put(0, stringArray2[0].length());
                gL.glShaderSource(n, 1, stringArray2, intBuffer);
                gL.glCompileShader(n2);
                if (this.checkGLObjectInfoLog(n2, "VertexShader")) {
                    gL.glCompileShader(n);
                    if (this.checkGLObjectInfoLog(n, "FragmentShader")) {
                        gL.glAttachShader(this.programHandle, n2);
                        gL.glAttachShader(this.programHandle, n);
                        gL.glDeleteShader(n2);
                        gL.glDeleteShader(n);
                        gL.glLinkProgram(this.programHandle);
                        if (this.checkGLObjectInfoLog(this.programHandle, "Program")) {
                            System.out.print("jup!");
                        }
                    }
                }
            }
            this.worldToClipMatrix.set(this.viewToClipMatrix);
            this.worldToClipMatrix.mul(this.worldToViewMatrix);
            this.selectedNodes.clear();
            this.lineStripNodes.clear();
            n2 = this.toolNodes.size();
            for (n = 0; n < n2; ++n) {
                this.toolNodes.get(n).destroy();
            }
            this.toolNodes.clear();
            this.opaqueShaderNodes.clear();
            this.boundArrayBufferIndex = -1;
            this.boundElementArrayBufferIndex = -1;
            this.openedArrayBufferIndex = -1;
            this.openedElementArrayBufferIndex = -1;
            for (n = 0; n < this.textureStagesAvailable; ++n) {
                this.boundTextureIndex[n] = 0;
                this.boundTextureDimension[n] = 0;
            }
            ++currentFrameID;
            this.inScene = true;
            bl = true;
        }
        return bl;
    }

    public final void endScene() {
        if (this.inScene) {
            this.inScene = false;
            this.renderScene();
        }
    }

    public final boolean inScene() {
        return this.inScene;
    }

    private final boolean checkGLObjectInfoLog(int n, String string) {
        boolean bl = false;
        int[] nArray = new int[1];
        this.currentGL.glGetObjectParameterivARB(n, 35716, nArray, 0);
        if (nArray[0] > 1) {
            byte[] byArray = new byte[nArray[0]];
            int[] nArray2 = new int[1];
            this.currentGL.glGetInfoLogARB(n, nArray[0], nArray2, 0, byArray, 0);
            System.out.println(string + ": " + new String(byArray));
        } else {
            bl = true;
            System.out.println(string + ": successful!");
        }
        return bl;
    }

    private final boolean renderScene() {
        boolean bl = false;
        if (!this.inScene) {
            Object object;
            int n;
            int n2;
            int n3;
            Object object2;
            Object object3;
            int n4;
            this.inRendering = true;
            this.currentGL.glClearColor(0.75f, 0.75f, 0.75f, 1.0f);
            this.currentGL.glClear(16640);
            this.currentGL.glMatrixMode(5889);
            this.currentGL.glLoadMatrixd(this.transformToGLMatrix(this.viewToClipMatrix), 0);
            this.currentGL.glMatrixMode(5888);
            this.currentGL.glLoadMatrixd(this.transformToGLMatrix(this.worldToViewMatrix), 0);
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.currentGL.glLightfv(16384, 4611, fArray, 0);
            this.currentGL.glMatrixMode(5889);
            this.currentGL.glMultMatrixd(this.transformToGLMatrix(this.worldToViewMatrix), 0);
            this.currentGL.glMatrixMode(5888);
            this.currentGL.glLoadIdentity();
            GL20MeshServer gL20MeshServer = GL20MeshServer.getInstance();
            gL20MeshServer.updateAllMultiUserMeshes();
            this.currentGL.glShadeModel(7425);
            this.currentGL.glEnable(2929);
            this.currentGL.glDepthFunc(513);
            this.currentGL.glEnable(2896);
            this.currentGL.glEnable(16384);
            this.currentGL.glEnable(2977);
            this.currentGL.glPolygonMode(1032, 6914);
            this.currentGL.glEnable(2884);
            float[] fArray2 = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
            float[] fArray3 = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
            this.currentGL.glMaterialfv(1032, 4610, fArray3, 0);
            this.currentGL.glMaterialf(1032, 5633, 128.0f);
            this.currentGL.glCullFace(1029);
            this.currentGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.currentGL.glBegin(1);
            this.currentGL.glVertex3f(-1.0f, 0.0f, 1.0f);
            this.currentGL.glVertex3f(1.0f, 0.0f, 1.0f);
            this.currentGL.glVertex3f(0.0f, -1.0f, 1.0f);
            this.currentGL.glVertex3f(0.0f, 1.0f, 1.0f);
            this.currentGL.glVertex3f(0.0f, 0.0f, 0.0f);
            this.currentGL.glVertex3f(0.0f, 0.0f, 2.0f);
            this.currentGL.glEnd();
            this.currentGL.glEnableClientState(32885);
            this.currentGL.glEnableClientState(32884);
            this.currentGL.glColor4f(0.75f, 0.75f, 0.75f, 1.0f);
            this.calculateNormalMatrix = true;
            int n5 = this.opaqueShaderNodes.size();
            for (n4 = 0; n4 < n5; ++n4) {
                GL20ResourceShape gL20ResourceShape = (GL20ResourceShape)this.opaqueShaderNodes.get(n4).getResource();
                object3 = gL20ResourceShape.getShader();
                if (!((GL20ResourceShader)object3).isUpToDate()) {
                    ((GL20ResourceShader)object3).update();
                }
                ((GL20ResourceShader)object3).applyShader(false);
                this.currentGL.glUseProgram(this.programHandle);
                int n6 = this.currentGL.glGetUniformLocation(this.programHandle, GL20GLSLCode.WORLD_TO_VIEW_MATRIX_NAME);
                if (n6 != -1) {
                    this.transformToGLMatrix(this.worldToViewMatrix);
                    object2 = new float[16];
                    for (n3 = 0; n3 < 16; ++n3) {
                        object2[n3] = (float)this.openGLMatrix[n3];
                    }
                    this.currentGL.glUniformMatrix4fv(n6, 1, false, (float[])object2, 0);
                }
                gL20ResourceShape.applyGeometry();
                this.currentGL.glUseProgram(0);
            }
            this.currentGL.glUseProgram(0);
            this.calculateNormalMatrix = false;
            this.currentGL.glDisableClientState(32888);
            this.currentGL.glDisableClientState(32885);
            this.currentGL.glDisable(2977);
            this.currentGL.glDisable(2896);
            this.currentGL.glDisable(16384);
            n4 = this.lineStripNodes.size();
            for (n2 = 0; n2 < n4; ++n2) {
                object3 = this.lineStripNodes.get(n2);
                GL20ResourceShape gL20ResourceShape = (GL20ResourceShape)((GL20Node)object3).getResource();
                this.currentGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gL20ResourceShape.applyGeometry();
            }
            this.currentGL.glDisable(2929);
            this.currentGL.glPolygonMode(1028, 6913);
            n2 = this.selectedNodes.size();
            for (n = 0; n < n2; ++n) {
                object2 = this.selectedNodes.get(n);
                n3 = ViewSelection.getColor((int)-1, (int)((GL20Node)object2).getSelectionState(), (boolean)true);
                this.currentGL.glColor4f((float)(n3 >> 16 & 0xFF) * 0.003921569f, (float)(n3 >> 8 & 0xFF) * 0.003921569f, (float)(n3 & 0xFF) * 0.003921569f, 1.0f);
                object = (GL20ResourceShape)((GL20Node)object2).getResource();
                ((GL20ResourceShape)object).applyGeometry();
            }
            n = 0;
            this.currentGL.glPolygonMode(1032, 6914);
            int n7 = this.toolNodes.size();
            for (n3 = 0; n3 < n7; ++n3) {
                object = this.toolNodes.get(n3);
                GL20ResourceShape gL20ResourceShape = (GL20ResourceShape)((GL20Node)object).getResource();
                if (gL20ResourceShape == null) continue;
                if (gL20ResourceShape.getResourceClassType() == 65540 || gL20ResourceShape.getResourceClassType() == 65539) {
                    if (n == 1) {
                        this.currentGL.glDisable(2896);
                        this.currentGL.glDisable(16384);
                        this.currentGL.glDisable(2977);
                        this.currentGL.glDisableClientState(32885);
                        this.calculateNormalMatrix = true;
                        n = 0;
                    }
                } else if (n == 0) {
                    this.currentGL.glEnable(2896);
                    this.currentGL.glEnable(16384);
                    this.currentGL.glEnable(2977);
                    this.currentGL.glEnableClientState(32885);
                    this.calculateNormalMatrix = false;
                    n = 1;
                }
                gL20ResourceShape.applyGeometry();
            }
            if (n == 1) {
                this.currentGL.glDisable(2896);
                this.currentGL.glDisable(16384);
                this.currentGL.glDisable(2977);
                this.currentGL.glDisableClientState(32885);
            }
            this.currentGL.glDisableClientState(32884);
            this.currentGL.glMatrixMode(5889);
            this.currentGL.glPopMatrix();
            this.currentGL.glFlush();
            this.inRendering = false;
            bl = true;
        }
        return bl;
    }

    public final void addNodeToScene(GL20Node gL20Node) {
        assert (this.inScene);
        GL20Resource gL20Resource = gL20Node.getResource();
        if (gL20Resource == null) {
            return;
        }
        switch (gL20Resource.getResourceClass()) {
            case 65536: {
                this.addShapeNodeToScene(gL20Node);
                break;
            }
            case 131072: {
                this.addLightNodeToScene(gL20Node);
            }
        }
    }

    public final void addNodeToTool(GL20Node gL20Node) {
        assert (this.inScene);
        this.toolNodes.add(gL20Node);
    }

    private final void addShapeNodeToScene(GL20Node gL20Node) {
        GL20ResourceShape gL20ResourceShape = (GL20ResourceShape)gL20Node.getResource();
        if (gL20ResourceShape.getResourceClassType() != 65540) {
            this.opaqueShaderNodes.add(gL20Node);
        } else {
            this.lineStripNodes.add(gL20Node);
        }
        if (gL20Node.getSelectionState() != 0) {
            this.selectedNodes.add(gL20Node);
        }
    }

    private final void addLightNodeToScene(GL20Node gL20Node) {
        GL20ResourceLight gL20ResourceLight = (GL20ResourceLight)gL20Node.getResource();
    }

    private final double[] transformToGLMatrix(Matrix4d matrix4d) {
        this.openGLMatrix[0] = matrix4d.m00;
        this.openGLMatrix[1] = matrix4d.m10;
        this.openGLMatrix[2] = matrix4d.m20;
        this.openGLMatrix[3] = matrix4d.m30;
        this.openGLMatrix[4] = matrix4d.m01;
        this.openGLMatrix[5] = matrix4d.m11;
        this.openGLMatrix[6] = matrix4d.m21;
        this.openGLMatrix[7] = matrix4d.m31;
        this.openGLMatrix[8] = matrix4d.m02;
        this.openGLMatrix[9] = matrix4d.m12;
        this.openGLMatrix[10] = matrix4d.m22;
        this.openGLMatrix[11] = matrix4d.m32;
        this.openGLMatrix[12] = matrix4d.m03;
        this.openGLMatrix[13] = matrix4d.m13;
        this.openGLMatrix[14] = matrix4d.m23;
        this.openGLMatrix[15] = matrix4d.m33;
        return this.openGLMatrix;
    }

    public final void setWorldTransformationMatrix(Matrix4d matrix4d) {
        if (this.inRendering) {
            this.currentGL.glLoadMatrixd(this.transformToGLMatrix(matrix4d), 0);
            if (this.calculateNormalMatrix) {
                // empty if block
            }
        }
    }

    public final int createArrayBuffer() {
        int[] nArray = new int[1];
        this.currentGL.glGenBuffers(1, nArray, 0);
        return nArray[0];
    }

    public final void deleteArrayBuffer(int n) {
        if (n > 0) {
            int[] nArray = new int[1];
            this.currentGL.glDeleteBuffers(1, nArray, 0);
        }
    }

    public final int createElementArrayBuffer() {
        return this.createArrayBuffer();
    }

    public final void deleteElementArrayBuffer(int n) {
        this.deleteArrayBuffer(n);
    }

    private final boolean bindArrayBuffer(int n) {
        boolean bl = false;
        if (n != -1 && this.openedArrayBufferIndex == -1) {
            if (this.boundArrayBufferIndex != n) {
                this.currentGL.glBindBuffer(34962, n);
                this.boundArrayBufferIndex = n;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean unbindArrayBuffer(int n) {
        boolean bl = false;
        if (n != -1 && this.openedArrayBufferIndex == -1 && this.boundArrayBufferIndex == n) {
            this.currentGL.glBindBuffer(34962, 0);
            this.boundArrayBufferIndex = -1;
            bl = true;
        }
        return bl;
    }

    private final boolean bindElementArrayBuffer(int n) {
        boolean bl = false;
        if (n != -1 && this.openedElementArrayBufferIndex == -1) {
            if (this.boundElementArrayBufferIndex != n) {
                this.currentGL.glBindBuffer(34963, n);
                this.boundElementArrayBufferIndex = n;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean unbindElementArrayBuffer(int n) {
        boolean bl = false;
        if (n != -1 && this.openedElementArrayBufferIndex == -1 && this.boundElementArrayBufferIndex == n) {
            this.currentGL.glBindBuffer(34963, 0);
            this.boundElementArrayBufferIndex = -1;
            bl = true;
        }
        return bl;
    }

    private final void setTextureAttributes(int n, int n2, int n3, int n4) {
        this.currentGL.glTexCoordPointer(n, n2, n4, (long)n3);
    }

    private final void setNormalAttributes(int n, int n2, int n3) {
        this.currentGL.glNormalPointer(n, n3, (long)n2);
    }

    private final void setVertexAttributes(int n, int n2, int n3, int n4) {
        this.currentGL.glVertexPointer(n, n2, n4, (long)n3);
    }

    public final boolean drawElementArrayBuffer(int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        if (this.inRendering && n != -1 && n2 != -1 && n3 >= 0 && n4 > 0 && ((n5 & 0xF) == 1 || (n5 & 0xF) == 2 || (n5 & 0xF) == 3) && this.openedElementArrayBufferIndex == -1 && this.openedArrayBufferIndex == -1 && this.bindElementArrayBuffer(n)) {
            if (this.bindArrayBuffer(n2)) {
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                switch (n5 & 0xF000) {
                    case 4096: {
                        n6 = 6;
                        n7 = 5122;
                        n8 = 3;
                        break;
                    }
                    case 12288: {
                        n6 = 8;
                        n7 = 5122;
                        n8 = 4;
                        break;
                    }
                    case 8192: {
                        n6 = 12;
                        n7 = 5126;
                        n8 = 3;
                        break;
                    }
                    case 16384: {
                        n6 = 16;
                        n7 = 5126;
                        n8 = 4;
                    }
                }
                int n9 = 0;
                int n10 = 0;
                switch (n5 & 0xF0) {
                    case 0: {
                        break;
                    }
                    case 16: {
                        n9 = 3;
                        n10 = 5120;
                        break;
                    }
                    case 32: {
                        n9 = 12;
                        n10 = 5126;
                    }
                }
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                switch (n5 & 0xF00) {
                    case 0: {
                        break;
                    }
                    case 256: {
                        n11 = 4;
                        n12 = 5122;
                        n13 = 2;
                        break;
                    }
                    case 512: {
                        n11 = 8;
                        n12 = 5126;
                        n13 = 2;
                    }
                }
                int n14 = n6 + n9 + n11;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                switch (n5 & 0xF0000) {
                    case 65536: {
                        n15 = 0;
                        n16 = n6;
                        n17 = n9 + n16;
                        break;
                    }
                    case 131072: {
                        n15 = 0;
                        n17 = n6;
                        n16 = n11 + n17;
                        break;
                    }
                    case 196608: {
                        n16 = 0;
                        n15 = n9;
                        n17 = n6 + n15;
                        break;
                    }
                    case 262144: {
                        n16 = 0;
                        n17 = n9;
                        n15 = n11 + n17;
                        break;
                    }
                    case 327680: {
                        n17 = 0;
                        n15 = n11;
                        n16 = n6 + n15;
                        break;
                    }
                    case 393216: {
                        n17 = 0;
                        n16 = n11;
                        n15 = n9 + n16;
                    }
                }
                if (n11 != 0) {
                    this.setTextureAttributes(n13, n12, n17, n14);
                }
                if (n9 != 0) {
                    this.setNormalAttributes(n10, n16, n14);
                }
                if (n6 != 0) {
                    this.setVertexAttributes(n8, n7, n15, n14);
                }
                int n18 = 0;
                switch (n5 & 0xF) {
                    case 1: {
                        n18 = 4;
                        break;
                    }
                    case 2: {
                        n18 = 7;
                        break;
                    }
                    case 3: {
                        n18 = 1;
                    }
                }
                int n19 = 0;
                int n20 = 0;
                switch (n5 & 0xF00000) {
                    case 0x100000: {
                        n19 = 5121;
                        n20 = 1;
                        break;
                    }
                    case 0x200000: {
                        n19 = 5123;
                        n20 = 2;
                        break;
                    }
                    case 0x300000: {
                        n19 = 5125;
                        n20 = 4;
                    }
                }
                this.currentGL.glDrawElements(n18, n4, n19, (long)(n3 * n20));
                bl = true;
                this.unbindArrayBuffer(n2);
            }
            this.unbindElementArrayBuffer(n);
        }
        return bl;
    }

    public final boolean openArrayBuffer(int n, int n2) {
        boolean bl = false;
        if (n > 0 && n2 > 0 && this.bindArrayBuffer(n)) {
            this.currentGL.glBufferData(34962, n2, null, 35044);
            this.arrayBuffer = this.currentGL.glMapBuffer(34962, 35001);
            this.openedArrayBufferIndex = n;
            this.freeArrayBufferCapacityRestBytes = n2;
            bl = true;
        }
        return bl;
    }

    public final boolean openElementArrayBuffer(int n, int n2) {
        boolean bl = false;
        if (n > 0 && n2 > 0 && this.bindElementArrayBuffer(n)) {
            this.currentGL.glBufferData(34963, n2, null, 35044);
            this.elementArrayBuffer = this.currentGL.glMapBuffer(34963, 35001);
            this.elementArrayBuffer.order(ByteOrder.nativeOrder());
            this.openedElementArrayBufferIndex = n;
            this.freeElementArrayBufferCapacityRestBytes = n2;
            bl = true;
        }
        return bl;
    }

    public final void closeArrayBuffer(int n) {
        if (n > 0 && this.openedArrayBufferIndex == n) {
            this.currentGL.glUnmapBuffer(34962);
            this.openedArrayBufferIndex = -1;
            this.unbindArrayBuffer(n);
            this.arrayBuffer = null;
        }
    }

    public final void closeElementArrayBuffer(int n) {
        if (n > 0 && this.openedElementArrayBufferIndex == n) {
            this.currentGL.glUnmapBuffer(34963);
            this.openedElementArrayBufferIndex = -1;
            this.unbindElementArrayBuffer(n);
            this.elementArrayBuffer = null;
        }
    }

    public final int createTextureIndex(int n) {
        int[] nArray = new int[]{0};
        if (this.currentGL != null && n > 0 && n < 3) {
            this.currentGL.glGenTextures(1, nArray, 0);
        }
        return nArray[0];
    }

    public final void deleteTextureIndex(int n, int n2) {
        if (this.currentGL != null && n > 0 && n < 3) {
            int[] nArray = new int[]{n2};
            this.currentGL.glDeleteTextures(1, nArray, 0);
        }
    }

    public final int setTextureImage(int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = 0;
        if (GL20Const.isPowerOf2(n2) && GL20Const.isPowerOf2(n3) && GL20Const.isPowerOf2(n4) && this.currentGL != null) {
            int n6 = this.boundTextureIndex[0];
            int n7 = this.boundTextureDimension[0];
            int n8 = 0;
            if (n2 > 0) {
                n5 = 1;
                n8 = 3552;
                if (n3 > 1) {
                    n5 = 2;
                    n8 = 3553;
                    if (n4 > 1) {
                        n5 = 3;
                        n8 = 32879;
                    }
                }
            }
            this.bindTextureIndex(n5, n, 0);
            this.currentGL.glTexParameteri(n8, 10241, 9729);
            this.currentGL.glTexParameteri(n8, 10240, 9729);
            this.currentGL.glTexParameteri(n8, 10242, 10497);
            if (n5 > 1) {
                this.currentGL.glTexParameteri(n8, 10243, 10497);
                if (n5 > 2) {
                    this.currentGL.glTexParameteri(n8, 32882, 10497);
                }
            }
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            switch (n5) {
                case 1: {
                    this.currentGL.glTexImage1D(n8, 0, 6408, n2, 0, 32993, 5121, (Buffer)intBuffer);
                    break;
                }
                case 2: {
                    this.currentGL.glTexImage2D(n8, 0, 6408, n2, n3, 0, 32993, 5121, (Buffer)intBuffer);
                    break;
                }
                case 3: {
                    this.currentGL.glTexImage3D(n8, 0, 6408, n2, n3, n4, 0, 32993, 5121, (Buffer)intBuffer);
                }
            }
            if (n6 != 0) {
                this.bindTextureIndex(n7, n6, 0);
            }
        }
        return n5;
    }

    public final boolean bindTextureIndex(int n, int n2, int n3) {
        boolean bl = false;
        if (this.currentGL != null && n2 != 0 && n3 < this.textureStagesAvailable && n > 0 && n < 3) {
            int n4 = 0;
            switch (n) {
                case 1: {
                    n4 = 3552;
                    break;
                }
                case 2: {
                    n4 = 3553;
                }
            }
            this.currentGL.glActiveTexture(33984 + n3);
            this.currentGL.glEnable(n4);
            this.currentGL.glBindTexture(n4, n2);
            this.boundTextureIndex[n3] = n2;
            this.boundTextureDimension[n3] = n;
            bl = true;
        }
        return bl;
    }

    public final void unbindTexture(int n, int n2) {
        if (this.currentGL != null && n2 < this.textureStagesAvailable && n == this.boundTextureDimension[n2]) {
            int n3 = 0;
            switch (n) {
                case 1: {
                    n3 = 3552;
                    break;
                }
                case 2: {
                    n3 = 3553;
                }
            }
            this.currentGL.glActiveTexture(33984 + n2);
            this.currentGL.glBindTexture(n3, 0);
            this.currentGL.glDisable(n3);
            this.boundTextureIndex[n2] = 0;
            this.boundTextureDimension[n2] = 0;
        }
    }

    public final int createShader(GL20GLSLCode gL20GLSLCode) {
        if (this.inRendering && !this.inScene) {
            String[] stringArray = new String[]{gL20GLSLCode.getShaderCodeVertex(false)};
            String[] stringArray2 = new String[]{gL20GLSLCode.getShaderCodeFragment()};
            if (this.programHandle != 0) {
                this.currentGL.glDeleteProgram(this.programHandle);
            }
            this.programHandle = this.currentGL.glCreateProgram();
            int n = this.currentGL.glCreateShader(35633);
            int n2 = this.currentGL.glCreateShader(35632);
            int[] nArray = new int[]{stringArray[0].length()};
            this.currentGL.glShaderSource(n, 1, stringArray, nArray, 0);
            nArray[0] = stringArray2[0].length();
            this.currentGL.glShaderSource(n2, 1, stringArray2, nArray, 0);
            this.currentGL.glCompileShader(n);
            if (this.checkGLObjectInfoLog(n, "VertexShader")) {
                this.currentGL.glCompileShader(n2);
                if (this.checkGLObjectInfoLog(n2, "FragmentShader")) {
                    this.currentGL.glAttachShader(this.programHandle, n);
                    this.currentGL.glAttachShader(this.programHandle, n2);
                    this.currentGL.glDeleteShader(n);
                    this.currentGL.glDeleteShader(n2);
                    this.currentGL.glLinkProgram(this.programHandle);
                    if (this.checkGLObjectInfoLog(this.programHandle, "Program")) {
                        System.out.println("YES!!!");
                    }
                }
            }
        }
        return 0;
    }

    public final void drawLine(Tuple3f tuple3f, Tuple3f tuple3f2) {
        if (this.inRendering) {
            this.currentGL.glBegin(1);
            this.currentGL.glVertex3f(tuple3f.x, tuple3f.y, tuple3f.z);
            this.currentGL.glVertex3f(tuple3f2.x, tuple3f2.y, tuple3f2.z);
            this.currentGL.glEnd();
        }
    }

    public final int writeArrayBuffer2f(float f, float f2) {
        int n = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 8) {
            this.arrayBuffer = this.arrayBuffer.putFloat(f);
            this.arrayBuffer = this.arrayBuffer.putFloat(f2);
            this.freeArrayBufferCapacityRestBytes -= 8;
            n = 2;
        }
        return n;
    }

    public final int writeArrayBuffer3f(float f, float f2, float f3) {
        int n = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 12) {
            this.arrayBuffer = this.arrayBuffer.putFloat(f);
            this.arrayBuffer = this.arrayBuffer.putFloat(f2);
            this.arrayBuffer = this.arrayBuffer.putFloat(f3);
            this.freeArrayBufferCapacityRestBytes -= 12;
            n = 3;
        }
        return n;
    }

    public final int writeArrayBuffer4f(float f, float f2, float f3, float f4) {
        int n = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 16) {
            this.arrayBuffer.putFloat(f);
            this.arrayBuffer.putFloat(f2);
            this.arrayBuffer.putFloat(f3);
            this.arrayBuffer.putFloat(f4);
            this.freeArrayBufferCapacityRestBytes -= 16;
            n = 4;
        }
        return n;
    }

    public final int writeArrayBufferfv(float[] fArray, int n) {
        int n2 = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= n * 4) {
            for (int i = 0; i < n; ++i) {
                this.arrayBuffer.putFloat(fArray[i]);
            }
            this.freeArrayBufferCapacityRestBytes -= n * 4;
            n2 = n;
        }
        return n2;
    }

    public final int writeArrayBuffer2i(int n, int n2) {
        int n3 = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 8) {
            this.arrayBuffer.putInt(n);
            this.arrayBuffer.putInt(n2);
            this.freeArrayBufferCapacityRestBytes -= 8;
            n3 = 2;
        }
        return n3;
    }

    public final int writeArrayBuffer3i(int n, int n2, int n3) {
        int n4 = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 12) {
            this.arrayBuffer.putInt(n);
            this.arrayBuffer.putInt(n2);
            this.arrayBuffer.putInt(n3);
            this.freeArrayBufferCapacityRestBytes -= 12;
            n4 = 3;
        }
        return n4;
    }

    public final int writeArrayBuffer4i(int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 16) {
            this.arrayBuffer.putInt(n);
            this.arrayBuffer.putInt(n2);
            this.arrayBuffer.putInt(n3);
            this.arrayBuffer.putInt(n4);
            this.freeArrayBufferCapacityRestBytes -= 16;
            n5 = 4;
        }
        return n5;
    }

    public final int writeArrayBufferiv(int[] nArray, int n) {
        int n2 = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= n * 4) {
            for (int i = 0; i < n; ++i) {
                this.arrayBuffer.putInt(nArray[i]);
            }
            this.freeArrayBufferCapacityRestBytes -= n * 4;
            n2 = n;
        }
        return n2;
    }

    public final int writeArrayBuffer2b(byte by, byte by2) {
        int n = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 2) {
            this.arrayBuffer.put(by);
            this.arrayBuffer.put(by2);
            this.freeArrayBufferCapacityRestBytes -= 2;
            n = 2;
        }
        return n;
    }

    public final int writeArrayBuffer3b(byte by, byte by2, byte by3) {
        int n = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 3) {
            this.arrayBuffer.put(by);
            this.arrayBuffer.put(by2);
            this.arrayBuffer.put(by3);
            this.freeArrayBufferCapacityRestBytes -= 3;
            n = 3;
        }
        return n;
    }

    public final int writeArrayBuffer4b(byte by, byte by2, byte by3, byte by4) {
        int n = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= 4) {
            this.arrayBuffer.put(by);
            this.arrayBuffer.put(by2);
            this.arrayBuffer.put(by3);
            this.arrayBuffer.put(by4);
            this.freeArrayBufferCapacityRestBytes -= 4;
            n = 4;
        }
        return n;
    }

    public final int writeArrayBufferbv(byte[] byArray, int n) {
        int n2 = 0;
        if (this.arrayBuffer != null && this.freeArrayBufferCapacityRestBytes >= n * 1) {
            this.arrayBuffer.put(byArray, 0, n);
            this.freeArrayBufferCapacityRestBytes -= n * 1;
            n2 = n;
        }
        return n2;
    }

    public final int writeElementArrayBuffer2f(float f, float f2) {
        int n = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 8) {
            this.elementArrayBuffer.putFloat(f);
            this.elementArrayBuffer.putFloat(f2);
            this.freeElementArrayBufferCapacityRestBytes -= 8;
            n = 2;
        }
        return n;
    }

    public final int writeElementArrayBuffer3f(float f, float f2, float f3) {
        int n = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 12) {
            this.elementArrayBuffer.putFloat(f);
            this.elementArrayBuffer.putFloat(f2);
            this.elementArrayBuffer.putFloat(f3);
            this.freeElementArrayBufferCapacityRestBytes -= 12;
            n = 3;
        }
        return n;
    }

    public final int writeElementArrayBuffer4f(float f, float f2, float f3, float f4) {
        int n = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 16) {
            this.elementArrayBuffer.putFloat(f);
            this.elementArrayBuffer.putFloat(f2);
            this.elementArrayBuffer.putFloat(f3);
            this.elementArrayBuffer.putFloat(f4);
            this.freeElementArrayBufferCapacityRestBytes -= 16;
            n = 4;
        }
        return n;
    }

    public final int writeElementArrayBufferfv(float[] fArray, int n) {
        int n2 = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= n * 4) {
            for (int i = 0; i < n; ++i) {
                this.elementArrayBuffer.putFloat(fArray[i]);
            }
            this.freeElementArrayBufferCapacityRestBytes -= n * 4;
            n2 = n;
        }
        return n2;
    }

    public final int writeElementArrayBuffer2i(int n, int n2) {
        int n3 = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 8) {
            this.elementArrayBuffer.putInt(n);
            this.elementArrayBuffer.putInt(n2);
            this.freeElementArrayBufferCapacityRestBytes -= 8;
            n3 = 2;
        }
        return n3;
    }

    public final int writeElementArrayBuffer3i(int n, int n2, int n3) {
        int n4 = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 12) {
            this.elementArrayBuffer.putInt(n);
            this.elementArrayBuffer.putInt(n2);
            this.elementArrayBuffer.putInt(n3);
            this.freeElementArrayBufferCapacityRestBytes -= 12;
            n4 = 3;
        }
        return n4;
    }

    public final int writeElementArrayBuffer4i(int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 16) {
            this.elementArrayBuffer.putInt(n);
            this.elementArrayBuffer.putInt(n2);
            this.elementArrayBuffer.putInt(n3);
            this.elementArrayBuffer.putInt(n4);
            this.freeElementArrayBufferCapacityRestBytes -= 16;
            n5 = 4;
        }
        return n5;
    }

    public final int writeElementArrayBufferiv(int[] nArray, int n) {
        int n2 = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= n * 4) {
            for (int i = 0; i < n; ++i) {
                this.elementArrayBuffer.putInt(nArray[i]);
            }
            this.freeElementArrayBufferCapacityRestBytes -= n * 4;
            n2 = n;
        }
        return n2;
    }

    public final int writeElementArrayBuffer2b(byte by, byte by2) {
        int n = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 2) {
            this.elementArrayBuffer.put(by);
            this.elementArrayBuffer.put(by2);
            this.freeElementArrayBufferCapacityRestBytes -= 2;
            n = 2;
        }
        return n;
    }

    public final int writeElementArrayBuffer3b(byte by, byte by2, byte by3) {
        int n = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 3) {
            this.elementArrayBuffer.put(by);
            this.elementArrayBuffer.put(by2);
            this.elementArrayBuffer.put(by3);
            this.freeElementArrayBufferCapacityRestBytes -= 3;
            n = 3;
        }
        return n;
    }

    public final int writeElementArrayBuffer4b(byte by, byte by2, byte by3, byte by4) {
        int n = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= 4) {
            this.elementArrayBuffer.put(by);
            this.elementArrayBuffer.put(by2);
            this.elementArrayBuffer.put(by3);
            this.elementArrayBuffer.put(by4);
            this.freeElementArrayBufferCapacityRestBytes -= 4;
            n = 4;
        }
        return n;
    }

    public final int writeElementArrayBufferbv(byte[] byArray, int n) {
        int n2 = 0;
        if (this.elementArrayBuffer != null && this.freeElementArrayBufferCapacityRestBytes >= n * 1) {
            this.elementArrayBuffer.put(byArray, 0, n);
            this.freeElementArrayBufferCapacityRestBytes -= n * 1;
            n2 = n;
        }
        return n2;
    }
}

