/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.LineArray;
import de.grogra.imp3d.gl20.GL20GfxServer;
import de.grogra.imp3d.gl20.GL20ResourceShape;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;

public class GL20ResourceShapeLineStrip
extends GL20ResourceShape {
    private static final int LINE_ARRAY = 1;
    private static final int COLOR = 2;
    private int changeMask = -1;
    private LineArray lineArray = null;
    private Vector4f color = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private int startElementIndex;
    private int elementUsedCount;
    private int drawingFlags = 0;
    private int elementArrayBufferIndex = -1;
    private int arrayBufferIndex = -1;
    private int lastContextID = -1;

    public GL20ResourceShapeLineStrip() {
        super(65540);
    }

    public final void setLineArray(LineArray lineArray) {
        if (this.lineArray != null) {
            if (lineArray == null) {
                this.lineArray = null;
                this.changeMask |= 1;
            } else {
                this.lineArray = null;
            }
        }
        if (this.lineArray == null && lineArray != null) {
            this.lineArray = lineArray;
            this.lineArray.userObject = this;
            this.changeMask |= 1;
        }
    }

    public final void setColor(Vector4f vector4f) {
        if (!this.color.equals((Tuple4f)vector4f)) {
            this.color.set((Tuple4f)vector4f);
            this.changeMask |= 2;
        }
    }

    public void applyGeometry() {
        super.applyGeometry();
        this.draw();
    }

    private void draw() {
        if (this.drawingFlags != 0) {
            GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
            gL20GfxServer.setCurrentColor(this.color);
            gL20GfxServer.drawElementArrayBuffer(this.elementArrayBufferIndex, this.arrayBufferIndex, this.startElementIndex, this.elementUsedCount, this.drawingFlags);
        }
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0 || GL20GfxServer.getInstance().getContextID() != this.lastContextID) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
        int n = gL20GfxServer.getContextID();
        if (this.changeMask != 0 || n != this.lastContextID) {
            if (n == this.lastContextID && (this.changeMask & 1) != 0) {
                gL20GfxServer.deleteElementArrayBuffer(this.elementArrayBufferIndex);
                this.elementArrayBufferIndex = -1;
                gL20GfxServer.deleteArrayBuffer(this.arrayBufferIndex);
                this.arrayBufferIndex = -1;
            }
            if (n != this.lastContextID || (this.changeMask & 1) != 0) {
                this.drawingFlags = 0;
                this.arrayBufferIndex = -1;
                this.elementArrayBufferIndex = -1;
                if (this.lineArray != null) {
                    int n2;
                    int n3;
                    int n4;
                    this.elementArrayBufferIndex = gL20GfxServer.createElementArrayBuffer();
                    this.arrayBufferIndex = gL20GfxServer.createArrayBuffer();
                    this.drawingFlags |= 3;
                    int n5 = this.lineArray.vertices.size();
                    int n6 = this.lineArray.dimension * 4;
                    gL20GfxServer.openArrayBuffer(this.arrayBufferIndex, n5 * n6);
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (this.lineArray.dimension == 3) {
                            gL20GfxServer.writeArrayBuffer3f(this.lineArray.vertices.get(n4 * 3), this.lineArray.vertices.get(n4 * 3 + 1), this.lineArray.vertices.get(n4 * 3 + 2));
                            continue;
                        }
                        gL20GfxServer.writeArrayBuffer4f(this.lineArray.vertices.get(n4 * 4), this.lineArray.vertices.get(n4 * 4 + 1), this.lineArray.vertices.get(n4 * 4 + 2), this.lineArray.vertices.get(n4 * 4 + 3));
                    }
                    gL20GfxServer.closeArrayBuffer(this.arrayBufferIndex);
                    this.drawingFlags = this.lineArray.dimension == 3 ? (this.drawingFlags |= 0x2000) : (this.drawingFlags |= 0x4000);
                    this.drawingFlags |= 0;
                    this.drawingFlags |= 0;
                    this.drawingFlags |= 0x10000;
                    n4 = 0;
                    boolean bl = true;
                    for (n3 = 0; n3 < this.lineArray.lines.size(); ++n3) {
                        n2 = this.lineArray.lines.get(n3);
                        if (n2 < 0) {
                            bl = true;
                            continue;
                        }
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        ++n4;
                    }
                    gL20GfxServer.openElementArrayBuffer(this.elementArrayBufferIndex, n4 * 2 * 4);
                    n3 = -1;
                    n2 = -1;
                    this.startElementIndex = 0;
                    this.elementUsedCount = 0;
                    for (int i = 0; i < this.lineArray.lines.size(); ++i) {
                        int n7 = this.lineArray.lines.get(i);
                        if (n7 < 0) {
                            n2 = -1;
                            n3 = -1;
                            continue;
                        }
                        n2 = n7;
                        if (n3 >= 0 && n2 >= 0) {
                            this.elementUsedCount += gL20GfxServer.writeElementArrayBuffer2i(n3, n2);
                            n3 = n2;
                            n2 = -1;
                            continue;
                        }
                        n3 = n2;
                        n2 = -1;
                    }
                    gL20GfxServer.closeElementArrayBuffer(this.elementArrayBufferIndex);
                    this.drawingFlags |= 0x300000;
                }
                this.lastContextID = n;
            }
            this.changeMask = 0;
        }
        super.update();
    }

    public void destory() {
        GL20GfxServer gL20GfxServer = GL20GfxServer.getInstance();
        gL20GfxServer.deleteArrayBuffer(this.arrayBufferIndex);
        gL20GfxServer.deleteElementArrayBuffer(this.elementArrayBufferIndex);
        super.destroy();
    }
}

