/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.utility.FrameBufferObject;
import de.grogra.imp3d.glsl.utility.RenderBuffer;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class JOGL_Test {
    private int dss = 3;
    GLU glu = new GLU();
    public static final int DSS_NONE = 0;
    public static final int DSS_DEPTH_ONLY = 1;
    public static final int DSS_SEPERATE = 2;
    public static final int DSS_COMBINED = 3;
    private static final String[] DSS_DESCRIPTION = new String[]{"None", "depth only", "seperate", "combined"};

    public int getDepthStencilSetup() {
        return this.dss;
    }

    public void GLTest(GL gL, Logger logger) {
        int[] nArray = new int[1];
        String string = gL.glGetString(7938);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        int n = Integer.valueOf(stringTokenizer.nextToken());
        int n2 = Integer.valueOf(stringTokenizer.nextToken());
        logger.info("OpenGL Version is " + n + "." + n2);
        if (n < 2) {
            logger.info("Your GPU does not support OpenGL 2.x");
            throw new RuntimeException("OpenGL >=2.0 not found");
        }
        String string2 = gL.glGetString(35724);
        stringTokenizer = new StringTokenizer(string2, ". ");
        n = Integer.valueOf(stringTokenizer.nextToken());
        n2 = Integer.valueOf(stringTokenizer.nextToken());
        logger.info("GLSL Version is: " + n + "." + n2);
        boolean bl = n > 1 || n == 1 && n2 >= 1;
        boolean bl2 = false;
        gL.glGetIntegerv(3379, nArray, 0);
        logger.info("Max Texturesize is: " + nArray[0]);
        bl &= nArray[0] >= 2048;
        gL.glGetIntegerv(3414, nArray, 0);
        logger.info("Depth is: " + nArray[0]);
        bl &= nArray[0] >= 24;
        bl2 = gL.isExtensionAvailable("GL_EXT_packed_depth_stencil");
        logger.info("Testing GL_EXT_packed_depth_stencil: " + bl2);
        bl &= bl2;
        bl2 = gL.isExtensionAvailable("GL_EXT_framebuffer_object");
        logger.info("Testing GL_EXT_framebuffer_object: " + bl2);
        bl &= bl2;
        bl2 = gL.isExtensionAvailable("GL_ARB_draw_buffers");
        logger.info("Testing GL_ARB_draw_buffers: " + bl2);
        bl &= bl2;
        bl2 = gL.isFunctionAvailable("glGenRenderbuffersEXT");
        logger.info("Testing Method glGenRenderbuffersEXT: " + bl2);
        bl &= bl2;
        gL.glGetIntegerv(36063, nArray, 0);
        logger.info("Max Colorbuffer is: " + nArray[0]);
        bl &= nArray[0] >= 4;
        bl2 = gL.isExtensionAvailable("GL_ARB_half_float_pixel");
        logger.info("Testing GL_ARB_half_float_pixel: " + bl2);
        bl &= bl2;
        bl2 = gL.isExtensionAvailable("GL_ARB_texture_rectangle");
        logger.info("Testing GL_ARB_texture_rectangle: " + bl2);
        bl &= bl2;
        bl2 = gL.isExtensionAvailable("GL_ARB_texture_cube_map");
        logger.info("Testing GL_ARB_texture_cube_map: " + bl2);
        if (!(bl &= bl2)) {
            throw new RuntimeException("One or more OpenGL Extensions or Capabilites do not meet the minimum requirements to run Proteus");
        }
        logger.info("All Tests passed!");
        this.FBOTest(gL, logger);
    }

    private int testGLError(GL gL, Logger logger, String string) {
        int n = gL.glGetError();
        if (n != 0) {
            logger.info(string + this.glu.gluErrorString(n));
        } else {
            logger.info(string + "passed");
        }
        return n;
    }

    private int testFBOError(GL gL, Logger logger, String string) {
        int n = gL.glCheckFramebufferStatusEXT(36160);
        String string2 = "Framebuffer complete";
        switch (n) {
            case 36053: {
                break;
            }
            case 36058: {
                string2 = "Framebuffer incomplete format";
                break;
            }
            case 36054: {
                string2 = "Framebuffer incomplete attachment";
                break;
            }
            case 36057: {
                string2 = "Framebuffer incomplete dimensions";
                break;
            }
            case 36059: {
                string2 = "Framebuffer incomplete draw buffer";
                break;
            }
            case 36056: {
                string2 = "Framebuffer incomplete duplicate attachment";
                break;
            }
            case 36055: {
                string2 = "Framebuffer incomplete missing attachment";
                break;
            }
            case 36182: {
                string2 = "Framebuffer incomplete multisample";
                break;
            }
            case 36060: {
                string2 = "Framebuffer incomplete missing read buffer";
                break;
            }
            case 36265: {
                string2 = "Framebuffer incomplete layer count";
                break;
            }
            case 36264: {
                string2 = "Framebuffer incomplete layer targets";
                break;
            }
            case 36061: {
                string2 = "Framebuffer unsupported";
                break;
            }
            default: {
                string2 = "unknown error!";
            }
        }
        if (n != 36053) {
            logger.info(string + string2);
        } else {
            logger.info(string + string2);
        }
        return n;
    }

    private void FBOTest(GL gL, Logger logger) {
        int n = 0;
        this.dss = 3;
        OpenGLState openGLState = new OpenGLState();
        openGLState.initSize(1, 1);
        openGLState.setGL(gL);
        RenderBuffer renderBuffer = new RenderBuffer();
        renderBuffer.create(openGLState, 33190);
        n = this.testGLError(gL, logger, "GL_DEPTH_COMPONENT24_ARB: ");
        if (n != 0) {
            throw new RuntimeException("Creating DepthBuffer failed");
        }
        RenderBuffer renderBuffer2 = new RenderBuffer();
        renderBuffer2.create(openGLState, 35056);
        n = this.testGLError(gL, logger, "GL_DEPTH24_STENCIL8: ");
        RenderBuffer renderBuffer3 = new RenderBuffer();
        if (n != 0) {
            renderBuffer3.create(openGLState, 36168);
            n = this.testGLError(gL, logger, "GL_STENCIL_INDEX8_EXT: ");
            if (n != 0) {
                this.dss = 1;
                logger.info("OpenGL(Proteus) was not able to create a valid Stencil-Buffer.  Fallback to simplified output");
            } else {
                this.dss = 2;
            }
        }
        FrameBufferObject frameBufferObject = null;
        while (this.dss > 0) {
            if (frameBufferObject == null) {
                frameBufferObject = new FrameBufferObject();
            } else {
                frameBufferObject.delete(openGLState, false);
            }
            frameBufferObject.create(openGLState);
            if (this.testGLError(gL, logger, "FBO creation: ") != 0) {
                throw new RuntimeException("Failed creating empty Frame-Buffer-Object");
            }
            switch (this.dss) {
                case 3: {
                    frameBufferObject.attachDepthStencil(openGLState, renderBuffer2);
                    break;
                }
                case 2: {
                    frameBufferObject.attachStencilOnly(openGLState, renderBuffer3);
                }
                case 1: {
                    frameBufferObject.attachDepthOnly(openGLState, renderBuffer);
                }
            }
            gL.glDrawBuffer(0);
            gL.glReadBuffer(0);
            gL.glGetError();
            n = this.testFBOError(gL, logger, "FBO-Setup: Depth/Stencil[" + DSS_DESCRIPTION[this.dss] + "]: ");
            if (n == 36053) break;
            --this.dss;
        }
        if (this.dss == 0) {
            throw new RuntimeException("Not able to create depth/stencil FBO");
        }
        logger.info("Will use \"" + DSS_DESCRIPTION[this.dss] + "\"-depth/stencil buffer");
        renderBuffer2.delete(openGLState, false);
        renderBuffer3.delete(openGLState, false);
        renderBuffer.delete(openGLState, false);
        frameBufferObject.delete(openGLState, false);
        gL.glGetError();
    }
}

