/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import de.grogra.imp3d.RenderState;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Calendar;
import java.util.Date;

public class Measures {
    long[][] passDiffs = new long[7][1000];
    long[] timeDiffs = new long[1000];
    String currentFileName;
    boolean redraw = false;
    static Measures _inst = null;
    long deltaTime = 0L;
    int counter = 1001;
    int all;
    int rend;

    private Measures() {
    }

    public void setRPTimeDiff(int n, long l) {
        if (n < 0 || n > 6 || this.counter < 0 || this.counter > 999) {
            return;
        }
        this.passDiffs[n][this.counter] = l;
    }

    public void printRPSummary() {
        int n;
        long[] lArray = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L};
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 1000; ++j) {
                int n2 = i;
                lArray[n2] = lArray[n2] + this.passDiffs[i][j];
            }
        }
        long l = 0L;
        for (n = 0; n < 7; ++n) {
            int n3 = n;
            lArray[n3] = lArray[n3] / 1000L;
            l += lArray[n];
        }
        System.out.println("Cache\tDepth\tLight\tBack\tTone\tTools\tPresent\tSum");
        for (n = 0; n < 7; ++n) {
            System.out.printf("%.2f\t", Float.valueOf((float)lArray[n] / 1000000.0f));
        }
        System.out.println(l);
    }

    void setTimeDiff(long l) {
        this.timeDiffs[this.counter] = l;
    }

    public void setCurrentFileName(String string) {
        this.currentFileName = string;
    }

    public void printSummary() {
        long l = this.timeDiffs[0];
        long l2 = this.timeDiffs[0];
        long l3 = this.timeDiffs[0];
        for (int i = 1; i < 1000; ++i) {
            long l4 = this.timeDiffs[i];
            l += l4;
            l2 = l4 < l2 ? l4 : l2;
            l3 = l4 > l3 ? l4 : l3;
        }
        System.out.println("Average:\tMin:\t\tMax:\t\t~FPS");
        System.out.printf("%.2f\t\t%.2f\t\t%.2f\t\t%.2f\n", Float.valueOf((float)(l /= 1000L) / 1000000.0f), Float.valueOf((float)l2 / 1000000.0f), Float.valueOf((float)l3 / 1000000.0f), Float.valueOf(1.0E9f / (float)l));
        System.out.println("All: " + this.all + "\tRend: " + this.rend);
    }

    public void setRedraw(boolean bl) {
        this.redraw = bl;
    }

    public boolean shouldRedraw() {
        if (this.counter >= 0 && this.counter < 1000) {
            return this.redraw;
        }
        return false;
    }

    public void saveTimeDiffSummary() {
        try {
            FileWriter fileWriter = new FileWriter(this.currentFileName + ".csv");
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("" + this.timeDiffs[0]);
            for (int i = 1; i < 1000; ++i) {
                bufferedWriter.write(";" + this.timeDiffs[i]);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
    }

    public static Measures getInstance() {
        if (_inst == null) {
            _inst = new Measures();
        }
        return _inst;
    }

    public void restartNow() {
        this.counter = -5;
    }

    public void setCounter(int n) {
        this.counter = n;
    }

    public void setData(int n, int n2) {
        this.all = n;
        this.rend = n2;
    }

    public void stopTimer(RenderState renderState) {
        if (this.counter < 0) {
            System.out.println("Starting in " + -this.counter);
            ++this.counter;
        }
        if (this.counter < 1000 && this.counter >= 0) {
            Measures.getInstance().setTimeDiff(System.nanoTime() - this.deltaTime);
            if (this.counter % 100 == 50) {
                System.out.print("" + this.counter / 100);
            }
            ++this.counter;
        }
        if (this.counter == 1000) {
            System.out.println();
            Measures.getInstance().printSummary();
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            Measures.getInstance().setCurrentFileName(renderState.getClass().getSimpleName() + date.getDate() + "-" + (date.getMonth() + 1) + "-" + (date.getYear() + 1900) + "_" + date.getHours() + "_" + date.getMinutes() + "_" + date.getSeconds());
            ++this.counter;
        }
    }

    public void startTimer() {
        this.deltaTime = System.nanoTime();
    }
}

