/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.light.GLSLLightShader;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.objects.DirectionalLight;
import javax.media.opengl.GL;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class GLSLDirectionalLight
extends GLSLLightShader {
    static final String DirLightPrologue = "void DirectionalLight(in vec3 normal,\nin vec3 ecPosition3, \nin float shininess,\nin vec3 lightDir,\nin float radientPower,\nin vec3 col0,\ninout vec3 diffuse,\ninout vec3 specular)";
    static final String DirLightPre = "     float nDotVP;\n     float nDotHV;\n     float pf;\n\t  vec3 \tR;\t  R = reflect(-lightDir, normal);\n     nDotVP = max(0.0, dot(normal, lightDir));\n";
    static final String DirLightPerspective = " nDotHV = max(0.0, dot(R, -normalize(ecPosition3)));\n";
    static final String DirLightParallel = " nDotHV = max(0.0, dot(R, vec3(0.0, 0.0, 1.0)));\n";
    static final String DirLightPost = " if ((nDotHV <= 0.0) || (shininess >= 65504.0))\n  pf = 0.0;\n else\n  pf = pow(nDotHV, shininess);\n diffuse  += col0 * nDotVP * radientPower;\n specular += col0 * pf * nDotVP * radientPower;";
    protected String lightDir;
    protected String col0;
    protected String radientPower;
    int dirLoc = -1;
    int rpLoc = -1;
    int colLoc = -1;

    public String getLightFunction() {
        String string = " vec3 normal = getEyeNormal(norm);\n DirectionalLight(normal.rgb, pos, shininess, " + this.lightDir + ", " + this.radientPower + ", " + this.col0 + ", " + "diff, spec);";
        return string;
    }

    public String[] getFragmentShader(Object object) {
        this.config.clearTmpVariables();
        this.lightDir = this.config.registerNewUniform(2);
        this.col0 = this.config.registerNewUniform(2);
        this.radientPower = this.config.registerNewUniform(0);
        this.config.registerFunc("vec3 getEyeNormal(vec2 encNorm)", " encNorm = encNorm*4.0-2.0;\n float f = dot(encNorm,encNorm);\n float g = sqrt(1.0-f*0.25);\n return vec3(encNorm*g,1.0-f*0.5);\n");
        this.config.registerFunc(DirLightPrologue, DirLightPre + (this.getLightShaderConfig().isPerspective() ? DirLightPerspective : DirLightParallel) + DirLightPost);
        return this.getLightShaderConfig().completeShader(this.getLightFunction());
    }

    public boolean needsRecompilation(Object object) {
        return false;
    }

    public Class instanceFor() {
        return DirectionalLight.class;
    }

    protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
        super.setupShader(gL, gLSLDisplay, object);
        this.dirLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.lightDir);
        this.rpLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.radientPower);
        this.colLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.col0);
    }

    protected void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
        LightPos lightPos = null;
        assert (object instanceof LightPos);
        lightPos = (LightPos)object;
        assert (lightPos.getLight() instanceof DirectionalLight);
        DirectionalLight directionalLight = (DirectionalLight)lightPos.getLight();
        Vector3d vector3d = new Vector3d(-lightPos.getLightDir().x, -lightPos.getLightDir().y, -lightPos.getLightDir().z);
        gLSLDisplay.getCurrentGLState().getWorldToView().transform(vector3d);
        gL.glUniform3f(this.dirLoc, (float)vector3d.x, (float)vector3d.y, (float)vector3d.z);
        this.spec.set((Tuple3f)directionalLight.getColor());
        this.spec.scale(1.0 / this.spec.integrate());
        gL.glUniform3f(this.colLoc, this.spec.x, this.spec.y, this.spec.z);
        gL.glUniform1f(this.rpLoc, directionalLight.getPowerDensity());
    }

    public GLSLShader getInstance() {
        return new GLSLDirectionalLight();
    }
}

