/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light.shadow;

import de.grogra.imp3d.glsl.GLDisplay;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.GLSLUpdateCache;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.utility.Drawable;
import de.grogra.imp3d.glsl.utility.TextureRenderTarget;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GLSLShadowMap
extends TextureRenderTarget {
    GLSLUpdateCache newVisit = null;
    Matrix4d LightTransf;
    Matrix4d LightToView = new Matrix4d();
    Matrix4d ViewToClip = new Matrix4d();
    Vector3d camPos = new Vector3d();
    Vector3d camDir = null;
    boolean changed = true;
    static final int NO_ROTATION = -1;
    protected int GRAPH_STAMP = -1;
    protected boolean invalid = true;

    public void setLightTransf(LightPos lightPos) {
        this.LightTransf = lightPos.getLightTransform();
        this.changed = true;
    }

    public void setCamDir(Vector3d vector3d) {
        this.camDir = vector3d;
        this.changed = true;
    }

    public void setCamPos(Point4d point4d) {
        this.camPos.x = point4d.x;
        this.camPos.y = point4d.y;
        this.camPos.z = point4d.z;
        this.changed = true;
    }

    void setRotateFront(Matrix4d matrix4d) {
        matrix4d.m00 = 0.0;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = -1.0;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = 1.0;
        matrix4d.m12 = 0.0;
        matrix4d.m20 = 1.0;
        matrix4d.m21 = 0.0;
        matrix4d.m22 = 0.0;
        matrix4d.m30 *= 1.0;
        matrix4d.m31 *= 1.0;
        matrix4d.m32 *= -1.0;
    }

    void setRotateBack(Matrix4d matrix4d) {
        matrix4d.m00 = 0.0;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 1.0;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = 1.0;
        matrix4d.m12 = 0.0;
        matrix4d.m20 = -1.0;
        matrix4d.m21 = 0.0;
        matrix4d.m22 = 0.0;
        matrix4d.m30 *= -1.0;
        matrix4d.m31 *= 1.0;
        matrix4d.m32 *= 1.0;
    }

    void setRotateTop(Matrix4d matrix4d) {
        matrix4d.m00 = 1.0;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 0.0;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = 0.0;
        matrix4d.m12 = 1.0;
        matrix4d.m20 = 0.0;
        matrix4d.m21 = -1.0;
        matrix4d.m22 = 0.0;
        matrix4d.m30 *= 1.0;
        matrix4d.m31 *= -1.0;
        matrix4d.m32 *= 1.0;
    }

    void setRotateBottom(Matrix4d matrix4d) {
        matrix4d.m00 = 1.0;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 0.0;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = 0.0;
        matrix4d.m12 = -1.0;
        matrix4d.m20 = 0.0;
        matrix4d.m21 = 1.0;
        matrix4d.m22 = 0.0;
        matrix4d.m30 *= 1.0;
        matrix4d.m31 *= 1.0;
        matrix4d.m32 *= -1.0;
    }

    void setRotateLeft(Matrix4d matrix4d) {
        matrix4d.m00 = -1.0;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 0.0;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = 1.0;
        matrix4d.m12 = 0.0;
        matrix4d.m20 = 0.0;
        matrix4d.m21 = 0.0;
        matrix4d.m22 = -1.0;
        matrix4d.m30 *= -1.0;
        matrix4d.m31 *= 1.0;
        matrix4d.m32 *= -1.0;
    }

    void setRotateRight(Matrix4d matrix4d) {
        matrix4d.m00 = 1.0;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 0.0;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = 1.0;
        matrix4d.m12 = 0.0;
        matrix4d.m20 = 0.0;
        matrix4d.m21 = 0.0;
        matrix4d.m22 = 1.0;
        matrix4d.m30 *= 1.0;
        matrix4d.m31 *= 1.0;
        matrix4d.m32 *= 1.0;
    }

    public Matrix4d getLightToView() {
        return this.getLightToView(-1);
    }

    public Matrix4d getLightToView(int n) {
        if (this.changed || n > 0) {
            this.LightToView = new Matrix4d(this.LightTransf);
            switch (n) {
                case 0: {
                    this.setRotateFront(this.LightToView);
                    break;
                }
                case 1: {
                    this.setRotateBack(this.LightToView);
                    break;
                }
                case 2: {
                    this.setRotateTop(this.LightToView);
                    break;
                }
                case 3: {
                    this.setRotateBottom(this.LightToView);
                    break;
                }
                case 4: {
                    this.setRotateRight(this.LightToView);
                    break;
                }
                case 5: {
                    this.setRotateLeft(this.LightToView);
                    break;
                }
            }
            this.LightToView.invert();
        }
        return this.LightToView;
    }

    public Matrix4d getViewToClip() {
        return this.ViewToClip;
    }

    public void setInvalid() {
        this.invalid = true;
        this.GRAPH_STAMP = -1;
    }

    protected void renderCachedScene(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Matrix4d matrix4d) {
        GLDisplay.GLVisitor gLVisitor = gLSLDisplay.getVisitor();
        if (this.newVisit == null) {
            this.newVisit = new GLSLUpdateCache(gLSLDisplay);
        }
        this.newVisit.init(gLSLDisplay.getRenderGraphState(), matrix4d, 0);
        gLSLDisplay.setVisitor(this.newVisit);
        GL gL = openGLState.getGL();
        openGLState.enable('\u0006');
        openGLState.setFaceCullingMode(1028);
        for (Drawable drawable : openGLState.deferredSolidRenderable) {
            drawable.activateGLSLShader(openGLState, gLSLDisplay, true);
            drawable.draw(gLSLDisplay, this.newVisit, matrix4d, false);
        }
        openGLState.setFaceCullingMode(1029);
        openGLState.disable('\u0006');
        for (Drawable drawable : openGLState.deferredTranspRenderable) {
            drawable.activateGLSLShader(openGLState, gLSLDisplay, true, true);
            drawable.draw(gLSLDisplay, this.newVisit, matrix4d, false);
        }
        gLSLDisplay.setVisitor(gLVisitor);
    }

    public abstract void fill(GLSLDisplay var1, OpenGLState var2);

    public abstract boolean create(GL var1);

    public abstract boolean create(GL var1, int var2, int var3);

    public abstract int getSize();

    public abstract GLSLShadowMap getInstance();

    public abstract Class<?> getDefaultLightType();

    public abstract void setupTextureMatrices(OpenGLState var1, Matrix4d var2, LightPos var3);

    void setBiasMatrix(Matrix4d matrix4d) {
        matrix4d.m00 = 0.5;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 0.0;
        matrix4d.m03 = 0.5;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = 0.5;
        matrix4d.m12 = 0.0;
        matrix4d.m13 = 0.5;
        matrix4d.m20 = 0.0;
        matrix4d.m21 = 0.0;
        matrix4d.m22 = 0.5;
        matrix4d.m23 = 0.5;
        matrix4d.m30 = 0.0;
        matrix4d.m31 = 0.0;
        matrix4d.m32 = 0.0;
        matrix4d.m33 = 1.0;
    }

    @Override
    public void delete(OpenGLState openGLState, boolean bl) {
        super.delete(openGLState, bl);
        this.setInvalid();
    }
}

