/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light.shadow;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.light.shadow.GLSLShadowMap;
import de.grogra.imp3d.objects.SpotLight;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLShadowPerspective
extends GLSLShadowMap {
    float FoV = 1.0471976f;
    private static final int DEFAULT_SIZE = 1024;

    @Override
    public Matrix4d getViewToClip() {
        this.getProjectionMatrix(this.ViewToClip, this.FoV, 0.01f, 2000.0f);
        return this.ViewToClip;
    }

    void getProjectionMatrix(Matrix4d matrix4d, float f, float f2, float f3) {
        double d = f2 - f3;
        double d2 = 1.0 / Math.tan((double)f / 2.0);
        matrix4d.setZero();
        matrix4d.m00 = d2;
        matrix4d.m11 = d2;
        matrix4d.m22 = (double)(f3 + f2) / d;
        matrix4d.m32 = -1.0;
        matrix4d.m23 = (double)(2.0f * (f2 * f3)) / d;
    }

    public void setFieldOfView(float f) {
        this.FoV = f;
    }

    @Override
    public boolean create(GL gL) {
        return this.create(gL, 1024, 1024);
    }

    @Override
    public boolean create(GL gL, int n, int n2) {
        if (this.index != 0) {
            if (this.width == n && this.height == n2) {
                return true;
            }
            this.delete(gL, false);
        }
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        this.index = nArray[0];
        gL.glBindTexture(3553, this.index);
        gL.glTexImage2D(3553, 0, 33190, n, n2, 0, 6402, 5121, null);
        gL.glTexParameterf(3553, 10242, 33071.0f);
        gL.glTexParameterf(3553, 10243, 33071.0f);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexParameteri(3553, 34892, 34894);
        gL.glTexParameteri(3553, 34893, 515);
        this.type = 5121;
        this.width = n;
        this.height = n2;
        this.type = 6402;
        this.internalFormat = 6402;
        this.texType = 3553;
        return gL.glGetError() != 0;
    }

    @Override
    public void fill(GLSLDisplay gLSLDisplay, OpenGLState openGLState) {
        int n = gLSLDisplay.getView().getGraph().getStamp();
        if (n == this.GRAPH_STAMP) {
            return;
        }
        if (!this.invalid) {
            return;
        }
        GL gL = openGLState.getGL();
        gL.glFramebufferTexture2DEXT(36160, 36096, 3553, this.getIndex(), 0);
        gL.glClear(256);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        openGLState.loadMatrixd(this.getViewToClip());
        gL.glMatrixMode(5888);
        Matrix4d matrix4d = this.getLightToView();
        gL.glPolygonOffset(1.1f, 4.0f);
        gL.glEnable(32823);
        this.renderCachedScene(gLSLDisplay, openGLState, matrix4d);
        gL.glDisable(32823);
        this.GRAPH_STAMP = n;
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public GLSLShadowMap getInstance() {
        return new GLSLShadowPerspective();
    }

    @Override
    public void setLightTransf(LightPos lightPos) {
        super.setLightTransf(lightPos);
        this.setFieldOfView(((SpotLight)lightPos.getLight()).getOuterAngle() * 2.0f);
    }

    @Override
    public void setupTextureMatrices(OpenGLState openGLState, Matrix4d matrix4d, LightPos lightPos) {
        GL gL = openGLState.getGL();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        Matrix4d matrix4d3 = new Matrix4d();
        this.setBiasMatrix(matrix4d3);
        matrix4d2.mul(matrix4d3);
        matrix4d2.mul(this.getViewToClip());
        matrix4d2.mul(this.getLightToView());
        matrix4d2.mul(matrix4d);
        gL.glActiveTexture(33991);
        gL.glBindTexture(3553, this.getIndex());
        gL.glMatrixMode(5890);
        gL.glActiveTexture(33986);
        openGLState.loadMatrixd(matrix4d2);
        gL.glMatrixMode(5888);
    }

    @Override
    public Class<?> getDefaultLightType() {
        return SpotLight.class;
    }
}

