/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderable;

import de.grogra.graph.GraphState;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderable.GLSLRenderable;
import de.grogra.imp3d.glsl.renderpass.RenderPass;
import de.grogra.imp3d.glsl.utility.GLSLManagedShader;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.objects.Plane;
import de.grogra.imp3d.shading.Shader;
import javax.media.opengl.GL;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.SingularMatrixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLPlane
extends GLSLRenderable {
    Matrix4d localToGlobal = new Matrix4d();
    GLSLShader plane = null;
    Matrix3f mat = new Matrix3f();
    int normalMatLoc = -1;

    @Override
    public void drawAlt(OpenGLState openGLState, GLSLDisplay gLSLDisplay) {
        try {
            this.localToGlobal.invert(gLSLDisplay.getTransformation(null));
        }
        catch (SingularMatrixException singularMatrixException) {
            return;
        }
        GL gL = openGLState.getGL();
        gL.glPushAttrib(2048);
        gL.glMatrixMode(5890);
        gL.glActiveTexture(33986);
        openGLState.loadMatrixd(gLSLDisplay.getTransformation(null));
        gL.glActiveTexture(33987);
        openGLState.loadMatrixd(this.localToGlobal);
        gL.glMatrixMode(5888);
        this.normalMatLoc = gL.glGetUniformLocation(openGLState.getActiveShader(), "normalMat");
        gLSLDisplay.getTransformation(null).getRotationScale(this.mat);
        this.mat.invert();
        this.mat.transpose();
        gL.glUniformMatrix3fv(this.normalMatLoc, 1, false, gLSLDisplay.getCurrentGLState().toGLMatrix3f(this.mat), 0);
        RenderPass.ViewOrtho(openGLState);
        Camera camera = gLSLDisplay.getView3D().getCamera();
        RenderPass.drawPrjQuad(openGLState, camera);
        RenderPass.ViewPerspective(openGLState);
        gL.glPopAttrib();
    }

    @Override
    public void draw(OpenGLState openGLState, RenderState renderState) {
        renderState.drawPlane(null, 0, null);
    }

    @Override
    public GLSLRenderable getInstance() {
        return this;
    }

    @Override
    public Class<?> instanceFor() {
        return Plane.class;
    }

    @Override
    public void updateInstance(Object object, Object object2, boolean bl, GraphState graphState) {
    }

    @Override
    public boolean isShaderDependant(boolean bl) {
        return true;
    }

    @Override
    public void activateShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay, Shader shader, boolean bl) {
        if (bl) {
            if (this.plane == null) {
                this.plane = new PlaneShader(openGLState);
            }
            this.plane.activateShader(openGLState, gLSLDisplay, null);
        } else {
            openGLState.setShaderConfSwitch(5);
            gLSLDisplay.findAndActivateShader(shader);
            openGLState.setShaderConfSwitch(0);
        }
    }

    @Override
    public GLSLManagedShader findShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay, Shader shader) {
        openGLState.setShaderConfSwitch(5);
        GLSLManagedShader gLSLManagedShader = gLSLDisplay.findShader(shader);
        openGLState.setShaderConfSwitch(0);
        return gLSLManagedShader;
    }

    class PlaneShader
    extends GLSLShader {
        final String[] vStdSrc;
        final String[] simpleDepthF;

        public PlaneShader(OpenGLState openGLState) {
            super(openGLState);
            this.vStdSrc = new String[]{"#version 110\n", "varying vec3 normal;\n", "varying vec2 TexUnit2;\n", "void main() {", "  gl_Position = ftransform();", "  TexUnit2 = gl_MultiTexCoord1.st;", "}"};
            this.simpleDepthF = new String[]{"#version 110\n", "varying vec2 TexUnit2;\n", "uniform mat3 normalMat;\n", "void main(void)\n", "{\n", "  vec3 normal = normalize(normalMat * vec3(0.0, 0.0, 1.0));", "  vec4 base = (gl_TextureMatrix[2] * vec4(0.0, 0.0, 0.0, 1.0));", "  vec3 pos = normalize(vec3(TexUnit2, -1.0));\n", "  float dotP = dot(normal, pos);", "  if (dotP >= 0.0) {\n", "    discard;\n", "  }\n", "  float t = ( dot(base.xyz, normal) ) / dotP;\n ", "  if(t < 0.0) discard;", "  vec4 clipPos = vec4(t * pos, 1.0);", "  clipPos = gl_TextureMatrix[0] * clipPos;", "  gl_FragDepth =  clamp((clipPos.z / clipPos.w)*0.5+0.5, 0.0, 1.0);", "}"};
        }

        protected String[] getVertexShader(Object object) {
            return this.vStdSrc;
        }

        protected String[] getFragmentShader(Object object) {
            return this.simpleDepthF;
        }
    }
}

