/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderable;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.glsl.renderable.GLSLPlaneInput;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.vecmath.Matrix3f;

public class PlaneMaterialConfiguration
extends MaterialConfiguration {
    int normalMatLoc = -1;
    Matrix3f mat = new Matrix3f();

    public String[] completeShader(Result[] resultArray) {
        int n;
        String string = "#version " + this.version + "\n#extension GL_ARB_draw_buffers : enable\n";
        string = string + "uniform mat3 normalMat;\n";
        for (n = 0; n < this.uniform.size(); ++n) {
            string = string + (String)this.uniform.elementAt(n);
        }
        if (this.uniform.size() > 0) {
            string = string + "\n";
        }
        for (n = 0; n < this.sampler.size(); ++n) {
            string = string + (String)this.sampler.elementAt(n);
        }
        if (this.sampler.size() > 0) {
            string = string + "\n";
        }
        for (n = 0; n < this.customSampler.size(); ++n) {
            string = string + (String)this.customSampler.elementAt(n);
        }
        if (this.customSampler.size() > 0) {
            string = string + "\n";
        }
        string = string + "varying vec2 TexUnit2;\n";
        for (n = 0; n < this.constVar.size(); ++n) {
            string = string + (String)this.constVar.elementAt(n);
        }
        if (this.constVar.size() > 0) {
            string = string + "\n";
        }
        Iterator iterator = this.funcMap.values().iterator();
        while (iterator.hasNext()) {
            string = string + (String)iterator.next();
        }
        if (this.funcMap.size() > 0) {
            string = string + "\n";
        }
        string = string + "float packToFloat(vec2 val) {\n val = clamp(val, 0.0, 1.0);\n val.x = floor(val.x * 255. / 256. * 128.) * 0.0078125 * 16.;\n vec2 X = vec2(floor(val.x), fract(val.x));\n return (X.y + (val.y * 255. / 257. * 0.125) + (1.0)) * exp2(X.x);\n}\n\n";
        string = string + "vec2 encodeNormal(vec3 normal){\n float f = sqrt(8.0*normal.z+8.0);\n return normal.xy / f + 0.5;\n}\n\n";
        string = string + "void main(void)\n{\n\tvec3 plane_normal = normalize(normalMat * vec3(0.0, 0.0, 1.0));\tvec4 base = (gl_TextureMatrix[2] * vec4(0.0, 0.0, 0.0, 1.0));\tvec3 viewPos = normalize(vec3(TexUnit2, -1.0));\n\tfloat dotP = dot(plane_normal, viewPos);\tif (dotP >= 0.0) {\n\t\tdiscard;\n\t}\n   float t = ( dot(base.xyz, plane_normal) ) / dotP;\n \tif(t < 0.0) discard;\tvec4 plane_pos = vec4(t * viewPos, 1.0);\tvec4 local_plane_pos = gl_TextureMatrix[3] * plane_pos;\n\tvec2 plane_uv = local_plane_pos.xy;\n";
        for (int i = 0; i < this.var.size(); ++i) {
            string = string + " " + (String)this.var.elementAt(i);
        }
        if (this.var.size() > 0) {
            string = string + "\n";
        }
        if (resultArray[10].toString().length() > 0) {
            string = string + resultArray[10] + "\n";
        }
        string = string + " vec3 emissive = " + resultArray[6].convert(2) + ";\n";
        string = string + " vec3 diff_transp = " + resultArray[8].convert(2) + ";\n";
        string = string + " gl_FragData[0] = vec4(encodeNormal(plane_normal), " + resultArray[2].reduce(0) + ", " + resultArray[9].reduce(0) + ");\n";
        string = string + " gl_FragData[1] = vec4(" + resultArray[3].convert(2) + ",packToFloat(emissive.rg));\n";
        string = string + " gl_FragData[2] = vec4(" + resultArray[4].convert(2) + ", packToFloat(vec2(emissive.b, diff_transp.r)));\n";
        string = string + " gl_FragData[3] = vec4(" + resultArray[7].convert(2) + ",packToFloat(diff_transp.gb));\n";
        string = string + " plane_pos = gl_TextureMatrix[0] * plane_pos; gl_FragDepth =  clamp((plane_pos.z / plane_pos.w)*.5+.5, 0., 1.);";
        string = string + "}";
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    public void setupShader(GL gL, GLSLDisplay gLSLDisplay, int n) {
        super.setupShader(gL, gLSLDisplay, n);
        this.normalMatLoc = gL.glGetUniformLocation(n, "normalMat");
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, int n) {
        super.setupDynamicUniforms(gL, gLSLDisplay, n);
        gLSLDisplay.getTransformation(null).getRotationScale(this.mat);
        this.mat.invert();
        this.mat.transpose();
        gL.glUniformMatrix3fv(this.normalMatLoc, 1, false, gLSLDisplay.getCurrentGLState().toGLMatrix3f(this.mat), 0);
    }

    public ShaderConfiguration clone() {
        PlaneMaterialConfiguration planeMaterialConfiguration = new PlaneMaterialConfiguration();
        planeMaterialConfiguration.setThisToOther(this);
        return planeMaterialConfiguration;
    }

    public GLSLChannelMap getDefaultInputChannel() {
        return new GLSLPlaneInput();
    }
}

