/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class EdgeFilteringPass
extends FullRenderPass {
    GLSLShader cs = null;

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        openGLState.setDepthMask(true);
        openGLState.enable('\u0002');
        EdgeFilteringPass.ViewPerspective(openGLState);
        gL.glPopAttrib();
        EdgeFilteringPass.deactivateTextures(gL, 2, 34037);
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        openGLState.switchFloatRT();
        GLSLDisplay.printDebugInfoN("Render Light to: " + (4 + openGLState.getFloatRT()));
        openGLState.getHDRFBO().drawBuffer(openGLState, openGLState.getFloatRT());
        if (this.cs == null) {
            this.cs = new FilterEdgeShader(openGLState);
        }
        this.cs.activateShader(openGLState, gLSLDisplay, null);
        GLSLDisplay.printDebugInfoN("Rendering Light with Shader: " + this.cs);
        gL.glPushAttrib(2048);
        gL.glViewport(0, 0, openGLState.width, openGLState.height);
        EdgeFilteringPass.ViewOrtho(openGLState);
        openGLState.disable('\u0002');
        openGLState.disable('\u0001');
        openGLState.setDepthMask(false);
        openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 0, 0);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRTLast(), 1);
        openGLState.getAlphaFBO().bindAttachmentAsTexture(openGLState, 0, 5);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        EdgeFilteringPass.drawPrjQuad(openGLState, camera);
    }

    public void process(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        super.process(gLSLDisplay, openGLState, object);
    }

    class FilterEdgeShader
    extends GLSLShader {
        final String[] baseLightF;

        public FilterEdgeShader(OpenGLState openGLState) {
            super(openGLState);
            this.baseLightF = new String[]{"uniform sampler2DRect firstTex;\n", "uniform sampler2DRect inputTex;\n", "uniform vec2 e_barrier;\n", "uniform vec2 e_weights;\n", "uniform vec2 e_kernel;\n", "vec3 getEyeNormal(vec2 encNorm){", " encNorm = encNorm*4.0-2.0;\n", " float f = dot(encNorm,encNorm);\n", " float g = sqrt(1.0-f*0.25);\n", " return vec3(encNorm*g,1.0-f*0.5);\n", "}", "void main() {\n", "\tvec2 tc0 = gl_FragCoord.st;\n", "\tvec2 tc1 = tc0 + vec2(-1.,-1.);\n", "\tvec2 tc2 = tc0 + vec2(1.,1.);\n", "\tvec2 tc3 = tc0 + vec2(1.,-1.);\n", "\tvec2 tc4 = tc0 + vec2(-1.,1.);\n", "\tvec4 tc5 = tc0.stst + vec4(-1.,0.,1.,0.);\n", "\tvec4 tc6 = tc0.stst + vec4(0.,-1.,0.,1.);\n", "\tvec4 dn0 = texture2DRect(firstTex, tc0);\n", "\tvec4 dn1 = texture2DRect(firstTex, tc1);\n", "\tvec4 dn2 = texture2DRect(firstTex, tc2);\n", "\tvec4 dn3 = texture2DRect(firstTex, tc3);\n", "\tvec4 dn4 = texture2DRect(firstTex, tc4);\n", " vec3 n0 = getEyeNormal(dn0.ba);\n", " vec4 nd;\n", " nd.x = dot(n0, getEyeNormal(dn1.ba));\n", " nd.y = dot(n0, getEyeNormal(dn2.ba));\n", " nd.z = dot(n0, getEyeNormal(dn3.ba));\n", " nd.w = dot(n0, getEyeNormal(dn4.ba));\n", " nd -= vec4(e_barrier.x);\n", " nd = step(0.0, nd);\n", " float ne = clamp(dot(nd, vec4(e_weights.x)), 0.0, 1.0);\n", " vec4 tc5r = tc5.zwxy;\n", " vec4 tc6r = tc6.zwxy;\n", "float dc = -dn0.r;\n", "vec4 dd;\n", "dd.x = -dn1.r -\n", "       dn2.r;\n", "dd.y = -dn3.r -\n", "       dn4.r;\n", "dd.z = -texture2DRect(firstTex, tc5.st).r -\n", "       texture2DRect(firstTex, tc5r.st).r;\n", "dd.w = -texture2DRect(firstTex, tc6.st).r -\n", "       texture2DRect(firstTex, tc6r.st).r;\n", "dd = abs(2.0 * dc - dd) - vec4(e_barrier.y);\n", "dd = step(0.0, dd);\n", "float de = clamp(dot(dd, vec4(e_weights.y)), 0.0, 1.0);\n", "float w = de * ne * e_kernel.x;", "vec4 s = texture2DRect(inputTex, tc0);\n", "vec4 s0 = texture2DRect(inputTex, tc0 + vec2(-1.));\n", "vec4 s1 = texture2DRect(inputTex, tc0 + vec2(1.));\n", "vec4 s2 = texture2DRect(inputTex, tc0 + vec2(-1.,1.));\n", "vec4 s3 = texture2DRect(inputTex, tc0 + vec2(1.,-1.));\n", "\tgl_FragColor = vec4(s * (1.0-w) + (s0 + s1 + s2 + s3)/4.*w);\n", "}"};
        }

        public String[] getFragmentShader(Object object) {
            return this.baseLightF;
        }

        public boolean needsRecompilation(Object object) {
            return false;
        }

        public Class instanceFor() {
            return null;
        }

        public void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "firstTex");
            int n2 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "inputTex");
            gL.glUniform1i(n, 0);
            gL.glUniform1i(n2, 1);
            int n3 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "e_barrier");
            gL.glUniform2f(n3, 0.8f, 0.05f);
            int n4 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "e_weights");
            gL.glUniform2f(n4, 1.0f, 1.0f);
            int n5 = gL.glGetUniformLocation(this.getShaderProgramNumber(), "e_kernel");
            gL.glUniform2f(n5, 1.0f, 1.0f);
        }

        public GLSLShader getInstance() {
            return this;
        }
    }
}

