/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class PrepareAlphaPass
extends FullRenderPass {
    GLSLShader cs = null;

    protected int getID() {
        return 2;
    }

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof LightPos);
        GL gL = openGLState.getGL();
        openGLState.disable('\u0001');
        openGLState.disable('\u0005');
        gL.glBlendFunc(770, 771);
        openGLState.setDepthMask(true);
        openGLState.enable('\u0002');
        PrepareAlphaPass.ViewPerspective(openGLState);
        gL.glPopAttrib();
        PrepareAlphaPass.deactivateTextures(gL, 1);
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        GL gL = openGLState.getGL();
        openGLState.getAlphaFBO().bind(openGLState);
        gL.glPushAttrib(2048);
        gL.glViewport(0, 0, openGLState.width, openGLState.height);
        GLSLDisplay.printDebugInfoN("Preparing Alpha");
        gL.glReadBuffer(36064);
        gL.glDrawBuffer(36064);
        if (this.cs == null) {
            this.cs = new SetupAlphaShader(openGLState);
        }
        this.cs.activateShader(openGLState, gLSLDisplay, null);
        PrepareAlphaPass.ViewOrtho(openGLState);
        openGLState.disable('\u0002');
        openGLState.setDepthMask(false);
        openGLState.getDeferredShadingFBO().bindAttachmentAsTexture(openGLState, 3, 0);
        openGLState.enable('\u0001');
        openGLState.enable('\u0005');
        openGLState.disable('\u0000');
        gL.glBlendFunc(774, 0);
        gL.glStencilFunc(514, 1, 1);
        gL.glStencilOp(7680, 7680, 7680);
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        Camera camera = gLSLDisplay.getView3D().getCamera();
        PrepareAlphaPass.drawPrjQuad(openGLState, camera);
    }

    class SetupAlphaShader
    extends GLSLShader {
        final String[] baseLightF;

        public SetupAlphaShader(OpenGLState openGLState) {
            super(openGLState);
            this.baseLightF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect fourthTex;\n", "void main() {\n", "\tvec4 alpha = texture2DRect(fourthTex, gl_FragCoord.st);\n", "\tgl_FragColor = vec4(alpha.rgb, 1.0);\n", "}"};
        }

        public String[] getFragmentShader(Object object) {
            return this.baseLightF;
        }

        public boolean needsRecompilation(Object object) {
            return false;
        }

        public Class instanceFor() {
            return null;
        }

        public void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "fourthTex");
            gL.glUniform1i(n, 0);
        }

        public GLSLShader getInstance() {
            return this;
        }
    }
}

