/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.renderpass;

import de.grogra.imp3d.Camera;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.renderpass.FullRenderPass;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import javax.media.opengl.GL;

public class ReduceImagePass
extends FullRenderPass {
    GLSLShader luminanceShader = null;
    GLSLShader reduceShader = null;
    int sourceDimLoc = -1;

    protected void epilogue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        GL gL = openGLState.getGL();
        ReduceImagePass.deactivateTextures(gL, 2);
        openGLState.setDepthMask(true);
        ReduceImagePass.ViewPerspective(openGLState);
        openGLState.enable('\u0002');
        openGLState.disable('\u0001');
        GLSLDisplay.printDebugInfoN("-- - ------------- --");
    }

    protected void prologue(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        openGLState.disable('\u0002');
        openGLState.disable('\u0001');
        openGLState.setDepthMask(false);
        ReduceImagePass.ViewOrtho(openGLState);
        GLSLDisplay.printDebugInfoN("-- - Reduce Image - --");
    }

    protected void render(GLSLDisplay gLSLDisplay, OpenGLState openGLState, Object object) {
        assert (object instanceof Integer);
        Camera camera = gLSLDisplay.getView3D().getCamera();
        GL gL = openGLState.getGL();
        gL.glPushAttrib(2048);
        if (this.luminanceShader == null) {
            this.luminanceShader = new LuminanceShader(openGLState);
        }
        this.luminanceShader.activateShader(openGLState, gLSLDisplay, null);
        gL.glUniform2f(this.sourceDimLoc, (float)openGLState.width, (float)openGLState.height);
        int n = Math.max(openGLState.height, openGLState.width);
        int n2 = Math.min(openGLState.height, openGLState.width);
        int n3 = 1;
        int n4 = 0;
        while (2 * n3 < n && n3 < n2) {
            n3 *= 3;
            ++n4;
        }
        int n5 = --n4 % 2 * 2;
        openGLState.getDeferredShadingFBO().drawBuffers(openGLState, 2, n5);
        openGLState.getHDRFBO().bindAttachmentAsTexture(openGLState, openGLState.getFloatRT(), 0);
        GLSLDisplay.printDebugInfoN("reduced to " + n5 + " with Size " + (n3 /= 3));
        ReduceImagePass.drawPrjQuad(openGLState, camera, 0.0f, (float)(openGLState.height - n3) + 0.1f, (float)n3 - 0.1f, (float)n3 - 0.1f);
        --n4;
        n3 /= 3;
        if (this.reduceShader == null) {
            this.reduceShader = new ReduceShader(openGLState);
        }
        this.reduceShader.activateShader(openGLState, gLSLDisplay, null);
        while (n4 >= 0) {
            openGLState.getDeferredShadingFBO().drawBuffers(openGLState, 2, (n5 + 2) % 4);
            openGLState.getDeferredShadingFBO().bindAllAttachmentsAsTextures(openGLState, 2, n5);
            GLSLDisplay.printDebugInfoN("reduced to " + (n5 + 2) % 4 + " with Size " + n3);
            ReduceImagePass.drawPrjQuad(openGLState, camera, 0.0f, (float)(openGLState.height - n3) + 0.1f, (float)n3 - 0.1f, (float)n3 - 0.1f);
            n5 = n4 % 2 * 2;
            n3 /= 3;
            --n4;
        }
        gL.glPopAttrib();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReduceShader
    extends GLSLShader {
        final String[] shaderF;

        public ReduceShader(OpenGLState openGLState) {
            super(openGLState);
            this.shaderF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect SourceTextureSampler;", "uniform sampler2DRect AverageTextureSampler;", "void main(){", " float average = 0.0;", " vec3 colAverage = vec3(0.0);", " float minimum =  100000000000000000000.0;", " float maximum = -100000000000000000000.0;", " float maxRGB  = -100000000000000000000.0;", " vec4 color = vec4(0.0);", " vec4 color2 = vec4(0.0);", " vec3 Offsets3x3 = vec3(-1.0, 0.0, 1.0);", "for (int x = 0; x < 3; x++)", "{", "for (int y = 0; y < 3; y++)", "{", "vec2 vOffset = vec2(Offsets3x3[x], Offsets3x3[y]);", "color = texture2DRect(SourceTextureSampler, gl_FragCoord.st * 3.0 + vOffset);", "color2 = texture2DRect(AverageTextureSampler, gl_FragCoord.st * 3.0 + vOffset);", "colAverage += color2.rgb;", "minimum = min( minimum, color.r );", "average += color.g;", "maximum = max( maximum, color.b );", "maxRGB = max( maxRGB, color2.a );", "}", "}", "average /= 9.0;", "colAverage /= 9.0;", " gl_FragData[0] = vec4(minimum, average, maximum, 1.0);", " gl_FragData[1] = vec4(colAverage, maxRGB);", "}"};
        }

        @Override
        protected String[] getFragmentShader(Object object) {
            return this.shaderF;
        }

        @Override
        public GLSLShader getInstance() {
            return this;
        }

        @Override
        public Class<?> instanceFor() {
            return null;
        }

        @Override
        public boolean needsRecompilation(Object object) {
            return false;
        }

        @Override
        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "SourceTextureSampler");
            gL.glUniform1i(n, 0);
            n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "AverageTextureSampler");
            gL.glUniform1i(n, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LuminanceShader
    extends GLSLShader {
        final String[] shaderF;

        public LuminanceShader(OpenGLState openGLState) {
            super(openGLState);
            this.shaderF = new String[]{"#version 110\n", "#extension GL_ARB_texture_rectangle : enable\n", "uniform sampler2DRect SourceTextureSampler;", "uniform sampler2DRect AverageTextureSampler;", "uniform vec2 SourceSize;", "varying vec2 uv;", "void main(){", "vec3 LUMINANCE = vec3(0.2125, 0.7154, 0.0721);", "float average = 0.0;", "vec3 colAverage = vec3(0.0);", "float minimum =  100000000000000000000.0;", "float maximum = -100000000000000000000.0;", "float maxRGB  = -100000000000000000000.0;", "vec4 color = vec4(0.0);", "vec3 Offsets2x2 = vec3(-1.0, 0.0, 1.0);", "for (int x = 0; x < 3; x++)", "{", "for (int y = 0; y < 3; y++)", "{", "vec2 vOffset = vec2(Offsets2x2[x], Offsets2x2[y]);", "color = texture2DRect(SourceTextureSampler, uv * SourceSize + vOffset);", "float GreyValue = dot(color.rgb, LUMINANCE);", "maximum = max(maximum, GreyValue);", "maxRGB = max(max(max(maxRGB, color.r), color.g), color.b);", "average += GreyValue;", "minimum = min(minimum, GreyValue);", "colAverage += color.rgb;", "}", "}", " gl_FragData[0] = vec4(minimum, average / 9.0, maximum, 1.0);", " gl_FragData[1] = vec4(colAverage / 9.0, maxRGB);", "}"};
        }

        @Override
        protected String[] getFragmentShader(Object object) {
            return this.shaderF;
        }

        @Override
        public GLSLShader getInstance() {
            return this;
        }

        @Override
        public Class<?> instanceFor() {
            return null;
        }

        @Override
        public boolean needsRecompilation(Object object) {
            return false;
        }

        @Override
        protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
            int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), "SourceTextureSampler");
            gL.glUniform1i(n, 0);
            ReduceImagePass.this.sourceDimLoc = gL.glGetUniformLocation(ReduceImagePass.this.luminanceShader.getShaderProgramNumber(), "SourceSize");
        }
    }
}

