/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.GLSLUpdateCache;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.material.GLSLMaterial;
import de.grogra.imp3d.glsl.renderable.GLSLRenderable;
import de.grogra.imp3d.shading.Shader;
import de.grogra.vecmath.Matrix34d;
import de.grogra.vecmath.geom.VolumeBase;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Drawable
implements Comparable<Drawable> {
    protected Matrix4d worldTransform = new Matrix4d();
    protected Matrix4d cachedWorldTransform = new Matrix4d();
    protected int layer;
    protected GLSLRenderable shape;
    protected Shader s;
    protected GLSLMaterial sh = null;
    protected boolean asNode;
    protected int type;
    private VolumeBase BoundingVolume;
    private float radius;
    private boolean changed;
    private static final Matrix4d mat = new Matrix4d();
    boolean hasNoVolume = true;
    static Matrix4d localToGlobal = new Matrix4d();

    public GLSLRenderable getShape() {
        return this.shape;
    }

    public Shader getShader() {
        return this.s;
    }

    public void setShader(Shader shader) {
        this.s = shader;
    }

    public void setGLSLShader(GLSLMaterial gLSLMaterial) {
        this.sh = gLSLMaterial;
    }

    public GLSLMaterial getGLSLShader() {
        return this.sh;
    }

    public Drawable(GLSLRenderable gLSLRenderable, Shader shader, GLSLMaterial gLSLMaterial, boolean bl, int n, Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.init(gLSLRenderable, shader, gLSLMaterial, bl, n, matrix4d, matrix4d2);
    }

    public Drawable(GLSLRenderable gLSLRenderable, Shader shader, GLSLMaterial gLSLMaterial, boolean bl, int n, Matrix34d matrix34d, Matrix34d matrix34d2) {
        this.init(gLSLRenderable, shader, gLSLMaterial, bl, n, matrix34d, matrix34d2);
    }

    public void init(GLSLRenderable gLSLRenderable, Shader shader, GLSLMaterial gLSLMaterial, boolean bl, int n, Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.init(gLSLRenderable, shader, gLSLMaterial, bl, n);
        this.worldTransform.set(matrix4d);
        this.cachedWorldTransform.set(matrix4d2);
    }

    public void init(GLSLRenderable gLSLRenderable, Shader shader, GLSLMaterial gLSLMaterial, boolean bl, int n, Matrix34d matrix34d, Matrix34d matrix34d2) {
        this.init(gLSLRenderable, shader, gLSLMaterial, bl, n);
        this.clearLastColumn(this.worldTransform);
        this.clearLastColumn(this.cachedWorldTransform);
        this.updateMat(this.worldTransform, matrix34d);
        this.updateMat(this.cachedWorldTransform, matrix34d2);
    }

    private void clearLastColumn(Matrix4d matrix4d) {
        matrix4d.m30 = 0.0;
        matrix4d.m31 = 0.0;
        matrix4d.m32 = 0.0;
        matrix4d.m33 = 1.0;
    }

    public void init(GLSLRenderable gLSLRenderable, Shader shader, GLSLMaterial gLSLMaterial, boolean bl, int n) {
        this.shape = gLSLRenderable;
        this.s = shader;
        this.sh = gLSLMaterial;
        this.asNode = bl;
        this.layer = n;
        this.changed = true;
        this.hasNoVolume = false;
        this.BoundingVolume = null;
    }

    public Matrix4d getWorldTransform() {
        return this.worldTransform;
    }

    public void activateGLSLShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay) {
        this.activateGLSLShader(openGLState, gLSLDisplay, false);
    }

    public void activateGLSLShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay, boolean bl) {
        this.activateGLSLShader(openGLState, gLSLDisplay, bl, false);
    }

    public void activateGLSLShader(OpenGLState openGLState, GLSLDisplay gLSLDisplay, boolean bl, boolean bl2) {
        if (this.s == null) {
            gLSLDisplay.getCurrentGLState().setActiveProgram(0);
            return;
        }
        if (this.sh != null && !bl) {
            this.sh.activateShader(openGLState, gLSLDisplay, this.s);
            return;
        }
        if (this.sh == null) {
            this.sh = gLSLDisplay.isOptionAltDrawing() && this.shape != null && this.shape.isShaderDependant(false) ? (GLSLMaterial)this.shape.findShader(openGLState, gLSLDisplay, this.s) : (GLSLMaterial)gLSLDisplay.findShader(this.s);
            if (!bl) {
                this.sh.activateShader(openGLState, gLSLDisplay, null);
                return;
            }
        }
        if (bl2 && !this.sh.isOpaque(this.s)) {
            openGLState.setShaderConfSwitch(3);
            gLSLDisplay.findAndActivateShader(this.s);
            openGLState.setShaderConfSwitch(0);
            return;
        }
        if (gLSLDisplay.isOptionAltDrawing() && this.shape != null && this.shape.isShaderDependant(true)) {
            this.shape.activateShader(openGLState, gLSLDisplay, this.s, true);
            return;
        }
        if (!this.sh.mayDiscard(this.s)) {
            gLSLDisplay.getCurrentGLState().setActiveProgram(0);
            return;
        }
        gLSLDisplay.findAndActivateShader(this.s);
    }

    public void rebuildVolumeData(OpenGLState openGLState) {
        this.shape.draw(openGLState, openGLState.volume);
        this.BoundingVolume = openGLState.volume.getCurrentVolume();
        this.radius = openGLState.volume.getCurrentRadius();
        if (this.BoundingVolume == null) {
            this.hasNoVolume = false;
        }
        this.changed = false;
    }

    protected void draw(GLSLDisplay gLSLDisplay, OpenGLState openGLState) {
        GL gL = openGLState.getGL();
        if (this.sh != null && this.sh.getConfig() != null && this.sh.getConfig().getBit((byte)4)) {
            gL.glMatrixMode(5890);
            gL.glActiveTexture(33987);
            openGLState.loadMatrixd(this.worldTransform);
            gL.glMatrixMode(5888);
        }
        if (gLSLDisplay.isVisible(this.layer)) {
            if (gLSLDisplay.isOptionAltDrawing()) {
                this.shape.drawAlt(openGLState, gLSLDisplay);
            } else {
                this.shape.draw(openGLState, gLSLDisplay);
            }
        }
        if (openGLState.volume.needsData()) {
            this.rebuildVolumeData(openGLState);
        }
    }

    public void drawAndUpdate(GLSLDisplay gLSLDisplay, GLSLUpdateCache gLSLUpdateCache, Matrix4d matrix4d) {
        mat.mul(matrix4d, this.worldTransform);
        this.cachedWorldTransform.set(mat);
        gLSLUpdateCache.setCurrentTransformation(mat);
        this.draw(gLSLDisplay, gLSLDisplay.getCurrentGLState());
    }

    public void draw(GLSLDisplay gLSLDisplay, GLSLUpdateCache gLSLUpdateCache, Matrix4d matrix4d, boolean bl) {
        if (!bl) {
            mat.mul(matrix4d, this.worldTransform);
        } else {
            mat.set(this.cachedWorldTransform);
        }
        gLSLUpdateCache.setCurrentTransformation(mat);
        this.draw(gLSLDisplay, gLSLDisplay.getCurrentGLState());
    }

    void updateMat(Matrix4d matrix4d, Matrix34d matrix34d) {
        if (matrix34d == null) {
            return;
        }
        matrix4d.m00 = matrix34d.m00;
        matrix4d.m01 = matrix34d.m01;
        matrix4d.m02 = matrix34d.m02;
        matrix4d.m03 = matrix34d.m03;
        matrix4d.m10 = matrix34d.m10;
        matrix4d.m11 = matrix34d.m11;
        matrix4d.m12 = matrix34d.m12;
        matrix4d.m13 = matrix34d.m13;
        matrix4d.m20 = matrix34d.m20;
        matrix4d.m21 = matrix34d.m21;
        matrix4d.m22 = matrix34d.m22;
        matrix4d.m23 = matrix34d.m23;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public int compareTo(Drawable drawable) {
        return this.sh.getShaderProgramNumber() - drawable.sh.getShaderProgramNumber();
    }
}

