/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.utility;

import de.grogra.imp3d.glsl.utility.GLSLTexture;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;

public class GLSLSkyCube
extends GLSLTexture {
    Matrix4d LightToView = new Matrix4d();
    Matrix4d ViewToClip = new Matrix4d();
    private static final int DEFAULT_SIZE = 256;

    void getProjectionMatrix(Matrix4d matrix4d, float f, float f2) {
        double d = f - f2;
        matrix4d.setZero();
        matrix4d.m00 = 1.0;
        matrix4d.m11 = 1.0;
        matrix4d.m22 = (double)(f2 + f) / d;
        matrix4d.m32 = -1.0;
        matrix4d.m23 = (double)(2.0f * (f * f2)) / d;
    }

    public boolean create(GL gL) {
        return this.create(gL, 256, 256);
    }

    public boolean create(GL gL, int n, int n2) {
        if (this.index != 0) {
            if (this.width == n && this.height == n2) {
                return true;
            }
            this.delete(gL, false);
        }
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        this.index = nArray[0];
        gL.glBindTexture(34067, this.index);
        for (int i = 0; i < 6; ++i) {
            gL.glTexImage2D(34069 + i, 0, 34842, n, n2, 0, 32993, 5126, null);
        }
        gL.glTexParameterf(34067, 10242, 33071.0f);
        gL.glTexParameterf(34067, 10243, 33071.0f);
        gL.glTexParameteri(34067, 32882, 33071);
        gL.glTexParameteri(34067, 10240, 9729);
        gL.glTexParameteri(34067, 10241, 9729);
        this.type = 5126;
        this.width = n;
        this.height = n2;
        this.type = 34842;
        this.internalFormat = 32993;
        this.texType = 34067;
        return gL.glGetError() != 0;
    }

    public Matrix4d setupAsRTAttachment(GL gL, int n) {
        gL.glFramebufferTexture2DEXT(36160, 36064, 34069 + n, this.getIndex(), 0);
        return this.getLightToView(n);
    }

    public void finish(GL gL) {
        gL.glFramebufferTexture2DEXT(36160, 36064, 3553, 0, 0);
        this.bindTo(gL, 33984);
    }

    public Matrix4d getLightToView(int n) {
        switch (n) {
            case 0: {
                this.setRotateFront(this.LightToView);
                break;
            }
            case 1: {
                this.setRotateBack(this.LightToView);
                break;
            }
            case 2: {
                this.setRotateTop(this.LightToView);
                break;
            }
            case 3: {
                this.setRotateBottom(this.LightToView);
                break;
            }
            case 4: {
                this.setRotateRight(this.LightToView);
                break;
            }
            case 5: {
                this.setRotateLeft(this.LightToView);
                break;
            }
        }
        return this.LightToView;
    }

    public Matrix4d getViewToClip() {
        return this.ViewToClip;
    }

    void setRotateFront(Matrix4d matrix4d) {
        matrix4d.setZero();
        matrix4d.m02 = -1.0;
        matrix4d.m11 = -1.0;
        matrix4d.m20 = -1.0;
        matrix4d.m33 = 1.0;
    }

    void setRotateBack(Matrix4d matrix4d) {
        matrix4d.setZero();
        matrix4d.m02 = 1.0;
        matrix4d.m11 = -1.0;
        matrix4d.m20 = 1.0;
        matrix4d.m33 = 1.0;
    }

    void setRotateTop(Matrix4d matrix4d) {
        matrix4d.setZero();
        matrix4d.m00 = 1.0;
        matrix4d.m12 = -1.0;
        matrix4d.m21 = 1.0;
        matrix4d.m33 = 1.0;
    }

    void setRotateBottom(Matrix4d matrix4d) {
        matrix4d.setZero();
        matrix4d.m00 = 1.0;
        matrix4d.m12 = 1.0;
        matrix4d.m21 = -1.0;
        matrix4d.m33 = 1.0;
    }

    void setRotateLeft(Matrix4d matrix4d) {
        matrix4d.setZero();
        matrix4d.m00 = -1.0;
        matrix4d.m11 = -1.0;
        matrix4d.m22 = 1.0;
        matrix4d.m33 = 1.0;
    }

    void setRotateRight(Matrix4d matrix4d) {
        matrix4d.setZero();
        matrix4d.m00 = 1.0;
        matrix4d.m11 = -1.0;
        matrix4d.m22 = -1.0;
        matrix4d.m33 = 1.0;
    }
}

